
// got it from Rogers' repo, arduino for nrf51822


#ifndef _KX22_H_
#define _KX22_H_
 

#include "wire.h"
#include "mbed.h"

#define KX22_addr_w              0x3E
#define KX22_addr_r              0x3F
#define KX22_Accel_CNTL1_1       0x18
#define KX22_Accel_CNTL1_2       0x41
#define KX22_Accel_ODCNTL_1      0x1B
#define KX22_Accel_ODCNTL_2      0x02
#define KX22_Accel_CNTL3_1       0x1A
#define KX22_Accel_CNTL3_2       0xD8
#define KX22_Accel_TILT_TIMER_1  0x22
#define KX22_Accel_TILT_TIMER_2  0x01
#define KX22_Accel_CNTL2_1       0x18
#define KX22_Accel_CNTL2_2       0xC1  

#define DATA_OUT_BASE 0x06


class KX22
{  
    public :
        KX22(uint8_t SCL, uint8_t SDA);
        void writeTwoBytes (int one, int two, TwoWire* wire);
        int getByte (int address, TwoWire* wire);
        int16_t getAccel(int channelNum); //returns 1000*acceleration m/s^2 value
   
   private :
        uint8_t scl, sda;       
        
};

 
#endif