#include "mbed.h"
SPI spi(p5, p6, p7); // mosi, miso, sclk
DigitalOut ak4117cs(p8);
DigitalOut ak4117pdn(p9);
DigitalOut ak4396cs(p10);
DigitalOut ak4396pdn(p11);
DigitalOut myled(LED1);

uint16_t CONTROL0_CLOCK_SOURCE =       0b0010000000001111;   // select PLL as master clock source
uint16_t CONTROL1_CLOCK_FREQ =        0b0010000100000000;   // select master clk for PLL mode, fs = 48kHz
uint16_t CONTROL2_FORMAT_SETTING =     0b0010001000001101;   // select I2S as comm format and channel 1 for fs
uint16_t CONTROL3_INT_0 =              0b0010001101111111;   // enable all the interrupts on INT0


uint16_t CONTROL2_DEFAULT_NORMALSPEED = 0b0010000110000010;
uint16_t CONTROL1_MODE3_RSTN_AUTO_SETTING = 0b0010000010001110;
uint16_t CONTROL1_MODE3_AUTO_SETTING = 0b0010000010001111;
uint16_t CONTROL3_DEFAULT = 0b0010001000000000;
uint16_t LCH_FULL_VOLUME = 0b0010001111111111;
uint16_t RCH_FULL_VOLUME = 0b0010010011111111;

//data order is C1,C0,R/W,A4,A3,A2,A1,A0,D7,D6.D5,D4,D3,D2,D1,D0
uint16_t CONTROL0_AK4396 = 0b0010000010000111;
uint16_t CONTROL1_AK4396 = 0b0010000110000010;


void ak4117_config();
void ak4396_config();

int main()
{
    // Setup the spi for 16 bit data, high steady state clock,
    // second edge capture, with a 9600 clock rate
    spi.format(16,3);
    spi.frequency(9600);
    ak4396cs = 1;
    ak4117cs=1;

    ak4117_config();
    wait(0.2);
    ak4396_config();
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}

void ak4396_config()
{
    // Chip must be deselected
    ak4396cs = 1;
    ak4396pdn=0; //power down
    wait_ms(1);
    ak4396pdn=1;
    wait_ms(1);

    
    //while (1)
    // {
    // Select the device by seting chip select low
    ak4396cs = 0;
    // turn on zero_detect
    spi.write(CONTROL0_AK4396);
    // Deselect the device
    ak4396cs = 1;
    wait_ms(1);

    ak4396cs=0;
    spi.write(CONTROL1_AK4396);
    ak4396cs=1;
    wait_ms(1);
    return;
}

void ak4117_config()
{
    // Chip must be deselected
    ak4117cs = 1;
    ak4117pdn=0; //power down
    wait_ms(1);
    ak4117pdn=1;
    wait_ms(1);

    //while (1)
    // {
    // Select the device by seting chip select low
    ak4117cs = 0;
    // turn on zero_detect
    spi.write(CONTROL0_CLOCK_SOURCE);
    // Deselect the device
    ak4117cs = 1;
    wait_ms(1);

    ak4117cs=0;
    spi.write(CONTROL1_CLOCK_FREQ);
    ak4117cs=1;
    wait_ms(1);

    ak4117cs=0;
    spi.write(CONTROL2_FORMAT_SETTING);
    ak4117cs=1;
    wait_ms(1);

    ak4117cs=0;
    spi.write(CONTROL3_INT_0);
    ak4117cs=1;
    wait_ms(1);
    return;
}