#include "mbed.h"
#include "rtos.h"

//----

#include "millis.h"

//----
#include "DS1820.h"

//--- Thread
Thread tTempCtrl;
Thread tMainCtrl;

//--- Function
void TempController();
void MainController();

//---
#define TEMP 1
#define LICHT 2

typedef struct checkedUnion {
    int type;
    union sensor_u {
        float  temperature;
        float  licht;
    } sensor;

    uint32_t counter;   /* A counter value               */
} message_t;

//---
Serial serial(USBTX, USBRX);
DS1820 ds1820(PA_9);

//---
MemoryPool<message_t, 8> mpool;
Queue<message_t, 8> queue;

//---
int main()
{
    serial.baud(19200);
    
    tTempCtrl.start(TempController);
    tMainCtrl.start(MainController);

    Thread::wait(osWaitForever);
}

void MainController()
{
    float  temperature;
    float  licht;
    
    while (true) {
        osEvent evt = queue.get();
        if (evt.status == osEventMessage) {
            message_t *message = (message_t*)evt.value.p;
            switch ( message->type ) {
                case TEMP:
                    printf("\Temperature: %.2f C\n\r", message->sensor.temperature);
                    temperature = message->sensor.temperature;
                    break;
                case LICHT:
                    printf("\Licht: %.2f C\n\r", message->sensor.licht);
                    licht = message->sensor.temperature;
                    break;
            }
            printf("Number of cycles: %u\n\r", message->counter);

            mpool.free(message);
        }
        
        Thread::wait(1);
    }
}

void TempController()
{
    uint32_t i = 0;

    while (true) {
        if(ds1820.begin()) {
            ds1820.startConversion();
            Thread::wait(500);
            while(true) {
                // read temperature
                serial.printf("temp = %3.1f\r\n", ds1820.read());
                ds1820.startConversion();  // start temperature conversion

                i++; // fake data update
                message_t *message = mpool.alloc();
                message->type = TEMP;
                message->sensor.temperature = ds1820.read();
                message->counter = i;
                
                queue.put(message);

                Thread::wait(250);         // let DS1820 complete the temperature conversion
            }
        } else
            serial.printf("No DS1820 sensor found!\r\n");

        Thread::wait(1000);
    }
}
