#ifndef CONTROLLER_H
#define CONTROLLER_H
#include "mbed.h"

#define prevnum 3
#define memoryLength 50
#define MT_TX               PA_9
#define MT_RX               PA_10
#define Xsens_req           PA_8


// spul voor encoders
#define select_encoder_left D10
#define select_encoder_right D8
//#define SPI_MOSI      PB_15
//#define SPI_MISO      PB_14
//#define SPI_SCK       PB_13
 
#define SPI_MOSI      D11
#define SPI_MISO      D12
#define SPI_SCK       D13

/** Controller class
 *  Contains the controll system seccesary to stabalize the boat
 */
class Controller
{
    
    public:
    Controller(RawSerial * pc, SPI * spi) : pc_(pc), spi_(spi){
            spi_->format(12,1);
    spi_->frequency(1000000);
    pc_->baud(9600);
        };

    int H1,H2;

    /** reads encoder data
    reads in the encoder data
    */
    void read_encoders();
    
    private:
    RawSerial * pc_;
    SPI * spi_;
};
    
#endif
