#include "controllerfile.h"
 
// #################### controller functions ######################################################################
//DigitalOut REQ_DATA_XSENS(Xsens_req);
//RawSerial MT(MT_TX,MT_RX);


DigitalOut encoder_left(select_encoder_left);
DigitalOut encoder_right(select_encoder_right);
    



void Controller::read_encoders()
{
    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
    
    
    uint8_t msb, lsb;

    // Select the device by seting chip select low
    encoder_left = 0;
    // Send 0x8f, the command to read the WHOAMI register (argument does not matter)
    msb=spi_->write(0xf);
    pc_->putc(msb);  
    lsb=spi_->write(0x8f);
    pc_->putc(lsb);
    /*Code to get the position from the msb and lsb*/
    int position = (msb<<4) + (lsb>>4);
    printf("Vlotter 2: %i\n", position);
    //Deselect the device
    encoder_left = 1;

        
    // Select the device by seting chip select low
    encoder_right = 0;

    // Send 0x8f, the command to read the WHOAMI register
    msb=spi_->write(0x8f);
    pc_->putc(msb);
    
    lsb=spi_->write(0x8f);
    pc_->putc(lsb);
    
    /*Code to get the position from the msb and lsb*/
    position = (msb<<4) + (lsb>>4);
    printf("Vlotter 1: %i\n", position);
    
    // Deselect the device
    encoder_right = 1;       
    
    pc_->printf("\r\n");
    //Two arbitrary end bits
        //pc_->putc('\r');
        //pc_->putc('\n');
}

