#include "mbed.h"
#include "SerialRPCInterface.h"
#include "LM75B.h"
#include "C12832.h"
#include "MMA7660.h"
#include <time.h>
#include <stdlib.h>
#include "Servo.h"
 
//  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  
//  //  //  //  //  //  //* Pennen defineren voor libs  */  //  //  //  //  //                  
C12832 glcd(p5, p7, p6, p8, p11);                       //Grafische display aangesloten op P5,6,7,8,11
MMA7660 MMA(p28, p27);                                  //I2C Accelerometer
LM75B LM75(p28,p27);                                    //LM75 Temp Sensor
SerialRPCInterface SerialInterface(USBTX, USBRX);       //USB seriele communicatie opzetten
 
PwmOut r (p23);                                         //RGB Led op pen 23-25
PwmOut g (p24);   
PwmOut b (p25);   
DigitalIn up(p15);                                      //Joystick aangesloten op P12-16
DigitalIn down(p12);
DigitalIn left(p13);
DigitalIn right(p16);
DigitalIn fire(p14);                                    //Drukknop joystick zit op pen P14
 
DigitalOut connectionLed(LED1);                         //Accel OK LED
 
BusOut leds(LED1,LED2,LED3,LED4);                       //Leds op MBED zelf defineren
 
//  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  
//  //  //  //  //  //  //*Variabelen aanmaken  */  //  //  //  //  //  //  //
int potentiometer1 = 0;
int potentiometer2 = 0;
float Xaxis = 0;
float Yaxis = 0;
float Zaxis = 0;
 
int modus = 0;
int kleur = 0;
int rood = 0;
int groen = 0;
int blauw = 0;
int xas = 0 ;
int yas = 0 ;
int potmet1 = 0;
int potmet2 = 0;
 
/*
char orientation;
char side; 
char Left;
char Right;
char Down;
char Up;
char Front;
char Back;
*/ 
 
RPCVariable<int> rpc_potentiometer1(&potentiometer1,"potentiometer1");
RPCVariable<int> rpc_potentiometer2(&potentiometer2,"potentiometer2");
RPCVariable<int> rpc_xas(&xas,"xas");
RPCVariable<int> rpc_yas(&yas,"yas");
 
RPCVariable<int> rpc_rood(&rood,"rood");
RPCVariable<int> rpc_groen(&groen,"groen");
RPCVariable<int> rpc_blauw (&blauw ,"blauw ");
 

 
AnalogIn pot2(p19);
AnalogIn pot1(p20);
 
DigitalOut led(LED1);
DigitalOut led2(LED2);
 
DigitalIn enter(p14);
 
PwmOut speaker(p26);
 
Servo Servo1(p21);
Servo Servo2(p22);
 
void RGB_routine();
void ReadPot();
void Accelero();
void Servosturing();
 
//  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  
//  //  //  //  //  //  //*Begin van het hoofdprogramma */  //  //  //  //  //  
int main() {
 
    speaker.period(0.5);    
    r.period(0.001);
    g.period(0.001);
    b.period(0.001);
    
            
    glcd.cls();                                      //Clear het display
    glcd.locate(0,0);                                //Zet de cursor op X = 0 & Y = 0
    glcd.printf("Project Misan");                    //Zet "Project Misan" op het LCD
    glcd.locate(0,15);                               //Zet de cursor op X = 0 & Y = 15
    glcd.printf("Use the joystick");                 //Zet "Project Misan" op het LCD
    wait(1);                                         //Wacht 1 seconde    
   
    while (1){

        if (fire)
        {
            while(fire){}
            
            if(modus >= 4)
            {
                modus = 0;
            }
                      
            modus = modus++;
            speaker = 0.5;
            wait(0.025);
            speaker = 0.25;
            wait(0.025); 
            speaker = 0;                                         
        }
        
        switch (modus) 
        {
                //RGB Controller
                case 0:
                    glcd.cls();                                      //Clear het display                 
                    RGB_routine();
                break;
                
                //ADC Potentiometer
                case 1:
                    glcd.cls();                                      //Clear het display                      
                    ReadPot();
                break;    
                
                //Accelerometer MMA7660
                case 2: 
                    glcd.cls();                                      //Clear het display                          
                    Accelero();
                break;  
                
                case 3:   
                    glcd.cls();                                      //Clear het display                          
                    Servosturing();
                break;                                             
        }
    }
}
 
 
 
 
//  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //
//  //  //  //  //  //  //* RGB routine voor kleurwijzigen met de Joystick  */  //  //  //  //  //
void RGB_routine()
{
   
   
   if (right)
    {
        if (kleur < 2)
        {
        kleur = kleur++;                                    
        }
        if (kleur == 2)
        {
        kleur = 0;
        }   
    }
    
    if (left)
    {                               
        if (kleur > 0)
        {
        kleur = kleur--;                                    
        }
        if (kleur == 0)
        {
        kleur = 2;
        }      
    } 
     
    if (up)
    {
        if(kleur == 0 & rood <1)
        {
        rood = rood + 0.05;
        }
        if(kleur == 0 && rood == 1)
        {
        rood = 0;
        }
        if(kleur == 1 && groen <1)
        {
        groen = groen + 0.05;
        }
        if(kleur == 1 && groen == 1)
        {
        groen = 0;
        }
        if(kleur == 2 && blauw <1)
        {
        blauw = blauw + 0.05;
        }
        if(kleur == 2 && blauw == 1)
        {
        blauw = 0;
        }
    }
    
    if (down)
    {
        if(kleur == 0 && rood <0)
        {
        rood = rood - 0.05;
        }
        if(kleur == 0 && rood == 0)
        {
        rood = 1;
        }
        if(kleur == 1 && groen <0)
        {
        groen = groen - 0.05;
        }
        if(kleur == 1 && groen == 0)
        {
        groen = 1;
        }
        if(kleur == 2 && blauw <0)
        {
        blauw = blauw - 0.05;
        }
        if(kleur == 2 && blauw == 0)
        {
        blauw = 1;
        }
    }
   
   
   
   
   
   /* if (up)
    {
        switch (kleur)
        {
            case 0:
                rood += 0.05;
                break;
            case 1:
                groen += 0.05;
                break;
            case 2:
                blauw += 0.05;
                break;                                           
        }
        
    }
    
    if (down)
    {
        switch (kleur)
        {
            case 0:
                rood -= 0.05;
                break;
            case 1:
                groen -= 0.05;
                break;
            case 2:
                blauw -= 0.05;
                break;                                           
        }            
    }
    
    if (right)
    {
        switch (kleur)
        {
            case 0:
                kleur += 1;
                break;
            case 1:
                kleur += 1;
                break;
            case 2:
                kleur = 0;
                break;                                         
        }  
        
    }
    
    if (left)
    {
        switch (kleur)
        {
            case 0:
                kleur = 2;
                break;
            case 1:
                kleur -= 1;
                break;
            case 2:
                kleur -= 1;
                break;                                         
        }  
        
    }
    
 
    */
    
    
    
    
    
    
    
    
    
    
    
     
    glcd.locate(0,0);                            //Zet de cursor op X = 0 & Y = 0
    glcd.printf("R: %i", up);
    glcd.locate(0,9);                            //Zet de cursor op X = 0 & Y = 10    
    glcd.printf("G: %i", down);
    glcd.locate(0,18);                           //Zet de cursor op X = 0 & Y = 18      
    glcd.printf("B: %i", blauw);
    wait(0.5);      
              
}
 
//  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //  //
//  //  //  //  //  //  //* Inlezen en visualiseren van de potentiometers   */  //  //  //  //  //
void ReadPot()
{
    potentiometer1 = pot1*100;       //steek de waarde van de Potentiometer1 in ai1
    potentiometer2 = pot2*100;       //steek de waarde van de Potentiometer2 in ai2
    
    glcd.locate(0,0);                            //Zet de cursor op X = 0 & Y = 0
    glcd.printf("Pot 1: %i ", potentiometer1);              //Print de waarde van de potententiometer 1 op het display
    glcd.locate(0,10);                           //Zet de cursor op X = 0 & Y = 10
    glcd.printf("Pot 2: %i ", potentiometer2);              //Print de waarde van de potententiometer 2 op het display
    wait(0.5);                                         //Wacht 1 seconde       
}
 
 
void Accelero()
{
    if (MMA.testConnection())
    {
         leds = 1;
    }    
    
    Xaxis = MMA.x();
    Yaxis = MMA.y();
    Zaxis = MMA.z();
    xas = Xaxis*100 ;
    yas = Yaxis*100 ;
    
    glcd.locate(0,0);                            //Zet de cursor op X = 0 & Y = 0
    glcd.printf("X-Axis: %f G", Xaxis);
    glcd.locate(0,9);                            //Zet de cursor op X = 0 & Y = 10    
    glcd.printf("Y-Axis: %f G", Yaxis);
    glcd.locate(0,18);                           //Zet de cursor op X = 0 & Y = 18      
    glcd.printf("Z-Axis: %f G", Zaxis);
    wait(1);      
 
} 
 
 
void Servosturing()
{
    
    potentiometer1 = pot1;       //steek de waarde van de Potentiometer1 in ai1
    potentiometer2 = pot2;       //steek de waarde van de Potentiometer2 in ai2      
    wait(0.1);
    
    Servo1.write(potentiometer1);
    Servo2.write(potentiometer2);
    
    glcd.locate(0,0);                            //Zet de cursor op X = 0 & Y = 0
    glcd.printf("Servo-1: %f", Servo1);
    glcd.locate(0,10);                            //Zet de cursor op X = 0 & Y = 10    
    glcd.printf("Servo-2: %f", Servo2);
 
    wait(0.5);     
} 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
    /*switch (side)
    {        
        case "Front":        
            switch (orientation)
            {
                case "Left":
                    glcd.locate(0,27);               //Zet de cursor op X = 0 & Y = 10      
                    glcd.printf("Front Left");
                    break;
                
                case "Right":
                    glcd.locate(0,27);               //Zet de cursor op X = 0 & Y = 10      
                    glcd.printf("Front Right");
                    break;
                
                case "Down":
                    glcd.locate(0,27);               //Zet de cursor op X = 0 & Y = 10      
                    glcd.printf("Front Down");
                    break;      
                
                case "Up":
                    glcd.locate(0,27);               //Zet de cursor op X = 0 & Y = 10      
                    glcd.printf("Front Up");
                    break;                                                      
            }  
        break;
 
    
        case "Back":        
            switch (orientation)
            {
                case "Left":
                    glcd.locate(0,27);               //Zet de cursor op X = 0 & Y = 10      
                    glcd.printf("Back Left");
                    break;
                
                case "Right":
                    glcd.locate(0,27);               //Zet de cursor op X = 0 & Y = 10      
                    glcd.printf("Back Right");
                    break;
                
                case "Down":
                    glcd.locate(0,27);               //Zet de cursor op X = 0 & Y = 10      
                    glcd.printf("Back Down");
                    break;      
                
                case "Up":
                    glcd.locate(0,27);               //Zet de cursor op X = 0 & Y = 10      
                    glcd.printf("Back Up");
                    break;                                                      
            }
        break; 
    } */