#include "mbed.h"

AnalogIn analog_value(A0);
AnalogIn analog_value1(A1);

PwmOut servo(PC_7);

int main()
{
    float meas_rx;
    float meas_vx;
    float meas_ry;
    float meas_vy;
    
    printf("\nAnalogIn Servo\n");
    servo.period_ms(20);
    
    while(1) {

        meas_rx = analog_value.read(); // Read the analog input value (value from 0.0 to 1.0 = full ADC conversion range)
        meas_vx = meas_rx * 3300; // Converts value in the 0V-3.3V range
        meas_ry = analog_value1.read(); // Read the analog input value (value from 0.0 to 1.0 = full ADC conversion range)
        meas_vy = meas_ry * 3300; // Converts value in the 0V-3.3V range
        
        // Valores de los datos
        printf("Datosx = %f = %.0f mV\n", meas_rx, meas_vx);
        printf("Datosy = %f = %.0f mV\n", meas_ry, meas_vy);

        
        if (meas_vx < 1000) {
            servo.pulsewidth_us(500);
        } else if(meas_vy>2000){
            servo.pulsewidth_us(1200);
        }

        wait(1.0); // Espera 1 segundo
    }
}
