#include "mbed.h"
#include "Wifly.h"
#include "Websocket.h"

DigitalOut l1(LED1);

//Here, we create an instance, with pins 9 and 10 connecting to the
//WiFly's TX and RX pins, and pin 21 to RESET. We are connecting to the
//"mbed" network, password "password", and we are using WPA.
Wifly wifly(p9, p10, p21, "mbed", "password", true);

//Here, we create a Websocket instance in 'rw' (read-write) mode
//on the 'samux' channel
Websocket ws("ws://sockets.mbed.org/ws/samux/rw", &wifly);


int main() {
    char recv[40];

    while (1) {

        //we connect the network
        while (!wifly.join()) {
            wifly.reset();
        }

        //we connect to the websocket server
        while (!ws.connect());

        while (1) {
            wait(0.5);

            //Send Hello world
            ws.send("Hello World! over Wifi");

            // if a message is available, print it
            if (ws.read(recv)) {
                // show that we receive messages
                l1 = !l1;
            }
        }
    }
}