#include "mbed.h"
#include "Websocket.h"

Serial pc(USBTX, USBRX);
Timer tmr;

//Here, we create a Websocket instance in 'rw' (write) mode
//on the 'samux' channel
Websocket ws("ws://sockets.mbed.org/ws/samux/rw");

int main() {
    char recv[128];
    while (1) {

        while (!ws.connect())
            pc.printf("cannot connect websocket, retrying\r\n");

        tmr.start();
        while (1) {
            if (tmr.read() > 0.5) {
                ws.send("Hello World! over Ethernet");
                if (ws.read(recv)) {
                    pc.printf("recv: %s\r\n", recv);
                }
                tmr.start();
            }
            Net::poll();
        }
    }
}