#include "mbed.h"
#include "VodafoneUSBModem.h"
#include "Websocket.h"
#include "LM75B.h"
#include "MMA7660.h"

// accelerometer
MMA7660 acc(p28, p27);

// temperature sensor
LM75B tmp(p28,p27);

Serial pc(USBTX, USBRX);

void test(void const*)
{
    char json_str[100];

    VodafoneUSBModem modem;
    
    // See the output on http://sockets.mbed.org/app-board/viewer
    Websocket ws("ws://sockets.mbed.org:443/ws/app-board/wo");
    

    int ret = modem.connect("pp.vodafone.co.uk");
    if(ret) {
        printf("Could not connect\n");
        return;
    }

    bool c = ws.connect();
    printf("Connect result: %s\n", c?"OK":"Failed");

    while(1) {
        sprintf(json_str, "{\"id\":\"app_board_3g_EW2013\",\"ax\":%d,\"ay\":%d,\"az\":%d, \"tmp\":%d}", (int)(acc.x()*360), (int)(acc.y()*360), (int)(acc.z()*360), (int)tmp.read());
        
        // send str
        ret = ws.send(json_str);
        
        if(ret<0) {
            printf("Timeout\n");
            ws.close();
            c = ws.connect();
            printf("Connect result: %s\n", c?"OK":"Failed");
        }
        
        Thread::wait(100);
    }

    modem.disconnect();

    while(1) {
    }
}


int main()
{
    pc.baud(921600);
    Thread testTask(test, NULL, osPriorityNormal, 1024 * 4);
    DigitalOut led(LED1);
    while(1) {
        led=!led;
        Thread::wait(1000);
    }

    return 0;
}
