// this program updates to the latest firmware a wifly module

#include "mbed.h"
#include "WiflyInterface.h"

WiflyInterface wifly(p9, p10, p30, p29, "mbed", "password", WPA);

int main() {

    wifly.init(); //Use DHCP
    while(!wifly.connect());
    
    bool success = true;
    // once connected, send command to update firmware
    if (!wifly.sendCommand("set ftp address 0\r", "AOK"))
        success = false;
    if (!wifly.sendCommand("set dns name rn.microchip.com\r", "AOK"))
        success = false;
    if (!wifly.sendCommand("save\r", "Stor"))
        success = false;
    if (!wifly.sendCommand("ftp update\r", "FTP OK", NULL, 30000))
        success = false;
    if (!wifly.sendCommand("factory RESET\r"))
        success = false;
    if (!wifly.sendCommand("reboot\r"))
        success = false;
    
    if (success)
        printf("firmware updated successfully!\r\n");
    else
        printf("ERROR while updating firmware!\r\n");
}
