#include "mbed.h"
#include "WiflyInterface.h"

#define ECHO_SERVER_PORT   7

/* wifly object where:
*     - p9 and p10 are for the serial communication
*     - p25 is for the reset pin
*     - p26 is for the connection status
*     - "mbed" is the ssid of the network
*     - "password" is the password
*     - WPA is the security
*/
WiflyInterface wifly(p9, p10, p25, p26, "mbed", "password", WPA);

int main (void)
{
    wifly.init(); // use DHCP
    while (!wifly.connect()); // join the network
    printf("IP Address is %s\n\r", wifly.getIPAddress());

    TCPSocketServer server;
    server.bind(ECHO_SERVER_PORT);
    server.listen();

    printf("\nWait for new connection...\n");
    TCPSocketConnection client;
    server.accept(client);

    char buffer[256];
    while (true) {
        int n = client.receive(buffer, sizeof(buffer));
        if (n <= 0) continue;
        buffer[n] = 0;

        client.send_all(buffer, n);
    }
}