#include "mbed.h"
#include "WiflyInterface.h"
#include "Websocket.h"


/* wifly interface:
*     - p9 and p10 are for the serial communication
*     - p19 is for the reset pin
*     - p26 is for the connection status
*     - "mbed" is the ssid of the network
*     - "password" is the password
*     - WPA is the security
*/
WiflyInterface wifly(p9, p10, p19, p26, "mbed", "password", WPA);

int main() {
    wifly.init(); //Use DHCP
    while (!wifly.connect());
    printf("IP Address is %s\n\r", wifly.getIPAddress());

    Websocket ws("ws://sockets.mbed.org:443/ws/demo/wo");
    while (!ws.connect());

    while (1) {
            ws.send("WebSocket Hello World over Wifly");
            wait(1.0);
    }
}