#include "mbed.h"
#include "EthernetInterface.h"
#include "Websocket.h"
#include "MMA7660.h"

MMA7660 MMA(p28, p27);

DigitalOut l1(LED1);
 
int main() {
    char json_str[100];
    
    if (MMA.testConnection())
        l1 = 1;
 
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address is %s\n\r", eth.getIPAddress());
 
    Websocket ws("ws://sockets.mbed.org/ws/demo/wo");
    ws.connect();
 
    while (1) {
        sprintf(json_str, "{\"id\":\"app_board_acc\",\"ax\":\"%d\",\"ay\":\"%d\",\"az\":\"%d\"}", (int)(MMA.x()*200), (int)(MMA.y()*200), (int)(MMA.z()*200));
        ws.send(json_str);
        wait(0.2);
    }
}