// Hello World example for the USBMIDI library

#include "mbed.h"
#include "USBMIDI.h"

//USBMIDI object
USBMIDI midi;


// Leds which will be switch on or off according to a MIDImessage
BusOut leds(LED1, LED2, LED3, LED4);

BusInOut buttons(p22, p23, p24, p25);

void show_message(MIDIMessage msg) {
    switch (msg.type()) {
        case MIDIMessage::NoteOnType:
            switch (msg.key()) {
                case 48:
                    leds = (1 << 0);
                    break;
                case 49:
                    leds = (1 << 1);
                    break;
                case 50:
                    leds = (1 << 2);
                    break;
                case 51:
                    leds = (1 << 3);
                    break;
            }
            break;
        case MIDIMessage::NoteOffType:
        default:
            leds = 0;
    }
}

int main() {
    uint8_t bus = 0;
    uint8_t p_bus = 0;

    // call back for messages received
    midi.attach(show_message);

    while (1) {

        //if buttons state changes, send a MIDI message
        bus = buttons.read();
        for (int i = 0; i < 4; i++) {
            if ( (bus & (1 << i)) != (p_bus & (1 << i))) {
                if (bus & (1 << i)) {
                    midi.write(MIDIMessage::NoteOn(48 + i));
                } else if ( !(bus & (1 << i)) ) {
                    midi.write(MIDIMessage::NoteOff(48 + i));
                }

            }
        }
        wait(0.001);
        p_bus = bus;
    }
}
