#include "mbed.h"
#include "USBKeyboard.h"
 
USBKeyboard keyboard;
 
//Bus of buttons
BusInOut buttons(p21, p22, p23, p24, p25, p26, p29);
 
int main(void) {
    uint8_t p_bus = 0;
 
    while (1) {
        //if the bus of buttons has changed, send a report
        if (buttons.read() != p_bus) {
            p_bus = buttons.read();
            if(p_bus & 0x01)
               keyboard.mediaControl(KEY_MUTE);
            if(p_bus & 0x02)
               keyboard.mediaControl(KEY_VOLUME_DOWN);
            if(p_bus & 0x04)
               keyboard.mediaControl(KEY_VOLUME_UP);
            if(p_bus & 0x08)
               keyboard.mediaControl(KEY_NEXT_TRACK);
            if(p_bus & 0x10)
               keyboard.mediaControl(KEY_PLAY_PAUSE);
            if(p_bus & 0x20)
               keyboard.mediaControl(KEY_PREVIOUS_TRACK);
            if(p_bus & 0x40)
               keyboard.printf("Hello World\r\n");
        }
        wait(0.01);
    }
}