#include "mbed.h"
#include "USBAudio.h"

// frequency: 8 kHz
#define FREQ 8000

// 1 channel: mono
#define NB_CHA 1

// length of an audio packet: each ms, we receive 48 * 16bits ->48 * 2 bytes. as there is one channel, the length will be 48 * 2 * 1
#define AUDIO_LENGTH_PACKET (FREQ/500) * NB_CHA

// as we don't use audio in, 48000 and 1 are dummy
USBAudio audio(8000, 1, FREQ, NB_CHA, 0x0103, 0x4521);

AnalogIn mic(p20);

int16_t buf[AUDIO_LENGTH_PACKET/2];

int main() {
    double mic_mean = 0.0;
    double mic_value;

    // compute average value of the microphone. We can then center the audio signal sent to the computer
    for (int j = 0; j < 1000; j++) {
        mic_value = (mic.read_u16() >> 3);
        mic_mean = (mic_mean*j + mic_value)/(j+1);
    }

    while (1) {
        for (int i = 0; i < AUDIO_LENGTH_PACKET/2; i++) {
            buf[i] = (mic.read_u16() >> 3) - mic_mean;
            if (i != AUDIO_LENGTH_PACKET/2) {
                wait_us(80);
            }
        }
        audio.write((uint8_t *)buf);
    }
}
