#include "mbed.h"
#include "MbedJSONRpc.h"
#include "MbedJSONValue.h"
#include "Websocket.h"

Serial pc(USBTX, USBRX);

//websocket: configuration with sub-network = samux and mbed_id = mbed_acc 
Websocket webs("ws://sockets.mbed.org/rpc/samux/mbed_client");

//RPC object attached to the websocket server
MbedJSONRpc rpc(&webs);

int main() {

    pc.printf("\x1B[2J");
    pc.printf("\x1B[H");
    
    RPC_TYPE t;
    
    //in: argument for the distant method (here empty)
    //out results of the distant method (accelerometers values)
    MbedJSONValue in, out;

    while (!webs.connect());

    //CALL getAcc on mbed_acc
    if ((t = rpc.call("getAcc", "mbed_acc", in, out)) == CALL_OK) {
        printf("call success\r\n");
        printf("acc_x: %d\r\n", out[0].get<int>());
        printf("acc_y: %d\r\n", out[1].get<int>());
        printf("acc_z: %d\r\n", out[2].get<int>());
    } else
        printType(t);
}
