#include "mbed.h"
#include "WiflyInterface.h"
#include "Websocket.h"
#include "MbedJSONRpc.h"

BusOut l(LED1, LED2, LED3, LED4);

/* wifly interface:
*     - p9 and p10 are for the serial communication
*     - p19 is for the reset pin
*     - p26 is for the connection status
*     - "mbed" is the ssid of the network
*     - "password" is the password
*     - WPA is the security
*/
WiflyInterface wifly(p9, p10, p19, p26, "mbed", "password", WPA);

//websocket: configuration with sub-network = demo and mbed_id = mbed_led 
Websocket ws("ws://sockets.mbed.org/rpc/demo/mbed_led");

//RPC object attached to the websocket server
MbedJSONRpc rpc(&ws);

//Test class
class Test {
public:
    Test() {};
    void led(MbedJSONValue& in, MbedJSONValue& out) {
        int id = in[0].get<int>();
        l = (1 << (id - 1));
        wait(0.2);
        l = 0;
    }
};

Test test;

int main() {

    wifly.init(); //Use DHCP
    wifly.connect();
    printf("IP Address is %s\n\r", wifly.getIPAddress());
    
    ws.connect();
    
    RPC_TYPE t;

    //------------register led---------------//
    if((t = rpc.registerMethod("led", &test, &Test::led)) == REGISTER_OK)
        printf("led is registered\r\n");
    else
        printType(t);
    
    //wait for incoming CALL requests
    rpc.work();
}