#include "mbed.h"
#include "MbedJSONRpc.h"
#include "MbedJSONValue.h"
#include "EthernetInterface.h"
#include "Websocket.h"

Serial pc(USBTX, USBRX);
BusOut l(LED1, LED2, LED3, LED4);

//websocket: configuration with sub-network = demo and mbed_id = mbed_led 
Websocket ws("ws://sockets.mbed.org/rpc/demo/mbed_led");

//RPC object attached to the websocket server
MbedJSONRpc rpc(&ws);

//Test class
class Test {
public:
    Test() {};
    void led(MbedJSONValue& in, MbedJSONValue& out) {
        int id = in[0].get<int>();
        l = (1 << (id - 1));
        wait(0.2);
        l = 0;
    }
};

Test test;

int main() {

    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address is %s\n\r", eth.getIPAddress());
    
    ws.connect();
    
    RPC_TYPE t;

    //------------register getAcc---------------//
    if((t = rpc.registerMethod("led", &test, &Test::led)) == REGISTER_OK)
        printf("led is registered\r\n");
    else
        printType(t);
    
    //wait for incoming CALL requests
    rpc.work();
}