#include "mbed.h"
#include "WiflyInterface.h"
#include "NTPClient.h"

/* wifly interface:
*     - p9 and p10 are for the serial communication
*     - p19 is for the reset pin
*     - p26 is for the connection status
*     - "mbed" is the ssid of the network
*     - "password" is the password
*     - WPA is the security
*/
WiflyInterface wifly(p9, p10, p19, p26, "mbed", "password", WPA);
NTPClient ntp;

int main() 
{
    wifly.init(); //Use DHCP

    wifly.connect();
   
    printf("Trying to update time...\r\n");
    if (ntp.setTime("0.pool.ntp.org") == 0)
    {
      printf("Set time successfully\r\n");
      time_t ctTime;
      ctTime = time(NULL);
      printf("Time is set to (UTC): %s\r\n", ctime(&ctTime));
    }
    else
    {
      printf("Error\r\n");
    } 
   
    wifly.disconnect();  

    while(1) {
    }
}