#include "mbed.h"
#include "USBMouse.h"
#include "ADXL345.h"

Serial pc(USBTX, USBRX);

USBMouse mouse;
ADXL345 acc(p5, p6, p7, p8);
AnalogIn strength(p15);


int main() {
    uint16_t str = 0;
    int readings[3];

    //Initialize accelerometer
    acc.setPowerControl(0x00);
    acc.setDataFormatControl(0x0B);
    acc.setDataRate(ADXL345_3200HZ);
    acc.setPowerControl(0x08);

    while (1) {
        wait(0.1);

        // test accelerometer
        acc.getOutput(readings);
        pc.printf("acc: %i, %i, %i\r\n", (int16_t)readings[0], (int16_t)readings[1], (int16_t)readings[2]);

        // test strtch sensor
        str = strength.read_u16();
        pc.printf("strength: %d\r\n", str);
        
        // test USB relative mouse
        mouse.move(10, 10);
    }
}
