/*
Enhanced Vehicle Diagnostics
ELM327 Version Utilizing HC-05 Bluetooth hardware and ELM327
*/
#include "mbed.h"
#include "N5110.h"
#include <string>
using namespace std;

N5110 LCD(PTB2,PTD0,PTB9,PTB3,PTD2,PTD1,PTD0);
Serial HC05(PTC17,PTC16);
Serial SR(USBTX,USBRX);

DigitalIn sw2(SW2);
DigitalIn sw3(SW3);
DigitalOut led(LED_RED);

char percent='%';
int flag=1;
char zero[2]={0x01,0x0c,};
char OBD[13];
char RPM[13];
char SPD[13];
char TMP[13];
char MAF[13];
char THR[13];

int OBDInit(void);
void OBDLiveData(void);
int main() {
      char c;
      HC05.format(8, Serial::None, 1);
      HC05.baud(115200);
      LCD.init();
      LCD.clear();
      led=1;
    //Initialization message//         
    LCD.printString ("-ENHANCED-", 0, 0);
    LCD.printString ("-VEHICLE-", 0, 1);
    LCD.printString ("-DIAGNOSTICS-", 0, 2);
    //LCD.printString ("ECE 595", 0, 3);
    //LCD.printString ("SAM THOMAS", 0, 4);
    wait(1);
    LCD.clear();
    LCD.printString ("-INITIALIZE-",0, 2);
    OBDInit();
    wait(1);
      LCD.clear();
      //HC05.printf(zero);
      while(1){
                if(flag){//static display incase HC05 connection fails
                LCD.printString("RPM 3000", 0, 0);
               
                LCD.printString("SPD 65KMPH", 0, 1);

                LCD.printString("TMP 80 C", 0, 2);

                LCD.printString("MAF 190 g/s", 0, 3);

                LCD.printString("THR 60", 0, 4);
                }
                else{
                    OBDLiveData();
                    }
          
           }
}
int OBDInit(){
    if(HC05.readable()){
        HC05.printf("ATZ\r");
        HC05.printf("ATSP0\r");
        HC05.printf("0100\r");
        return 1;
    }
    else
    {
        LCD.printString("Bluetooth NOT available",0,0);
        return 0;
    }
}
void OBDLiveData(){
    char c;
    if(HC05.readable()){
           c=HC05.getc();
           if(c=='~')//Get the initial character sent
            { 
                flag=0;
                LCD.clear();
                //takes in the whole string sent to it From PC below
                HC05.scanf("%s",&OBD);
                SR.printf(OBD);
                sprintf(RPM,"RPM %c%c%c%c",OBD[0],OBD[1],OBD[2],OBD[3]);
                sprintf(SPD,"SPEED %c%cKMPH",OBD[4],OBD[5]);
                sprintf(TMP,"E.TMP %c%c F",OBD[6],OBD[7]);
                sprintf(MAF,"MAF %c%c%c g/s",OBD[8],OBD[9],OBD[10]);
                sprintf(THR,"THR %c%c %c",OBD[11],OBD[12],percent);
                LCD.clear();   
                LCD.printString(RPM, 0, 0);
                SR.printf(RPM);
                LCD.printString(SPD, 0, 1);
                SR.printf(SPD);
                LCD.printString(TMP, 0, 2);
                SR.printf(TMP);
                LCD.printString(MAF, 0, 3);
                SR.printf(MAF);
                LCD.printString(THR, 0, 4);
                SR.printf(THR);
                //If SW2 is pressed Check Engine codes are displayed
                if(!sw2){
                  if(!sw2){
                  LCD.clear();
                  LCD.printString ("CHECKING ", 0, 0);
                  LCD.printString ("ENGINE ", 0, 1);
                  LCD.printString ("Code(s) ", 0, 2);
                  wait(2);
                  LCD.clear();
                  LCD.printString ("DTC CODE: ", 0, 0);
                  LCD.printString ("P0103 ", 0, 1);
                  LCD.printString ("Mass Air Flow", 0, 2);
                  LCD.printString ("High Input", 0, 3);
                  led=0;
                  wait(2);
                  }
                }
              }
            }
}