#include "spi_ram.h"

SRAM::SRAM(SPI& spiDef, PinName csiPin) : spi(spiDef), csi(csiPin)  {
    deselect();
}

void SRAM::select() {
    csi = 0;
}

void SRAM::deselect() {
    csi = 1;
}

void SRAM::writeStatus(char status) {
    select();
    spi.write(WRITE_STATUS);
    spi.write(status);
    deselect();
}
 
char SRAM::readStatus() {
    select();
    spi.write(READ_STATUS);
    char result = (char)spi.write(0);
    deselect();
    return result;
}
 
void SRAM::prepareCommand(char command, int address) {
    select();
    spi.write(command);
    spi.write(address >> 16);
    spi.write((address >> 8) & 0xFF);
    spi.write(address & 0xFF);
}

void SRAM::startWriteSequence() {
    select();
    writeStatus(SEQUENTIAL_MODE);
    prepareCommand(WRITE, 0);
}

void SRAM::writeSequence0(char c) {
    while (!(LPC_SSP0->SR & TNF));       // While TNF-Bit = 0, wait for FIFO
    LPC_SSP0->DR = c;                // Write to FIFO buffer
    while( !(LPC_SSP0->SR & RNE));
    uint8_t v = LPC_SSP0->DR;
}

void SRAM::writeSequence1(char c) {
    while (!(LPC_SSP1->SR & TNF));       // While TNF-Bit = 0, wait for FIFO
    LPC_SSP1->DR = c;                // Write to FIFO buffer
    while( !(LPC_SSP1->SR & RNE));
    uint8_t v = LPC_SSP1->DR;
}

void SRAM::startReadSequence() {
    select();
    writeStatus(SEQUENTIAL_MODE);
    prepareCommand(READ, 0);
}

char SRAM::readSequence0() {
    while (!(LPC_SSP0->SR & TNF));       // While TNF-Bit = 0, wait for FIFO
    LPC_SSP0->DR = 0;                // Write to FIFO buffer
    while( !(LPC_SSP0->SR & RNE));
    return LPC_SSP0->DR;
}

char SRAM::readSequence1() {
    while (!(LPC_SSP1->SR & TNF));       // While TNF-Bit = 0, wait for FIFO
    LPC_SSP1->DR = 0;                // Write to FIFO buffer
    while( !(LPC_SSP1->SR & RNE));
    return LPC_SSP1->DR;
}

void SRAM::stopSequence() {
    deselect();
    writeStatus(BYTE_MODE);
}