#include "mbed.h"
#include "Constants.h"
#include "OV7670.h"
#include "FastPWM.h"
#include "spi_ram.h"
#include "MODSERIAL.h"

#define SIZEX (160)
#define SIZEY (120)
#define SIZE 19200

OV7670 camera(
    p28, p27,           // SDA,SCL(I2C / SCCB)
    p21, p22, p23, p24, // XCLK, PCLK, VSYNC, HREF
    Port0, 0x07878000); // D0-D7 -> P11-p18
    
Serial host(USBTX, USBRX);
MODSERIAL bt(p9, p10, 16384, 512);
DigitalOut status(p20);
int feedMode = 0;

int hexToInt(int i) {
    if(i >= '0' && i <= '9') return i - '0';
    else if(i >= 'A' && i <= 'F') return i - 55;
    else return 0;
}

int getHexWord(Serial *ser) {
    int b1 = ser->getc();
    int b2 = ser->getc();
    return (hexToInt(b1) << 4) | hexToInt(b2);
}

void readLine(Serial *ser, char *data) {
    int i=0;
    char c = '0';
    while(c != '\n') {
        if(ser->readable()) {
            c = ser->getc();
            data[i++] = c;
        }
    }
    data[i] = '\0';
}

int main() {
    host.baud(115200);
    bt.baud(230400);
    
    // Initialize a 12Mhz XCLK for the camera
    camera.Init();
    
    // Reset camera on power up
    camera.Reset();
    
    // Set up for 160*120 pixels RGB565
    camera.InitQQVGA();

    char c;
    char data[20];
    while(1) {
        if(bt.readable()) {
            c = bt.getc();
            switch(c) {
                case REQUEST_PROFILE:
                    host.printf("Profile requested\n\r");
                    bt.putc(CLIENT_PROFILE);
                    bt.putc((TAPCAM_ID >> 4) & 0x0F);
                    bt.putc(TAPCAM_ID & 0x0F);
                    bt.printf("device\n");
                    break;
                case CLIENT_PROFILE: {
                    host.printf("Client profile:\n\r");
                    int id = bt.getc() << 4;
                    id |= bt.getc();
                    readLine(&bt, data);
                    host.printf("ID: %d\n\r", id);
                    host.printf("Type: %s\n\r", data);
                    break;
                }
                case FEED_REQUEST:
                    host.printf("Feed requested\n\r");
                    bt.putc(FEED_START);
                    break;
                case FEED_START_ACK:
                    host.printf("Feed start acknowledged\n\r");
                    feedMode = 1;
                    break;
                case FEED_CANCEL:
                    host.printf("Feed canceled\n\r");
                    feedMode = 0;
                    break;
            }
        }
        if(feedMode) {
            int bytes = camera.captureImage();
            bt.putc(FRAME_READ);
            bt.printf(ORIENTATION);
            bt.printf("%d\n", bytes);
            camera.sendImage(&bt, bytes);
            host.printf("Sent %d\n\r", bytes);
            wait_ms(100);
        }
        if(host.readable()) {
            c = host.getc();
            if(c == 'r') {
                int reg = getHexWord(&host);
                host.printf("%d\n\r", camera.ReadReg(reg));
            } else if(c == 'w') {
                int reg = getHexWord(&host);
                int val = getHexWord(&host);
                camera.WriteReg(reg, val);
                host.printf("%d\n\r", camera.ReadReg(reg));
            } else if(c == 't') {
                camera.scopeTest(&host);
            } else if(c == 'c') {
                status = 1;
                int bytes = camera.captureImage();
                host.printf("%d\n", bytes);
                camera.sendImage(&host, bytes);
                status = 0;
            } else if(c == 's') {
                feedMode = false;
            } else if(c == 'p') {
                bt.putc(REQUEST_PROFILE);
            }
        }
    }
}

