#include "mbed.h"

#ifndef  SPI_RAM_H
#define  SPI_RAM_H

// Mode codes
#define BYTE_MODE       0x00
#define SEQUENTIAL_MODE 0x40

// Command codes
#define READ            0x03
#define WRITE           0x02
#define READ_STATUS     0x05
#define WRITE_STATUS    0x01

// Underlying SPI constants
#define TFE             0x02
#define TNF             0x02
#define RNE             0x04

class SRAM {
public:

    SRAM(SPI& spiDef, PinName csiPin);

    char readStatus();
    void writeStatus(char status);
    void startWriteSequence();
    void startReadSequence();
    void writeSequence0(char c);
    void writeSequence1(char c);
    char readSequence0();
    char readSequence1();
    void stopSequence();

private:
    SPI& spi;
    DigitalOut csi;
    void prepareCommand(char command, int address);
    void select();
    void deselect();
};

#endif