 /*
 k64F -- OLED
 D11 mosi/D0
 D13 sck/D1
 D5 CS
 D6 DC
 D7 RST
 */
#include "mbed.h"
#include "Adafruit_SSD1306.h"
 
DigitalOut myled(LED2);
 
// an SPI sub-class that provides a constructed default
class SPIPreInit : public SPI
{
public:
    SPIPreInit(PinName mosi, PinName miso, PinName clk) : SPI(mosi,miso,clk)
    {
        format(8,3);
        frequency(2000000);
    };
};

SPIPreInit mySpi(D11,NC,D13);
Adafruit_SSD1306_Spi myOled(mySpi,D6,D7,D5,64,128);

int main()
{  
    uint16_t x=0;
    myOled.clearDisplay();
    myOled.printf("%ux%u OLED Display\r\n", myOled.width(), myOled.height());
    myOled.setTextCursor(0,17);
    myOled.printf("blog:enjoythe.party\r\n");
    myOled.printf("qq:1028917076\r\n");
    myOled.printf("phone:1709005xxxxx\r\n");
    while(1)
    {
        myled = !myled;
        myOled.printf("%u\r ",x);
        myOled.display();
        x++;
        wait(1.0);
    }
     
}