#ifndef FMS_ALL_INCLUDED
#define FMS_ALL_INCLUDED
//#include "ThreadsAndFunctions.h"
// Includes MMS RAM functions also

/*===================================================FMS Functions=================================================*/
//==========for P_PL_RCV_SC_DATA==========// 
dmaSPISlave *gPAY_SPI;
void payload_isr_fun(){
    gSCIENCE_THREAD->signal_set(SCIENCE_SIGNAL);
  
}
//=========================================//
//Run processes
void P_PL_INIT();
void P_PL_MAIN();
void P_COM_INIT();
void P_PL_RCV_SC_DATA();
void P_CDMS_INIT_SD();

// Switch ON/OFF functions
void CDMS_SD_SW_ON();
void CDMS_SD_SW_OFF();
void CDMS_RTC_ON();
void CDMS_RTC_OFF();
void SW_ON_BAE();
void SW_OFF_BAE();
void SW_ON_PL_BEE();
void SW_OFF_PL_BEE();
void SW_ON_PL_EPS();
void SW_OFF_PL_EPS();
void SW_ON_V_A_EN();
void SW_OFF_V_A_EN();

// RST functions
void RST_SD();
void SW_RST_BAE();
void SW_RST_PL_BEE();
void RST_BAE();
void RST_PL_BEE();
void CDMS_RESET();
void SYS_PWR_RESET();  // Have to be decided with EPS team.
void sys_pwr_reset(void const *args);
void EPS_V_A_EN();
void EPS_V_C_EN();

void RST_HK_COUNTER();
int8_t CDMS_RD_SD_HK(uint8_t *);
void CDMS_CALIB_RTC(uint8_t *);
void TOTAL_RESET_WITH_CDMS();

void sys_pwr_reset(void const *args){
    SYS_PWR_RESET();
}

void P_PL_INIT()
{
    gPC.printf("No such TC, here have some motivation instead\r\n");
    gPC.printf("This satellite will work , you just have to believe\r\n");
}

void P_PL_MAIN()
{
   FCTN_CDMS_PL_MAIN((void *)NULL);
}

void P_COM_INIT()
{
    P_COM_INIT;
}

void P_PL_RCV_SC_DATA()
{   gPC.printf("\r\nFM TC....Testing Payload science mode\r\n");
    PL_SC_TEST = true;
    PL_GPIO_2_STATUS=0;
    gPAY_SPI->bulkRead_resume(&payload_isr_fun);//runs science thread while com is waiting
    gMutex.unlock();
    //gSCIENCE_THREAD->signal_set(SCIENCE_SIGNAL);
    Thread::signal_wait( RCVED_SCI_DATA_SIGNAL );
    //gPC.printf("\r\nit works!!!\r\n");
    PL_GPIO_2_STATUS = 1;
    gPAY_SPI->bulkRead_pause();

    gMutex.lock();
}

void P_CDMS_INIT_SD()
{
    FCTN_CDMS_SD_INIT();
}

void CDMS_SD_SW_ON()
{
   // SD_CARD_fromuC_ENA3 = 1; 
 //   SD_CARD_fromISO_ENA4 = 1;
    SD_SW_EN_DS = 1;
    SD_STATUS = DEVICE_POWERED;
    WRITE_TO_EEPROM(2,DEVICE_POWERED);
    gPC.printf("sw on sd\n");
}

void CDMS_SD_SW_OFF()
{
 //   SD_CARD_fromuC_ENA3 = 0; 
 //   SD_CARD_fromISO_ENA4 = 0;
    SD_SW_EN_DS = 0;
    SD_STATUS = DEVICE_DISABLED;
    WRITE_TO_EEPROM(2,DEVICE_DISABLED);
    gPC.printf("sw off sd\n");
}

void CDMS_RTC_ON()
{
    //FCTN_CDMS_INIT_RTC();
    SPI_mutex.lock();
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x01); //reading seconds register
    uint8_t response =spi.write(0x01);
    response = response & 0x7F;
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x8C); //register address with write flag
    spi.write(0x00);//enabling halt bit in the seconds register
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x81); //register address with write flag
    spi.write(response);//disabling stop bit in the seconds register
    gCS_RTC=1;

     //EN_RTC = 0x01;
    CDMS_RTC_DISABLE =1;
    WRITE_TO_EEPROM(6,DEVICE_POWERED);
  //  gPC.printf("0x%08X \n", READ_FROM_EERPOM(6));
    SPI_mutex.unlock();
    gPC.printf("sw on rtc\n");
}

void CDMS_RTC_OFF()
{
    SPI_mutex.lock();
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x01); //reading seconds register
    uint8_t response =spi.write(0x01);
    response = response + 0x80;
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x81); //register address with write flag
    spi.write(response);//enabling stop bit in the seconds register + also preserving the second bits in the register
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x8C); //register address with write flag
    spi.write(0x40);//enabling halt bit in the seconds register
    gCS_RTC=1;
   
   //EN_RTC  = 0x00;
    CDMS_RTC_DISABLE = 0;
    WRITE_TO_EEPROM(6,0x00);
    SPI_mutex.unlock();
    gPC.printf("sw off rtc\n");
}

void SW_ON_BAE()
{
    BAE_SW_EN_DS = 1;
    BAE_STATUS = DEVICE_POWERED;
    WRITE_TO_EEPROM(1,DEVICE_POWERED);
    gPC.printf("sw on bae\n");
}

void SW_OFF_BAE()
{
    BAE_SW_EN_DS = 0;
    BAE_STATUS = DEVICE_DISABLED;
    WRITE_TO_EEPROM(1,DEVICE_DISABLED);
    gPC.printf("sw off bae\n");
}

void SW_ON_PL_BEE()
{
    PYLD_DFF_CLK = 0;
    PYLD_DFF = 1;
    wait_us(1);
    PYLD_DFF_CLK = 1;
    wait_us(1);
    PYLD_DFF_CLK = 0;
    wait_us(1);
    PL_BEE_SW_STATUS = DEVICE_POWERED;
    WRITE_TO_EEPROM(4,DEVICE_POWERED);
}

void SW_OFF_PL_BEE()
{
    PYLD_DFF_CLK = 0;
    PYLD_DFF = 0;
    wait_us(1);
    PYLD_DFF_CLK = 1;
    wait_us(1);
    PYLD_DFF_CLK = 0;
    wait_us(1);
    PL_BEE_SW_STATUS = DEVICE_DISABLED;
    WRITE_TO_EEPROM(4,DEVICE_DISABLED);
}

void SW_ON_PL_EPS()
{
    PYLD_EPS_DFF_PWR_CLK = 0;
    PYLD_EPS_DFF_PWR = 1;
    wait_us(1);
    PYLD_EPS_DFF_PWR_CLK = 1;
    wait_us(1);
    PYLD_EPS_DFF_PWR_CLK = 0;
    wait_us(1);
    PL_EPS_LATCH_SW_EN = 1;
}

void SW_OFF_PL_EPS()
{
    PYLD_EPS_DFF_PWR_CLK = 0;
    PYLD_EPS_DFF_PWR = 0;
    wait_us(1);
    PYLD_EPS_DFF_PWR_CLK = 1;
    wait_us(1);
    PYLD_EPS_DFF_PWR_CLK = 0;
    wait_us(1);
    PL_EPS_LATCH_SW_EN = 0;
}

void SW_ON_V_A_EN()
{
    V_A_EN = 1;
    EPS_V_A_EN_STATUS = 1;
    WRITE_TO_EEPROM(0,1);
   
}

void SW_OFF_V_A_EN()
{
    V_A_EN = 0;
    EPS_V_A_EN_STATUS = 0;
    WRITE_TO_EEPROM(0,0);
}

void RST_SD()
{
    SD_CARD_fromuC_ENA3 = 0; 
    SD_CARD_fromISO_ENA4 = 0;
    SD_SW_EN_DS = 0;
    wait_ms(10);
    SD_CARD_fromuC_ENA3 = 1; 
    SD_CARD_fromISO_ENA4 = 1;
    SD_SW_EN_DS = 1;
    SD_STATUS = DEVICE_POWERED;
    WRITE_TO_EEPROM(2,DEVICE_POWERED);
    gPC.printf("rst sd\n");
}

void SW_RST_BAE()
{
   BAE_SW_EN_DS = 0;
   wait(5);
   BAE_SW_EN_DS = 1;
   
    BAE_STATUS = DEVICE_POWERED;
    WRITE_TO_EEPROM(1,DEVICE_POWERED);
    gPC.printf("rst bae\n");
}

void SW_RST_PL_BEE()
{
    SW_OFF_PL_BEE();
    wait_ms(10);
    SW_ON_PL_BEE();
}

void RST_BAE()
{
    RESET_TO_BAE = 0;
    wait_ms(10);
    RESET_TO_BAE = 1;
}

void RST_PL_BEE()
{
    RESET_TO_PYLD = 0;
    wait_ms(10);
    RESET_TO_PYLD = 1;
}

void CDMS_INTERNAL_RESET()
{
    NVIC_SystemReset();
}

void SYS_PWR_RESET()  // Have to be decided with EPS team.
{
    //sys_pwr_rst = 1;
}

void EPS_V_A_EN()     // This is a reset function
{
    V_A_EN = 0;
    wait_ms(10);
    V_A_EN = 1;
}

void EPS_V_C_EN()     // This is a reset function
{
    COM_RX_CNTRL = 0;
    wait_ms(10);
    COM_RX_CNTRL = 1;
}

void RST_HK_COUNTER()
{
    firstCount = true;
    CDMS_HK_MAIN_COUNTER = 0;
    PL_MAIN_COUNTER = 0;
    PL_RCV_SC_DATA_COUNTER = 0;
    COMRX_RESET_COUNTER = 0;
}

int8_t CDMS_RD_SD_HK(uint8_t *sd_statusbits)
{
    int8_t p;
    if(SD_SW_EN_DS != DEVICE_POWERED)
    {
        SD_RD_ERROR = 1;
        p = 1;
    }
    else
    {
        p = disk_read_statusbits(sd_statusbits);
    }
    return p;
}

void CDMS_CALIB_RTC(uint32_t time)
{
    gPC.printf("\n\r Hello : %u",time);
    SPI_mutex.lock();
    gCS_RTC=1;
    spi.format(8,0);
    spi.frequency(1000000);
 
    gPC.printf("\n\rseconds: %u",((((((uint8_t)(time) & 0x3F)/10)<<4)+(((uint8_t)(time) & 0x3F)%10)) & 0x7F));
    gCS_RTC=0;
    spi.write(0x81);
    spi.write((((((uint8_t)(time) & 0x3F)/10)<<4)+(((uint8_t)(time) & 0x3F)%10)) & 0x7F);//set seconds plus stop bit = 0
    gCS_RTC=1;
     
    gPC.printf("\n\rminutes: %u",(((((uint8_t)(time>>6) & 0x3F)/10)<<4)+(((uint8_t)(time>>6) & 0x3F)%10)));
    gCS_RTC=0;
    spi.write(0x82);
    spi.write(((((uint8_t)(time>>6) & 0x3F)/10)<<4)+(((uint8_t)(time>>6) & 0x3F)%10));//set minutes
    gCS_RTC=1;
 
    gPC.printf("\n\rhours: %u",(((((uint8_t)(time>>12) & 0x1F)/10)<<4)+(((uint8_t)(time>>12) & 0x1F)%10)));
    gCS_RTC=0;
    spi.write(0x83); 
    spi.write(((((uint8_t)(time>>12) & 0x1F)/10)<<4)+(((uint8_t)(time>>12) & 0x1F)%10)); //set hours
    gCS_RTC=1;
    
    gPC.printf("\n\rdate : %u",(((((uint8_t)(time>>17) & 0x1F)/10)<<4)+(((uint8_t)(time>>17) & 0x1F)%10)));
    gCS_RTC=0;
    spi.write(0x85); 
    spi.write(((((uint8_t)(time>>17) & 0x1F)/10)<<4)+(((uint8_t)(time>>17) & 0x1F)%10)); //set date
    gCS_RTC=1;
    
    gPC.printf("\n\rmonth : %u",(((((uint8_t)(time>>22) & 0x0F)/10)<<4)+(((uint8_t)(time>>22) & 0x0F)%10)));
    gCS_RTC=0;
    spi.write(0x86); 
    spi.write(((((uint8_t)(time>>22) & 0x0F)/10)<<4)+(((uint8_t)(time>>22) & 0x0F)%10)); //set month
    gCS_RTC=1;
    
    uint8_t temp = ((((uint8_t)(time>>26) & 0xFF)/10)<<4)+(((uint8_t)(time>>26) & 0xFF)%10);
    gPC.printf("\n\rtemp : %u",((((uint8_t)(time>>26) & 0xFF)/10)<<4)+(((uint8_t)(time>>26) & 0xFF)%10));
    uint8_t year = (temp == 0x00)?0x16:(temp == 0x01)?0x17:(temp == 0x02)?0x18:(temp == 0x03)?0x019:0x16;
    gCS_RTC=0;
    spi.write(0x87); 
    spi.write(year); //set year
    gCS_RTC=1;
    gPC.puts("\n\r rtc initalised \n");
    SPI_mutex.unlock();
}

void CDMS_RESET()
{
    NVIC_SystemReset();    
}

/*
//void CDMS_INTERNAL_RESET()
{
    
}
*/

//===============================MMS RAM functions==================================

void FCTN_CDMS_RD_L_RAM(Base_tm *);

void FCTN_CDMS_RD_L_RAM(Base_tm *tm_pointer)
{
    uint32_t time = FCTN_CDMS_RD_RTC() >> 7;             //Reading Time from RTC
    for(int i = 124; i<128; i++)
    CDMS_HEALTH_DATA[i] = time >> (127-i)*8;
    for(int i=0;i<128;i++)
    {
        //tm_pointer->TM_string[i] = 0;
        tm_pointer->TM_string[i+4] = CDMS_HEALTH_DATA[i];
    }
    
}

void FCTN_CDMS_MAX_MIN(Base_tm *);                      //idk Joel

void FCTN_CDMS_MAX_MIN(Base_tm *tm_pointer)
{ 
    tm_pointer->TM_string[4] = MAX_COM_ADF_TMP+40;
    tm_pointer->TM_string[6] = (uint8_t)(MAX_RSSI_VOLTAGE*10);
    
    for(int i=0;i<16;i++)
    {
        //tm_pointer->TM_string[i] = 0;
        tm_pointer->TM_string[i+7] = (uint8_t)(min_max_data.temp_max[i]);
    }
    
    tm_pointer->TM_string[23] = MIN_COM_ADF_TMP+40;
    tm_pointer->TM_string[25] = (uint8_t)(MIN_RSSI_VOLTAGE*10);
    
    for(int i=0;i<16;i++)
    {
        //tm_pointer->TM_string[i] = 0;
        tm_pointer->TM_string[i+26] = (uint8_t)(min_max_data.temp_min[i]);
    }

    tm_pointer->TM_string[42] = GPIO_FAULTS>>8;
    tm_pointer->TM_string[43] = (GPIO_FAULTS<<3) & 0x00FF;
    
    TIME_LATEST_RTC= FCTN_CDMS_RD_RTC() >> 7;
    for(int i = 0; i<4; i++)
        tm_pointer->TM_string[44+i] = TIME_LATEST_RTC >> (3-i)*8; 
}

void FCTN_SCP_CALIB_A(Base_tm *, uint16_t);

void FCTN_SCP_CALIB_A(Base_tm *tm_pointer, uint16_t mid)
{
    uint32_t temp_e2prom[32] = {0};
//    THRES_READ_FROM_EEPROM(mid, temp_e2prom);
    for(uint8_t i = 0; i < 32; i++)
    {
        tm_pointer->TM_string[(4*i)+4] = (temp_e2prom[i]>>24);
        tm_pointer->TM_string[(4*i)+5] = (temp_e2prom[i]>>16);
        tm_pointer->TM_string[(4*i)+6] = (temp_e2prom[i]>>8);
        tm_pointer->TM_string[(4*i)+7] = temp_e2prom[i];
    }
}
#endif