// TESTING PUSH PULL IN MAIN CPP

#include "mbed.h"

#define DEBUG 1

#include "SimpleDMA.h"
#include "dmaSPIslave.h"
#include "rtos.h"
#include "mbed_debug.h"
void rx_read();
#include "Structures.h"
#include "pinconfig.h"
#include "DefinitionsAndGlobals.h"
#include "crc.h"
#include "i2c.h"
#include "COM_SND_TM_functions.h"
#include "Flash.h"
#include "cdms_rtc.h"
#include "COM_SND_TM.h"
#include "cdms_sd.h"
#include "common_functions.h"
#include "RESET_functions.h"
#include "CDMS_PL.h"
#include "CDMS_HK.h"
#include "adf.h"
#include "COM_RCV_TC.h"
#include "FMS_all.h"
#include "Compression.h"
#include "COM_MNG_TMTC.h"
#include "COM_POWER_OFF_TX.h"
#include "COM_POWER_ON_TX.h"
#include "OBSRS.h"
#include "ThreadsAndFunctions.h"
#include "TEST_PL.h"

int main()
{    
    
    //RELAY SWITCHING 
    
    
    RF_SW_CNTRL_BCN = 1;
    Thread::wait(25);
    RF_SW_CNTRL_BCN = 0;
    PYLD_DFF = 1;
    
    for(int i= 0; i< 10 ; i++)
    {PYLD_DFF_CLK = !PYLD_DFF_CLK;
    wait_us(10);} 
    
    CDMS_I2C_GPIO = 0; 
    PL_I2C_GPIO = 0; 
    
    RX1M.baud(1200);
    gRX_HEAD_DATA_NODE = new COM_RX_DATA_NODE;
    gRX_HEAD_DATA_NODE->next_node = NULL;
    gRX_CURRENT_DATA_NODE = gRX_HEAD_DATA_NODE;
    gRX_COUNT = 0;
    RX1M.attach(&rx_read, Serial::RxIrq);
    
   gPC.baud(1200);//changed for bypassing COM
   
    
    //Base_tm *tm_ptr = NULL;
    //SET_BCN_STANDBY(tm_ptr);
    //gPC.puts("set Bcn off\r\n");
    
    // COMMON SPI
    spi.format(8,0);
    spi.frequency(500000);

    SD_SW_EN_DS = 0; 
    wait(1);
    SD_SW_EN_DS = 1;
    wait(1);
    // SD CARD
    cs_sd = 1;
    gCS_RTC = 1;
    gCS_ADF = 1;
    
    FCTN_CDMS_INIT_RTC();/* rtc initialization*/
    FCTN_CDMS_SD_INIT();/* sd card initialization*/
    
    
    uint8_t test[512] = {0};
    disk_write(test,8000); //to be used only just before launch
    
    #if DEBUG
    gPC.puts("welcome to mng_tmtc\r\n");
    #endif
    
    #if DEBUG
    gPC.puts("allocating threads\r\n");
    #endif
    
    // COM_POWER_ON_TX();
    
    // COM_MNG_TMTC THREAD
    gCOM_MNG_TMTC_THREAD = new Thread(COM_MNG_TMTC_FUN);
    gCOM_MNG_TMTC_THREAD->set_priority(osPriorityRealtime);
    
    gHK_THREAD = new Thread(FCTN_CDMS_HK_MAIN);
    gHK_THREAD->set_priority(osPriorityAboveNormal);
    
    gSCIENCE_THREAD = new Thread(SCIENCE_FUN);
    gSCIENCE_THREAD->set_priority(osPriorityHigh);
    
    #if DEBUG
    gPC.puts("completed allocating threads\r\n");
    #endif 
    
    master.frequency(400000);
    
    HK_counter = new RtosTimer(hk_isr, osTimerPeriodic,(void * )NULL);
    gHK_THREAD->signal_set(HK_SIGNAL);
    HK_counter->start(10000);
    
    sys_reset_cdms_timer = new RtosTimer(sys_pwr_reset, osTimerPeriodic, (void * )NULL);
    sys_reset_cdms_timer->start(cdms_reset_timeout);

    //PL_wo_dma = new RtosTimer(payload_isr_fun_dma, osTimerPeriodic,(void * )NULL);
    //PL_wo_dma->start(6000);
    //gSCIENCE_THREAD->signal_set(SCIENCE_SIGNAL);
    
    /*Timeout flipper;
    flipper.attach(BAE_TC,31);*/
    
    /*while(1){
    gPC.printf("PL_TC sending\r\n");
    
    Base_tm *tm_ptr = new Long_tm;
    PL_TC(tm_ptr);
    wait(1);
    }
    gPC.printf("PL_TC sent");*/
    //test_pl_main();
    while(true){
        Thread::wait(osWaitForever);
         gLEDG = !gLEDG;
    }
}