//Science Thread
//SPI ISR
void payload_isr_fun(){
    gSCIENCE_THREAD->signal_set(SCIENCE_SIGNAL);
}

void payload_isr_fun_dma(void const *args ){
    gSCIENCE_THREAD->signal_set(SCIENCE_SIGNAL);
}

void SCIENCE_FUN(void const *args){
    gPAY_SPI = new dmaSPISlave(PAY_SPI_MOSI, PAY_SPI_MISO, PAY_SPI_CLK, PAY_SPI_CS);
    gPAY_SPI->frequency(1000000);
    gPAY_SPI->format(8,0);
    gPAY_SPI->bulkRead_init(gPAYLOAD_BUFFER, PAYLOAD_BUFFER_LENGTH, &payload_isr_fun);
    gPAY_SPI->bulkRead_start();
    while(true){
        gPC.puts("entering sci\r\n");
        gSCIENCE_THREAD->signal_wait(SCIENCE_SIGNAL);
        gMutex.lock();
        gPC.puts("sig_set\r\n");
        srp(gPAYLOAD_BUFFER);//skip one apcket when cdms resets
        gPC.puts("exit_srp\r\n");
        wait(2);/*timeout to be decided*/
        if(dma)
        gPAY_SPI->bulkRead_start();
        gMutex.unlock();
    }
}

//HK Thread(Contains HK_main() and PL_main())
//RTOS timer calllback func
void hk_isr(void const *args){
    gHK_THREAD->signal_set(HK_SIGNAL);
}


//COM THREAD
// UART ISR
void rx_read(){
    gRX_CURRENT_DATA_NODE->values[gRX_COUNT] = RX1M.getc();
    gFLAGS = gFLAGS | UART_INT_FLAG;
    gCOM_MNG_TMTC_THREAD->signal_set(COM_MNG_TMTC_SIGNAL_UART_INT);
}

// COM_RX_DISABLE ISR
void after_com_disable(){
    gCOM_RX_DISABLE.detach();
    RX1M.attach(&rx_read, Serial::RxIrq);
}

// RX_TIMEOUT ISR
void after_receive(){
    gRX_TIMEOUT.detach();
    gFLAGS = gFLAGS | NEW_TC_RECEIVED;
    gCOM_MNG_TMTC_THREAD->signal_set(COM_MNG_TMTC_SIGNAL_UART_INT);
}

// SESSION_TIMOUT ISR
void after_session(){
    gSESSION_TIMEOUT.detach();
    gFLAGS = gFLAGS | COM_SESSION_TIMEOUT_FLAG;
    if( gMASTER_STATE != TCL_STATE_EXECUTING ){
        gCOM_MNG_TMTC_THREAD->signal_set(COM_MNG_TMTC_SIGNAL_UART_INT);
    }
}

#define reset_all {\
    Base_tc *tcp = gHEAD_NODE_TCL;\
    /*gPC.puts("inside reset\r\n");*/\
    gFLAGS = 0x0000;\
    while(tcp != NULL){\
        Base_tc *temp = tcp->next_TC;\
        delete tcp;\
        tcp = temp;\
    }\
    gHEAD_NODE_TCL = NULL;\
    gLAST_NODE_TCL = NULL;\
    gMASTER_STATE = TCL_STATE_COMPLETED;\
    gTOTAL_INCORRECT_SIZE_TC = 0;\
    gTOTAL_CRC_FAIL_TC = 0;\
    gTOTAL_REPEATED_TC = 0;\
    gTOTAL_VALID_TC = 0;\
    for(int i = 0 ; i < TM_LONG_SIZE ; ++i){\
        /*gLAST_TM[i] = 0x00;*/\
    }\
    /*gLAST_TM_SHORT_OR_LONG = SHORT_TM_CODE;*/\
    COM_RX_DATA_NODE *dataptr = gRX_HEAD_DATA_NODE;\
    while( dataptr != NULL ){\
        COM_RX_DATA_NODE *temp = dataptr->next_node;\
        delete dataptr;\
        dataptr = temp;\
    }\
    gRX_HEAD_DATA_NODE = new COM_RX_DATA_NODE;\
    gRX_HEAD_DATA_NODE->next_node = NULL;\
    gRX_CURRENT_DATA_NODE = gRX_HEAD_DATA_NODE;\
    gRX_COUNT = 0;\
    gTOTAL_RAW_BYTES = 0;\
    /*PENDING : ALL GLOBAL VAARIABLES AND FLAGS*/\
    /*gPC.puts("finished reset all\r\n");*/\
}

#define PUT_RAW_BYTE {\
    if( gRX_COUNT < (RX_BUFFER_LENGTH-1) ){\
        ++gRX_COUNT;\
    }\
    else{\
        gRX_COUNT = 0;\
        gRX_CURRENT_DATA_NODE->next_node = new COM_RX_DATA_NODE;\
        gRX_CURRENT_DATA_NODE = gRX_CURRENT_DATA_NODE->next_node;\
        gRX_CURRENT_DATA_NODE->next_node = NULL;\
    }\
    ++gTOTAL_RAW_BYTES;\
    gRX_TIMEOUT.attach(&after_receive, RX_TIMEOUT_LIMIT);\
}

void COM_MNG_TMTC_FUN(void const *args){
    if( !(gFLAGS & COM_SESSION_FLAG) ){
        //gLEDR = 1;
        //gLEDG = 1;
    }
    while(true){
        Thread::signal_wait( COM_MNG_TMTC_SIGNAL_UART_INT );
        if( gFLAGS & UART_INT_FLAG ){
            gFLAGS = gFLAGS & (~UART_INT_FLAG);
            if( !(gFLAGS & COM_SESSION_FLAG) ){
                // DISABLE THREADS
                HK_counter->stop();
                gPAY_SPI->bulkRead_pause();
                gFLAGS = gFLAGS | COM_SESSION_FLAG;
                gSESSION_TIMEOUT.attach(&after_session, SESSION_TIME_LIMIT);
                gFLAGS = gFLAGS | COM_RX_FLAG;
                gTOTAL_RAW_BYTES = 0;
                PUT_RAW_BYTE;
                // PENDING : MEASURE RSSI
                if( gFLAGS & COM_SESSION_FLAG ){
                    //gLEDR = 0;
                    //gLEDG = 0;
                }
            }
            else if( gFLAGS & COM_RX_FLAG ){
                //gLEDR = 0;
                //gLEDG = 1;
                PUT_RAW_BYTE;
            }
            else{
                //gLEDR = 1;
                //gLEDG = 0;
                gFLAGS = gFLAGS | COM_RX_FLAG;
                PUT_RAW_BYTE;
            }
            if(gTOTAL_RAW_BYTES > BYTE_OVERFLOW_CONSTANT){
                RX1M.attach(NULL);
                gCOM_RX_DISABLE.attach(&after_com_disable, COM_RX_DISABLE_TIMEOUT);
                after_receive();
            }
        }
        else if( gFLAGS & NEW_TC_RECEIVED ){
            gPC.puts("NEW TC RECEIVED\r\n");
            Thread::wait(10000);
            gFLAGS = gFLAGS & (~NEW_TC_RECEIVED);
            gFLAGS = gFLAGS | COM_MNG_TMTC_RUNNING_FLAG;

            // DISABLE THE RX1M INTERRUPT
            RX1M.attach(NULL);
            
            // VERIFY CRC, REPEATED PSC AND UPDATE TOTAL_VALID_TC, INCORRECT SIZE TC, CRC FAIL TC
            while(gRX_COUNT < (RX_BUFFER_LENGTH)){
                gRX_CURRENT_DATA_NODE->values[gRX_COUNT] = 0x00;
                ++gRX_COUNT;
            }
            gRX_COUNT = 0;
            raw_data_to_tc();
            gFLAGS = gFLAGS & (~COM_RX_FLAG);
            
            //Mutex
            gMutex.lock();
            
            if( gTOTAL_VALID_TC > 0 ){
                gPC.printf("valid TC rx: %u\r\n", gTOTAL_VALID_TC);
                if( gTOTAL_VALID_TC < COM_MAX_TC_LIMIT ){
                    // CHECK WEATHER TC LIST HAS MISSING TC OR WEATHER LAST FRAME BIT IS HIGH IN THE LAST PSC-TC
                    gPC.puts("checking for tc list complete\r\n");
                    uint8_t tempContinue = 0xFF;
                    continueToExecute(tempContinue);
                    if(tempContinue == 0x00){
                        gPC.puts("tc list is complete\r\n");
                        // CHECK WEATHER GS VERIFICATION CODE MATCHES
                        uint8_t tempGSver = 0x00;
                        GScodeVerification(tempGSver);
                        /*PENDING: INCLUDE GS VERIFICATION CODE*/
                        if( tempGSver == 0xFF ){
                            gPC.puts("GS code match !!\r\n");
                            gFLAGS = gFLAGS | COM_SESSION_VALIDITY;
                            //sys_reset_cdms_timer->start(cdms_reset_timeout);
                            COM_POWER_ON_TX();
                            gPC.puts("P_com_hk !!\r\n");
                            P_COM_HK;
                            gPC.puts("P_com_hk !!\r\n");
                            if( (gFLAGS & COM_PA_HOT_FLAG) || ( gFLAGS & COM_PA_OC_FLAG ) ){
                                gPC.puts("Pahot or paoc !!\r\n");
                                COM_TX_CNTRL = 0;
                                gCOM_PA_COOLING_TIMEOUT.attach(&after_cooling_pa, COM_PA_COOLING_TIME_LIMIT);
                                gFLAGS = gFLAGS & (~COM_MNG_TMTC_RUNNING_FLAG);
                                RX1M.attach(&rx_read, Serial::RxIrq);
                            }
                            else{
                                gCOM_PA_COOLING_TIMEOUT.detach();
                                gPC.puts("EXECUTING TELECOMMANDS\r\n");
                                EXECUTE_OBOSC_ONLY;
                                EXECUTE_TC;
                                gPC.puts("COMPLETED EXECUTION\r\n");
                            }
                        }
                        else{
                            gPC.puts("GS code mismatch !!\r\n");
                            RX1M.attach(&rx_read, Serial::RxIrq);
                            reset_all;
                            gFLAGS = gFLAGS & (~COM_SESSION_VALIDITY);
                            // ENABLE THREADS
                            HK_counter->start(10000);
                            gPAY_SPI->bulkRead_resume(&payload_isr_fun);
                            gSESSION_TIMEOUT.detach();
                            gFLAGS = gFLAGS & (~COM_SESSION_FLAG);
                            // WARNING: clear COM_MNG_TMTC ?
                            gFLAGS = gFLAGS & (~COM_MNG_TMTC_RUNNING_FLAG);
                        }
                    }
                    else{
                        gPC.puts("tc list is not complete\r\n");
                        if(tempContinue & 0x01){
                            gPC.puts("last packet bit not found\r\n");
                        }
                        if( tempContinue & 0x02 ){
                            gPC.puts("missing psc found\r\n");
                        }
                        //gPC.printf("crc fail tc = %u\r\n", gTOTAL_CRC_FAIL_TC);
                        //gPC.printf("incorrect size tc = %u\r\n", gTOTAL_INCORRECT_SIZE_TC);
                        //gPC.printf("repeated psc = %u\r\n", gTOTAL_REPEATED_TC);
                        Base_tc *test_tc = gHEAD_NODE_TCL;
                        while( test_tc != NULL ){
                            int length = 0;
                            if( GETshort_or_long_tc(test_tc) == SHORT_TC_CODE ){
                                length = TC_SHORT_SIZE;
                            }
                            else{
                                length = TC_LONG_SIZE;
                            }
                            for(int i = 0 ; i < length ; ++i ){
                                //gPC.printf("%x ", test_tc->TC_string[i]);
                            }
                            //gPC.puts("\r\n");
                            test_tc = test_tc->next_TC;
                        }
                        //gPC.puts("\r\n");
                        COM_POWER_ON_TX();
                        // PENDING : POWER OFF TX
                        COM_TX_CNTRL = 0;
                        RX1M.attach(&rx_read, Serial::RxIrq);
                        gFLAGS = gFLAGS & (~COM_MNG_TMTC_RUNNING_FLAG);
                    }
                }
                else{
                    COM_POWER_ON_TX();
                    // POWER OFF TX transmitter only
                    // WARNING: reset_all ? clear com_session ?
                    COM_TX_CNTRL = 0;
                    reset_all;
                    gFLAGS = gFLAGS & (~COM_SESSION_FLAG);
                    RX1M.attach(&rx_read, Serial::RxIrq);
                    gFLAGS = gFLAGS & (~COM_MNG_TMTC_RUNNING_FLAG);
                }
            }
            else{
                gPC.puts("No valid TC received\r\n");
                RX1M.attach(&rx_read, Serial::RxIrq);
                gFLAGS = gFLAGS & (~COM_MNG_TMTC_RUNNING_FLAG);
                reset_all;
                // ENABLE THREADS
                HK_counter->start(10000);
                gPAY_SPI->bulkRead_resume(&payload_isr_fun);
                gSESSION_TIMEOUT.detach();
                gFLAGS = gFLAGS & (~COM_SESSION_FLAG);
            }
        }
        else if( gFLAGS & COM_PA_HOT_FLAG ){
            gPC.puts("checking for PA hot in main\r\n");
            P_COM_HK;
            if((gFLAGS & COM_PA_HOT_FLAG) || (gFLAGS & COM_PA_OC_FLAG)){
                COM_TX_CNTRL = 0;
                gCOM_PA_COOLING_TIMEOUT.attach(&after_cooling_pa, COM_PA_COOLING_TIME_LIMIT);
            }
            else{
                gCOM_PA_COOLING_TIMEOUT.detach();
                if( !(gFLAGS & COM_RX_FLAG) ){
                    gPC.puts("PA IS COOLED DOWN\r\n");
                    gFLAGS = gFLAGS | COM_MNG_TMTC_RUNNING_FLAG;
                    RX1M.attach(NULL);
                    COM_POWER_ON_TX();
                    EXECUTE_OBOSC_ONLY;
                    EXECUTE_TC;
                }
            }
        }
        else if( gFLAGS & COM_SESSION_TIMEOUT_FLAG ){
            gPC.puts("session timeout: resetting in main\r\n");
            COM_POWER_OFF_TX;
            /*ENABLE THREADS*/
            HK_counter->start(10000);
            gPAY_SPI->bulkRead_resume(&payload_isr_fun);
            gSESSION_TIMEOUT.detach();
            gFLAGS = gFLAGS & (~COM_MNG_TMTC_RUNNING_FLAG);
            gFLAGS = gFLAGS & (~COM_SESSION_FLAG);
            reset_all;
        }
        else{
            gPC.puts("INVALID SIGNAL RECEIVED IN MAIN\r\n");
            // SOME INVALID SIGNAL RECEIVED
            COM_POWER_OFF_TX;
            reset_all;
            // ENABLE THREADS
            HK_counter->start(10000);
            gPAY_SPI->bulkRead_resume(&payload_isr_fun);
            gSESSION_TIMEOUT.detach();
            gFLAGS = gFLAGS & (~COM_SESSION_FLAG);
        }
        gMutex.unlock();
    }
}