
// Includes MMS RAM functions also

/*===================================================FMS Functions=================================================*/


//Run processes
void P_PL_INIT();
void P_PL_MAIN();
void P_COM_INIT();
void P_CDMS_HK_MAIN();
void P_PL_RCV_SC_DATA();
void P_CDMS_INIT_SD();

// Switch ON/OFF functions
void CDMS_SD_SW_ON();
void CDMS_SD_SW_OFF();
void CDMS_RTC_ON();
void CDMS_RTC_OFF();
void SW_ON_BAE();
void SW_OFF_BAE();
void SW_ON_PL_BEE();
void SW_OFF_PL_BEE();
void SW_ON_PL_EPS();
void SW_OFF_PL_EPS();
void SW_ON_V_A_EN();
void SW_OFF_V_A_EN();

// RST functions
void RST_SD();
void SW_RST_BAE();
void SW_RST_PL_BEE();
void RST_BAE();
void RST_PL_BEE();
void CDMS_RESET();
void SYS_PWR_RESET();  // Have to be decided with EPS team.
void sys_pwr_reset(void const *args);
void EPS_V_A_EN();
void EPS_V_C_EN();

void RST_HK_COUNTER();
int8_t CDMS_RD_SD_HK(uint8_t *);
void CDMS_CALIB_RTC(uint8_t *);
void TOTAL_RESET_WITH_CDMS();

void sys_pwr_reset(void const *args){
    SYS_PWR_RESET();
}

void P_PL_INIT()
{
    
}

void P_PL_MAIN()
{
   FCTN_CDMS_PL_MAIN((void *)NULL);
}

void P_COM_INIT()
{
    P_COM_INIT;
}

void P_CDMS_HK_MAIN()
{
    FCTN_CDMS_HK_MAIN((void *)NULL);
}

void P_PL_RCV_SC_DATA()
{
    
}

void P_CDMS_INIT_SD()
{
    FCTN_CDMS_SD_INIT();
}

void CDMS_SD_SW_ON()
{
    SD_SW_EN_DS = 1;
    SD_STATUS = DEVICE_POWERED;
    FCTN_CDMS_WR_FLASH(2,DEVICE_POWERED);
    gPC.printf("sw on sd\n");
}

void CDMS_SD_SW_OFF()
{
    SD_SW_EN_DS = 0;
    SD_STATUS = DEVICE_DISABLED;
    FCTN_CDMS_WR_FLASH(2,DEVICE_DISABLED);
    gPC.printf("sw off sd\n");
}

void CDMS_RTC_ON()
{
    //FCTN_CDMS_INIT_RTC();
    SPI_mutex.lock();
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x81); //register address with write flag
    spi.write(0x00);//disabling stop bit in the seconds register
    SPI_mutex.unlock();
    gPC.printf("sw on rtc\n");
}

void CDMS_RTC_OFF()
{
    SPI_mutex.lock();
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x81); //register address with write flag
    spi.write(0x80);//enabling stop bit in the seconds register
    SPI_mutex.unlock();
    gPC.printf("sw off rtc\n");
}

void SW_ON_BAE()
{
    BAE_SW_EN_DS = 1;
    BAE_STATUS = DEVICE_POWERED;
    FCTN_CDMS_WR_FLASH(1,DEVICE_POWERED);
    gPC.printf("sw on bae\n");
}

void SW_OFF_BAE()
{
    BAE_SW_EN_DS = 0;
    BAE_STATUS = DEVICE_DISABLED;
    FCTN_CDMS_WR_FLASH(1,DEVICE_DISABLED);
    gPC.printf("sw off bae\n");
}

void SW_ON_PL_BEE()
{
    PYLD_DFF_CLK = 0;
    PYLD_DFF = 1;
    wait_us(1);
    PYLD_DFF_CLK = 1;
    wait_us(1);
    PYLD_DFF_CLK = 0;
    wait_us(1);
    PL_STATUS = DEVICE_POWERED;
    FCTN_CDMS_WR_FLASH(3,DEVICE_POWERED);
}

void SW_OFF_PL_BEE()
{
    PYLD_DFF_CLK = 0;
    PYLD_DFF = 0;
    wait_us(1);
    PYLD_DFF_CLK = 1;
    wait_us(1);
    PYLD_DFF_CLK = 0;
    wait_us(1);
    PL_STATUS = DEVICE_DISABLED;
    FCTN_CDMS_WR_FLASH(3,DEVICE_DISABLED);
}

void SW_ON_PL_EPS()
{
    PYLD_EPS_DFF_PWR_CLK = 0;
    PYLD_EPS_DFF_PWR = 1;
    wait_us(1);
    PYLD_EPS_DFF_PWR_CLK = 1;
    wait_us(1);
    PYLD_EPS_DFF_PWR_CLK = 0;
    wait_us(1);
    PL_EPS_LATCH_SW_EN = 1;
    FCTN_CDMS_WR_FLASH(4,1);
}

void SW_OFF_PL_EPS()
{
    PYLD_EPS_DFF_PWR_CLK = 0;
    PYLD_EPS_DFF_PWR = 0;
    wait_us(1);
    PYLD_EPS_DFF_PWR_CLK = 1;
    wait_us(1);
    PYLD_EPS_DFF_PWR_CLK = 0;
    wait_us(1);
    PL_EPS_LATCH_SW_EN = 0;
    FCTN_CDMS_WR_FLASH(4,0);
}

void SW_ON_V_A_EN()
{
    V_A_EN = 1;
    EPS_V_A_EN_STATUS = 1;
    FCTN_CDMS_WR_FLASH(0,1);
}

void SW_OFF_V_A_EN()
{
    V_A_EN = 0;
    EPS_V_A_EN_STATUS = 0;
    FCTN_CDMS_WR_FLASH(0,0);
}

void RST_SD()
{
    SD_SW_EN_DS = 0;
    wait_ms(10);
    SD_SW_EN_DS = 1;
    SD_STATUS = DEVICE_POWERED;
    FCTN_CDMS_WR_FLASH(2,DEVICE_POWERED);
    gPC.printf("rst sd\n");
}

void SW_RST_BAE()
{
    BAE_SW_EN_DS = 0;
    wait_ms(10);
    BAE_SW_EN_DS = 1;
    BAE_STATUS = DEVICE_POWERED;
    FCTN_CDMS_WR_FLASH(1,DEVICE_POWERED);
    gPC.printf("rst bae\n");
}

void SW_RST_PL_BEE()
{
    PYLD_DFF = 0;
    wait_ms(10);
    PYLD_DFF = 1;
    PL_STATUS = DEVICE_POWERED;
    FCTN_CDMS_WR_FLASH(3,DEVICE_POWERED);
}

void RST_BAE()
{
    RESET_TO_BAE = 0;
    wait_ms(10);
    RESET_TO_BAE = 1;
}

void RST_PL_BEE()
{
    RESET_TO_PYLD = 0;
    wait_ms(10);
    RESET_TO_PYLD = 1;
}

void CDMS_INTERNAL_RESET()
{
    NVIC_SystemReset();
}

void SYS_PWR_RESET()  // Have to be decided with EPS team.
{
    sys_pwr_rst = 1;
}

void EPS_V_A_EN()     // This is a reset function
{
    V_A_EN = 0;
    wait_ms(10);
    V_A_EN = 1;
}

void EPS_V_C_EN()     // This is a reset function
{
    COM_RX_CNTRL = 0;
    wait_ms(10);
    COM_RX_CNTRL = 1;
}

void RST_HK_COUNTER()
{
    firstCount = true;
}

int8_t CDMS_RD_SD_HK(uint8_t *sd_statusbits)
{
    int8_t p;
    if(SD_SW_EN_DS != DEVICE_POWERED)
    {
        SD_RD_ERROR = 1;
        p = 1;
    }
    else
    {
        p = disk_read_statusbits(sd_statusbits);
    }
    return p;
}

void CDMS_CALIB_RTC(uint64_t time)
{
    SPI_mutex.lock();
    gCS_RTC=1;
    spi.format(8,0);
    spi.frequency(1000000);
 
    gCS_RTC=0;
    spi.write(0x82);
    spi.write((uint8_t)time);//set minutes
    gCS_RTC=1;
 
    gCS_RTC=0;
    spi.write(0x83); 
    spi.write((uint8_t)(time>>8) & 0x3F); //set hours
    gCS_RTC=1;
    
    gCS_RTC=0;
    spi.write(0x85); 
    spi.write((uint8_t)(time>>16) & 0x3F); //set date
    gCS_RTC=1;
    
    gCS_RTC=0;
    spi.write(0x86); 
    spi.write((uint8_t)(time>>24) & 0x1F); //set month
    gCS_RTC=1;
    
    gCS_RTC=0;
    spi.write(0x87); 
    spi.write((uint8_t)(time>>32)); //set year to 00(2000)
    gCS_RTC=1;
    gPC.puts("\n\r rtc initalised \n");
    SPI_mutex.unlock();
}

void CDMS_RESET()
{
    NVIC_SystemReset();    
}

/*
//void CDMS_INTERNAL_RESET()
{
    
}
*/

//===============================MMS RAM functions==================================

void FCTN_CDMS_RD_L_RAM(Base_tm *);

void FCTN_CDMS_RD_L_RAM(Base_tm *tm_pointer)
{
    for(int i=4;i<132;i++)
    tm_pointer->TM_string[i] = CDMS_HK_FRAME[i-4];
}