/*-----------------------------------------to_do_compression.h---------------------------------------------------------------

    -> SD_Write error to be checked(refer to flowchart)
    -> compression algo not yet changed
    -> inform Nandu that in extreme data conservation mode alone, even if pzf,ezf=1 the bins are present but have junk values
    -> attitude tag not updated anywhere
    -> packet_pp to be verified
-----------------------------------------------------------------------------------------------------------------------------*/

//last updated on 18 Dec 2016

/*#include <iostream>
#include "stdio.h"
#include "crc.h"
#include "interleave.h"
#include "Convolution.h"
#include "bitset"*/
//using namespace std;

//reading functions 2byte, 4byte
#define srpz 0
#define scpz 0
#define scpz_last 0
#define srpz_last 0
#define debug_fsc 0
#define debug_time 0    //used for testing without rtc, assigns constant time to all frames
#define debug_dma 0     //byte reading order in dma, used to read test_cases 4 to 16 since they're in the wrong order
#define test_science 0
#define tabulation 0
uint8_t HK_timer_toggle = 0;

Timer timer_test;

#if debug_dma
uint16_t read_2byte(uint8_t* ptr)
{
    uint16_t output = (((uint16_t )(*(ptr+1)))<<8);
    output += (((uint16_t)(*ptr)));
    return output;
}
uint32_t read_4byte(uint8_t* ptr)
{
    uint32_t output = (uint32_t)(*(ptr+3))<<24;
    output += (uint32_t)(*(ptr+2)<<16);
    output += (uint32_t)(*(ptr+1)<<8);
    output += (uint32_t)(*(ptr));
    return output;
}
#endif
#if !debug_dma
uint16_t read_2byte(uint8_t* ptr)
{
    uint16_t output = (uint8_t ) *(ptr+1);
    output += ( (uint8_t )(*ptr) ) << 8;
    return output;
}
uint32_t read_4byte(uint8_t* ptr)
{
    uint32_t output = (uint32_t) (*(ptr+3));
    output += (uint32_t)(*(ptr+2)<<8);
    output += (uint32_t)(*(ptr+1)<<16);
    output += (uint32_t)(*(ptr)<<24);
    return output;
}
#endif
uint8_t adjust(uint8_t size, uint8_t data, uint8_t* ptr , uint8_t space)
{
    space = space&0x0f;
    if(space == 8)  *ptr = 0;
    data = data&((1<<size)-1);
    if(space >= size){
        *ptr += data<<(space-size);
        if(space - size == 0){
            return 0x18;
        }else{
            return space-size;
        }
    }else{
        ptr[0] += data>>(size-space);
        ptr[1] = (data<<(8-(size-space)))&0xff ;
        return 0x10 + 8-(size - space);
    }
}
int compress (int data, int x, int y)   //to be compressed with scheme (msb x)*4^y ;
{
    for(int i = 0 ; i < (1<<y) ; i++)
    {
        if(data <= ( (1<<x)-1) * (1<<(2*i)) )
        {
            return ( ((data>>i*2)<<y) + i);
        }
    }
    if ( data > (( (1<<x)-1) * (1<<(2*((1<<y)-1)))) )       //if value of data is more than that can be stored by compressed bits then return maximum value
    {
        //cout <<"compression exception"<<endl;
        return (1<<(x+y))-1;    //maximum value is nothing but a number with(x+y) bits with all 1's
    }
}
int compress2 (int data, int x, int y)  //to be compressed with scheme (msb x)*8^y;
{
    for(int i = 0 ; i < (1<<y) ; i++)
    {
        if(data <= ( (1<<x)-1) * (1<<(3*i)) )
        {
            return ( ((data>>i*3)<<y) + i);
        }
    }
    if ( data > (( (1<<x)-1) * (1<<(3*((1<<y)-1)))) )       //if value of data is more than that can be stored by compressed bits then return maximum value
    {
        //cout <<"compression exception"<<endl;
        return (1<<(x+y))-1;    //maximum value is nothing but a number with(x+y) bits with all 1's
    }   
}

//--------------------------------------------------------beacon
uint8_t beacon_array[134];
uint8_t beacon_cntr = 1;
uint8_t *beacon_ptr;
//--------------------------------------------------------beacon

//variable declarations
uint8_t srp_mode , at , pzf , ezf ,sfp[71] ,scp[56],beacon_at; //tells which mode is calibrated or plot 0 for calibrated and 1 for scatterered, below threshold , proton zero flux, electron zero flux.
uint32_t sfp_bin[52] , scp_bin[52];         //storing the bin values.
uint32_t sfp_threshold_m0[52]  = {124,124,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,4032,252,252,252,252,252,4032,8128,8128,8128,8128,8128,8128,8128,8128,960,960,960,960,960,960,960,960,960,960,960,960,4032,4032,4032,4032,8128,8128,8128,8128};
uint32_t scp_threshold_m0[52]  = {4032,4032,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,114688,8128,4032,4032,4032,4032,114688,245760,245760,245760,245760,245760,245760,245760,245760,49152,49152,49152,49152,49152,49152,49152,49152,49152,49152,49152,49152,114688,114688,114688,114688,245760,245760,245760,245760};
uint32_t scp_threshold_m0_1[9] = {114688,245760,245760,245760,245760,114688,114688,65472,65472} ; //for callibrated mode with data conservation
uint32_t scp_sfp_threshold_m0_2[3] = {245760,65472,65472};
uint32_t sfp_threshold_m1[52]  = {1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,8128,8128,8128,8128};
uint32_t scp_threshold_m1[52]  = {114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,245760,245760,245760,245760};
uint8_t frames[3][134] = {0};
uint8_t position_tm_frame[3] = {8,11,5} , position_tm_starting[3] = {8,11,5}; //{sc,sf-bt,sf-at}
uint8_t id;   //sf = 0,sc-at = 1,sc-bt = 2;
uint8_t TM_interleave_data[512] , TM_convoluted_data[270] = {0};
uint64_t proton_scp_sum,electron_scp_sum,FSC_science;
uint16_t temp_crc;
uint32_t debug_cntr, size,space,length;
uint8_t *ptr ,* pointer;
uint64_t sci_time = 0, time_prev_scp = 0;
uint32_t attitude = 0;
uint32_t beacon_threshold[9] = {114688,245760,245760,245760,245760,114688,114688,65472,65472};

/*----------------------------temporary counters used for testing purposes---------------------------*/
uint32_t test_fsc[4]={0,0,0,0};
/*---------------------------------------------------------------------------------------------------*/


Convolution ConvObj;
void convolution (uint8_t * ptr){
    ConvObj.convolutionEncode(ptr, TM_convoluted_data);
    ConvObj.convolutionEncode(ptr + 67, TM_convoluted_data + 135);
}
#if test_science
char srp_calibrated[][34] = {       //names of different bins in calibrated mode, refer to excel sheet having testcases
                            "NA",   //packet sequnce count (not important here)
                            "NA",   //science data mode + compression mode (not important here)
                            "proton energy",
                            "electron energy",
                            "Ion dEdX response",
                            "Ion bulk response",
                            "proton angles [0,40]",
                            "proton angles [40,50]",
                            "proton angles [50,60]",
                            "proton angles [60,70]",
                            "proton angles [70,80]",
                            "electron angles [0,60]",
                            "high energy protons and electrons",
                            "proton energy overlap events",
                            "dEdX & bulk & Veto counts",
                            "dEdX fast counts",
                            "bulk fast counts",
                            "veto fast counts"
};
char srp_scattered[][33] = {    //names of different bins in scattered mode, refer to excel sheet having testcases
                            "NA",
                            "NA",
                            "dEdX & bulk & not veto 2d dEdX..",
                            "dEdX & bulk & veto counts",
                            "dEdX fast counts",
                            "bulk fast counts",
                            "veto fast counts"
};
#endif
uint32_t data_srp_calibrated[] = {  // this data will be copied 60 times(except for the first two elements which are included only at the start of dma) and to fill the dma
                        1,      //packet sequence count
                        0,      //last bit for calibrated mode and next two bits for compression mode
                        20,     //proton energy(18 bins)
                        60,     //Electron energy(6 bins)
                        700,    //Ion dEdX response
                        600,    //Ion bulk response
                        100,    //proton angles [0,40]
                        200,    //proton angles [40,50]
                        500,    //proton angles [50,60]
                        600,    //proton angles [60,70]
                        720,    //proton angles [70,80]
                        246,    //electron angles [0,60]
                        10,     //high energy protons and electrons
                        250,    //proton energy overlap events
                        120,    //dEdX & bulk & Veto counts
                        8129,   //dEdX fast counts
                        3000,   //bulk fast counts
                        4000    //veto fast counts
};
/*uint8_t calib_sfp_at_com[] = {0,0,0,0,700,600,100,200,500,600,720,246,10,250,120,3500,3000,4000};
uint8_t data_sfp_calib_at[][2] = {
                                {20,300}    //64 bytes
                                {300,0},    //58 bytes
                                {0,300},    //43 bytes
                                {0,0}       //36 bytes
};   //36 bytes
uint16_t packet_insert_dma(uint8_t *head,uint8_t size,uint16_t j)
{
    if(size==64){
        for(count=0;count<18;count++,j+=2){
            head[j]   = (calib_sfp_at_com[0][0]>>8) & 0xff;
            head[j+1] = (calib_sfp_at_com[0][0]) & 0xff;
        }
        for(count=0;count<6;count++,j+=2){
            head[j]   = (calib_sfp_at_com[0][1]>>8) & 0xff;
            head[j+1] = (calib_sfp_at_com[0][1]) & 0xff;
        }
    }
    else if(size==58){
        for(count=0;count<18;count++,j+=2){
            head[j]   = (calib_sfp_at_com[1][0]>>8) & 0xff;
            head[j+1] = (calib_sfp_at_com[1][0]) & 0xff;
        }
        for(count=0;count<6;count++,j+=2){
            head[j]   = (calib_sfp_at_com[1][1]>>8) & 0xff;
            head[j+1] = (calib_sfp_at_com[1][1]) & 0xff;
        }
    }
    else if(size==43){
        for(count=0;count<18;count++,j+=2){
            head[j]   = (calib_sfp_at_com[2][0]>>8) & 0xff;
            head[j+1] = (calib_sfp_at_com[2][0]) & 0xff;
        }
        for(count=0;count<6;count++,j+=2){
            head[j]   = (calib_sfp_at_com[2][1]>>8) & 0xff;
            head[j+1] = (calib_sfp_at_com[2][1]) & 0xff;
        }
    }
    else if(size==36){
        for(count=0;count<18;count++,j+=2){
            head[j]   = (calib_sfp_at_com[3][0]>>8) & 0xff;
            head[j+1] = (calib_sfp_at_com[3][0]) & 0xff;
        }
        for(count=0;count<6;count++,j+=2){
            head[j]   = (calib_sfp_at_com[3][1]>>8) & 0xff;
            head[j+1] = (calib_sfp_at_com[3][1]) & 0xff;
        }
    }
    else{
        gPC.printf("\n\rError: Invalid length in inserting packet DMA");
        return 3;
    }
    for(count=0;count<4;count++,j+=2){
        head[j]   = (calib_sfp_at_com[4]>>8) & 0xff;
        head[j+1] = (calib_sfp_at_com[4]) & 0xff;
    }
    for(count=0;count<4;count++,j+=2){
        head[j]   = (calib_sfp_at_com[5]>>8) & 0xff;
        head[j+1] = (calib_sfp_at_com[5]) & 0xff;
    }
    for(uint8_t count2 = 0;count2<6;count2++)
        for(uint8_t count=0;count<2;count++,j+=2){
            head[j]   = (calib_sfp_at_com[6+count2]>>8) & 0xff;
            head[j+1] = (calib_sfp_at_com[6+count2]) & 0xff;
        }
    head[j++] = (calib_sfp_at_com[12]>>8) & 0xff;
    head[j++] = (calib_sfp_at_com[12]) & 0xff;
    for(count=0;count<3;count++,j+=2){
        head[j]   = (calib_sfp_at_com[13]>>8) & 0xff;
        head[j+1] = (calib_sfp_at_com[13]) & 0xff;
    }
    for(uint8_t count2 =0;count2<4;count2++)
        for(uint8_t count=0;count<1;count++,j+=4){
            head[j]   = (calib_sfp_at_com[14+count2]>>24) & 0xff;
            head[j+1] = (calib_sfp_at_com[14+count2]>>16) & 0xff;
            head[j+2] = (calib_sfp_at_com[14+count2]>>8) & 0xff;
            head[j+3] = (calib_sfp_at_com[14+count2]) & 0xff;
        }
    return j;
}
void generate_dma_tmid2(uint8_t *head)
{
    uint8_t dma_index = 3;
    head[0] = 0;
    head[1] = 1;
    head[2] = 0;
    for(uint8_t count=1;count<=2;count++){
        dma_index = packet_insert_dma(head,64,dma_index);
        dma_index = packet_insert_dma(head,58,dma_index);
        dma_index = packet_insert_dma(head,43,dma_index);
        dma_index = packet_insert_dma(head,36,dma_index);
    }
}
*/
//uint8_t data_sfp_scat_at10[] ={};
//uint8_t data_sfp_scat_at
/*uint32_t data_srp_calibrated2[] = {  // this data will be copied 60 times(except for the first two elements which are included only at the start of dma) and to fill the dma
                        1,      //packet sequence count
                        0,      //last bit for calibrated mode and next two bits for compression mode
                        1,     //proton energy(18 bins)
                        60,     //Electron energy(6 bins)
                        700,    //Ion dEdX response
                        600,    //Ion bulk response
                        100,    //proton angles [0,40]
                        200,    //proton angles [40,50]
                        500,    //proton angles [50,60]
                        600,    //proton angles [60,70]
                        720,    //proton angles [70,80]
                        246,    //electron angles [0,60]
                        10,     //high energy protons and electrons
                        250,    //proton energy overlap events
                        120,    //dEdX & bulk & Veto counts
                        3500,   //dEdX fast counts
                        3000,   //bulk fast counts
                        4000    //veto fast counts
};*/
uint32_t data_srp_scattered[] = {// this data will be copied 60 times(except for the first two elements which are included only at the start of dma) and to fill the dma
                        1,      //packet sequence count
                        5,      //last bit for scattered plot mode and next two bits for compression mode
                        1980,    //dEdX & bulk & not veto 2d dEdX bulk response
                        10,     //dEdX & bulk & veto counts
                        8100,   //dEdX fast counts
                        1500,   //bulk fast counts
                        10295    //veto fast counts 
};
#if test_science
uint8_t dma_sfp_at_count=0,dma_scp_at_count=0,calib_thres_index[16][60],scat_thres_index[5][60],calib_thres_index_scp[16],scat_thres_index_scp[5];
uint8_t calib_thres_subindex[16],scat_thres_subindex[5],thres_scp_index[16],proton_scp_sum_at,electron_scp_sum_at,sfp_mode_count[2],scp_mode_count[5];
#endif
#if tabulation
uint8_t pack_curr_det,pack_prev_det,pack_split_det= 0,pack_buf[3][70] = {0};
uint8_t fsc_incomplete[3]={0},len_prev[3]={0},len_correct[3]={0},len_current;

//uint8_t test_tm[3][134] = {0};
uint64_t decompress(uint16_t data, uint8_t x,uint8_t y){    //x * 4^y
    uint64_t value = 0;
    value = ((data>>y)&((1<<x)-1))*(1<<(2*(data &((1<<y)-1))));
    return value;
}
uint64_t decompress2(uint16_t data, uint8_t x,uint8_t y){   //x * 8^y for proton and electron angles bins in SCP_AT(calibrated)
    uint64_t value = 0;
    value = ((data>>y)&((1<<x)-1))*(1<<(3*(data &((1<<y)-1))));
    return value;
}
uint8_t calc_length(uint8_t tmid,uint8_t srp_mode,uint8_t comp_opt,uint8_t zf){
    uint16_t length;
    if(tmid==1){
        if(srp_mode == 0 && (comp_opt>>1 & 0x03) == 0){
            if((comp_opt&0x01) == 0){
                length = 228;
                if(((zf>>1)&0x01) == 0)
                    length += 121;
                if((zf&0x01) == 0)
                    length +=41;
            }else if((comp_opt&0x01) == 1){
                length = 266;
                if(((zf>>1)&0x01) == 0)
                    length += 136;
                if((zf&0x01) == 0)
                    length += 40;
            }
        }else if(srp_mode == 0 && (comp_opt>>1 & 0x03) == 1){                         //data conservation mode
            if((comp_opt&0x01) == 0){
                length = 94;
                if(((zf>>1)&0x01) == 0)
                    length += 12;
                if((zf&0x01) == 0)
                    length += 12;
            }else if((comp_opt&0x01) == 1){
                length = 123;
                if(((zf>>1)&0x01) == 0)
                    length += 9;
                if((zf&0x01) == 0)
                    length += 9;
            }
        }
        else if( srp_mode == 1){
            if((comp_opt&0x01) == 0)
                length = 368;
            else if((comp_opt&0x01) == 1)
                length = 432;
        }
        else if(((comp_opt>>1 & 0x03)==2)&&(srp_mode==0))
        {                         
            if((comp_opt&0x01) == 0){
                length = 31;
                if(((zf>>1)&0x01) == 0)
                    length += 12;
                if((zf&0x01) == 0)
                    length += 12;
            }else if((comp_opt&0x01) == 1){
                length = 36;
                if(((zf>>1)&0x01) == 0)
                    length += 9;
                if((zf&0x01) == 0)
                    length += 9;
            }
        }
        else if(((comp_opt>>1 & 0x03)==2)&&(srp_mode==1))
        {
            length = 56;
        }
    }
    else if(tmid==2){    
        if(srp_mode==0){
            length = 288;
            if(((zf>>1)&0x01) == 0)
                length += 170;
            if((zf&0x01) == 0)
                length += 50;            
        }
        else if(srp_mode==1)
            length = 568;
    }
    else if(tmid==3){
        if(srp_mode==0){
            length = 241;
            if(((zf>>1)&0x01) == 0)
                length += 87;
            if((zf&0x01) == 0)
                length += 35;
        }
        else if(srp_mode==1)
            length = 384;
    }
    length = (length%8==0)?(length/8):(length/8)+1;
    return (uint8_t)length;
}
uint64_t decode(uint8_t size,uint8_t *space,uint8_t **ptr){    
    /*  This function accepts a double pointer, pointing to the header pointer of an array,
        example if TM[135] is a telemetry array, then create a new "temporary" pointer as ptr=&TM and pass &ptr to the function
        Given this pointer and size, this function reads the number of bits(=size) and returns the decimal value and updates (*space).
        "space" is nothing but how many bits have been not been read in the current byte.
        example: when reading an array for the first time,(*space) will be 8 coz none of the bits have been decoded, once we decode a few bits(say 5), then (*space) will be 3
        This function can be used to decode bins(which have varying number of bits) from telemetry 
    */
    uint64_t data = 0;
    while(size!=0){
        if((*space)>=size){
            data |= (((**ptr)>>((*space)-size)) & ((1<<size)-1));
            (*space) = (*space)-size;
            size = 0;
        }
        else{
            data |= (((**ptr) & ((1<<(*space))-1))<<(size-(*space)));
            size -= (*space);
            (*space) = 8;
            (*ptr)++;
        }
    }
    return data;
}
uint8_t print_packet(uint8_t tmid,uint8_t *ptr)
{
    //prints each bin values of a packet in a row separated by tab spaces and returns the length of the packet printed
    uint8_t *temp,space;
    uint8_t len = 0;
    temp = ptr; space = 8;
    uint8_t temp_x,srp_mode;                    //temp_x = header(compression option)
    uint8_t pzf=0,ezf=0;
    if(tmid==1)                                 //SCP packet
    {
        gPC.printf("\n\r%d",decode(1,&space,&temp));
        gPC.printf("\t%d",decode(6,&space,&temp));
        gPC.printf("\t%d",decode(7,&space,&temp));        
        gPC.printf("\t%d",decode(4,&space,&temp));        
        temp_x = decode(3,&space,&temp);
        gPC.printf("\t%d",temp_x);
        srp_mode = decode(1,&space,&temp);
        gPC.printf("\t%d",srp_mode);
        if((temp_x>>1 & 0x03)!=2){
            gPC.printf("\t%d",decode(24,&space,&temp)); //SFP_AT starting counter not present in extreme conservation mode        
        }
        if(srp_mode==0){    //scp calibrated
            pzf = decode(1,&space,&temp);
            ezf = decode(1,&space,&temp);
            gPC.printf("\t%d",pzf);
            gPC.printf("\t%d",ezf);
            len = calc_length(tmid,srp_mode,temp_x,((uint8_t)((pzf<<1)|ezf)));
            if(temp_x==0){
                for(uint8_t i=0;i<4;i++){
                    if(i==0){gPC.printf("\t");}     gPC.printf("%d",decompress(decode(7,&space,&temp),4,3));    if(i!=3){gPC.printf(",");}
                }
                for(uint8_t i=0;i<4;i++){
                    if(i==0){gPC.printf("\t");}     gPC.printf("%d",decompress(decode(7,&space,&temp),4,3));    if(i!=3){gPC.printf(",");}
                }
                for(uint8_t i=0;i<12;i++){
                    if(i%2==0){gPC.printf("\t");}   gPC.printf("%d",decompress(decode(5,&space,&temp),2,3));    if(i%2==0){gPC.printf(",");}
                }            
            }
            if(temp_x==1){
                for(uint8_t i=0;i<4;i++){
                    if(i==0){gPC.printf("\t");}     gPC.printf("%d",decompress(decode(7,&space,&temp),4,3));    if(i!=3){gPC.printf(",");}
                }
                for(uint8_t i=0;i<4;i++){
                    if(i==0){gPC.printf("\t");}     gPC.printf("%d",decompress(decode(7,&space,&temp),4,3));    if(i!=3){gPC.printf(",");}
                }
                for(uint8_t i=0;i<12;i++){
                    if(i%2==0){gPC.printf("\t");}   gPC.printf("%d",decompress2(decode(5,&space,&temp),2,3));    if(i%2==0){gPC.printf(",");}
                }
            }
            if(temp_x==0){                                  //SCP calibrated below threshold                
                gPC.printf("\t%d",decompress(decode(6,&space,&temp),3,3)); 
                for(uint8_t i=0;i<3;i++){
                    if(i==0){gPC.printf("\t");}     gPC.printf("%d",decompress(decode(6,&space,&temp),3,3));    if(i!=2){gPC.printf(",");}
                }
                for(uint8_t i=0;i<4;i++){
                    gPC.printf("\t%d",decompress(decode(7,&space,&temp),4,3));
                }
                for(uint8_t i=0;i<2;i++)
                    gPC.printf("\t%d",decompress(decode(6,&space,&temp),3,3));
                if(pzf==0){
                    for(uint8_t i=0;i<2;i++){
                        if(i==0){gPC.printf("\t");}     gPC.printf("%d",decompress(decode(8,&space,&temp),6,2));    if(i==0){gPC.printf(",");}
                    }
                    for(uint8_t i=0;i<15;i++){
                        if(i==0){gPC.printf("\t");}     gPC.printf("%d",decompress(decode(7,&space,&temp),5,2));    if(i!=14){gPC.printf(",");}
                    }
                }
                else{
                    gPC.printf("\tNA");
                    gPC.printf("\tNA");                       
                }
                if(ezf==0){
                    gPC.printf("\t%d",decompress(decode(9,&space,&temp),7,2));
                    for(uint8_t i=0;i<4;i++){
                        if(i==0){gPC.printf("\t");}     gPC.printf("%d",decompress(decode(8,&space,&temp),7,2));    if(i!=3){gPC.printf(",");}
                    }
                }
                else{
                    gPC.printf("\tNA");
                    gPC.printf("\tNA");   
                }
            }
            else if(temp_x==1){                             //SCP calibrated above threshold
                gPC.printf("\t%d",decompress(decode(9,&space,&temp),6,3));
                for(uint8_t i=0;i<3;i++){
                    if(i==0){gPC.printf("\t");}         gPC.printf("%d",decompress(decode(9,&space,&temp),6,3));    if(i!=2){gPC.printf(",");}
                }
                for(uint8_t i=0;i<4;i++){
                    gPC.printf("\t%d",decompress(decode(12,&space,&temp),9,3));
                }
                for(uint8_t i=0;i<2;i++){
                    gPC.printf("\t%d",decompress(decode(9,&space,&temp),6,3));
                }
                if(pzf==0){
                    for(uint8_t i=0;i<2;i++){
                        if(i==0){gPC.printf("\t");}     gPC.printf("%d",decompress(decode(8,&space,&temp),5,3));    if(i==0){gPC.printf(",");}
                    }
                    for(uint8_t i=0;i<15;i++){
                        if(i==0){gPC.printf("\t");}     gPC.printf("%d",decompress(decode(8,&space,&temp),5,3));    if(i!=14){gPC.printf(",");}
                    }
                }
                else{
                    gPC.printf("\tNA");
                    gPC.printf("\tNA");   
                }
                if(ezf==0){
                    gPC.printf("\t%d",decompress(decode(8,&space,&temp),5,3));
                    for(uint8_t i=0;i<4;i++){
                        if(i==0){gPC.printf("\t");}     gPC.printf("%d",decompress(decode(8,&space,&temp),5,3));    if(i!=3){gPC.printf(",");}
                    }
                }
                else{
                    gPC.printf("\tNA");
                    gPC.printf("\tNA");   
                }
            }
            else if(temp_x ==2){
                gPC.printf("\t%d",decompress(decode(6,&space,&temp),3,3));
                for(uint8_t i=0;i<4;i++){
                    gPC.printf("\t%d",decompress(decode(7,&space,&temp),4,3));
                }
                gPC.printf("\t%d",decompress(decode(6,&space,&temp),3,3));
                gPC.printf("\t%d",decompress(decode(6,&space,&temp),3,3));
                gPC.printf("\t%d",decompress(decode(12,&space,&temp),10,2));
                gPC.printf("\t%d",decompress(decode(12,&space,&temp),10,2));
            }
            else if(temp_x==3){
                gPC.printf("\t%d",decompress(decode(9,&space,&temp),6,3));
                for(uint8_t i=0;i<4;i++){
                    gPC.printf("\t%d",decompress(decode(12,&space,&temp),9,3));
                }
                for(uint8_t i=0;i<4;i++){
                    gPC.printf("\t%d",decompress(decode(9,&space,&temp),6,3));
                }
            }
            else if(temp_x==4){
                gPC.printf("\t%d",decompress(decode(7,&space,&temp),4,3));
                gPC.printf("\t%d",decompress(decode(12,&space,&temp),10,2));
                gPC.printf("\t%d",decompress(decode(12,&space,&temp),10,2));
            }
            else if(temp_x==5){
                gPC.printf("\t%d",decompress(decode(12,&space,&temp),9,3));
                gPC.printf("\t%d",decompress(decode(9,&space,&temp),6,3));
                gPC.printf("\t%d",decompress(decode(9,&space,&temp),6,3));
            }
        }
        else if(srp_mode==1){   //scattered mode
            len = calc_length(tmid,srp_mode,temp_x,0);
            if(temp_x==0){
                for(uint8_t i=0;i<48;i++){
                    if(i==0){gPC.printf("\t");}         gPC.printf("%d",decompress(decode(6,&space,&temp),3,3));    if(i!=47){gPC.printf(",");}
                }
                for(uint8_t i=0;i<4;i++){
                    gPC.printf("\t%d",decompress(decode(7,&space,&temp),4,3));
                }
            }
            else if(temp_x==1){
                gPC.printf("\t%d",2*decompress(decode(7,&space,&temp),4,3));
                for(uint8_t i=0;i<4;i++){
                    gPC.printf("\t%d",decompress(decode(12,&space,&temp),9,3));
                }
            }
            else if(temp_x==4){
                gPC.printf("\t%d",decompress(decode(7,&space,&temp),4,3));
                gPC.printf("\t%d",decompress(decode(12,&space,&temp),10,2));
                gPC.printf("\t%d",decompress(decode(12,&space,&temp),10,2));
            }
            else if(temp_x==5){
                gPC.printf("\t%d",decompress(decode(12,&space,&temp),9,3));
                gPC.printf("\t%d",decompress(decode(9,&space,&temp),6,3));
                gPC.printf("\t%d",decompress(decode(9,&space,&temp),6,3));
            }
        }
    }
    else{
        if(tmid==2){
            gPC.printf("\n\r%d",decode(2,&space,&temp));  //splitting first 35 bits of time into year,month.......
            gPC.printf("\t%d",decode(4,&space,&temp));
            gPC.printf("\t%d",decode(5,&space,&temp));
            gPC.printf("\t%d",decode(5,&space,&temp));
            gPC.printf("\t%d",decode(6,&space,&temp));
            gPC.printf("\t%d",decode(6,&space,&temp));
            gPC.printf("\t%d",decode(7,&space,&temp));  //time ends here
        }
        if(tmid==3)
            gPC.printf("\n\r");
        gPC.printf("\t%d",decode(4,&space,&temp));
        gPC.printf("\t%d",decode(6,&space,&temp));
        srp_mode = decode(1,&space,&temp);
        gPC.printf("\t%d",srp_mode);
        if(srp_mode==0){        
            //gPC.printf("\n\rspace before pzf = %d",space);    
            pzf = decode(1,&space,&temp);
            //gPC.printf("\n\rspace after pzf = %d",space);
            ezf = decode(1,&space,&temp);
            //gPC.printf("\n\rspace after pzf = %d",space);
            gPC.printf("\t%d",pzf);
            gPC.printf("\t%d",ezf);
            len = calc_length(tmid,srp_mode,0,((uint8_t)((pzf<<1)|ezf)));
            for(uint8_t i=0;i<4;i++){
                if(i==0){gPC.printf("\t");}         gPC.printf("%d",decompress(decode(9,&space,&temp),7,2));    if(i!=3){gPC.printf(",");}
            }
            for(uint8_t i=0;i<4;i++){
                if(i==0){gPC.printf("\t");}         gPC.printf("%d",decompress(decode(9,&space,&temp),7,2));    if(i!=3){gPC.printf(",");}
            }            
            if(tmid==2){
                for(uint8_t i=0;i<12;i++){
                    if(i%2==0){gPC.printf("\t");}   gPC.printf("%d",decompress(decode(6,&space,&temp),3,3));    if(i%2==0){gPC.printf(",");}
                }
                gPC.printf("\t%d",decompress(decode(10,&space,&temp),8,2));
                for(uint8_t i=0;i<3;i++){
                    if(i==0){gPC.printf("\t");}         gPC.printf("%d",decompress(decode(10,&space,&temp),8,2));    if(i!=2){gPC.printf(",");}
                }
                for(uint8_t i=0;i<4;i++){
                    gPC.printf("\t%d",decompress(decode(9,&space,&temp),6,3));
                }
                gPC.printf("\t%d",decompress(decode(10,&space,&temp),8,2));
                gPC.printf("\t%d",decompress(decode(10,&space,&temp),8,2));
                if(pzf==0){
                    for(uint8_t i=0;i<2;i++){
                        if(i==0){gPC.printf("\t");}     gPC.printf("%d",decompress(decode(10,&space,&temp),8,2));    if(i==0){gPC.printf(",");}
                    }
                    for(uint8_t i=0;i<15;i++){
                        if(i==0){gPC.printf("\t");}     gPC.printf("%d",decompress(decode(10,&space,&temp),8,2));    if(i!=14){gPC.printf(",");}
                    }
                }
                else{
                    gPC.printf("\tNA");
                    gPC.printf("\tNA");   
                }
                if(ezf==0){
                    gPC.printf("\t%d",decompress(decode(10,&space,&temp),8,2));
                    for(uint8_t i=0;i<4;i++){
                        if(i==0){gPC.printf("\t");}     gPC.printf("%d",decompress(decode(10,&space,&temp),8,2));    if(i!=3){gPC.printf(",");}
                    }
                }
                else{
                    gPC.printf("\tNA");
                    gPC.printf("\tNA");   
                }
            }
            else if(tmid==3){
                for(uint8_t i=0;i<12;i++){
                    if(i%2==0){gPC.printf("\t");}   gPC.printf("%d",decompress(decode(6,&space,&temp),4,2));    if(i%2==0){gPC.printf(",");}
                }
                gPC.printf("\t%d",decompress(decode(8,&space,&temp),6,2));
                for(uint8_t i=0;i<3;i++){
                    if(i==0){gPC.printf("\t");}         gPC.printf("%d",decompress(decode(8,&space,&temp),6,2));    if(i!=2){gPC.printf(",");}
                }
                for(uint8_t i=0;i<4;i++){
                    gPC.printf("\t%d",decompress(decode(9,&space,&temp),7,2));
                }
                gPC.printf("\t%d",decompress(decode(8,&space,&temp),6,2));
                gPC.printf("\t%d",decompress(decode(8,&space,&temp),6,2));
                if(pzf==0){
                    for(uint8_t i=0;i<2;i++){
                        if(i==0){gPC.printf("\t");}     gPC.printf("%d",decompress(decode(6,&space,&temp),5,1));    if(i==0){gPC.printf(",");}
                    }
                    for(uint8_t i=0;i<15;i++){
                        if(i==0){gPC.printf("\t");}     gPC.printf("%d",decompress(decode(5,&space,&temp),4,1));    if(i!=14){gPC.printf(",");}
                    }
                }
                else{
                    gPC.printf("\tNA");
                    gPC.printf("\tNA");   
                }
                if(ezf==0){
                    gPC.printf("\t%d",decompress(decode(7,&space,&temp),6,1));
                    for(uint8_t i=0;i<4;i++){
                        if(i==0){gPC.printf("\t");}     gPC.printf("%d",decompress(decode(7,&space,&temp),6,1));    if(i!=3){gPC.printf(",");}
                    }
                }
                else{
                    gPC.printf("\tNA");
                    gPC.printf("\tNA");   
                }   
            }
        }        
        else if(srp_mode==1){
            len = calc_length(tmid,srp_mode,0,((uint8_t)((pzf<<1)|ezf)));
            if(tmid==2){
                for(uint8_t i=0;i<48;i++){
                    if(i==0){gPC.printf("\t");}   gPC.printf("%d",decompress(decode(10,&space,&temp),8,2));    if(i!=47){gPC.printf(",");}
                }
                for(uint8_t i=0;i<4;i++){
                    gPC.printf("\t%d",decompress(decode(9,&space,&temp),6,3));
                }
            }
            else if(tmid==3){
                for(uint8_t i=0;i<48;i++){
                    if(i==0){gPC.printf("\t");}   gPC.printf("%d",decompress(decode(7,&space,&temp),5,2));    if(i!=47){gPC.printf(",");}
                }
                for(uint8_t i=0;i<4;i++){
                    gPC.printf("\t%d",decompress(decode(9,&space,&temp),7,2));
                }
            }
        }
    }
    return len;
}
#endif
void print_headings(uint8_t *pack_curr_det){
    switch(((*pack_curr_det) & 0x3F)){
        case 0x10:  gPC.printf("\n\n\r----------------------------SCP_BT calibrated mode-----------------------------"); 
                    break;
        case 0x12:  gPC.printf("\n\n\r----------------------------SCP_AT calibrated mode-----------------------------"); 
                    break;                    
        case 0x14:  gPC.printf("\n\n\r-----------------SCP_BT calibrated with data conservation mode-----------------");
                    break;
        case 0x16:  gPC.printf("\n\n\r-----------------SCP_AT calibrated with data conservation mode-----------------");
                    break;
        case 0x18:  gPC.printf("\n\n\r----------------SCP_BT calibrated with extreme conservation mode---------------");
                    break;
        case 0x1A:  gPC.printf("\n\n\r----------------SCP_AT calibrated with extreme conservation mode---------------");
                    break;
        case 0x11:  gPC.printf("\n\n\r---------------------------SCP_BT scattered plot mode--------------------------");
                    break;
        case 0x13:  gPC.printf("\n\n\r---------------------------SCP_AT scattered plot mode--------------------------");
                    break;
        case 0x19:  gPC.printf("\n\n\r--------------SCP_BT scattered plot with extreme conservation mode-------------");
                    break;
        case 0x1B:  gPC.printf("\n\n\r--------------SCP_AT scattered plot with extreme conservation mode-------------");
                    break;
        case 0x20:  gPC.printf("\n\n\r---------------------------SFP_BT calibrated mode--------------------------");
                    break;
        case 0x22:  gPC.printf("\n\n\r---------------------------SFP_AT calibrated mode--------------------------");
                    break;
        case 0x30:  gPC.printf("\n\n\r---------------------------SFP_BT calibrated mode--------------------------");
                    break;
        case 0x32:  gPC.printf("\n\n\r---------------------------SFP_AT calibrated mode--------------------------");
                    break;
        case 0x21:  gPC.printf("\n\n\r---------------------------SFP_BT scattered plot mode--------------------------");
                    break;
        case 0x23:  gPC.printf("\n\n\r---------------------------SFP_AT scattered plot mode--------------------------");
                    break;        
        case 0x31:  gPC.printf("\n\n\r---------------------------SFP_BT scattered plot mode--------------------------");
                    break;
        case 0x33:  gPC.printf("\n\n\r---------------------------SFP_AT scattered plot mode--------------------------");
                    break;
        default:    gPC.printf("\n\n\rxxxxxxxxxxxxxxxxxxxx INVALID packet type xxxxxxxxxxxxxxxxxxxxxx");
                    break;
    }
}
#if tabulation
void clear_buffer(uint8_t index){   //index = tmid-1;
    for(uint8_t i=0;i<70;i++)
    pack_buf[index][i] = 0;
    fsc_incomplete[index] = 0;
    len_prev[index] = 0;
    len_correct[index] = 0;
    pack_split_det &= (~(0x01<<(index)));      //making the corresponding tmid bit 0 to indicate buffer is empty
}
void tabulate_TM(uint8_t *ptr){
    /* This function prints the TM packets info in the form of a table so that the data can be used to verify decoding 
       at the Ground Station(GS)."ptr" is the pointer to the TM frame extracted from SD card before transmitting to GS
    */
    pack_curr_det = 0;
    uint32_t fsc_TM;        //to store the FSC of the current TM
    uint8_t tmid = (ptr[0]>>3)&0x0f,temp_index;
    pack_curr_det |= (ptr[0]<<1)& 0x30; //3rd and 4th bits(MSB) = tmid
    if(tmid==1||tmid==2){       //the TMID corresponds to SCP or SFP_AT(both have FSC at the same location in the frame)
        fsc_TM &= 0x00000000;
        fsc_TM |= (((uint32_t)(ptr[1]<<16))&0x00ff0000);
        fsc_TM |= (((uint32_t)(ptr[2]<<8)) &0x0000ff00);
        fsc_TM |= (((uint32_t)(ptr[3]))    &0x000000ff);
        gPC.printf("\n\n\rFrame sequence count(tmid=%d): %d---------------------------------------------------------",tmid,fsc_TM);
        if(tmid==1){
            gPC.printf("\n\rYear:%d\tMon:%d\tDate:%d",((ptr[5]>>4)&0x03),(ptr[5]&0x0f),((ptr[6]>>3)&0x1f));
            gPC.printf("\tHour:%d\tMin:%d\n\r",((ptr[6]&0x07)<<2)|((ptr[7]&0xC0)>>6),ptr[7]&0x3f);
        }
        if(ptr[4]!=(11-(3*tmid))){          //there is an incomplete packet present at the start of the current frame
            if(!((pack_split_det>>(tmid-1))&0x01)){
                gPC.printf("\n\rError: TMID = %d frame contains split packet but buffer empty----------------------\n",tmid);
                pack_split_det |= 0x08;     //4 th bit (from LSB) if equal to 1 indicates error in packet splitting
            }
            if((fsc_TM-1)!=(fsc_incomplete[tmid-1])){                                              //fsc_incomplete[]
                gPC.printf("\n\rError: FSC for TMID = %d is not continous---------------------------\n",tmid);
                clear_buffer(tmid-1);
                pack_split_det |= 0x08;     //4 th bit (from LSB) indicates error in packet splitting
            }
            if(((pack_split_det>>3)&0x01)==0){      //no error upto now in split packet
                len_current = ptr[4] - (11-(3*tmid));                                       //len_current
                if((len_prev[tmid-1]+len_current)!=len_correct[tmid-1]){                           //len_correct[] and len_prev[]
                    gPC.printf("\n\rError: Length of the split packet for TMID = %d not correct,len_correct=%d,len_prev=%d,len_current=%d",tmid,len_correct[tmid-1],len_prev[tmid-1],len_current);
                    clear_buffer(tmid-1);
                    pack_split_det &= (~0x08);     //clear the packet splitting error bit
                }
                else{
                    temp_index = 11-(3*tmid);
                    for(uint8_t i=0;i<len_current;i++)
                        pack_buf[tmid-1][len_prev[tmid-1]+i] = ptr[temp_index+i];   //storing the remaining part of the packet in appropriate buffer
                    if(tmid==1){
                        pack_curr_det |= (pack_buf[0][2]>>2)&0x0f;//5th and 6th bits (start from MSB) bits = compression option, 7th bit = threshold bit and last bit = science data mode
                    }
                    else if(tmid==2){
                        pack_curr_det |= (pack_buf[1][5]>>2)&0x01;//5th and 6th (start from MSB) bits = compression option, 7th bit = threshold bit and last bit = science data mode                    
                        pack_curr_det |= 0x02;      //to indicate sfp is above threshold
                    }
                    //gPC.printf("\n\rpack_curr_det=0x%02X and pack_prev_det=0x%02X",pack_curr_det,pack_prev_det);
                    if(pack_curr_det!=pack_prev_det){
                        print_headings(&pack_curr_det);
                        pack_prev_det = pack_curr_det;                        
                        pack_curr_det &= (~0x0f);   //clearing last four bits to store next packet's info(but tmid remains same)
                    }                    
                    if(len_correct[tmid-1]!=print_packet(tmid,&(pack_buf[tmid-1][0]))){
                        gPC.printf("\n\rError: print_packet() length not equal to len_correct (tmid=%d)-------------------------\n",tmid);
                    }
                    clear_buffer(tmid-1);
                }
            }            
        }
        temp_index = ptr[4];    //index of the first complete packet in the frame
        //gPC.printf("\n\rfirst header pointer = %d and temp_index = %d",ptr[4],temp_index);
        while(temp_index!=0 && temp_index <132){   //temp_index = 0 implies no more complete packets left to display
            if(tmid==1){
                pack_curr_det |= (ptr[temp_index+2]>>2)&0x0f;//5th and 6th (start from MSB) 2 bits = compression option, next bit = threshold bit and last bit = science data mode
            }
            else if(tmid==2){
                pack_curr_det |= (ptr[temp_index+5]>>2)&0x01;//5th and 6th (start from MSB) bits = compression option, next bit = threshold bit and last bit = science data mode
                pack_curr_det |= 0x02;      //to indicate sfp is above threshold
                //gPC.printf("\n\rScience data mode:%d",pack_curr_det&0x1);
            }
            //gPC.printf("\n\rpack_curr_det=0x%02X and pack_prev_det=0x%02X",pack_curr_det,pack_prev_det);
            if(pack_curr_det!=pack_prev_det){
                print_headings(&pack_curr_det);
                pack_prev_det = pack_curr_det;                    
                pack_curr_det &= (~0x0f);   //clearing last four bits to store next packet's info(but tmid remains same)
            }                
            temp_index = temp_index + print_packet(tmid,&ptr[temp_index]);
            //gPC.printf("\n\rtemp_index = %d after one packet",temp_index);
            //temp_index = 69;
            if((132-temp_index)<(3*tmid)){
                temp_index = 0;         //no more packets available, minimum number of bytes are not remaining(3 for SCP and 6 for SFP_AT)
            }
            else if((132-temp_index)<(41+(15*tmid))){   //space left in the frame is less than the maximum packet size for the corresponding tmid
                if(tmid==1){
                    pack_split_det |= ((ptr[temp_index+2]<<2)&0xf0);
                    //first(MSB) 3 bits = header(compression option),next bit=science data mode,next bit=errorbit,last 3 bits = to store if incomplete packet is present in the buffer
                    if((pack_split_det&0xd0)==0x80)    //extreme data & calibrated mode
                        len_correct[tmid-1] = calc_length(tmid,(pack_split_det>>4)&0x1,(pack_split_det>>5)&0x3,ptr[temp_index+2]&0x03);
                    else
                        len_correct[tmid-1] = calc_length(tmid,(pack_split_det>>4)&0x1,(pack_split_det>>5)&0x3,ptr[temp_index+5]&0x03); 
                        //scattered plot mode doesn't have pzf and ezf bits but even if we send junk values but they will not be used in the function
                }
                else if(tmid==2){
                    pack_split_det |= ((ptr[temp_index+5]<<4)&0x70);
                    len_correct[tmid-1] = calc_length(tmid,(pack_split_det>>6)&0x1,0,(pack_split_det>>4)&0x03);
                    //in this case(tmid = 2), 2nd bit(MSB) is srp_mode, next bit is pzf, next is ezf and next four bits are described before                        
                }
                pack_split_det &= (~0xf0);      //first four bits(MSB) of pack_split_det not used anymore
                if((132-temp_index)<len_correct[tmid-1]){   //incomplete packet present
                    len_prev[tmid-1] = 132 - temp_index;
                    fsc_incomplete[tmid-1] = fsc_TM;                        
                    for(uint8_t i=0;i<len_prev[tmid-1];i++)
                        pack_buf[tmid-1][i] = ptr[temp_index+i];
                    pack_split_det |= (1<<(tmid-1));//1st bit(LSB) indicates scp incomplete packet,2nd bit indicates sfp_at incomplete
                    temp_index = 0;
                }
            }
        }
    }
    else if(tmid==3){   //SFP_BT
        fsc_TM &= 0x00000000;
        fsc_TM |= (((uint32_t)(ptr[1]<<24))&0xff000000);
        fsc_TM |= (((uint32_t)(ptr[2]<<16))&0x00ff0000);
        fsc_TM |= (((uint32_t)(ptr[3]<<8)) &0x0000ff00);
        fsc_TM |= (((uint32_t)(ptr[4]))    &0x000000ff);
        gPC.printf("\n\n\rFrame sequence count(tmid=%d): %d---------------------------------------------------------",tmid,fsc_TM);
        gPC.printf("\n\rYear:%d\tMon:%d\tDate:%d",((ptr[6]>>1)&0x03),(((ptr[7]>>5)&0x07)|((ptr[6]&0x01)<<3)),(ptr[7]&0x1f));
        gPC.printf("\tHour:%d\tMin:%d\tSec:%d\tCenti:%d\n\r",(ptr[8]&0xf1)>>3,(((ptr[9]&0xE0)>>5)|((ptr[8]&0x07)<<3)),((ptr[10]&0x80)|((ptr[9]&0x1f)<<1)),ptr[10]&0x7f);
        if(ptr[5]!=11){                         //there is an incomplete packet present at the start of the current frame
            if(!((pack_split_det>>(tmid-1))&0x01)){
                gPC.printf("\n\rError: TMID = %d frame contains split packet but buffer empty",tmid);
                pack_split_det |= 0x08;     //4 th bit (from LSB) indicates error in packet splitting
            }
            else if((fsc_TM-1)!=(fsc_incomplete[tmid-1])){  //fsc 
                gPC.printf("\n\rError: FSC for TMID = %d is not continous---------------------------\n",tmid);
                clear_buffer(tmid-1);
                pack_split_det |= 0x08;     //4 th bit (from LSB) indicates error in packet splitting
            }
            if(((pack_split_det>>3)&0x01)==0){      //no error upto now in split packet
                len_current = ptr[5] - 11;
                if((len_prev[tmid-1]+len_current)!=len_correct[tmid-1]){
                    gPC.printf("\n\rError: Length of the split packet for TMID = %d not correct,len_correct=%d,len_prev=%d,len_current=%d",tmid,len_correct[tmid-1],len_prev[tmid-1],len_current);
                    clear_buffer(tmid-1);
                    pack_split_det &= (~0x08);     //clear the packet splitting error bit
                }
                else{
                    temp_index = 11;
                    for(uint8_t i=0;i<len_current;i++)
                        pack_buf[tmid-1][len_prev[tmid-1]+i] = ptr[temp_index+i];   //storing the remaining part of the packet in appropriate buffer
                    pack_curr_det |= (pack_buf[2][1]>>5)&0x01;//5th and 6th (start from MSB) bits = compression option, 7th bit = threshold bit and last bit = science data mode
                    if(pack_curr_det!=pack_prev_det){
                        print_headings(&pack_curr_det);
                        pack_prev_det = pack_curr_det;
                        pack_curr_det &= (~0x0f);//clearing last four bits to store next packet's info(but tmid remains same)
                    }
                    if(len_correct[tmid-1]!=print_packet(tmid,&(pack_buf[tmid-1][0]))){
                        gPC.printf("\n\rError: print_packet() length not equal to len_correct (tmid=%d)-------------------------",tmid);
                    }
                    clear_buffer(tmid-1);
                }
            }            
        }
        temp_index = ptr[5];    //index of the first complete packet in the frame
        while(temp_index!=0){   //temp_index = 0 implies no more complete packets left to display
            pack_curr_det |= (ptr[temp_index+1]>>5)&0x01;   //calibrated or scattered mode
            if(pack_curr_det!=pack_prev_det){
                print_headings(&pack_curr_det);
                pack_prev_det = pack_curr_det;
                pack_curr_det &= (~0x0f);   //clearing last four bits to store next packet's info(but tmid remains same)
            }
            temp_index = temp_index + print_packet(tmid,&ptr[temp_index]);
            if((132-temp_index)<2){
                temp_index = 0;         //no more packets available, minimum number of bytes are not remaining(2 for SFP_BT)
            }
            else if((132-temp_index)<(46+(2*(pack_curr_det&0x01)))){   //space left in the frame is less than the maximum packet size(46 bytes for calib and 48 for scattered mode)
                pack_split_det |= ((ptr[temp_index+1]<<1)&0x70);
                len_correct[tmid-1] = calc_length(tmid,(pack_split_det>>6)&0x1,0,(pack_split_det>>4)&0x03);
                //gPC.printf("\n\rSFP_BT srp mode:%d",(pack_split_det>>6)&0x1);
                //gPC.printf("\n\rSFP_BT: len_correct = %d",len_correct[tmid-1]);
                //in this case(tmid = 3), 2nd bit(MSB) is srp_mode, next bit is pzf, next is ezf and next four bits are described before
                pack_split_det &= (~0xf0);      //first four bits(MSB) of pack_split_det not used anymore
                if((132-temp_index)<len_correct[tmid-1]){   //incomplete packet present at the end of the frame
                    len_prev[tmid-1] = 132 - temp_index;
                    fsc_incomplete[tmid-1] = fsc_TM;                        
                    for(uint8_t i=0;i<len_prev[tmid-1];i++)
                        pack_buf[tmid-1][i] = ptr[temp_index+i];
                    pack_split_det |= (1<<(tmid-1));//1st bit(LSB) indicates scp incomplete packet,2nd bit indicates sfp_at incomplete
                    //len_correct[tmid-1] = calc_length(tmid,(pack_split_det>>6)&0x1,0,(pack_split_det>>4)&0x03);
                    temp_index = 0;
                }
            }
        }
    }
}
#endif
#if test_science
void generated_dma(uint8_t *head){
    uint8_t temp_buf[16] = {0};
    gPC.printf("\n\rDisplaying generated data");
    gPC.printf("\n\rhead[0,1] = %d",read_2byte(&head[0]));
    for(uint8_t i=0,j=3;i<48;i++,j+=2)
        gPC.printf("\n\rhead[%d] = %d",i,read_2byte(&head[j]));
    for(uint8_t i=0,j=99;i<4;i++,j+=4)
        gPC.printf("\n\rhead[%d] = %d",i+48,read_4byte(&head[j]));
    for(uint16_t j=115;j<6723;j++)
        if(head[j]!=head[j-112]){
            gPC.printf("\n\rDMA data repeat error at index = %d",j);
            return;
        }
    gPC.printf("\n\rNo errors in generated repeated DMA data");
}
void generate_dma_calibrated(uint8_t *head)
{
    head[0] = (data_srp_calibrated[0]>>8) & 0xff;
    head[1] = (data_srp_calibrated[0]) & 0xff;
    head[2] = (data_srp_calibrated[1]) & 0xff;
    for(int j=3,count=0;count<18;count++,j+=2){
        head[j]   = (data_srp_calibrated[2]>>8) & 0xff;
        head[j+1] = (data_srp_calibrated[2]) & 0xff;
    }
    for(int j=39,count=0;count<6;count++,j+=2){
        head[j]   = (data_srp_calibrated[3]>>8) & 0xff;
        head[j+1] = (data_srp_calibrated[3]) & 0xff;
    }
    for(int j=51,count=0;count<4;count++,j+=2){
        head[j]   = (data_srp_calibrated[4]>>8) & 0xff;
        head[j+1] = (data_srp_calibrated[4]) & 0xff;
    }
    for(int j=59,count=0;count<4;count++,j+=2){
        head[j]   = (data_srp_calibrated[5]>>8) & 0xff;
        head[j+1] = (data_srp_calibrated[5]) & 0xff;
    }
    int j=67;
    for(uint8_t count2 = 0;count2<6;count2++)
        for(uint8_t count=0;count<2;count++,j+=2){
            head[j]   = (data_srp_calibrated[6+count2]>>8) & 0xff;
            head[j+1] = (data_srp_calibrated[6+count2]) & 0xff;
            //gPC.printf("\n\rj = %d",j);
        }
    head[91] = (data_srp_calibrated[12]>>8) & 0xff;
    head[92] = (data_srp_calibrated[12]) & 0xff;
    for(j=93,count=0;count<3;count++,j+=2){
        head[j]   = (data_srp_calibrated[13]>>8) & 0xff;
        head[j+1] = (data_srp_calibrated[13]) & 0xff;
    }
    j=99;
    for(uint8_t count2 =0;count2<4;count2++)
        for(uint8_t count=0;count<1;count++,j+=4){
            head[j]   = (data_srp_calibrated[14+count2]>>24) & 0xff;
            head[j+1] = (data_srp_calibrated[14+count2]>>16) & 0xff;
            head[j+2] = (data_srp_calibrated[14+count2]>>8) & 0xff;
            head[j+3] = (data_srp_calibrated[14+count2]) & 0xff;
        }
    for(j=115;j<6723;j++)   //copying the same data for all other 59 packets
            head[j] = head[j-112];
    /*for(j=115;j<3363;j++)   //copying the same data for all next 29 packets
        head[j] = head[j-112];
    //next 30 packets will have following data
    j=3363;
    for(int count=0;count<18;count++,j+=2){
        head[j]   = (data_srp_calibrated2[2]>>8) & 0xff;
        head[j+1] = (data_srp_calibrated2[2]) & 0xff;
    }
    for(int j=3399,count=0;count<6;count++,j+=2){
        head[j]   = (data_srp_calibrated2[3]>>8) & 0xff;
        head[j+1] = (data_srp_calibrated2[3]) & 0xff;
    }
    for(int j=3411,count=0;count<4;count++,j+=2){
        head[j]   = (data_srp_calibrated2[4]>>8) & 0xff;
        head[j+1] = (data_srp_calibrated2[4]) & 0xff;
    }
    for(int j=3419,count=0;count<4;count++,j+=2){
        head[j]   = (data_srp_calibrated2[5]>>8) & 0xff;
        head[j+1] = (data_srp_calibrated2[5]) & 0xff;
    }
    j=3427;
    for(uint8_t count2 = 0;count2<6;count2++)
        for(uint8_t count=0;count<2;count++,j+=2){
            head[j]   = (data_srp_calibrated2[6+count2]>>8) & 0xff;
            head[j+1] = (data_srp_calibrated2[6+count2]) & 0xff;
            //gPC.printf("\n\rj = %d",j);
        }
    head[3451] = (data_srp_calibrated2[12]>>8) & 0xff;
    head[3452] = (data_srp_calibrated2[12]) & 0xff;
    for(j=3453,count=0;count<3;count++,j+=2){
        head[j]   = (data_srp_calibrated2[13]>>8) & 0xff;
        head[j+1] = (data_srp_calibrated2[13]) & 0xff;
    }
    j=3459;
    for(uint8_t count2 =0;count2<4;count2++)
        for(uint8_t count=0;count<1;count++,j+=4){
            head[j]   = (data_srp_calibrated2[14+count2]>>24) & 0xff;
            head[j+1] = (data_srp_calibrated2[14+count2]>>16) & 0xff;
            head[j+2] = (data_srp_calibrated2[14+count2]>>8) & 0xff;
            head[j+3] = (data_srp_calibrated2[14+count2]) & 0xff;
        }
    for(j=3475;j<6723;j++)   //copying the same data for last 29 packets
            head[j] = head[j-112];*/
}
void generate_dma_scattered(uint8_t *head)
{
    int j=3;
    uint8_t count;
    head[0] = (data_srp_scattered[0]>>8) & 0xff;
    head[1] = (data_srp_scattered[0]) & 0xff;
    head[2] = (data_srp_scattered[1]) & 0xff;
    for (count=0,j=3;count<48;count++,j+=2){
        head[j]   = (data_srp_scattered[2]>>8) & 0xff;
        head[j+1] = (data_srp_scattered[2]) & 0xff;
    }
    j=99;
    for(uint8_t count2 =0;count2<4;count2++)
        for(uint8_t count=0;count<1;count++,j+=4){
            head[j]   = (data_srp_scattered[3+count2]>>24) & 0xff;
            head[j+1] = (data_srp_scattered[3+count2]>>16) & 0xff;
            head[j+2] = (data_srp_scattered[3+count2]>>8) & 0xff;
            head[j+3] = (data_srp_scattered[3+count2]) & 0xff;
        }
    for(int j=115;j<6723;j++)
        head[j] = head[j-112];
}
uint8_t map_index_bins_2_srp_index(uint8_t i,uint8_t srp_mode)
{
    /* This function is used to map sfp_indices to data_srp_calibrated[] or data_srp_scattered[] array indices
        Example: indices 0 to 17 (the first 18 bins of sfp_bin[] array) correspond to index 2 of data_srp_calibrated[] array which is nothing 
        but proton energy. This function is used to update calib_thres_index[], scat_thresh_index[], calib_thres_index_scp[]
        and scat_thres_index_scp[] which stores info about which bins is causing above threshold condition(refer to comments
        in dma_packet_info() funtion regarding calib_thres_index[] array)
    */
    if(srp_mode==0){
        if(i<18)    return 2;
        else if(i<24)   return 3;
        else if(i<28)   return 4;
        else if(i<32)   return 5;
        
        else if(i<34)   return 6;
        else if(i<36)   return 7;
        else if(i<38)   return 8;
        else if(i<40)   return 9;
        else if(i<42)   return 10;
        else if(i<44)   return 11;

        //else if(i<44)   return 6+((i-32)/2);
        else if(i<45)   return 12;
        else if(i<48)   return 13;

        else if(i<49)   return 14;
        else if(i<50)   return 15;
        else if(i<51)   return 16;
        else if(i<52)   return 17;
        //else if(i<52)   return i-34;
    }
    else if(srp_mode==1){
        if(i<48)        return 2;
        else if(i<52)   return i-45;
    }
}
void verify_read_dma(uint8_t srp_mode,uint8_t counter){
    /* This function verifies that correct data was generated in dma by comparing sfp_bin[i] with the 
       data in srp_calibrated[] or srp_scattered[]. This function assumes that all the 60 srp packets in DMA have 
       identical data. If not change the dma_generating functions and this function appropriately
    */
    uint8_t i;
    if(srp_mode==0){
        for(i=0;i<18;i++)   //first 18 bins correspond to proton energy which is nothing but data_srp_calibrated[2]
            if(sfp_bin[i]!=data_srp_calibrated[2]){
                gPC.printf("\n\rsfp_bin[%d]:%d\tdatasrp_calibrated[2]:%d",i,sfp_bin[i],data_srp_calibrated[2]);
                gPC.printf("\n\r\"%s\" data mismatch in DMA, counter = %d",srp_calibrated[2],counter);    //print the name of the bin whose DMA value didn't match with value in the data_srp_calibrated[] array
                return;
            }
        for(;i<24;i++)      //next 6 bins correspond to electron energy
            if(sfp_bin[i]!=data_srp_calibrated[3]){
                gPC.printf("\n\r\"%s\" data mismatch in DMA, counter = %d",srp_calibrated[3],counter);
                return;
            }
        for(;i<28;i++)      //refer to excel sheet with test cases
            if(sfp_bin[i]!=data_srp_calibrated[4]){
                gPC.printf("\n\r\"%s\" data mismatch in DMA, counter = %d",srp_calibrated[4],counter);
                return;   
            }
        for(;i<32;i++)
            if(sfp_bin[i]!=data_srp_calibrated[5]){
                gPC.printf("\n\r\"%s\" data mismatch in DMA, counter = %d",srp_calibrated[5],counter);
                return;   
            }
        for(i=0;i<12;i++)
            if(sfp_bin[32+i]!=data_srp_calibrated[6+(i/2)]){
                gPC.printf("\n\r\"%s\" data mismatch in DMA, counter = %d",srp_calibrated[6+(i/2)],counter);
                return;   
            }
        if(sfp_bin[44]!=data_srp_calibrated[12]){
            gPC.printf("\n\r\"%s\" data mismatch in DMA, counter = %d",srp_calibrated[12],counter);
            return;   
        }
        for(i=45;i<48;i++)
            if(sfp_bin[i]!=data_srp_calibrated[13]){
                gPC.printf("\n\r\"%s\" data mismatch in DMA, counter = %d",srp_calibrated[13],counter);
                return;   
            }
        if(sfp_bin[48]!=data_srp_calibrated[14]){
            gPC.printf("\n\r\"%s\" data mismatch in DMA, counter = %d",srp_calibrated[14],counter);
            return;   
        }
        if(sfp_bin[49]!=data_srp_calibrated[15]){
            gPC.printf("\n\r\"%s\" data mismatch in DMA, counter = %d",srp_calibrated[15],counter);
            return;
        }
        if(sfp_bin[50]!=data_srp_calibrated[16]){
            gPC.printf("\n\r\"%s\" data mismatch in DMA, counter = %d",srp_calibrated[16],counter);
            return;   
        }    
        if(sfp_bin[51]!=data_srp_calibrated[17]){
            gPC.printf("\n\r\"%s\" data mismatch in DMA, counter = %d",srp_calibrated[17],counter);
            return;   
        }
    }
    else if(srp_mode==1){
        for(i=0;i<48;i++)   //first 48 bins correspond to dEdX & bulk & not Veto.....  which is nothing but data_srp_scattered[2]
            if(sfp_bin[i]!=data_srp_scattered[2]){
                gPC.printf("\n\r\"%s\" data mismatch in DMA",srp_scattered[2]); //  //print the name of the bin whose DMA value didn't match with value in the srp_scattered[] array
                return;
            }
        if(sfp_bin[48]!=data_srp_scattered[3]){
            gPC.printf("\n\r\"%s\" data mismatch in DMA",srp_scattered[3]);
            return;   
        }
        if(sfp_bin[49]!=data_srp_scattered[4]){
            gPC.printf("\n\r\"%s\" data mismatch in DMA",srp_scattered[4]);
            return;   
        }
        if(sfp_bin[50]!=data_srp_scattered[5]){
            gPC.printf("\n\r\"%s\" data mismatch in DMA",srp_scattered[5]);
            return;   
        }    
        if(sfp_bin[51]!=data_srp_scattered[6]){
            gPC.printf("\n\r\"%s\" data mismatch in DMA",srp_scattered[6]);
            return;   
        }
    }
    gPC.printf("\n\rNo errors in generated data");
}
void dma_packets_info()
{
    gPC.printf("\n\n\r-------------------------------------------------------------------------------------------");
    gPC.printf("\n\rNumber of SFP_AT: %d",dma_sfp_at_count);    // dma_sfp_at_count = number of sfp which are above threshold when dma is read every 6 seconds
    gPC.printf("\n\rNumber of SCP_AT: %d",dma_scp_at_count);    // dma_scp_at_count = number of scp which are above threshold when dma is read every 6 seconds
    if(sfp_mode_count[0]!=0){   //number of sfp packets in calibrated mode when dma is read every 6 seconds
        gPC.printf("\n\rNumber of SFP in calibrated mode: %d",sfp_mode_count[0]);
        if(dma_sfp_at_count!=0) //if there are above threshold packets then display information
            gPC.printf("\n\rSFP Above Threshold indices info:");
        for(uint8_t i=0;i<16;i++){  //for the 16 types of bins in calibrated mode 
            
            /* calib_thres_index is a 2d array with 16 rows(for 16 differnt types of bins possible in calibrated mode which are named
                in srp_calibrated character array) and each "i"th row contains the packet numbers(1 to 60) which is above threshold due to the "i"th row
                example:if proton bins have energy above threshold for all the 60 srp packets in dma, then calib_thres_index[0] will have numbers 
                from {1,2,3...so on upto 60} which is why the column size of calib_thres_index is [16][60].the variable calib_thres_subindex[j] is 
                used to update packet numbers in each row of calib_thres_index[i][j] (0<=j<60)
            */

            if(calib_thres_index[i][0]!=0){ //display only those bins which have atleast one packet in which they are above threshold
                gPC.printf("\n\r%s :{ ",srp_calibrated[i+2]);
                /*srp_calibrated has index (i+2) because the first two indices have "NA" and index of "proton bins"=2 whereas,
                  in calib_thres_index[] the index of "proton_bins" is 0 and similarly for all other 15 bins of srp_calibrated
                */
            }
            //for(uint8_t j=0;j<60;j++){
            for(uint8_t j=0;(calib_thres_index[i][j]!=0)&&(j<60);j++){    //display only non zero elements
                gPC.printf("%d ",calib_thres_index[i][j]);
            }
            if(calib_thres_index[i][0]!=0)
                gPC.printf("}");
        }
    }
    if(sfp_mode_count[1]!=0){   //number of sfp/srp packets in scattered plot mode when dma is read every 6 seconds
        gPC.printf("\n\rNumber of SFP in scattered plot mode: %d",sfp_mode_count[1]);
        if(dma_sfp_at_count!=0) //same logic as stated above 
            gPC.printf("\n\rSFP Above Threshold indices info:");
        for(uint8_t i=0;i<5;i++){   //scat_thres_index[5][60] has only 5 rows because only 5 different bins are possible, refer to excel sheet having test cases
            if(scat_thres_index[i][0]!=0){  //display only those bins which contribute to above threshold
                gPC.printf("\n\r%s :{ ",srp_scattered[i+2]);
            }
            //for(uint8_t j=0;scat_thres_index[i][j]!=0;j++){
            for(uint8_t j=0;(scat_thres_index[i][j]!=0)&&(j<60);j++){
                gPC.printf("%d ",scat_thres_index[i][j]);
            }
            if(scat_thres_index[i][0]!=0)
                gPC.printf("}");
        }
    }
    if(scp_mode_count[0]!=0){   //scp_mode_count[0] stores number of scp in calibrated mode
        gPC.printf("\n\rNumber of SCP in calibrated mode: %d",scp_mode_count[0]);
        if(dma_scp_at_count!=0)
            gPC.printf("\n\rSCP Above Threshold indices info:");
        //for(uint8_t temp_i=0;temp_i<16;temp_i++)
            //gPC.printf("\n\rcalib_thres_index_scp[%d]:%d",temp_i,calib_thres_index_scp[temp_i]);
        for(uint8_t i=0;i<16;i++){  //same logic as srp/sfp above threshold stated above
            if(calib_thres_index_scp[i]!=0){    
                /*the array calib_thres_index_scp[16] is one dimensional because every 6 seconds only one scp packet is generated, so if a bin caused it to 
                  be above threshold it is possible only in one scp packet whereas in sfp, the bin could have caused any of the 60 sfp's to be 
                  above threshold(so we store the packet number also), we make the value of calib_thres_index_scp[i] = 1 if that bin caused above threshold in scp
                */
                gPC.printf("\n\r%s is above threshold",srp_calibrated[i+2]);
            }
        }
    }
    if(scp_mode_count[1]!=0){   //scp_mode_count[1] stores number of scp in calibrated mode with data conservation
        gPC.printf("\n\rNumber of SCP in calibrated mode with data conservation: %d",scp_mode_count[1]);
        if(dma_scp_at_count!=0)
            gPC.printf("\n\rSCP Above Threshold indices info:");
        for(uint8_t i=0;i<16;i++){  //same logic as above
            if(calib_thres_index_scp[i]!=0){
                gPC.printf("\n\r%s is above threshold",srp_calibrated[i+2]);
            }
        }
        if(proton_scp_sum_at==1){
            /* here two other things apart from the bins stated in test cases can cause above threshold,
               namely proton_scp_sum and electron_scp_sum which are calculated as sum of proton enery bins, refer to excel sheet
               hence we check these two cases saparately at the end
            */
            gPC.printf("\n\rSum of proton bins is above threshold");
        }
        if(electron_scp_sum_at==1)
            gPC.printf("\n\rSum of electron bins is above threshold");
    }
    if(scp_mode_count[2]!=0){   //scp_mode_count[2] stores number of scp packets in calibrated with extreme data conservation mode
        gPC.printf("\n\rNumber of SCP in calibrated mode with Extreme data conservation: %d",scp_mode_count[2]);
        if(dma_scp_at_count!=0)
            gPC.printf("\n\rSCP Above Threshold indices info:");
        //for(uint8_t temp_i=0;temp_i<16;temp_i++)
            //gPC.printf("\n\rcalib_thres_index_scp[%d]:%d",temp_i,calib_thres_index_scp[temp_i]);
        if(calib_thres_index_scp[14]!=0)    //only bulk fast counts bin is present other than sum of energies bins
            gPC.printf("\n\rBulk fast counts is above threshold");
        if(proton_scp_sum_at==1)
            gPC.printf("\n\rSum of proton bins is above threshold");
        if(electron_scp_sum_at==1)
            gPC.printf("\n\rSum of electron bins is above threshold");
    }
    if(scp_mode_count[3]!=0){   //scp_mode_count[3] stores number of scp packets in scattered plot mode
        gPC.printf("\n\rNumber of SCP in scattered plot mode: %d",scp_mode_count[3]);
        if(dma_scp_at_count!=0)
            gPC.printf("\n\rSCP Above Threshold indices info:");
        //for(uint8_t temp_i=0;temp_i<5;temp_i++)
            //gPC.printf("\n\rscat_thres_index_scp[%d]:%d",temp_i,scat_thres_index_scp[temp_i]);
        for(uint8_t i=0;i<5;i++){
            if(scat_thres_index_scp[i]!=0){
                gPC.printf("\n\r%s is above index",srp_scattered[i+2]);
            }
        }
    }
    if(scp_mode_count[4]!=0){   //scp_mode_count[4] stores number of scp packets in scattered plot with extreme data conservation mode
        gPC.printf("\n\rNumber of SCP in scattered mode with Extreme data conservation: %d",scp_mode_count[4]);
        if(scat_thres_index_scp[3]!=0)    //only bulk fast counts bin is present other than sum of energies bins
            gPC.printf("\n\rBulk fast counts is above threshold");
        if(proton_scp_sum_at==1)
            gPC.printf("\n\rSum of proton bins is above threshold");
        if(electron_scp_sum_at==1)
            gPC.printf("\n\rSum of electron bins is above threshold");    
    }
}
#endif
//give the pointer of 6 second data to this function
void srp(uint8_t * head)//void const *args)
{
    //timer_test.start();
    uint8_t sd_stat = 0;
//    SCI_LED1 =1;
   
   /****** added by samp to HK occurance *********/
   if (HK_timer_toggle==0)
   {
   HK_counter->stop();
   wait_ms(0.1);
   HK_counter->start(10000);
   }
   HK_timer_toggle = !HK_timer_toggle;
   
   /****** added by samp to HK occurance *********/
   
    // SCI_LED1 = !SCI_LED1;
    //gPC.printf("\n\rsrp");
    debug_cntr = 0;
    sci_time = FCTN_CDMS_RD_RTC();
    TIME_LATEST_SPI_SPEED = sci_time;
    #if debug_time
    gPC.printf("\n\rAssigning time manually");
        sci_time = 0x000000055555555;
    #endif
    if(time_prev_scp==0){
        time_prev_scp = sci_time;
    } 
 //   gPC.printf("enterdSCI_SD7");   
 //  gPC.printf("timer start %d::",HK_counter.read_ms());  
 
      FCTN_SD_MNGR();     
   
  //  gPC.printf("timer end %d::",HK_counter.read_ms());                                                    ///changed recently
   // timer_test.stop();
//    gPC.printf("endSCI_SD8");
    #if tabulation
    if(head[0]==0 & head[1]==0){
        position_tm_frame[1] = position_tm_starting[1];
        position_tm_frame[2] = position_tm_starting[2];
        gPC.printf("\n\n\r--------------------------*************************************-------------------------------");
        //gPC.printf("\n\rFrame pointer reset done");
        gPC.printf("\n\rStart FSC for TMID=1 :%d",FSC_CURRENT[1]+1);
        gPC.printf("\n\rStart FSC for TMID=2 :%d",FSC_CURRENT[2]+1);
        gPC.printf("\n\rStart FSC for TMID=3 :%d",FSC_CURRENT[3]+1);
        gPC.printf("\n\r--------------------------*************************************-------------------------------");
    }
    #endif    
    ptr = head + 3;                                         //ptr points to proton energy bin of srp
    srp_mode = head[2]&0x01;
    //for(uint8_t temp_counter=0;temp_counter<9;temp_counter++){
    for (int i = 0; i < 52 ; i++)
    {
        scp_bin[i] = 0;
    }
    #if test_science
    gPC.printf("\n\n\rTesting science mode - initializing test indices and to zero");
    for(uint8_t i=0;i<5;i++)
        for(uint8_t j=0;j<60;j++){
            calib_thres_index[i][j] = 0;
            scat_thres_index[i][j] = 0;            
        }
    for(uint8_t i=5;i<16;i++)
        for(uint8_t j=0;j<60;j++){
            calib_thres_index[i][j] = 0;
            calib_thres_index_scp[i] = 0;
        }
    for(uint8_t i=0;i<16;i++){
        if(i<5){
            scat_thres_subindex[i] = 0;
            scat_thres_index_scp[i] = 0;
            scp_mode_count[i] = 0;
        }
        calib_thres_subindex[i] = 0;
        thres_scp_index[i] = 0;
        calib_thres_index_scp[i] = 0;
    }
    dma_scp_at_count = 0;
    dma_sfp_at_count = 0;
    proton_scp_sum_at = 0;
    electron_scp_sum_at = 0;
    sfp_mode_count[0] = 0;
    sfp_mode_count[1] = 0;
    /*if((head[2]&0x01)==0){
        gPC.printf("\n\rGenerating DMA calibrated data");
        generate_dma_calibrated(head);  //fill the dma with data given in data_srp_calibrated[] and repeat it 60 times to fill the entire dma        
    }
    else if((head[2]&0x1)==1){
        gPC.printf("\n\rGenerating DMA scattered data");
        generate_dma_scattered(head);   //fill the dma with data given in data_srp_scattered[] and repeat it 60 times to fill the entire dma
    }
    generated_dma(head);*/
    #endif
    for(uint8_t counter = 0 ; counter < 60 ; counter++)
    {       
        #if srpz
        gPC.printf("\n\n\rSRP count:%d",counter+1);
        #endif
        /*---------------------------------populating sfp_bin and scp_bin[] starts here(also tag AT or BT)-----------------------*/
        at = 0;     pzf = 1;    ezf = 1;
        if(srp_mode == 0)                                   //calibrated mode 
        {
            #if srpz
            gPC.printf("\n\rSRP - Calibrated Mode");
            #endif
            for(int i=0; i<48 ; i++)                        //first 48 bins or SRP are of 16 bits size
            {
                sfp_bin[i] = read_2byte(ptr + i*2);
                /*if(counter==0){
                    gPC.printf("\n\r sfp_bin[%d] = %d",i,sfp_bin[i]);
                }*/
                scp_bin[i] += sfp_bin[i];
                if(sfp_bin[i]>sfp_threshold_m0[i])
                {
                    //gPC.printf("\n\rSFP above threshold index:%d",i);
                    #if test_science
                    //gPC.printf("\n\ri:%d",i);
                    //gPC.printf("\n\ri:%d\tj:%d",map_index_bins_2_srp_index(i,srp_mode)-2,calib_thres_subindex[map_index_bins_2_srp_index(i,srp_mode)-2]);
                    calib_thres_index[map_index_bins_2_srp_index(i,srp_mode)-2][calib_thres_subindex[map_index_bins_2_srp_index(i,srp_mode)-2]] = 1;
                    //gPC.printf("\n\ri:%d\tj:%d",map_index_bins_2_srp_index(i,srp_mode)-2,calib_thres_subindex[map_index_bins_2_srp_index(i,srp_mode)-2]);
                    #endif
                    at = 1;
                }
                if(i<17)
                {
                    if(sfp_bin[i] > 0)
                        pzf = 0;
                }
                else if (i>17 && i < 23)
                {
                    if(sfp_bin[i]>0)
                        ezf = 0;
                }
            }
            for(int i=0; i<4; i++)                          //last 4 bins(excluding the spare bin) are 32 bit each
            {
                sfp_bin[i+48] = read_4byte( (ptr+96) + 4*i );
                /*if(counter==0){
                    gPC.printf("\n\rsfp_bin[%d] = %d",48+i,sfp_bin[i+48]);                    
                }*/
                scp_bin[i+48] += sfp_bin[i+48];
                if(sfp_bin[i+48]>sfp_threshold_m0[i+48]){
                    //gPC.printf("\n\rSP above threshold index: %d",i+48);
                    #if test_science
                    //gPC.printf("\n\ri:%d\tj:%d",map_index_bins_2_srp_index(48+i,srp_mode)-2,calib_thres_subindex[map_index_bins_2_srp_index(48+i,srp_mode)-2]);
                    calib_thres_index[map_index_bins_2_srp_index(48+i,srp_mode)-2][calib_thres_subindex[map_index_bins_2_srp_index(48+i,srp_mode)-2]] = 1;
                    //gPC.printf("\n\ri:%d\tj:%d",map_index_bins_2_srp_index(48+i,srp_mode)-2,calib_thres_subindex[map_index_bins_2_srp_index(48+i,srp_mode)-2]);
                    #endif
                    at = 1;
                }
            }
        }        
        else if(srp_mode == 1)                              //scattered mode
        {
            #if srpz
            gPC.printf("\n\rSRP - Scatter Plot Mode");
            #endif
            for(int i = 0; i <48; i++)                      //first 48 bins of SRP are of 16 bit size
            {
                sfp_bin[i]  = read_2byte(ptr+2*i);
                scp_bin[i] += sfp_bin[i];
                /*if(counter==0){               
                    gPC.printf("\n\rsfp_bin[%d]= %u\t\tscp_bin[%d]= %u",i,sfp_bin[i],i,scp_bin[i]); 
                }*/
                if(sfp_bin[i] > sfp_threshold_m1[i]){
                    //gPC.printf("\n\rSP above threshold index: %d",i);
                    #if test_science
                    scat_thres_index[map_index_bins_2_srp_index(i,srp_mode)-2][scat_thres_subindex[map_index_bins_2_srp_index(i,srp_mode)-2]] = 1;
                    #endif
                    at = 1;
                }
            }
            for(int i = 0; i < 4 ; i++)                     //next 4 bins are of 32 bit size
            {
                sfp_bin[i+48] = read_4byte( (ptr+96) + 4*i );
                scp_bin[i+48] += sfp_bin[i+48];
                
                /*if(counter==0){
                    gPC.printf("\n\rsfp_bin[%d]= %u\t\tscp_bin[%d]= %u",i,sfp_bin[i],i,scp_bin[i]);
                }*/
                if(sfp_bin[i+48] > sfp_threshold_m1[i+48]){
                    //gPC.printf("\n\rSP above threshold index: %d",i+48);
                    #if test_science
                    scat_thres_index[map_index_bins_2_srp_index(48+i,srp_mode)-2][scat_thres_subindex[map_index_bins_2_srp_index(48+i,srp_mode)-2]] = 1;
                    #endif
                    at = 1;
                }
            }
        }
        #if test_science
        for(uint8_t temp_i = 0;temp_i<16;temp_i++){
            if(calib_thres_index[temp_i][calib_thres_subindex[temp_i]]==1){
                calib_thres_index[temp_i][calib_thres_subindex[temp_i]] = counter+1;
                calib_thres_subindex[temp_i]++;
            }
        }
        for(uint8_t temp_i = 0;temp_i<5;temp_i++){
            if(scat_thres_index[temp_i][scat_thres_subindex[temp_i]]==1){
                scat_thres_index[temp_i][scat_thres_subindex[temp_i]] = counter+1;
                scat_thres_subindex[temp_i]++;
            }
        }
        #endif
        /*---------------------------populating sfp_bin[] and scp_bin[] from srp ends here(also tagging AT or BT)------------------*/
        #if test_science
        //gPC.printf("\n\n\rCounter: %d",counter);
        //verify_read_dma(srp_mode,counter);
        #endif
        ptr = ptr + 112;                                    //moving the pointer to next srp packet in the DMA buffer
        
        /*------------------------------------------forming a science fine packet starts here----------------------------------------
        First we fill packet header, then fill packet data and finally assign its length
        ----------------------------------------------------------------------------------------------------------------------------*/
        for(int i = 0; i<71; i++)
            sfp[i] = 0;
        if(srp_mode == 0)                                                                   //calibrated mode
        {
            if(at == 0)
            {
                #if srpz
                gPC.printf("\n\rSFP Below Threshold");
                #endif
                pointer = sfp; debug_cntr = 0;
                space = adjust(4, attitude,pointer,8);      pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(6, counter,pointer,space);   pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(1, srp_mode,pointer,space);  pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(1, pzf,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(1, ezf,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
                for(uint8_t i = 0 ; i < 8 ; i++){
                    space = adjust(1, ((compress(sfp_bin[24+i],7,2))&0x100)>>8 ,pointer,space); pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, ((compress(sfp_bin[24+i],7,2))&0xff) ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                }
                for(uint8_t i = 0 ; i <12 ; i++){
                    space = adjust(6, (compress(sfp_bin[32+i],4,2)) ,pointer,space);            pointer += space>>4;    debug_cntr += space>>4;
                }
                for(uint8_t i = 0; i < 4; i++){
                    space = adjust(8, (compress(sfp_bin[44+i],6,2)) ,pointer,space);            pointer += space>>4;    debug_cntr += space>>4;
                }
                for(uint8_t i = 0 ; i < 4 ; i++){
                    space = adjust(1, (compress(sfp_bin[48+i],7,2))>>8 ,pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, compress(sfp_bin[48+i],7,2) ,pointer,space);              pointer += space>>4;    debug_cntr += space>>4;
                }
                space = adjust(8, ((compress(sfp_bin[17],6,2))&0xff) ,pointer,space);           pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, ((compress(sfp_bin[23],6,2))&0xff) ,pointer,space);           pointer += space>>4;    debug_cntr += space>>4;
                if(pzf == 0){
                    for(uint8_t i = 0; i<2 ; i++){
                        space = adjust(6, ((compress(sfp_bin[i],5,1))&0xff) ,pointer,space);    pointer += space>>4;    debug_cntr += space>>4;
                    }
                    for(uint8_t i = 0; i<15 ; i++){
                        space = adjust(5, ((compress(sfp_bin[i+2],4,1))&0xff) ,pointer,space);  pointer += space>>4;    debug_cntr += space>>4;
                    }
                }
                if(ezf == 0){
                    for(uint8_t i = 0; i <5 ;i++){
                        space = adjust(7, ((compress(sfp_bin[18+i],6,1))&0xff) ,pointer,space); pointer += space>>4;    debug_cntr += space>>4;
                    }
                }
            }                                                                                           //below thershold ends here.
            if(at == 1){
                #if srpz
                gPC.printf("\n\rSFP Above Threshold");
                #endif
                pointer = sfp + 6; debug_cntr = 6;space = 8;
                sfp[0] = (sci_time>>27)&0xff;   sfp[1] = (sci_time>>19)&0xff;   sfp[2] = (sci_time>>11)&0xff;   sfp[3] = (sci_time>>3)&0xff;
                sfp[4] = ((sci_time&0x07)<<5) + ((attitude&0x0f)<<1) + (counter>>5);
                sfp[5] = ((counter&0x1f)<<3) + (srp_mode<<2);
                sfp[5] += (pzf<<1) + ezf ;
                for(uint8_t i = 0 ; i < 8 ; i++){
                    space = adjust(1, (compress(sfp_bin[24+i],7,2))>>8 ,pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, ((compress(sfp_bin[24+i],7,2))&0xff) ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                }
                for(uint8_t i = 0 ; i <12 ; i++){
                    space = adjust(6, ((compress(sfp_bin[32+i],3,3))&0xff) ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                }
                for(uint8_t i = 0 ; i < 4 ; i++){
                    space = adjust(2, (compress(sfp_bin[44+i],8,2))>>8 ,pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, compress(sfp_bin[44+i],8,2) ,pointer,space);              pointer += space>>4;    debug_cntr += space>>4;
                }
                for(uint8_t i = 0 ; i < 4 ; i++){
                    space = adjust(1, (compress(sfp_bin[48+i],6,3))>>8 ,pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, compress(sfp_bin[48+i],6,3) ,pointer,space);              pointer += space>>4;    debug_cntr += space>>4;
                }
                space = adjust(2, (compress(sfp_bin[17],8,2))>>8 ,pointer,space);               pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, compress(sfp_bin[17],8,2) ,pointer,space);                    pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(2, (compress(sfp_bin[23],8,2))>>8 ,pointer,space);               pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, compress(sfp_bin[23],8,2) ,pointer,space);                    pointer += space>>4;    debug_cntr += space>>4;

                if(pzf == 0){
                    //cout<<"proton bins ";
                    #if srpz
                    gPC.printf("\n\rProton bins present in SRP");
                    #endif
                    for(uint8_t i = 0; i<17 ; i++){
                        space = adjust(2, ((compress(sfp_bin[i],8,2))>>8) ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
                        space = adjust(8, compress(sfp_bin[i],8,2) ,pointer,space);             pointer += space>>4;    debug_cntr += space>>4;
                        //gPC.printf("%02X ",compress(sfp_bin[i],8,2));
                    }
                }
                //if(pzf==1)
                    //gPC.printf("\n\rAll proton bins empty");
                if(ezf == 0){
                    //cout<<"electron bins ";
                    #if srpz
                    gPC.printf("\n\rElectron bins present in SRP");
                    #endif
                    for(int i = 0; i<5 ; i++){
                        space = adjust(2,((compress(sfp_bin[18+i],8,2))>>8),pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                        space = adjust(8, compress(sfp_bin[18+i],8,2),pointer,space);           pointer += space>>4;    debug_cntr += space>>4;
                        //gPC.printf("%02X ",compress(sfp_bin[i],8,2));
                    }
                }
                //if(ezf==1)
                    //gPC.printf("\n\rAll electron bins empty");
            }                                                                                   //above threshold ends here.            
            if(at == 0)
            {
                id = 1;     length = 241;
                if(pzf == 0)
                    length += 87;
                if(ezf == 0)
                    length += 35;                
            }
            else
            {
                id = 2;     length = 288;
                if(pzf == 0)
                    length += 170;
                if(ezf == 0)
                    length += 50;
                #if test_science
                dma_sfp_at_count++;
                #endif
            }
            #if test_science
            sfp_mode_count[0]++;
            #endif
        }
        else if(srp_mode == 1)                                                                 //scattered mode
        {
            if(at == 0)
            {
                #if srpz
                gPC.printf("\n\rSFP below threshold");
                #endif
                pointer = sfp; debug_cntr = 0;  space = 8;
                space = adjust(4, attitude,pointer,8);      pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(6, counter,pointer,space);   pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(1, srp_mode,pointer,space);  pointer += space>>4;    debug_cntr += space>>4;
                for(uint8_t i=0; i<48; i++)
                {
                    space = adjust(7, compress(sfp_bin[i],5,2) ,pointer,space);             pointer += space>>4;    debug_cntr += space>>4;
                }
                for(uint8_t i = 0 ; i < 4 ; i++)
                {
                    space = adjust(1, (compress(sfp_bin[48+i],7,2))>>8 ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, compress(sfp_bin[48+i],7,2) ,pointer,space);          pointer += space>>4;    debug_cntr += space>>4;
                }
            }
            if(at == 1)
            {
                
                #if srpz                
                gPC.printf("\n\rSFP above threshold");
                #endif
                pointer = sfp; debug_cntr = 0;  space = 8;
                space = adjust(3, sci_time>>32 ,pointer,space); pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, sci_time>>24 ,pointer,space); pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, sci_time>>16 ,pointer,space); pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, sci_time>>8 ,pointer,space);  pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, sci_time ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(4, attitude,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(6, counter,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(1, srp_mode,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
                for(uint8_t i=0; i<48; i++)
                {
                    space = adjust(2, (compress(sfp_bin[i],8,2))>>8 ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, compress(sfp_bin[i],8,2) ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                }
                for(uint8_t i = 0 ; i < 4 ; i++)
                {
                    space = adjust(1, (compress(sfp_bin[48+i],6,3))>>8 ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, compress(sfp_bin[48+i],6,3) ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
                }
            }
            if(at == 0)
            {
                id = 1;     length = 384;                                       
            }
            else
            {
                id = 2;     length = 568;
                #if test_science
                dma_sfp_at_count++;
                #endif
            }
            #if test_science
            sfp_mode_count[1]++;
            #endif
        }
        length = (length%8==0)?(length/8):(length/8)+1;                         //converting length to mulitple of 8
        #if srpz
        gPC.printf("\n\rLength of SFP packet in bytes = %d",length);
        #endif
        //gPC.printf("\n\rLength of SFP packet in bytes = %d",length);
        /*----------------------------------------filling the science fine packet array ends here------------------------------------------*/

        /*-----------------------------Inserting the above packet(sfp) into the TM frame(s) starts here----------------------------*/
        if(id==1){  //below threshold
            if(position_tm_frame[id]>130){
                #if srpz
                gPC.printf("\n\rSkipping the current frame.Inserting sfp packet into the next frame.");
                #endif
                while(position_tm_frame[id]<132){
                    frames[id][position_tm_frame[id]] = 0;
                    position_tm_frame[id]++;
                }
                //position_tm_frame[id]=position_tm_starting[id];
            }
        }
        else if(id==2){ //above threshold
            if(position_tm_frame[id]>126){
                #if srpz
                gPC.printf("\n\rSkipping the current frame.Inserting sfp packet into the next frame.");
                #endif
                while(position_tm_frame[id]<132){
                    frames[id][position_tm_frame[id]] = 0;
                    position_tm_frame[id]++;
                }
                //position_tm_frame[id]=position_tm_starting[id];     //
            }
        }
        if(position_tm_frame[id]==position_tm_starting[id]){
            frames[id][6-id] = position_tm_starting[id];
        }
        for(uint16_t j=0 ; j<length ;)
        {            
            if(position_tm_frame[id]==frames[id][6-id]){
                if(id==1){
                    #if srpz
                    gPC.printf("\n\rAdding Time to TM frame");
                    #endif
                    frames[id][6]  = (uint8_t)((sci_time>>32)&0x07);
                    frames[id][7]  = (uint8_t)((sci_time>>24)&0xff);
                    frames[id][8]  = (uint8_t)((sci_time>>16)&0xff);
                    frames[id][9]  = (uint8_t)((sci_time>>8)&0xff);
                    frames[id][10] = (uint8_t)((sci_time)&0xff);
                }
            }
            if(position_tm_frame[id]<132){
                frames[id][position_tm_frame[id]] = sfp[j];
                j++;
                position_tm_frame[id]++;                                            //incrementing position of write pointer in TM frame
            }
            if(position_tm_frame[id] == 132)
            {
                /*-----------the current frame is completely filled and we fill frame header to write into SD card---------*/
                #if srpz
                gPC.printf("\n\rSFP_TM frame full. Length of current packet = %d",j);
                gPC.printf("\n\rFirst Header pointer: %d",frames[id][6-id]);
                gPC.printf("\n\rFirst head pointer contents: 0x%02X",frames[id][frames[id][6-id]]);
                #endif
                pointer = frames[id];
                if(id == 1){    //below threshold
                    space = adjust(1,0,pointer,8);
                    space = adjust(4,3,pointer,space);
                    FSC_science = FSC_CURRENT[3];                               ///to be used as this, but FSC_CURRENT[] is 32 bit 

                    //gPC.printf("3 = 0x%X",FSC_science);                   
                    #if debug_fsc
                    frames[id][1] = (test_fsc[3]>>24)&0xff;
                    frames[id][2] = (test_fsc[3]>>16)&0xff;
                    frames[id][3] = (test_fsc[3]>>8)&0xff;
                    frames[id][4] = test_fsc[3]&0xff;                    
                    test_fsc[3]++;
                    #endif                    
                    #if !debug_fsc
                    frames[id][1] = (FSC_science>>24)&0xff;
                    frames[id][2] = (FSC_science>>16)&0xff;
                    frames[id][3] = (FSC_science>>8)&0xff;
                    frames[id][4] = FSC_science&0xff;                    
                    #endif
                }
                else if(id == 2)    //above threshold
                {
                    space = adjust(1,0,pointer,8);
                    space = adjust(4,2,pointer,space);                    
                    FSC_science = FSC_CURRENT[2];                                               ///to be used as this
                    //gPC.printf("2 = 0x%X",FSC_science);
                    #if debug_fsc
                    frames[id][1] = (test_fsc[2]>>16)&0xff;
                    frames[id][2] = (test_fsc[2]>>8)&0xff;
                    frames[id][3] = test_fsc[2]&0xff;
                    test_fsc[2]++;
                    #endif
                    #if !debug_fsc
                    frames[id][1] = (FSC_science>>16)&0xff;
                    frames[id][2] = (FSC_science>>8)&0xff;
                    frames[id][3] = FSC_science&0xff;
                    #endif
                }
                temp_crc = crc16_gen(frames[id],132);
                frames[id][132] = temp_crc>>8;
                frames[id][133] = temp_crc & 0xff;
                
                #if srpz
                gPC.printf("\n\rPrinting SFP_TM\n\r{");                
                //gPC.printf("\n\r{");
                for(uint8_t z=0;z<134;z++){
                    gPC.printf("%02X",frames[id][z]);
                }
                gPC.printf("}\n\r");
                #endif
                #if tabulation
                tabulate_TM(&frames[id][0]);
                #endif
                /*------------------current TM frame completely filled-----------------------*/
                exor(frames[id]);
                convolution(frames[id]);
                interleave(TM_convoluted_data,TM_interleave_data);
                interleave(TM_convoluted_data+ 135,TM_interleave_data + 144);
  //              gPC.printf("enterSCI_SD11");
                
  //              gPC.printf("timer start %d::",HK_counter);
                if(id == 1)
                {
                    sd_stat = SD_WRITE(TM_interleave_data,FSC_science+1,3);     //sd_write will return ack later, for now not included
                }
                else if (id == 2)
                {
                   sd_stat = SD_WRITE(TM_interleave_data,FSC_science+1,2);     //sd_write will return ack later, for now not included
                }
                if(sd_stat)
                {
                    gPC.printf("\n\n\rsd write fail---------------------------------------");
                }
                
             //  gPC.printf("timer end %d::",timer_test.read_ms());                                                    ///changed recently
             //    timer_test.stop();
              
             
 //              gPC.printf("endSCI_SD12");
                position_tm_frame[id] = position_tm_starting[id];
                if(j!=0)
                    frames[id][6-id] = (length - j)+position_tm_starting[id];
                else if(j==0)
                    frames[id][6-id] = position_tm_starting[id];
            }
        }
        /*------------------------------finished inserting the sfp packet into the TM frame(s)-------------------------------------*/
    }                                                                               // for loop bracket which runs 60 times
    //ptr = ptr + 112;                                    //moving the pointer to next srp packet in the DMA buffer
    
    #if test_science
    if(pzf==1){
        gPC.printf("\n\rAll protons bins empty");
    }
    if(ezf==1){
        gPC.printf("\n\rAll electrons bins are empty");        
    }
    #endif
    #if srpz_last
    //gPC.printf("\n\rPrinting the last SFP_TM frame");
    //gPC.printf("\n\n\rPosition of tm_pointer: %d",position_tm_frame[id]);
    while(position_tm_frame[id]<132){
        frames[id][position_tm_frame[id]] = 0;
        position_tm_frame[id]++;
    }
    if(position_tm_frame[id]==132){
        //gPC.printf("\n\rFirst head pointer contents: 0x%02X",frames[id][frames[id][6-id]]);
        pointer = frames[id];
        if(id == 1){    //below threshold
            space = adjust(1,0,pointer,8);
            space = adjust(4,3,pointer,space);
            FSC_science = FSC_CURRENT[3];                               ///to be used as this, but FSC_CURRENT[] is 32 bit                    
            #if debug_fsc
            frames[id][1] = (test_fsc[3]>>24)&0xff;
            frames[id][2] = (test_fsc[3]>>16)&0xff;
            frames[id][3] = (test_fsc[3]>>8)&0xff;
            frames[id][4] = test_fsc[3]&0xff;                    
            test_fsc[3]++;
            #endif
            #if !debug_fsc
            frames[id][1] = (FSC_science>>24)&0xff;
            frames[id][2] = (FSC_science>>16)&0xff;
            frames[id][3] = (FSC_science>>8)&0xff;
            frames[id][4] = FSC_science&0xff;                    
            #endif
        }
        else if(id == 2)    //above threshold
        {
            space = adjust(1,0,pointer,8);
            space = adjust(4,2,pointer,space);                    
            FSC_science = FSC_CURRENT[2];                                               ///to be used as this
            #if debug_fsc
            frames[id][1] = (test_fsc[2]>>16)&0xff;
            frames[id][2] = (test_fsc[2]>>8)&0xff;
            frames[id][3] = test_fsc[2]&0xff;
            test_fsc[2]++;
            #endif
            #if !debug_fsc
            frames[id][1] = (FSC_science>>16)&0xff;
            frames[id][2] = (FSC_science>>8)&0xff;
            frames[id][3] = FSC_science&0xff;
            #endif
        }
        temp_crc = crc16_gen(frames[id],132);
        frames[id][132] = temp_crc>>8;
        frames[id][133] = temp_crc & 0xff;        
        
        //gPC.printf("\n\rPrinting SFP_TM\n\r{");
        gPC.printf("\n\r{");
        for(uint8_t z=0;z<134;z++){
            gPC.printf("%02X",frames[id][z]);
        }
        gPC.printf("}\n\r");
        position_tm_frame[id] = position_tm_starting[id];
    }
    #endif
    at = 0;     pzf = 1;    ezf = 1;
    srp_mode = head[2]&0x1;
    uint8_t compression_option = (head[2]>>1)&0x3;
    /*-------------------------------Tagging the scp packet formed from these 60 sfp's as AT or BT starts here-------------------------
    ------------------(in case compression option = 0 , then tagging beacon packet(not yet formed) as AT or BT is also done)----------*/
    if(srp_mode ==0)
    {
        if(compression_option == 0)
        {
            for(int i=0; i<52 ;i++)
            {
                if(scp_bin[i] > scp_threshold_m0[i])
                {
                    //gPC.printf("\n\rSCP above threshold index: %d",i);
                    #if test_science
                    calib_thres_index_scp[map_index_bins_2_srp_index(i,srp_mode)-2] = 1;
                    #endif
                    at = 1;
                    //break;
                }
            }
            #if test_science
            scp_mode_count[0]++;
            #endif
        }
        else if(compression_option == 1)
        {
            if(scp_bin[44] > scp_threshold_m0_1[0]){
                //gPC.printf("\n\rSCP above threshold index: 44"); 
                #if test_science
                //thres_scp_index[map_index_bins_2_srp_index(44,srp_mode)-2] = 1;
                calib_thres_index_scp[map_index_bins_2_srp_index(44,srp_mode)-2] = 1;
                #endif
                at=1;
            }
            for(int i=0; i<4 ;i++)
            {
                if(scp_bin[48+i] > scp_threshold_m0_1[i+1])
                {
                    //gPC.printf("\n\rSCP above threshold index: %d",i+48);
                    #if test_science
                    //thres_scp_index[map_index_bins_2_srp_index(48+i,srp_mode)-2] = 1;
                    calib_thres_index_scp[map_index_bins_2_srp_index(48+i,srp_mode)-2] = 1;
                    #endif
                    at = 1;
                    //break;
                }
            }
            if(scp_bin[17] > scp_threshold_m0_1[5]){ 
                //gPC.printf("\n\rSP above threshold index: 17");
                #if test_science
                //thres_scp_index[map_index_bins_2_srp_index(17,srp_mode)-2] = 1;
                calib_thres_index_scp[map_index_bins_2_srp_index(17,srp_mode)-2] = 1;
                #endif
                at=1;
            }
            if(scp_bin[23] > scp_threshold_m0_1[6]){ 
                //gPC.printf("\n\rSP above threshold index: 23");
                #if test_science
                //thres_scp_index[map_index_bins_2_srp_index(23,srp_mode)-2] = 1;
                calib_thres_index_scp[map_index_bins_2_srp_index(23,srp_mode)-2] = 1;
                #endif
                at=1;
            }
            proton_scp_sum = 0; electron_scp_sum = 0;
            for(int i=0;i<17;i++)
            {
                proton_scp_sum += scp_bin[i];
            }
            for(int i=0; i<5; i++)
            {
                electron_scp_sum += scp_bin[18+i];
            }
            if(proton_scp_sum > scp_threshold_m0_1[7]){ 
                //gPC.printf("\n\rProton_scp_sum above threshold");
                #if test_science
                proton_scp_sum_at = 1;
                #endif
                at=1;
            }
            if(electron_scp_sum > scp_threshold_m0_1[8]){
                //gPC.printf("\n\rElectron_scp_sum above threshold");
                #if test_science
                electron_scp_sum_at = 1;
                #endif
                at=1;
            }
            #if test_science
            scp_mode_count[1]++;
            #endif
        }
        else if(compression_option == 2)
        {
            if(scp_bin[50] > scp_sfp_threshold_m0_2[0]){
                //gPC.printf("\n\rSCP above threshold index:50"); 
                #if test_science
                //thres_scp_index[map_index_bins_2_srp_index(50,srp_mode)-2] = 1;
                calib_thres_index_scp[map_index_bins_2_srp_index(50,srp_mode)-2] = 1;
                #endif
                at=1;
            }
            proton_scp_sum = 0; electron_scp_sum = 0;
            for(int i=0;i<17;i++)
            {
                proton_scp_sum += scp_bin[i];
            }
            for(int i=0; i<5; i++)
            {
                electron_scp_sum += scp_bin[18+i];
            }
            if(proton_scp_sum > scp_sfp_threshold_m0_2[1]){//gPC.printf("\n\rProton_SCP_sum above threshold"); 
            #if test_science
            proton_scp_sum_at = 1;
            #endif
            at=1;}
            if(electron_scp_sum > scp_sfp_threshold_m0_2[2]){//gPC.printf("\n\rElectron above threshold");
            #if test_science
            electron_scp_sum_at = 1;
            #endif
             at=1;}
            #if test_science
            scp_mode_count[2]++;
            #endif
        }
    }
    else if(srp_mode ==1)
    {
        if(compression_option==0){
            for(int i=0; i<48; i++)
            {
                if(scp_bin[i] > scp_threshold_m1[i]){
                    //gPC.printf("\nSCP above threshold index:%d, Value:%d",i,scp_bin[i]);
                    #if test_science
                    scat_thres_index_scp[map_index_bins_2_srp_index(i,srp_mode)-2] = 1;
                    #endif
                    at = 1;
                    //break;
                }
            }
            for(int i=48; i<52; i++)
            {
                if(scp_bin[i] > scp_threshold_m1[i]){
                    //gPC.printf("\nSCP above threshold index:%d, Value:%d",i,scp_bin[i]);
                    #if test_science
                    scat_thres_index_scp[map_index_bins_2_srp_index(i,srp_mode)-2] = 1;
                    #endif
                    at = 1;
                    //break;
                }
            }
            #if test_science
            scp_mode_count[3]++;
            #endif
        }
        else if(compression_option==2){            
            if(scp_bin[50]>scp_sfp_threshold_m0_2[0]){
                //gPC.printf("\nSCP above threshold index:50, Value:%",scp_bin[50]);
                #if test_science
                //thres_scp_index[map_index_bins_2_srp_index(50,srp_mode)-2] = 1;
                scat_thres_index_scp[map_index_bins_2_srp_index(50,srp_mode)-2] = 1;
                #endif
                at=1;
            }
            #if test_science
            scp_mode_count[4]++;
            #endif
        }
    }
    /*----------------------------Tagging the scp packet formed from these 60 sfp's as AT or BT ends here--------------------------*/
    /*for(uint8_t temp_i=0;temp_i<52;temp_i++){
        gPC.printf("\n\rscp_bin[%d] =%d",temp_i+1,scp_bin[temp_i]);
    }*/
    if(srp_mode == 0)
    {
        //determining if non zero values of proton and electron bins exist for calibrated mode (srp)
        for(int i=0; i<17 ;i++)
        {
            if(scp_bin[i]>0)
                pzf = 0;
        }
        for(int i=18; i<23 ;i++)
        {
            if(scp_bin[i]>0)
                ezf = 0;
        }
    }
    /*-----------------------------------------Tagging beacon packet as AT or BT starts here-------------------------------------*/
    beacon_at = 0;
    if(srp_mode==0)     //those bins which can be meaningfully compared only in srp_mode==0
    {
        if(scp_bin[44]>beacon_threshold[0])     beacon_at = 1;            
        if(scp_bin[17]>beacon_threshold[5])     beacon_at = 1;
        if(scp_bin[23]>beacon_threshold[6])     beacon_at = 1;
        proton_scp_sum = 0; electron_scp_sum = 0;
        for(int i=0;i<17;i++)
        {
            proton_scp_sum += scp_bin[i];
        }
        for(int i=0; i<5; i++)
        {
            electron_scp_sum += scp_bin[18+i];
        }
        if(proton_scp_sum > beacon_threshold[7]) beacon_at =1;
        if(electron_scp_sum > beacon_threshold[8]) beacon_at =1;
    }
    if(scp_bin[48]>beacon_threshold[1])     beacon_at = 1;
    if(scp_bin[49]>beacon_threshold[2])     beacon_at = 1;
    if(scp_bin[50]>beacon_threshold[3])     beacon_at = 1;
    if(scp_bin[51]>beacon_threshold[4])     beacon_at = 1;   
    /*----------------------------------------Tagging beacon packet as AT or BT ends here------------------------------------------*/

    /*-----------------------------------------------Forming the beacon packet starts here-----------------------------------------*/
    //Last 512 bits of beacon_array excluding CRC bits is used for storing the 5 most recent beacon packets

    if(beacon_cntr == 1)
    {
        beacon_ptr = &(beacon_array[47]);   // starting block address, stores the oldest(among the 5 most recent) beacon packet
    }
    else if(beacon_cntr>1 && beacon_cntr<6)
    {
        beacon_ptr +=17;                    // increase the block number(totally 5 blocks for 5 beacon packets)
    }
    else if(beacon_cntr == 6)
    {
        for(uint16_t i=0;i<17;i++)          // when all 5 blocks have been used shift the last 4 blocks up along the array and
        {                                   // overwrite the new beacon packet in the 5th block
            beacon_array[47+i] = beacon_array[64+i];
            beacon_array[64+i] = beacon_array[81+i];
            beacon_array[81+i] = beacon_array[98+i];
            beacon_array[98+i] = beacon_array[115+i];
        }
        beacon_ptr = &(beacon_array[115]);  //address of the 5th block
        beacon_cntr = 5;
    }
    pointer = beacon_ptr;        debug_cntr = 0;     space = 8;
    space = adjust(2, compression_option,pointer,space);        pointer += space>>4;    debug_cntr += space>>4; //first two bits of compression option
    space = adjust(1, srp_mode,pointer,space);                  pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(3,(sci_time>>32)&0x07,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(8,(sci_time>>24)&0xff,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(8,(sci_time>>16)&0xff,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(8,(sci_time>>8)&0xff,pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(8,(sci_time)&0xff,pointer,space);            pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(4, (attitude)&0x0f,pointer,space);           pointer += space>>4;    debug_cntr += space>>4;

    if(srp_mode==0){
        if(beacon_at == 0){
            space = adjust(1, 0,pointer,space);                                     pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(6, compress(scp_bin[44],3,3),pointer,space);             pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(7, compress(scp_bin[48],4,3),pointer,space);             pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(7, compress(scp_bin[49],4,3),pointer,space);             pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(7, compress(scp_bin[50],4,3),pointer,space);             pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(7, compress(scp_bin[51],4,3),pointer,space);             pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(6, compress(scp_bin[17],3,3),pointer,space);             pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(6, compress(scp_bin[23],3,3),pointer,space);             pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(4, compress(proton_scp_sum ,10,2)>>8,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(8, compress(proton_scp_sum ,10,2),pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(4, compress(electron_scp_sum ,10,2)>>8,pointer,space);   pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(8, compress(electron_scp_sum ,10,2),pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
            pointer = pointer + 1;
            for(int temp_i = 12; temp_i<14; temp_i++)
            {            
                *pointer = 0;
                pointer = pointer + 1;
            }
        }
        else if(beacon_at==1){
            space = adjust(1, 1,pointer,space);     pointer += space>>4;        debug_cntr += space>>4;
            space = adjust(1, compress(sfp_bin[44],6,3)>>8,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;             
            space = adjust(8, compress(sfp_bin[44],6,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(4, compress(sfp_bin[48],9,3)>>8,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;             
            space = adjust(8, compress(sfp_bin[48],9,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(4, compress(sfp_bin[49],9,3)>>8,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;             
            space = adjust(8, compress(sfp_bin[49],9,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(4, compress(sfp_bin[50],9,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;                 
            space = adjust(8, compress(sfp_bin[50],9,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(4, compress(sfp_bin[51],9,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;                 
            space = adjust(8, compress(sfp_bin[51],9,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(1, compress(sfp_bin[17],6,3)>>8,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;             
            space = adjust(8, compress(sfp_bin[17],6,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(1, compress(sfp_bin[23],6,3)>>8,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;             
            space = adjust(8, compress(sfp_bin[23],6,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(1, compress(proton_scp_sum ,6,3)>>8,pointer,space);  pointer += space>>4;    debug_cntr += space>>4;         
            space = adjust(8, compress(proton_scp_sum ,6,3),pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(1, compress(electron_scp_sum,6,3)>>8,pointer,space); pointer += space>>4;    debug_cntr += space>>4;     
            space = adjust(8, compress(electron_scp_sum ,6,3),pointer,space);   pointer += space>>4;    debug_cntr += space>>4;
            //cout<<"for beacon space = "<<(space&0x0f)<<" counter = "<<debug_cntr;
        }
    }else if(srp_mode==1){
        if(beacon_at==0){
            space = adjust(1, 0,pointer,space);                             pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(6, compress(0,3,3),pointer,space);               pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(7, compress(sfp_bin[48],4,3),pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(7, compress(sfp_bin[49],4,3),pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(7, compress(sfp_bin[50],4,3),pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(7, compress(sfp_bin[51],4,3),pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
            pointer = pointer + 1;
            for(uint8_t temp_i = 7; temp_i<14; temp_i++)
            {            
                *pointer = 0;
                pointer = pointer + 1;
            }
        }
        else if(beacon_at==1){
            space = adjust(1, 1,pointer,space);                                 pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(1, compress(0,6,3)>>8,pointer,space);                pointer += space>>4;    debug_cntr += space>>4;             
            space = adjust(8, compress(0,6,3),pointer,space);                   pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(4, compress(sfp_bin[48],9,3)>>8,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;             
            space = adjust(8, compress(sfp_bin[48],9,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(4, compress(sfp_bin[49],9,3)>>8,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;             
            space = adjust(8, compress(sfp_bin[49],9,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(4, compress(sfp_bin[50],9,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;                 
            space = adjust(8, compress(sfp_bin[50],9,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(4, compress(sfp_bin[51],9,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;                 
            space = adjust(8, compress(sfp_bin[51],9,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
            pointer = pointer + 1;
            for(uint8_t temp_i = 10; temp_i<14; temp_i++)
            {            
                *pointer = 0;
                pointer = pointer + 1;
            }
        }
    }
    beacon_cntr++;
    /*--------------------------------------------------beacon packet ends here--------------------------------------------------------*/

    //gPC.printf("\n\n\rSCP");
    uint8_t packet_pp,time_diff;
    /*------------------------------------------Forming a science packet(scp) starts here----------------------------------------------*/

    pointer = scp;      debug_cntr = 0;     space = 8;
    time_diff = 0;    
    packet_pp = 1;      //value 1 indicates there is no time jump, i.e. next packet in the frame arrived within 10 seconds

    /*upto line 892: if the time difference between two successive frames is greater than 10 seconds then packet_pp bit is set to 1
      to indicate this time jump*/
    if(time_prev_scp!=sci_time)
    {
        if((((uint8_t)(sci_time>>7))&0x3f)<(((uint8_t)(time_prev_scp>>7))&0x3f))
        {
            time_diff = time_diff+60;
        }
        time_diff += (((uint8_t)(sci_time>>7))&0x3f);
        time_diff -= (((uint8_t)(time_prev_scp>>7))&0x3f);
        if(time_diff>10){
            packet_pp = 0;
        }
        else{
            uint8_t min[2],hour[2],day[2],month[2],year[2];
            min[0]   = (((uint8_t)(sci_time>>13))&0x3f);
            min[1]   = (((uint8_t)(time_prev_scp>>13))&0x3f);
            hour[0]  = (((uint8_t)(sci_time>>19))&0x1f);
            hour[1]  =  (((uint8_t)(time_prev_scp>>19))&0x1f);
            day[0]   = (((uint8_t)(sci_time>>24))&0x1f);
            day[1]   = (((uint8_t)(time_prev_scp>>24))&0x1f);
            month[0] = (((uint8_t)(sci_time>>29))&0x0f);
            month[1] = (((uint8_t)(time_prev_scp>>29))&0x0f);
            year[0]  = (((uint8_t)(sci_time>>33))&0x03);
            year[1]  = (((uint8_t)(time_prev_scp>>33))&0x03);
            if(min[0]<min[1]){
                if(hour[0]<hour[1]){
                    if(day[0]<day[1]){
                        if(month[0]<month[1]){
                            if((year[0]-year[1])!=1)
                                packet_pp = 0;
                        }
                        else if((month[0]-month[1])!=1)
                            packet_pp = 0;
                    }
                    else if((day[0]-day[1])!=1)
                        packet_pp = 0;
                }
                else if((hour[0]-hour[1])!=1)
                    packet_pp = 0;
            }
            else if((min[0]-min[1])!=1)
                packet_pp = 0;
        }
    }
    time_prev_scp = sci_time;
    uint32_t sfp_at_counter;
    sfp_at_counter = FSC_CURRENT[2];
    space = adjust(1, packet_pp,pointer,space);                     pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(5, (sci_time>>8)&0x1f,pointer,space);            pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(8, (sci_time)&0xff,pointer,space);               pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(4, (attitude)&0xf,pointer,space);                pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(2, compression_option,pointer,space);            pointer += space>>4;    debug_cntr += space>>4; //first two bits of compression option
    space = adjust(1, at,pointer,space);                            pointer += space>>4;    debug_cntr += space>>4; //last bit of compression option
    space = adjust(1, srp_mode,pointer,space);                      pointer += space>>4;    debug_cntr += space>>4;
    if(!((srp_mode==0 && compression_option==2)|(srp_mode==1 && compression_option==2)))
    {
        space = adjust(8, sfp_at_counter>>16,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
        space = adjust(8, sfp_at_counter>>8,pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
        space = adjust(8, sfp_at_counter,pointer,space);            pointer += space>>4;    debug_cntr += space>>4;
    }
    if(srp_mode == 0 && compression_option == 0){       //normal callibrated mode
        #if scpz
        gPC.printf("\n\rSCP - Normal calibrated mode");
        #endif
        space = adjust(1, pzf,pointer,space);                       pointer += space>>4;    debug_cntr += space>>4;
        space = adjust(1, ezf,pointer,space);                       pointer += space>>4;    debug_cntr += space>>4;
        if(at == 0 ){
            #if scpz
            gPC.printf("\n\rBelow threshold");
            #endif
            for(int i = 0; i<8 ;i++){
                space = adjust(7,compress(scp_bin[24+i],4,3) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            }
            for(int i = 0; i<12 ;i++){
                space = adjust(5,compress(scp_bin[32+i],2,3) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            }
            for(int i = 0; i<4 ;i++){
                space = adjust(6,compress(scp_bin[44+i],3,3) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            }
            for(int i = 0; i<4 ;i++){
                space = adjust(7,compress(scp_bin[48+i],4,3) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            }
            space = adjust(6,compress(scp_bin[17],3,3) ,pointer,space);             pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(6,compress(scp_bin[23],3,3),pointer,space);              pointer += space>>4;    debug_cntr += space>>4;
            if(pzf == 0){
                for(int i = 0; i<2 ;i++){
                    space = adjust(8,compress(scp_bin[i],6,2) ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
                }
                for(int i = 0; i<15 ;i++){
                    space = adjust(7,compress(scp_bin[i+2],5,2) ,pointer,space);    pointer += space>>4;    debug_cntr += space>>4;
                }
            }
            if(ezf == 0){
                space = adjust(1,compress(scp_bin[18],7,2)>>8 ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8,compress(scp_bin[18],7,2) ,pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
                for(int i=0; i<4; i++){
                    space = adjust(8,compress(scp_bin[19+i],6,2) ,pointer,space);   pointer += space>>4;    debug_cntr += space>>4;
                }
            }
        }// below threshold ends here
        if(at == 1){
            #if scpz
            gPC.printf("\n\rAbove threshold");
            #endif
            for(int i = 0; i<8 ;i++){
                space = adjust(7,compress(scp_bin[24+i],4,3) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            }
            for(int i = 0; i<12 ;i++){
                space = adjust(5,compress2(scp_bin[32+i],2,3) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            }
            for(int i = 0; i<4 ;i++){
                space = adjust(1,compress(scp_bin[44+i],6,3)>>8 ,pointer,space);    pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8,compress(scp_bin[44+i],6,3) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            }
            for(int i=0; i<4 ;i++){
                space = adjust(4,compress(scp_bin[48+i],9,3)>>8 ,pointer,space);    pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8,compress(scp_bin[48+i],9,3) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            }
            space = adjust(1,compress(scp_bin[17],6,3)>>8 ,pointer,space);          pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(8,compress(scp_bin[17],6,3),pointer,space);              pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(1,compress(scp_bin[23],6,3)>>8,pointer,space);           pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(8,compress(scp_bin[23],6,3),pointer,space);              pointer += space>>4;    debug_cntr += space>>4;

            if(pzf == 0){
                for(int i = 0; i<17 ; i++){
                    space = adjust(8, (compress(scp_bin[i],5,3)) ,pointer,space);   pointer += space>>4;    debug_cntr += space>>4;
                }
            }
            if(ezf == 0){
                for(int i = 0; i<5 ; i++){
                    space = adjust(8, (compress(scp_bin[18+i],5,3)) ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
                }
            }
        }   //above thresholds ends
    }   //srp_mode == 0 ends
    if(srp_mode == 1){
        #if scpz
        gPC.printf("\n\rSCP - Scatter plot mode");
        #endif
        if(at == 0){
            #if scpz
            gPC.printf("\n\rBelow Threshold");
            #endif
            for(int i=0; i<48; i++){
                space = adjust(6, ((compress(scp_bin[i],3,3))&0xff) ,pointer,space);    pointer += space>>4;    debug_cntr += space>>4;
            }
            for(int i = 0 ; i < 4 ; i++){
                space = adjust(7, (compress(scp_bin[48+i],4,3))>>8 ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
            }
        }
        if(at == 1){
            #if scpz
            gPC.printf("\n\rAbove threshold");
            #endif
            for(int i=0; i<48; i++){
                space = adjust(7, (compress((scp_bin[i]/2),4,3))>>8 ,pointer,space);    pointer += space>>4;    debug_cntr += space>>4;
            }
            for(int i = 0 ; i < 4 ; i++){
                space = adjust(4, (compress(scp_bin[48+i],9,3))>>8 ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, (compress(scp_bin[48+i],9,3)) ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
            }
        }
    }// scp mode 1 end
    if( srp_mode == 0 && compression_option == 1 ){ //scp data conservation mode
        #if scpz
        gPC.printf("\n\rSCP - Calibrated data conservation mode");
        #endif
        space = adjust(1, pzf,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
        space = adjust(1, ezf,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
        if(at == 0){
            #if scpz
            gPC.printf("\n\rBelow threshold");
            #endif
            space = adjust(6, (compress(scp_bin[44],3,3)) ,pointer,space);              pointer += space>>4;    debug_cntr += space>>4;
            for(int i=0; i<4; i++){
                space = adjust(7, (compress(scp_bin[48+i],4,3)) ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
            }
            space = adjust(6, (compress(scp_bin[17],3,3)) ,pointer,space);              pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(6, (compress(scp_bin[23],3,3)) ,pointer,space);              pointer += space>>4;    debug_cntr += space>>4;
            if(pzf==0){
                space = adjust(4, (compress(proton_scp_sum,10,2))>>8 ,pointer,space);   pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, ( compress(proton_scp_sum,10,2)) ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
            }
            if(ezf==0){
                space = adjust(4, (compress(electron_scp_sum,10,2))>>8 ,pointer,space); pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, (compress(electron_scp_sum,10,2)) ,pointer,space);    pointer += space>>4;    debug_cntr += space>>4;
            }
        }else if(at == 1){
            #if scpz
            gPC.printf("\n\rAbove threshold");
            #endif
            space = adjust(1, (compress(scp_bin[44],6,3))>>8 ,pointer,space);           pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(8, (compress(scp_bin[44],6,3)) ,pointer,space);              pointer += space>>4;    debug_cntr += space>>4;
            for(int i=0; i<4; i++){
                space = adjust(4, (compress(scp_bin[48+i],9,3))>>8 ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, (compress(scp_bin[48+i],9,3)) ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
            }
            space = adjust(1, (compress(scp_bin[17],6,3)>>8) ,pointer,space);           pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(8, (compress(scp_bin[17],6,3)) ,pointer,space);              pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(1, (compress(scp_bin[23],6,3))>>8 ,pointer,space);           pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(8, (compress(scp_bin[23],6,3)) ,pointer,space);              pointer += space>>4;    debug_cntr += space>>4;
            if(pzf==0){
                space = adjust(1, (compress(proton_scp_sum,6,3))>>8 ,pointer,space);    pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, (compress(proton_scp_sum,6,3)) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            }
            if(ezf==0){
                space = adjust(1, (compress(electron_scp_sum,6,3))>>8 ,pointer,space);  pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, (compress(electron_scp_sum,6,3)) ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
            }
        }
    }
    if(compression_option == 2 )  //scp extreme data conservation mode
    {
        if(srp_mode==0)
        {
            #if scpz
            gPC.printf("\n\rSCP - calibrated extreme data conservation mode");
            #endif
            space = adjust(1, pzf,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(1, ezf,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            if(at==0){
                #if scpz
                gPC.printf("\n\rBelow threshold");
                #endif
                space = adjust(7, (compress(scp_bin[50],4,3)) ,pointer,space);              pointer += space>>4;    debug_cntr += space>>4;
                if(pzf==0){
                    space = adjust(4, (compress(proton_scp_sum,10,2))>>8 ,pointer,space);   pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, ( compress(proton_scp_sum,10,2)) ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                }
                if(ezf==0){
                    space = adjust(4, (compress(electron_scp_sum,10,2))>>8 ,pointer,space); pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, (compress(electron_scp_sum,10,2)) ,pointer,space);    pointer += space>>4;    debug_cntr += space>>4;
                }
            }else if(at==1){
                #if scpz
                gPC.printf("\n\rAbove threshold");
                #endif
                space = adjust(4, (compress(scp_bin[50],9,3))>>8 ,pointer,space);           pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, (compress(scp_bin[50],9,3)) ,pointer,space);              pointer += space>>4;    debug_cntr += space>>4;
                if(pzf==0){
                    space = adjust(1, (compress(proton_scp_sum,6,3))>>8 ,pointer,space);    pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, (compress(proton_scp_sum,6,3)) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
                }
                if(ezf==0){
                    space = adjust(1, (compress(electron_scp_sum,6,3))>>8 ,pointer,space);  pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, (compress(electron_scp_sum,6,3)) ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                }
            }
        }
        else if(srp_mode==1)
        {
            #if scpz
            gPC.printf("\n\rSCP - Scatter plot, extreme data conservation mode");
            #endif
            pzf = 0;    ezf = 0;    //because proton energy bins are not available in scatter plot mode and hence in the packet we send dummy data(which is nothng but the maximum value which fits into that particular compression scheme)
            space = adjust(1, pzf,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(1, ezf,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            if(at==0){
                #if scpz
                gPC.printf("\n\rBelow threshold");
                #endif
                space = adjust(7, (compress(scp_bin[50],4,3)) ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
                // below 4 lines - filling the proton ane electron energy bins with zeros(junk value) since they're not available in srp
                space = adjust(4, (compress(0,10,2))>>8 ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, (compress(0,10,2)) ,pointer,space);           pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(4, (compress(0,10,2))>>8 ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, (compress(0,10,2)) ,pointer,space);           pointer += space>>4;    debug_cntr += space>>4;
            }
            else if(at==1){
                #if scpz
                gPC.printf("\n\rAbove threshold");
                #endif
                space = adjust(4, (compress(scp_bin[50],9,3))>>8 ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, (compress(scp_bin[50],9,3)) ,pointer,space);          pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(1, (compress(0,6,3))>>8 ,pointer,space);                 pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, (compress(0,6,3)) ,pointer,space);                    pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(1, (compress(0,6,3))>>8 ,pointer,space);                 pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, (compress(0,6,3)) ,pointer,space);                    pointer += space>>4;    debug_cntr += space>>4;
            }
        }
    }
    /*---------------------------------------------forming a science coarse packet ends here----------------------------------------------*/

    id = 0;
    if(srp_mode == 0 && compression_option == 0){
        if(at == 0){
            length = 228;
            if(pzf == 0)
                length += 121;
            if(ezf == 0)
                length +=41;
        }else if(at == 1){
            length = 266;
            if(pzf == 0)
                length += 136;
            if(ezf == 0)
                length += 40;
            #if test_science
            dma_scp_at_count++;
            #endif
        }
    }else if(srp_mode == 0 && compression_option == 1){                         //data conservation mode
        if(at == 0){
            length = 94;
            if(pzf == 0)
                length += 12;
            if(ezf == 0)
                length += 12;
        }else if(at == 1){
            length = 123;
            if(pzf == 0)
                length += 9;
            if(ezf == 0)
                length += 9;
            #if test_science
            dma_scp_at_count++;
            #endif
        }
    }
    else if( srp_mode == 1){
        if(at == 0)
            length = 368;
        else if(at == 1){
            length = 432;
            #if test_science
            dma_scp_at_count++;
            #endif
        }        
    }
    else if(compression_option == 2 && srp_mode==0)                                //in extreme data conservation mode, length is same for both srp_modes
    {                         
        if(at == 0){
            length = 31;
            if(pzf == 0)
                length += 12;
            if(ezf == 0)
                length += 12;
        }else if(at == 1){
            length = 36;
            if(pzf == 0)
                length += 9;
            if(ezf == 0)
                length += 9;
            #if test_science
            dma_scp_at_count++;
            #endif
        }
    }
    else if(compression_option == 2 && srp_mode==1){
        if(at==0)
            length = 56;
        else if(at==1){
            length = 56;
            #if test_science
            dma_scp_at_count++;
            #endif
        }
    }
    length = (length%8==0)?(length/8):(length/8)+1;
    #if scpz
    gPC.printf("\n\rLength of SCP packet in bytes = %d",length);
    #endif
    /*if(position_tm_frame[id]>129){
        #if scpz
        gPC.printf("\n\rSkipping the current TM frame. Inserting SCP into the next frame");
        gPC.printf("\n\rposition_tm_frame = %d",position_tm_frame[id]);
        #endif
        while(position_tm_frame[id]<132){
            frames[id][position_tm_frame[id]] = 0;
            position_tm_frame[id]++;
        }
    }*/
    if(srp_mode==0 && compression_option!=2){
        if(position_tm_frame[id]>126){
            #if scpz
            gPC.printf("\n\rSkipping the current TM frame. Inserting SCP into the next frame");
            gPC.printf("\n\rposition_tm_frame = %d",position_tm_frame[id]);
            #endif
            while(position_tm_frame[id]<132){
                frames[id][position_tm_frame[id]] = 0;
                position_tm_frame[id]++;
            }
        }
    }
    else if(((srp_mode==0)||(srp_mode==1)) && compression_option==2){
        if(position_tm_frame[id]>129){
            #if scpz
            gPC.printf("\n\rSkipping the current TM frame. Inserting SCP into the next frame");
            gPC.printf("\n\rposition_tm_frame = %d",position_tm_frame[id]);
            #endif
            while(position_tm_frame[id]<132){
                frames[id][position_tm_frame[id]] = 0;
                position_tm_frame[id]++;
            }
        }
    }
    else if(srp_mode==1){
        if(position_tm_frame[id]>129){
            #if scpz
            gPC.printf("\n\rSkipping the current TM frame. Inserting SCP into the next frame");
            gPC.printf("\n\rposition_tm_frame = %d",position_tm_frame[id]);
            #endif
            while(position_tm_frame[id]<132){
                frames[id][position_tm_frame[id]] = 0;
                position_tm_frame[id]++;
            }
        }
    }
    if(position_tm_frame[id]==position_tm_starting[id]){
        frames[id][4] = position_tm_starting[id];
    }
    for(int j= 0; j < length ;)
    {        
        if(position_tm_frame[id]==frames[id][4]){
            #if scpz
            gPC.printf("\n\rInserting Time into SCP_TM");
            #endif
            frames[id][5] = (uint8_t)((sci_time>>29)&0x3f);
            frames[id][6] = (uint8_t)((sci_time>>21)&0xff);
            frames[id][7] = (uint8_t)((sci_time>>13)&0x3f);
        }
        if(position_tm_frame[id]<132){
            frames[id][position_tm_frame[id]] = scp[j];
            j++;
            position_tm_frame[id]++;
        }
        if(position_tm_frame[id] == 132)                                                //space full in the frame bro
        {
            #if scpz
            gPC.printf("\n\rSCP_TM frame full. Length of current SCP packet = %d",j);
            #endif
            pointer = frames[id];
            space = adjust(1,0,pointer,8);
            space = adjust(4,1,pointer,space);
            FSC_science = FSC_CURRENT[1];
            //gPC.printf("1 = 0x%X",FSC_science);
            
            #if debug_fsc
            frames[id][1] = (test_fsc[1]>>16)&0xff;
            frames[id][2] = (test_fsc[1]>>8)&0xff;
            frames[id][3] = (test_fsc[1])&0xff;
            test_fsc[1]++;
            #endif
            #if !debug_fsc
            frames[id][1] = (FSC_science>>16)&0xff;
            frames[id][2] = (FSC_science>>8)&0xff;
            frames[id][3] = (FSC_science)&0xff;
            #endif

            temp_crc = crc16_gen(frames[id],132);
            frames[id][132] = temp_crc>>8;
            frames[id][133] = temp_crc & 0xff;
            #if scpz
            gPC.printf("\n\rFirst head pointer: 0x%02X",frames[id][4]);
            gPC.printf("\n\rFirst head pointer contents: 0x%02X",frames[id][frames[id][4]]);
            gPC.printf("\n\rPrinting SCP_TM\n\r{");
            for(uint8_t z=0;z<134;z++){
                gPC.printf("%02X",frames[id][z]);
            }
            gPC.printf("}\n\r");
            #endif
            #if tabulation
            tabulate_TM(&frames[id][0]);
            #endif
            exor(frames[id]);
            convolution(frames[id]);
            interleave(TM_convoluted_data,TM_interleave_data);
            interleave(TM_convoluted_data+ 135,TM_interleave_data + 144);
            gPC.printf("endSCI_SD13");
           sd_stat = SD_WRITE(TM_interleave_data,FSC_science+1,1);         //sd_write returns ack, for now not included
            gPC.printf("endSCI_SD14");
            if(sd_stat)
            {
                gPC.puts("sd write fail");
            }
            position_tm_frame[id] = position_tm_starting[id];
            if(j!=0)
                frames[id][4] = (length - j)+position_tm_starting[id];
            else if(j==0)
                frames[id][4] = position_tm_starting[id];
        }
    }
    #if scpz_last
    //gPC.printf("\n\rPrinting the last SCP_TM frame");
    //gPC.printf("\n\n\rPosition of tm_pointer: %d",position_tm_frame[id]);
    while(position_tm_frame[id]<132){
        frames[id][position_tm_frame[id]] = 0;
        position_tm_frame[id]++;
    }
    if(position_tm_frame[id] == 132)                                                //space full in the frame bro
    {
        //gPC.printf("\n\rSCP_TM frame full. Length of current SCP packet = %d",j);
        pointer = frames[id];
        space = adjust(1,0,pointer,8);
        space = adjust(4,1,pointer,space);
        FSC_science = FSC_CURRENT[1];
        //gPC.printf("1 = 0x%X",FSC_science);
        
        #if debug_fsc
        frames[id][1] = (test_fsc[1]>>16)&0xff;
        frames[id][2] = (test_fsc[1]>>8)&0xff;
        frames[id][3] = (test_fsc[1])&0xff;
        test_fsc[1]++;
        #endif
        #if !debug_fsc
        frames[id][1] = (FSC_science>>16)&0xff;
        frames[id][2] = (FSC_science>>8)&0xff;
        frames[id][3] = (FSC_science)&0xff;
        #endif

        temp_crc = crc16_gen(frames[id],132);
        frames[id][132] = temp_crc>>8;
        frames[id][133] = temp_crc & 0xff;
        //gPC.printf("\n\rFirst head pointer contents: 0x%02X",frames[id][frames[id][4]]);
        //gPC.printf("\n\rPrinting SCP_TM\n\r{");
        gPC.printf("\n\r{");
        for(uint8_t z=0;z<134;z++){
            gPC.printf("%02X",frames[id][z]);
        }
        gPC.printf("}\n\r");
        position_tm_frame[id] = position_tm_starting[id];
    }
    #endif   
    gPC.printf("fsc = %u, %u,%u\n\r", FSC_CURRENT[1],FSC_CURRENT[2],FSC_CURRENT[3]);
    #if test_science
    dma_packets_info();
    #endif
    gPC.printf("End of SRP function\n\r"); 
    //SCI_LED1 = !SCI_LED1;
 //   SCI_LED1 = 0;
}
/*void test_sci_main(){
    gPAYLOAD_BUFFER[2] &= (~0x01);  //calibrated mode data generation
    //gPAYLOAD_BUFFER[2] |= (0x01);   //scattered plot mode data generation
    srp(gPAYLOAD_BUFFER);
}*/
/*void test_tabulate(){
    uint8_t tmid=2,temp_index,temp=13,space;
    pointer = &test_tm[0][0];
    space = adjust(1, 0,pointer,8);          pointer += space>>4;
    space = adjust(4, 2,pointer,space);      pointer += space>>4;
    space = adjust(3, 0,pointer,space);      pointer += space>>4;

    space = adjust(8, 0,pointer,space);      pointer += space>>4;   //fsc
    space = adjust(8, 0,pointer,space);      pointer += space>>4;
    space = adjust(8, 1,pointer,space);      pointer += space>>4;

    space = adjust(8, 5,pointer,space);      pointer += space>>4;   //first head pointer

    space = adjust(2, 2,pointer,space);      pointer += space>>4;   //time
    space = adjust(4, 12,pointer,space);      pointer += space>>4;
    space = adjust(5, 8,pointer,space);      pointer += space>>4;
    space = adjust(5, 10,pointer,space);      pointer += space>>4;
    space = adjust(6, 25,pointer,space);      pointer += space>>4;
    space = adjust(6, 25,pointer,space);     pointer += space>>4;   
    space = adjust(7, 69,pointer,space);     pointer += space>>4;

    space = adjust(4, 15,pointer,space);     pointer += space>>4;  //attitude

    space = adjust(6, 60,pointer,space);      pointer += space>>4;
    space = adjust(1, 1,pointer,space);      pointer += space>>4;   //science data mode    

    for(uint8_t i = 0 ; i < 48 ; i++){
        space = adjust(2, ((compress(16320,8,2))>>8) ,pointer,space); pointer += space>>4;
        space = adjust(8, ((compress(16320,8,2))&0xff) ,pointer,space); pointer += space>>4;
    }
    for(uint8_t i = 0 ; i < 4 ; i++){
        space = adjust(1, ((compress(1032192,6,3))>>8) ,pointer,space); pointer += space>>4;
        space = adjust(8, ((compress(1032192,6,3))&0xff) ,pointer,space); pointer += space>>4;
    }
    space = adjust(6, 0,pointer,space);      pointer += space>>4;   //spare

    //next packet
    space = adjust(2, 2,pointer,space);      pointer += space>>4;   //time
    space = adjust(4, 12,pointer,space);      pointer += space>>4;
    space = adjust(5, 8,pointer,space);      pointer += space>>4;
    space = adjust(5, 10,pointer,space);      pointer += space>>4;
    space = adjust(6, 25,pointer,space);      pointer += space>>4;
    space = adjust(6, 25,pointer,space);     pointer += space>>4;   
    space = adjust(7, 69,pointer,space);     pointer += space>>4;

    space = adjust(4, 15,pointer,space);     pointer += space>>4;  //attitude

    space = adjust(6, 61,pointer,space);      pointer += space>>4;
    space = adjust(1, 0,pointer,space);      pointer += space>>4;   //science data mode
    space = adjust(1, 0,pointer,space);      pointer += space>>4;   //pzf
    space = adjust(1, 0,pointer,space);      pointer += space>>4;   //ezf

    for(uint8_t i = 0 ; i < 8 ; i++){
        space = adjust(1, ((compress(8128,7,2))>>8) ,pointer,space); pointer += space>>4;
        space = adjust(8, ((compress(8128,7,2))&0xff) ,pointer,space); pointer += space>>4;
    }
    for(uint8_t i = 0 ; i < 12 ; i++){
        space = adjust(6, ((compress(114688,3,3))) ,pointer,space); pointer += space>>4;
    }
    for(uint8_t i = 0 ; i < 4 ; i++){
        space = adjust(2, ((compress(16320,8,2))>>8) ,pointer,space); pointer += space>>4;
        space = adjust(8, ((compress(16320,8,2))&0xff) ,pointer,space); pointer += space>>4;
    }
    for(uint8_t i = 0 ; i < 4 ; i++){
        space = adjust(1, ((compress(1032192,6,3))>>8) ,pointer,space); pointer += space>>4;
        space = adjust(8, ((compress(1032192,6,3))&0xff) ,pointer,space); pointer += space>>4;
    }
    for(uint8_t i = 0 ; i < 18 ; i++){
        space = adjust(2, ((compress(16320,8,2))>>8) ,pointer,space); pointer += space>>4;
        space = adjust(8, ((compress(16320,8,2))&0xff) ,pointer,space); pointer += space>>4;
    }    
    tabulate_TM(&test_tm[0][0]);

    space=8;    pointer = &test_tm[1][0];
    space = adjust(1, 0,pointer,8);          pointer += space>>4;
    space = adjust(4, 2,pointer,space);      pointer += space>>4;
    space = adjust(3, 0,pointer,space);      pointer += space>>4;

    space = adjust(8, 0,pointer,space);      pointer += space>>4;   //fsc
    space = adjust(8, 0,pointer,space);      pointer += space>>4;
    space = adjust(8, 2,pointer,space);      pointer += space>>4;

    space = adjust(8, 13,pointer,space);      pointer += space>>4;   //first head pointer

    for(uint8_t i = 0 ; i < 6 ; i++){
        space = adjust(2, ((compress(16320,8,2))>>8) ,pointer,space); pointer += space>>4;
        space = adjust(8, ((compress(16320,8,2))&0xff) ,pointer,space); pointer += space>>4;
    }
    space = adjust(4, 0,pointer,space);      pointer += space>>4;   //spare    
    tabulate_TM(&test_tm[1][0]);
}*/