#ifndef DMASPISLAVE_H    // To make sure you don't declare the function more than once by including the header multiple times.
#define DMASPISLAVE_H

#ifdef TARGET_KL46Z
class dmaSPISlave : public SPISlave{
    public:
/*
@brief:     constructor : initialise the spi slave pins
@param:     mosi, miso, sclk, ssel
@return:    none
*/
        dmaSPISlave(PinName mosi, PinName miso, PinName sclk, PinName ssel) : SPISlave(mosi, miso, sclk, ssel){
//            trigger appropriate spi for dma
            if(_spi.spi == SPI0){
                read_dma.trigger(Trigger_SPI0_RX);
            }
            else{
                read_dma.trigger(Trigger_SPI1_RX);
            }
            
//            set source for spi slave dma : mosi
            read_dma.source(&_spi.spi->DL, false);
        }
        
/*
@brief:     initialise the dma buffer to store the recevied data
@param:     read_data : pointer to the buffer
            len : length in bytes to store in the buffer
            fun : address of the function to attach to the dma interrupt, interrupt is called when the len num of bytes are written to the buffer
@return:    none
*/
        void bulkRead_init(uint8_t *read_data, int len, void (*fun)(void) ){
//            acquire();
            _spi.spi->C2 |= SPI_C2_RXDMAE_MASK;
        
//            auto increment is true
            read_dma.destination(read_data, true);
        
//            specify length
            length = len;
            
//            attach interrupt function
            read_dma.attach(fun);

        }
        
        void bulkRead_pause(){
            read_dma.attach(NULL);
            }
            
        void bulkRead_resume(void (*fun)(void)){
            read_dma.attach(fun);
            }
/*
@brief:     start the dma read process : has to be done everytime the buffer gets filled, can be used repeatedly
@param:     none
@return:    none
*/
        void bulkRead_start(){
//            start the read_dma
            read_dma.start(length);
        }

/*
@brief:     end dma process and return back to normal spi mode, there should not be an unfinished 'start' when running end
@param:     none
@return:    none
*/
        void bulkRead_end(){
//            turn off dma
            _spi.spi->C2 &= ~(SPI_C2_RXDMAE_MASK);
        }
        
/*
@brief:     restart the dma process after 'end'ing
@param:     none
@return:    none
*/
        void bulkRead_restart(){
            _spi.spi->C2 |= SPI_C2_RXDMAE_MASK;
        }
    private:
        int length;
        SimpleDMA read_dma;
};
#endif
#endif