#ifndef EEPROM_H
#define EEPROM_H

#define ee_scl PIN86
#define ee_sda PIN87
#define check 10

EEPROM e2prom(ee_sda, ee_scl, 0, EEPROM::T24C512);
int32_t INITIAL_EEPROM[32] = {1,1,1,1,1,0,0,0,0,35000,0xff,300,85,20,20,3,80000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

void WRITE_TO_EEPROM(uint32_t address, int32_t data_block)
{
    e2prom.write(address+10,data_block);
}

int32_t READ_FROM_EERPOM(uint32_t address)
{
    int32_t data;
    e2prom.read(address+10, data);
    return data;
}

void INIT_EEPROM()
{
    int32_t test_buffer;
    e2prom.ready();
    e2prom.read(9,test_buffer);
    if(test_buffer == 0)
    {
        for(int i=0;i<32;i++)
            WRITE_TO_EEPROM( i, INITIAL_EEPROM[i]);
        
        e2prom.write(9,1);
    }
    
    EPS_V_A_EN_STATUS         = READ_FROM_EERPOM(0);
    BAE_STATUS                = READ_FROM_EERPOM(1);
    SD_STATUS                 = READ_FROM_EERPOM(2);
    PL_STATUS                 = READ_FROM_EERPOM(3);
    PL_EPS_LATCH_SW_EN        = READ_FROM_EERPOM(4);
    RTC_INIT_STATUS           = READ_FROM_EERPOM(5);
    CDMS_RTC_DISABLE          = READ_FROM_EERPOM(6);
    CDMS_RESET_COUNTER        = READ_FROM_EERPOM(7);
    TIME_LATEST_CDSMS_RESET   = READ_FROM_EERPOM(8);
    COM_TC_BYTES_LIMIT        = READ_FROM_EERPOM(9);
    COM_RX_CURRENT_MAX        = READ_FROM_EERPOM(10);
    COM_RX_DISABLE_TIMEOUT    = READ_FROM_EERPOM(11);
    COM_PA_TMP_HIGH           = READ_FROM_EERPOM(12);
    COM_PA_RECOVERY_TIMEOUT   = READ_FROM_EERPOM(13);
    COM_SESSION_TIMEOUT       = READ_FROM_EERPOM(14);
    COM_RSSI_MIN              = READ_FROM_EERPOM(15);
    SD_LIB_BLK_CURRENT        = READ_FROM_EERPOM(16);
}


#endif