// 8 Jul
// did flowchart of states

// handle sd card with cdms team

// Jun 6
// WHAT IS TC exec code in L1 ack ? 

//Jan 7 
//added RLY_TMTC function
//added included related files

//#include "Flash.h"

//DigitalIn tm_status_4m_slv(PIN39); //I2C interrupt to CDMS from BAE
//DigitalIn tm_status_4m_pl(PIN61); //I2C interrupt to CDMS from PL
#ifndef COM_MNG_TMTC_H    // To make sure you don't declare the function more than once by including the header multiple times.
#define COM_MNG_TMTC_H

#include "dmaSPIslave.h"

#define RESET_CDMS NVIC_SystemReset()


uint8_t received = 0;
uint16_t mid1;
uint16_t mid2;
uint16_t Nbytes;
uint32_t Data[2];
uint16_t nbytes;
uint8_t flash_counter = 0;
uint16_t crc16;
uint16_t mid;
uint32_t block;

uint8_t ACK_CODE;

void TM_PMS_PL_SCHEDULE(Base_tm* tm_pointer1,uint8_t psc);
void ACK_L234(Base_tm* tm_pointer_short1,uint8_t ackCode,uint8_t psc);

#define delete_TC(tc_ptr) {\
    if(tc_ptr == gHEAD_NODE_TCL){\
        gHEAD_NODE_TCL = tc_ptr->next_TC;\
    }\
    delete tc_ptr;\
}

// typeof tm_ptr: Base_tm
// typeof tc_ptr: Base_tc
// typeof temp_xxxx: uint8_t




#define detect_ack(tm_ptr, temp_ack) {\
    if( tm_ptr != NULL ){\
        int length = TM_SHORT_SIZE;\
        if( GETshort_or_long_tm(tm_ptr) == SHORT_TM_CODE ){\
            length = TM_SHORT_SIZE;\
        }\
        else{\
            length = TM_LONG_SIZE;\
        }\
        uint16_t crc = crc16_gen(tm_ptr->TM_string, length-2);\
        if( (((crc & 0xFF00) >> 8) == tm_ptr->TM_string[length-2]) && ( (crc & 0x00FF) == tm_ptr->TM_string[length-1] ) ){\
            uint8_t temp8;\
            temp8 = tm_ptr->TM_string[TM_ACK_CODE_INDEX];\
            temp8 = temp8 & 0xE0;\
            if( (temp8 == 0xC0) || (temp8 == 0xA0) )\
                temp_ack = 0x01;\
            else{\
                temp_ack = 0x02;\
                /*CHECK FOR NACK CODE: CRC FAIL NACK*/\
                temp8 = tm_ptr->TM_string[TM_ACK_CODE_INDEX];\
                temp8 = temp8 & 0x0F;\
                if( temp8 == CRC_FAIL_NACK_CODE ){\
                    temp_ack = 0x04;\
                }\
            }\
        }\
        else\
            temp_ack = 0x03;\
    }\
    else{\
        temp_ack = 0x02;\
    }\
}

#define isit_obosc(tc_ptr, temp_obosc) {\
    temp_obosc = 0x00;\
    if( GETapid(tc_ptr) == APID_COM ){\
        if( ((tc_ptr->TC_string[2]) >> 4) == SERVICE_OBOSC ){\
            temp_obosc = 0x01;\
        }\
    }\
}

#define isit_sdcard(tc_ptr, temp_sdcard) {\
    temp_sdcard = 0x00;\
    if( GETapid(tc_ptr) == APID_COM ){\
        if( ( (tc_ptr->TC_string[2]) >> 4) == SERVICE_OBSRS ){\
            temp_sdcard = 0x01;\
        }\
    }\
}



void after_cooling_pa(){
    gCOM_MNG_TMTC_THREAD->signal_set(COM_MNG_TMTC_SIGNAL_UART_INT);
}

/*
@brief:     check for missing tc, also check crc, i.e. 
            if true execution can be started else have to wait
            decide the next state
@param:     none
@return:    bool indicating whether there are missing tc
*/
// PENDING: LAST FRAME BIT
/*
for loop: check for missing tc
if: check for incorrect sized tc
if: check for last frame bit
*/
#define continueToExecute(returnHere) {\
    uint8_t tempReturn = 0x00;\
    /*search for missing psc*/\
    for(uint8_t p = 0x00 ; p < (gTOTAL_VALID_TC) ; ++p){\
        bool flag = false;\
        Base_tc *node_ptr = gHEAD_NODE_TCL;\
        while(node_ptr != NULL){\
            if( (GETpacket_seq_count(node_ptr) == p) && (GETcrc_pass(node_ptr) == 1) ){\
                flag = true;\
                break;\
            }\
            else{\
                node_ptr = node_ptr->next_TC;\
            }\
        }\
        if(flag == false){\
            tempReturn = 0x02;\
            break;\
        }\
    }\
    /*search for last packet bit*/\
    tempReturn = tempReturn + 0x01;\
    Base_tc *tcp = gHEAD_NODE_TCL;\
    while(tcp != NULL){\
        if(GETpacket_seq_count(tcp) == (gTOTAL_VALID_TC - 1)){\
            if( ( (tcp->TC_string[1]) & 0x20 ) == 0x20 ){\
                tempReturn = tempReturn - 0x01;\
            }\
            break;\
        }\
        tcp = tcp->next_TC;\
    }\
    returnHere = tempReturn;\
    /*UPDATE gMASTER STATE*/\
    if( (returnHere == 0x00) ){\
        if( (gMASTER_STATE == TCL_STATE_INCOMPLETE) || (gMASTER_STATE == TCL_STATE_COMPLETED) || (gMASTER_STATE == TCL_STATE_ABORTED) ){\
            gMASTER_STATE = TCL_STATE_EXECUTING;\
        }\
    }\
    else{\
        if( (gMASTER_STATE == TCL_STATE_INCOMPLETE) || (gMASTER_STATE == TCL_STATE_COMPLETED) || (gMASTER_STATE == TCL_STATE_ABORTED) ){\
            gMASTER_STATE = TCL_STATE_INCOMPLETE;\
        }\
    }\
}

/*
return 1 if code match
return 0 if code mismatch
*/
#define GScodeVerification(returnHere){\
    Base_tc *testTC = gHEAD_NODE_TCL;\
    uint16_t overflowCount = 0;\
    returnHere = 0xFF;\
    while( (overflowCount < TCL_OVERFLOW_CONSTANT) && (testTC != NULL) ){\
        if( (GETpacket_seq_count(testTC) == PSC_CALLSIGN) && (GETapid(testTC) == APID_CALLSIGN) ){\
            /*uint8_t temp8 = testTC->TC_string[1];*/\
            if( true ){\
                for( int i = 2 ; i <= 8 ; ++i ){\
                    if( testTC->TC_string[i] != gGSCODE[i-2] ){\
                        returnHere = 0;\
                        break;\
                    }\
                }\
            }\
            break;\
        }\
        testTC = testTC->next_TC;\
        ++overflowCount;\
    }\
}

/*
@brief:     DELETE THE CRC FAILED TC FROM THE LIST TO FREE-UP MEMORY AND UPDATE 
            THE TOTAL VALID TC AND GENERATE L1_ACK_TM
@param:     none
@return:    none
*/
/*tm_ptr is the next_TM of a linked list, and should have the value NULL, i.e. tm_ptr should be the next_TM pointer of thte last node */

/*tm_ptr is the next_TM of a linked list, and should have the value NULL, i.e. tm_ptr should be the next_TM pointer of thte last node */

// CDMS TEAM CODE START
void ACK_L234(Base_tm* tm_pointer_short1,uint8_t ackCode,uint8_t psc)
{
    tm_pointer_short1->TM_string[0] = 0xB0; 
    tm_pointer_short1->TM_string[1] = psc;
    tm_pointer_short1->TM_string[2] = ackCode;
    tm_pointer_short1->TM_string[3] = 0x00;
    tm_pointer_short1->TM_string[4] = 0x00;
    for(uint8_t i=0;i<6;i++)
        tm_pointer_short1->TM_string[i+5] = 0;
    crc16 = crc16_gen(tm_pointer_short1->TM_string,11);
    tm_pointer_short1->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
    tm_pointer_short1->TM_string[12] = (uint8_t)(crc16&0x00FF);
    tm_pointer_short1->next_TM = NULL;                                                 
}
void TM_PMS_PL_SCHEDULE(Base_tm *tm_pointer1,uint8_t psc)
{
    Base_tm *tm_pointer2 = NULL;
    if(!(tm_pointer2  = new Long_tm))
    {
       gPC.printf("\n\rError: out of memory");
       return;   
    }
    Base_tm *tm_pointer3 = NULL;
    if(!(tm_pointer3  = new Long_tm))
    {
       gPC.printf("\n\rError: out of memory");
       return;   
    }
    Base_tm *tm_pointer4 = NULL;
    if(!(tm_pointer4  = new Long_tm))
    {
       gPC.printf("\n\rError: out of memory");
       return;   
    }
    Base_tm *tm_pointer5 = NULL;
    if(!(tm_pointer5  = new Long_tm))
    {
       gPC.printf("\n\rError: out of memory");
       return;   
    }    
    Base_tm *tm_pointer6 = NULL;
    if(!(tm_pointer6  = new Long_tm))
    {
       gPC.printf("\n\rError: out of memory");
       return;   
    }
    tm_pointer1->TM_string[0] = 0x48;     
    tm_pointer1->TM_string[1] = psc;
    tm_pointer1->TM_string[2] = 0xA0;
    tm_pointer1->TM_string[3] = 0x01;
    for(uint8_t i=0;i<128;i+=4)
    {
        tm_pointer1->TM_string[i+4] = (uint8_t)((pl_block[i/4] & 0xFF000000)>>24);
        tm_pointer1->TM_string[i+5] = (uint8_t)((pl_block[i/4] & 0x00FF0000)>>16);
        tm_pointer1->TM_string[i+6] = (uint8_t)((pl_block[i/4] & 0x0000FF00)>>8);
        tm_pointer1->TM_string[i+7] = (uint8_t)((pl_block[i/4] & 0x000000FF));                        
    }
    crc16 = crc16_gen(tm_pointer1->TM_string,132);
    tm_pointer1->TM_string[132] = (uint8_t)((crc16&0xFF00)>>8);
    tm_pointer1->TM_string[133] = (uint8_t)(crc16&0x00FF);    
    tm_pointer1->next_TM = tm_pointer2;
    
    tm_pointer2->TM_string[0] = 0x48;     
    tm_pointer2->TM_string[1] = psc;
    tm_pointer2->TM_string[2] = 0xA0;
    tm_pointer2->TM_string[3] = 0x02;
    for(uint8_t i=0;i<128;i+=4)
    {
        tm_pointer2->TM_string[i+4] = (uint8_t)((pl_block[(i/4)+32] & 0xFF000000)>>24);
        tm_pointer2->TM_string[i+5] = (uint8_t)((pl_block[(i/4)+32] & 0x00FF0000)>>16);
        tm_pointer2->TM_string[i+6] = (uint8_t)((pl_block[(i/4)+32] & 0x0000FF00)>>8);
        tm_pointer2->TM_string[i+7] = (uint8_t)((pl_block[(i/4)+32] & 0x000000FF));                        
    }
    crc16 = crc16_gen(tm_pointer2->TM_string,132);
    tm_pointer2->TM_string[132] = (uint8_t)((crc16&0xFF00)>>8);
    tm_pointer2->TM_string[133] = (uint8_t)(crc16&0x00FF);
    tm_pointer2->next_TM = tm_pointer3;

    tm_pointer3->TM_string[0] = 0x48;     
    tm_pointer3->TM_string[1] = psc;
    tm_pointer3->TM_string[2] = 0xA0;
    tm_pointer3->TM_string[3] = 0x03;
    for(uint8_t i=0;i<128;i+=4)
    {
        tm_pointer3->TM_string[i+4] = (uint8_t)((pl_block[(i/4)+64] & 0xFF000000)>>24);
        tm_pointer3->TM_string[i+5] = (uint8_t)((pl_block[(i/4)+64] & 0x00FF0000)>>16);
        tm_pointer3->TM_string[i+6] = (uint8_t)((pl_block[(i/4)+64] & 0x0000FF00)>>8);
        tm_pointer3->TM_string[i+7] = (uint8_t)((pl_block[(i/4)+64] & 0x000000FF));                        
    }
    crc16 = crc16_gen(tm_pointer3->TM_string,132);
    tm_pointer3->TM_string[132] = (uint8_t)((crc16&0xFF00)>>8);
    tm_pointer3->TM_string[133] = (uint8_t)(crc16&0x00FF);
    tm_pointer3->next_TM = tm_pointer4;

    tm_pointer4->TM_string[0] = 0x48;     
    tm_pointer4->TM_string[1] = psc;
    tm_pointer4->TM_string[2] = 0xA0;
    tm_pointer4->TM_string[3] = 0x04;
    for(uint8_t i=0;i<128;i+=4)
    {
        tm_pointer4->TM_string[i+4] = (uint8_t)((pl_block[(i/4)+96] & 0xFF000000)>>24);
        tm_pointer4->TM_string[i+5] = (uint8_t)((pl_block[(i/4)+96] & 0x00FF0000)>>16);
        tm_pointer4->TM_string[i+6] = (uint8_t)((pl_block[(i/4)+96] & 0x0000FF00)>>8);
        tm_pointer4->TM_string[i+7] = (uint8_t)((pl_block[(i/4)+96] & 0x000000FF));                        
    }
    crc16 = crc16_gen(tm_pointer4->TM_string,132);
    tm_pointer4->TM_string[132] = (uint8_t)((crc16&0xFF00)>>8);
    tm_pointer4->TM_string[133] = (uint8_t)(crc16&0x00FF);                        
    tm_pointer4->next_TM = tm_pointer5;

    tm_pointer5->TM_string[0] = 0x48;     
    tm_pointer5->TM_string[1] = psc;
    tm_pointer5->TM_string[2] = 0xA0;
    tm_pointer5->TM_string[3] = 0x05;
    for(uint8_t i=0;i<128;i+=4)
    {
        tm_pointer5->TM_string[i+4] = (uint8_t)((pl_block[(i/4)+128] & 0xFF000000)>>24);
        tm_pointer5->TM_string[i+5] = (uint8_t)((pl_block[(i/4)+128] & 0x00FF0000)>>16);
        tm_pointer5->TM_string[i+6] = (uint8_t)((pl_block[(i/4)+128] & 0x0000FF00)>>8);
        tm_pointer5->TM_string[i+7] = (uint8_t)((pl_block[(i/4)+128] & 0x000000FF));                        
    }
    crc16 = crc16_gen(tm_pointer5->TM_string,132);
    tm_pointer5->TM_string[132] = (uint8_t)((crc16&0xFF00)>>8);
    tm_pointer5->TM_string[133] = (uint8_t)(crc16&0x00FF);
    tm_pointer5->next_TM = tm_pointer6;

    tm_pointer6->TM_string[0] = 0x48;     
    tm_pointer6->TM_string[1] = psc;
    tm_pointer6->TM_string[2] = 0xA0;
    tm_pointer6->TM_string[3] = 0x06;
    for(uint8_t i=0;i<128;i+=4)
    {
        tm_pointer6->TM_string[i+4] = (uint8_t)((pl_block[(i/4)+160] & 0xFF000000)>>24);
        tm_pointer6->TM_string[i+5] = (uint8_t)((pl_block[(i/4)+160] & 0x00FF0000)>>16);
        tm_pointer6->TM_string[i+6] = (uint8_t)((pl_block[(i/4)+160] & 0x0000FF00)>>8);
        tm_pointer6->TM_string[i+7] = (uint8_t)((pl_block[(i/4)+160] & 0x000000FF));                        
    }
    crc16 = crc16_gen(tm_pointer6->TM_string,132);
    tm_pointer6->TM_string[132] = (uint8_t)((crc16&0xFF00)>>8);
    tm_pointer6->TM_string[133] = (uint8_t)(crc16&0x00FF);
    tm_pointer6->next_TM = NULL;
}
Base_tm* FCTN_CDMS_RLY_TMTC(Base_tc *tc_ptr)
{
    //uint8_t ACKCODE = 0xB0;
    bool y;
    //gPC.printf("\rTC execution in progress\r\n");
    received = 0;
    switch(GETapid(tc_ptr))             //checking APID's
    {
        case 1: //apid=01 implies it corresponds to bae
        {
            BAE_I2C_mutex.lock();
            //BAE_TC;
            gPC.printf("Telecommand is for BAE\r\n");
            //gPC.printf("Sending TC to BAE...\r\n"); //interrupt to be sent to the bae
            y = FCTN_I2C_WRITE((char*)tc_ptr->TC_string,TC_LONG_SIZE);                         // Check for SHORT and LONG TC and then send
                
            if(y==1)                                                            
            {        
                gPC.printf("Write fail\r\n");
                Base_tm *tm_ptr_short = new Short_tm;
                ACK_L234(tm_ptr_short,0x03,GETpacket_seq_count(tc_ptr));
                return tm_ptr_short;
            }                                  
            else if(y==0)
            {
                TIME_LATEST_I2C_BAE = FCTN_CDMS_RD_RTC() >> 7;
                gPC.printf("Write success\r\n");
                //wait(0.2);
                int poll=0;
                while(poll<3000 && BAE_I2C_GPIO==0)
                {
                    wait_ms(1);
                    poll+=1;
                }
                if(BAE_I2C_GPIO == 1)
                {
                    //gPC.printf("BAE_I2C_GPIO is high\r\n");
                    Base_tm *tm_ptr = new Long_tm;
                    y=FCTN_I2C_READ((char*)tm_ptr->TM_string,TM_LONG_SIZE);
                    if(y==0)
                    {
                        TIME_LATEST_I2C_BAE = FCTN_CDMS_RD_RTC() >> 7;
                        gPC.printf("Read success\r\n");
                        tm_ptr->next_TM=NULL;
                        return tm_ptr;
                    }
                    else if(y==1)
                    {
                        delete tm_ptr;
                        Base_tm *tm_ptr_short = new Short_tm;
                        gPC.printf("Read fail\r\n");
                        ACK_L234(tm_ptr_short,0x85,GETpacket_seq_count(tc_ptr));                
                        //gPC.printf("\n\rPTE->PDIR = 0x%08X",PTE->PDIR);
                        return tm_ptr_short;
                    }
                }
                else if(BAE_I2C_GPIO == 0)
                {
                    gPC.printf("BAE_I2C_GPIO is not high\r\n");                    
                    Base_tm *tm_ptr_short = new Short_tm;
                    ACK_L234(tm_ptr_short,0x84,GETpacket_seq_count(tc_ptr));
                    return tm_ptr_short;
                }
            }
            BAE_I2C_mutex.unlock();
        }

        case 2: // APID = 2 corresponds to CDMS
        {
            //gPC.printf("Telecommand is for CDMS\r\n"); //apid = 10 corresponds to cdms
            switch(GETservice_type(tc_ptr))
            {
                case 0x60:  //service type = 0x6
                {
                    gPC.printf("service:MMS\r\n");
                    switch(GETservice_subtype(tc_ptr))      
                    {
                        case 0x2:   //service subtye                        
                        {
                            //gPC.printf("sub_service:Read LONG_RAM_Memory\r\n");
                            mid=((uint16_t)(tc_ptr->TC_string[3]<<4))+((uint16_t)(tc_ptr->TC_string[4]));                                                       
                            if(mid!=0x0000 && mid!=0x0001)
                            {
                                Base_tm *tm_ptr_short = new Short_tm;
                                ACK_L234(tm_ptr_short,0x02,GETpacket_seq_count(tc_ptr));
                                return tm_ptr_short;
                            }
                            Base_tm *tm_ptr = new Long_tm;
                            tm_ptr->TM_string[0] = 0x30;
                            tm_ptr->TM_string[1] = GETpacket_seq_count(tc_ptr);
                            tm_ptr->TM_string[2] = 0xA0;
                            tm_ptr->TM_string[3] = 0x00;                            //spare bits
                            
                            if(mid == 0x0000)
                            FCTN_CDMS_RD_L_RAM(tm_ptr);
                            if(mid == 0x0001)
                            FCTN_CDMS_MAX_MIN(tm_ptr);
                            
                            crc16 = crc16_gen(tm_ptr->TM_string,132);
                            tm_ptr->TM_string[132] = (uint8_t)((crc16&0xFF00)>>8);
                            tm_ptr->TM_string[133] = (uint8_t)(crc16&0x00FF);
                            tm_ptr->next_TM = NULL;
                            return tm_ptr;
                        }                           
                        case 0x5:                           // change the cases appropriately
                        {
                            //gPC.printf("WRITE ON SHORT_FLASH_MEMORY\r\n");                          
                            mid=(uint16_t)(tc_ptr->TC_string[3]<<4)+(uint16_t)(tc_ptr->TC_string[4]);
                            //32 bits at a time           
                            Base_tm *tm_ptr_short = new Short_tm;
                            if(mid == 0x0101 || mid==0x0102 || mid == 0x0103 || mid == 0x0100)                                  //allowable MID values?
                            {
                                
                                ACK_L234(tm_ptr_short,0x02,GETpacket_seq_count(tc_ptr));
                                return tm_ptr_short;
                            }                                                        

                            FCTN_CDMS_WR_S_FLASH(mid,(uint32_t)(tc_ptr->TC_string[5]<<24)+(uint32_t)(tc_ptr->TC_string[6]<<16)+(uint32_t)(tc_ptr->TC_string[7]<<8)+(uint32_t)(tc_ptr->TC_string[8]));                                                     

                            ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));              

                            return tm_ptr_short;
                        }
                        case 0x6:   //service subtye = WR_L_FLASH
                        {
                            mid=((uint16_t)(tc_ptr->TC_string[3]<<8))+((uint16_t)(tc_ptr->TC_string[4]));
                            if(mid == 0x0002)
                            {
                                for(uint8_t z=0;z<24;z++)
                                    scp_threshold_m0[z] = tc_ptr->TC_string[z+5];
                                for(uint8_t z=24;z<32;z++)
                                    scp_threshold_m0[z+8] = tc_ptr->TC_string[z+5];                            
                                //int strt_add = flash_size() - (11*SECTOR_SIZE);
                                //uint32_t flasharray[32] = {0};
                                for(uint8_t z=0;z<24;z++)
                                    flasharray_thres[z] = scp_threshold_m0[z];
                                for(uint8_t z=24;z<32;z++)
                                    flasharray_thres[z] = scp_threshold_m0[z+8];
                                erase_sector(strt_add_thres);
                                program_flash(strt_add_thres, (char*)flasharray_thres,32);
                                
                                Base_tm *tm_ptr_short = new Short_tm;
                                ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                                return tm_ptr_short;
                            }
                            else if(mid == 0x0003)
                            {
                                for(uint8_t z=0;z<12;z++)
                                    scp_threshold_m0[z+40] = tc_ptr->TC_string[z+5];
                                //int strt_add = flash_size() - (10*SECTOR_SIZE);
                                //uint32_t flasharray[32] = {0};
                                for(uint8_t z=0;z<12;z++)
                                    flasharray_thres[z] = scp_threshold_m0[z+40];
                                erase_sector(strt_add_thres+SECTOR_SIZE);
                                program_flash(strt_add_thres+SECTOR_SIZE, (char*)flasharray_thres,32);
                                Base_tm *tm_ptr_short = new Short_tm;
                                ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                                return tm_ptr_short;
                            }
                            else if(mid == 0x0004)
                            {
                                for(uint8_t z=0;z<32;z++)
                                    scp_threshold_m1[z] = tc_ptr->TC_string[z+5];
                                //int strt_add = flash_size() - (9*SECTOR_SIZE);
                                //uint32_t flasharray[32] = {0};
                                for(uint8_t z=0;z<32;z++)
                                    flasharray_thres[z] = scp_threshold_m1[z];
                                erase_sector(strt_add_thres+(2*SECTOR_SIZE));
                                program_flash(strt_add_thres+(2*SECTOR_SIZE), (char*)flasharray_thres,32);
                                Base_tm *tm_ptr_short = new Short_tm;
                                ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                                return tm_ptr_short;
                            }
                            else if(mid == 0x0005)
                            {
                                for(uint8_t z=0;z<20;z++)
                                    scp_threshold_m1[z+32] = tc_ptr->TC_string[z+5];
                                //int strt_add = flash_size() - (8*SECTOR_SIZE);
                                //uint32_t flasharray[32] = {0};
                                for(uint8_t z=0;z<20;z++)
                                    flasharray_thres[z] = scp_threshold_m1[z+32];
                                erase_sector(strt_add_thres+(3*SECTOR_SIZE));
                                program_flash(strt_add_thres+(3*SECTOR_SIZE), (char*)flasharray_thres,32);
                                Base_tm *tm_ptr_short = new Short_tm;
                                ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                                return tm_ptr_short;
                            }
                            else if(mid == 0x0006)
                            {
                                scp_threshold_m0_1[7] = tc_ptr->TC_string[5];
                                scp_threshold_m0_1[5] = tc_ptr->TC_string[6];
                                scp_threshold_m0_1[8] = tc_ptr->TC_string[7];
                                scp_threshold_m0_1[6] = tc_ptr->TC_string[8];
                                for(uint8_t z=0;z<5;z++)
                                    scp_threshold_m0_1[z] = tc_ptr->TC_string[z+9];
                                scp_sfp_threshold_m0_2[0] = tc_ptr->TC_string[14];
                                scp_sfp_threshold_m0_2[1] = tc_ptr->TC_string[15];
                                scp_sfp_threshold_m0_2[2] = tc_ptr->TC_string[16];
                                //int strt_add = flash_size() - (7*SECTOR_SIZE);
                                //uint32_t flasharray[32] = {0};
                                flasharray_thres[0] = scp_threshold_m0_1[7];
                                flasharray_thres[1] = scp_threshold_m0_1[5];
                                flasharray_thres[2] = scp_threshold_m0_1[8];
                                flasharray_thres[3] = scp_threshold_m0_1[6];
                                for(uint8_t z=0;z<5;z++)
                                    flasharray_thres[z+4] = scp_threshold_m0_1[z];
                                flasharray_thres[9]  = scp_sfp_threshold_m0_2[0];
                                flasharray_thres[10] = scp_sfp_threshold_m0_2[1];
                                flasharray_thres[11] = scp_sfp_threshold_m0_2[2];
                                erase_sector(strt_add_thres+(4*SECTOR_SIZE));
                                program_flash(strt_add_thres+(4*SECTOR_SIZE), (char*)flasharray_thres,32);
                                Base_tm *tm_ptr_short = new Short_tm;
                                ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                                return tm_ptr_short;
                            }
                            else if(mid == 0x0007)
                            {
                                for(uint8_t z=0;z<24;z++)
                                    sfp_threshold_m0[z] = tc_ptr->TC_string[z+5];
                                for(uint8_t z=24;z<32;z++)
                                    sfp_threshold_m0[z+8] = tc_ptr->TC_string[z+5];
                                //int strt_add_thres = flash_size() - (6*SECTOR_SIZE);
                                //uint32_t flasharray_thres[32] = {0};
                                for(uint8_t z=0;z<24;z++)
                                    flasharray_thres[z] = sfp_threshold_m0[z];
                                for(uint8_t z=24;z<32;z++)
                                    flasharray_thres[z] = sfp_threshold_m0[z+8];
                                erase_sector(strt_add_thres+(5*SECTOR_SIZE));
                                program_flash(strt_add_thres+(5*SECTOR_SIZE), (char*)flasharray_thres,32);
                                Base_tm *tm_ptr_short = new Short_tm;
                                ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                                return tm_ptr_short;
                            }
                            else if(mid == 0x0008)
                            {
                                for(uint8_t z=0;z<12;z++)
                                    sfp_threshold_m0[z+40] = tc_ptr->TC_string[z+5];
                                //int strt_add_thres = flash_size() - (5*SECTOR_SIZE);
                                //uint32_t flasharray_thres[32] = {0};
                                for(uint8_t z=0;z<12;z++)
                                    flasharray_thres[z] = sfp_threshold_m0[z+40];
                                erase_sector(strt_add_thres+(6*SECTOR_SIZE));
                                program_flash(strt_add_thres+(6*SECTOR_SIZE), (char*)flasharray_thres,32);
                                Base_tm *tm_ptr_short = new Short_tm;
                                ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                                return tm_ptr_short;
                            }
                            else if(mid == 0x0009)
                            {
                                for(uint8_t z=0;z<32;z++)
                                    sfp_threshold_m1[z] = tc_ptr->TC_string[z+5];
                                //int strt_add_thres = flash_size() - (4*SECTOR_SIZE);
                                //uint32_t flasharray_thres[32] = {0};
                                for(uint8_t z=0;z<32;z++)
                                    flasharray_thres[z] = sfp_threshold_m1[z];
                                erase_sector(strt_add_thres+(7*SECTOR_SIZE));
                                program_flash(strt_add_thres+(7*SECTOR_SIZE), (char*)flasharray_thres,32);
                                Base_tm *tm_ptr_short = new Short_tm;
                                ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                                return tm_ptr_short;
                            }
                            else if(mid == 0x000A)
                            {
                                for(uint8_t z=0;z<20;z++)
                                    sfp_threshold_m1[z+32] = tc_ptr->TC_string[z+5];
                                //int strt_add_thres = flash_size() - (3*SECTOR_SIZE);
                                //uint32_t flasharray_thres[32] = {0};
                                for(uint8_t z=0;z<20;z++)
                                    flasharray_thres[z] = sfp_threshold_m1[z+32];
                                erase_sector(strt_add_thres+(8*SECTOR_SIZE));
                                program_flash(strt_add_thres+(8*SECTOR_SIZE), (char*)flasharray_thres,32);
                                Base_tm *tm_ptr_short = new Short_tm;
                                ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                                return tm_ptr_short;
                            }                        
                        }
                        default:
                        {
                            gPC.printf("INVALID SERVICE SUBTYPE\r\n");
                            Base_tm *tm_ptr_short = new Short_tm;
                            ACK_L234(tm_ptr_short,0x02,GETpacket_seq_count(tc_ptr));
                            return tm_ptr_short;
                        }
                    } 
                }                                                                   
                case 0x80:
                {
                    gPC.printf("service:FUNCTION MANAGEMENT SERVICE\r\n"); 
                    if(GETservice_subtype(tc_ptr)==0x1)
                    {                               
                        if(GETpid(tc_ptr)==0x01)
                        {
                            Base_tm *tm_ptr_short = new Short_tm;
                            if(CDMS_STANDBY==1)
                            {   
                                //gPC.printf("TC_PL_INIT\r\n");                         // call PWR_SWCH_ON function
                                
                                P_PL_INIT();
                                    
                                ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                                return tm_ptr_short;
                            }                
                            else if(CDMS_STANDBY==0)
                            {
                                ACK_L234(tm_ptr_short,0x87,GETpacket_seq_count(tc_ptr));                        //TC cannot be processed now
                                return tm_ptr_short;
                            }
                        }                                
                        else if(GETpid(tc_ptr)==0x02)
                        {
                            Base_tm *tm_ptr_short = new Short_tm;
                            if(CDMS_STANDBY==1)
                            {   
                                //gPC.printf("TC_PL_MAIN\r\n");                         // call PWR_SWCH_ON function
                                
                                P_PL_MAIN();

                                ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                                return tm_ptr_short;
                            }                
                            else if(CDMS_STANDBY==0)
                            {
                                ACK_L234(tm_ptr_short,0x87,GETpacket_seq_count(tc_ptr));                        //TC cannot be processed now
                                return tm_ptr_short;
                            }
                        }
                        else if(GETpid(tc_ptr)==0x03)
                        {                            
                            Base_tm *tm_ptr_short = new Short_tm;
                            if(CDMS_STANDBY==1)
                            {   
                                //gPC.printf("PL_COM_INIT\r\n");                        // call PWR_SWCH_ON function
                                
                                P_COM_INIT();

                                ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                                return tm_ptr_short;
                            }                
                            else if(CDMS_STANDBY==0)
                            {
                                ACK_L234(tm_ptr_short,0x87,GETpacket_seq_count(tc_ptr));                        //TC cannot be processed now
                                return tm_ptr_short;
                            }
                        }
                        else if(GETpid(tc_ptr)==0x04)
                        {                            
                            Base_tm *tm_ptr_short = new Short_tm;
                            if(CDMS_STANDBY==1)
                            {   
                                //gPC.printf("TC_P_CDMS_HK_MAIN\r\n"); // call PWR_SWCH_ON function
                                
                                //gHK_THREAD->signal_set(HK_SIGNAL);

                                ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                                return tm_ptr_short;
                            }                
                            else if(CDMS_STANDBY==0)
                            {
                                ACK_L234(tm_ptr_short,0x87,GETpacket_seq_count(tc_ptr));                        //TC cannot be processed now
                                return tm_ptr_short;
                            }
                        }
                        else if(GETpid(tc_ptr)==0x05)
                        {                            
                            Base_tm *tm_ptr_short = new Short_tm;
                            if(CDMS_STANDBY==1)
                            {   
                                //gPC.printf("TC_SW_ON_SD\r\n");                        // call PWR_SWCH_ON function
                                
                                P_PL_RCV_SC_DATA();

                                ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                                return tm_ptr_short;
                            }                
                            else if(CDMS_STANDBY==0)
                            {
                                ACK_L234(tm_ptr_short,0x87,GETpacket_seq_count(tc_ptr));                        //TC cannot be processed now
                                return tm_ptr_short;
                            }
                        }
                        else if(GETpid(tc_ptr)==0x06)
                        {                            
                            Base_tm *tm_ptr_short = new Short_tm;
                            if(CDMS_STANDBY==1)
                            {   
                                //gPC.printf("TC_SW_ON_RTC\r\n"); // call PWR_SWCH_ON function
                                gPC.printf("SD _INIT\r\n");
                                P_CDMS_INIT_SD();

                                ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                                return tm_ptr_short;
                            }                
                            else if(CDMS_STANDBY==0)
                            {
                                ACK_L234(tm_ptr_short,0x87,GETpacket_seq_count(tc_ptr));                        //TC cannot be processed now
                                return tm_ptr_short;
                            }    
                        }
                        else if(GETpid(tc_ptr)==0x11)
                        {       
                            //gPC.printf("TC_SW_ON_SD\r\n"); // call PWR_SWCH_ON function
                            
                            CDMS_SD_SW_ON();
                            Base_tm *tm_ptr_short = new Short_tm;
                            ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                            return tm_ptr_short;                                                       
                        }
                        else if(GETpid(tc_ptr)==0x21)
                        {       
                            //gPC.printf("TC_SW_ON_SD\r\n"); // call PWR_SWCH_ON function
                            
                            CDMS_SD_SW_OFF();
                            Base_tm *tm_ptr_short = new Short_tm;
                            ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                            return tm_ptr_short;     
                        }
                        else if(GETpid(tc_ptr)==0x12)
                        {       
                            //gPC.printf("TC_SW_ON_SD\r\n"); // call PWR_SWCH_ON function
                            
                            CDMS_RTC_ON();
                            Base_tm *tm_ptr_short = new Short_tm;
                            ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                            return tm_ptr_short;                                                       
                        }
                        else if(GETpid(tc_ptr)==0x22)
                        {       
                            //gPC.printf("TC_SW_ON_SD\r\n"); // call PWR_SWCH_ON function
                            
                            CDMS_RTC_OFF();
                            Base_tm *tm_ptr_short = new Short_tm;
                            ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                            return tm_ptr_short;
                        } 
                        else if(GETpid(tc_ptr)==0x13)
                        {                           
                            //gPC.printf("TC_SW_ON_BAE\r\n"); // call PWR_SWCH_ON function
                            
                            SW_ON_BAE();
                            Base_tm *tm_ptr_short = new Short_tm;
                            ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                            return tm_ptr_short;                            
                        }
                        else if(GETpid(tc_ptr)==0x23)
                        {                           
                            //gPC.printf("TC_SW_OFF_BAE\r\n"); // call PWR_SWCH_ON function
                            
                            SW_OFF_BAE();
                            Base_tm *tm_ptr_short = new Short_tm;
                            ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                            return tm_ptr_short;                                                        
                        }
                        else if(GETpid(tc_ptr)==0x14)
                        {                            
                            //gPC.printf("TC_SW_ON_PL_BEE\r\n"); // call PWR_SWCH_ON function
                            
                            SW_ON_PL_BEE();
                            Base_tm *tm_ptr_short = new Short_tm;
                            ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                            return tm_ptr_short;                                                        
                        }
                        else if(GETpid(tc_ptr)==0x24)
                        {                   
                            //gPC.printf("TC_SW_OFF_PL_BEE\r\n"); // call PWR_SWCH_ON function
                            
                            SW_OFF_PL_BEE();
                            Base_tm *tm_ptr_short = new Short_tm;
                            ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                            return tm_ptr_short;    
                        }
                        else if(GETpid(tc_ptr)==0x15)
                        {                            
                            //gPC.printf("TC_SW_ON_PL_EPS\r\n"); // call PWR_SWCH_ON function
                            
                            SW_ON_PL_EPS();
                            Base_tm *tm_ptr_short = new Short_tm;
                            ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));     
                            return tm_ptr_short;                            
                        }
                        else if(GETpid(tc_ptr)==0x25)
                        {                            
                            //gPC.printf("TC_SW_OFF_PL_EPS\r\n"); // call PWR_SWCH_ON function
                            
                            SW_OFF_PL_EPS();
                            Base_tm *tm_ptr_short = new Short_tm;
                            ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                            return tm_ptr_short;                            
                        }
                        else if(GETpid(tc_ptr)==0x16)
                        {                            
                                                                                       
                            //gPC.printf("TC_SW_ON_V_A_EN\r\n"); // call PWR_SWCH_ON function
                            
                            SW_ON_V_A_EN();
                            Base_tm *tm_ptr_short = new Short_tm;
                            ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                            return tm_ptr_short;                        
                        }
                        else if(GETpid(tc_ptr)==0x26)
                        {                        
                            //gPC.printf("TC_SW_OFF_V_A_EN\r\n"); // call PWR_SWCH_ON function
                            
                            SW_OFF_V_A_EN();
                            Base_tm *tm_ptr_short = new Short_tm;
                            ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                            return tm_ptr_short;                                                    
                        }
                        else if(GETpid(tc_ptr)==0x31)
                        {                            
                            //gPC.printf("TC_RST_SD\r\n"); // call PWR_SWCH_ON function
                            
                            RST_SD();
                            Base_tm *tm_ptr_short = new Short_tm;
                            ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                            return tm_ptr_short;                                                        
                        }
                        else if(GETpid(tc_ptr)==0x33)
                        {                            
                            //gPC.printf("TC_RST_BAE\r\n"); // call PWR_SWCH_ON function
                            
                            RST_BAE();
                            Base_tm *tm_ptr_short = new Short_tm;
                            ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                            return tm_ptr_short;                            
                        }
                        else if(GETpid(tc_ptr)==0x34)
                        {                            
                            //gPC.printf("TC_RST_PL_BEE\r\n"); // call PWR_SWCH_ON function
                            
                            RST_PL_BEE();
                            Base_tm *tm_ptr_short = new Short_tm;
                            ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                            return tm_ptr_short;                                                        
                        }
                        else if(GETpid(tc_ptr)==0x38)
                        {
                            //gPC.printf()
                            
                            CDMS_INTERNAL_RESET();
                            Base_tm *tm_ptr_short = new Short_tm;
                            ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                        }
                        else if(GETpid(tc_ptr)==0x40)
                        {                         
                            //gPC.printf("RESET_HK_COUNTER\r\n"); // call PWR_SWCH_ON function
                            
                            if(tc_ptr->TC_string[4] == 0x00 || tc_ptr->TC_string[4] == 0x01)
                            EN_PL = tc_ptr->TC_string[4];
                            else if(tc_ptr->TC_string[5] == 0x00 || tc_ptr->TC_string[5] == 0x01)
                            EN_CDMS_HK = tc_ptr->TC_string[5];
                            else if(tc_ptr->TC_string[6] == 0x00 || tc_ptr->TC_string[6] == 0x01)
                            EN_RCV_SC = tc_ptr->TC_string[6];
                            
                            Base_tm *tm_ptr_short = new Short_tm;
                            ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                            return tm_ptr_short;                                                    
                        }
                        else if(GETpid(tc_ptr)==0x41)
                        {                            
                            //gPC.printf("RESET_HK_COUNTER\r\n"); // call PWR_SWCH_ON function
                            
                            RST_HK_COUNTER();
                            Base_tm *tm_ptr_short = new Short_tm;
                            ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                            return tm_ptr_short;    
                        }
                        else if(GETpid(tc_ptr)==0xF1)
                        {          
                            //gPC.printf("TC_CDMS_RD_RTC\r\n"); // call PWR_SWCH_ON function
                            
                            uint32_t time_temp = FCTN_CDMS_RD_RTC();                        //RTC_RD_EROR has to incorporated
                            Base_tm *tm_ptr = new Long_tm;
                            tm_ptr->TM_string[0] = 0x78;     
                            tm_ptr->TM_string[1] = GETpacket_seq_count(tc_ptr);                                    
                            tm_ptr->TM_string[2] = 0xA0;
                            tm_ptr->TM_string[3] = 0x00;
                            tm_ptr->TM_string[4] = (uint8_t)((time_temp & 0xFF000000)>>24);
                            tm_ptr->TM_string[5] = (uint8_t)((time_temp & 0x00FF0000)>>16);
                            tm_ptr->TM_string[6] = (uint8_t)((time_temp & 0x0000FF00)>>8);
                            tm_ptr->TM_string[7] = (uint8_t)((time_temp & 0x000000FF));
                            for(uint8_t i=0;i<124;i++)
                            {
                                tm_ptr->TM_string[i+8] = 0x00;
                            }
                            crc16 = crc16_gen(tm_ptr->TM_string,132);
                            tm_ptr->TM_string[132] = (uint8_t)((crc16&0xFF00)>>8);
                            tm_ptr->TM_string[133] = (uint8_t)(crc16&0x00FF);
                            tm_ptr->next_TM = NULL;                 
                            return tm_ptr;                                                     //incomplete
                        }
                        else if(GETpid(tc_ptr)==0xF0)
                        {
                            uint8_t statusbits[64];
                            if( CDMS_RD_SD_HK(statusbits) != 0){
                                Base_tm *tm_ptr_short = new Short_tm;
                                ACK_L234(tm_ptr_short,0xA0,GETpacket_seq_count(tc_ptr));
                                return tm_ptr_short;
                            }
                            else
                            {
                                uint32_t time_temp = FCTN_CDMS_RD_RTC();                        //RTC_RD_EROR has to incorporated
                                Base_tm *tm_ptr = new Long_tm;
                                tm_ptr->TM_string[0] = 0x78;     
                                tm_ptr->TM_string[1] = GETpacket_seq_count(tc_ptr);                                    
                                tm_ptr->TM_string[2] = 0xA0;    // ACK CODE
                                tm_ptr->TM_string[3] = 0x00;
                                for(int i=4;i<64;i++)
                                {
                                    tm_ptr->TM_string[i+4] = (i<68)?statusbits[i]:0x00;
                                }
                                for(uint8_t i=68;i<132;i++)
                                {
                                    tm_ptr->TM_string[i] = 0x00;
                                }
                                crc16 = crc16_gen(tm_ptr->TM_string,132);
                                tm_ptr->TM_string[132] = (uint8_t)((crc16&0xFF00)>>8);
                                tm_ptr->TM_string[133] = (uint8_t)(crc16&0x00FF);
                                tm_ptr->next_TM = NULL;                                                                     //incomplete
                                return tm_ptr;
                            }
                        }
                        else if(GETpid(tc_ptr)==0xF1)
                        {
                            CDMS_CALIB_RTC((uint64_t)(tc_ptr->TC_string[4])<<32 + (uint64_t)(tc_ptr->TC_string[5])<<24 + (uint64_t)(tc_ptr->TC_string[5])<<16 + (uint64_t)(tc_ptr->TC_string[6])<<8  +(uint64_t)(tc_ptr->TC_string[7]));
                            Base_tm *tm_ptr_short = new Short_tm;
                            ACK_L234(tm_ptr_short,0xC0,GETpacket_seq_count(tc_ptr));
                            return tm_ptr_short;
                        }                               
                        else 
                        {
                            gPC.printf("INVALID FID\r\n");
                            Base_tm *tm_ptr_short = new Short_tm;
                            ACK_L234(tm_ptr_short,0x02,GETpacket_seq_count(tc_ptr));  
                            return tm_ptr_short;
                        }
                    }
                    else 
                    {
                        gPC.printf("INVALID SERVICE SUBTYPE\r\n");
                        Base_tm *tm_ptr_short = new Short_tm;
                        ACK_L234(tm_ptr_short,0x02,GETpacket_seq_count(tc_ptr));  
                        return tm_ptr_short;
                    }                                    
                }
                case 0x70:
                {
                    gPC.printf("\n\n\rService:PAYLOAD MANAGEMENT SERVICE"); 
                    if(GETservice_subtype(tc_ptr)==0x1)                     //make sure it is LONG TC before executing else INVALID TC
                    {
                        gPC.printf("\n\rTC with subtype = 0x1");
                        Base_tm *tm_ptr = new Long_tm;
                        TM_PMS_PL_SCHEDULE(tm_ptr,GETpacket_seq_count(tc_ptr));
                        for(uint8_t i=0,j=0;i<32;i++)
                        {
                            pl_block[i] &= 0x00000000;
                            pl_block[i] |= (((uint32_t)(tc_ptr->TC_string[3+j]))<<24);
                            pl_block[i] |= (((uint32_t)(tc_ptr->TC_string[4+j]))<<16);
                            pl_block[i] |= (((uint32_t)(tc_ptr->TC_string[5+j]))<<8);
                            pl_block[i] |= (((uint32_t)(tc_ptr->TC_string[6+j])));
                            j+=4;
                        }                        
                        return tm_ptr;
                    }                    
                    else if(GETservice_subtype(tc_ptr)==0x2)
                    {
                        gPC.printf("\n\rTC with subtype = 0x2");
                        Base_tm *tm_ptr = new Long_tm;
                        TM_PMS_PL_SCHEDULE(tm_ptr,GETpacket_seq_count(tc_ptr));
                        for(uint8_t i=32,j=0;i<64;i++,j+=4)
                        {
                            pl_block[i] &= 0x00000000;
                            pl_block[i] |= (((uint32_t)(tc_ptr->TC_string[3+j]))<<24);
                            pl_block[i] |= (((uint32_t)(tc_ptr->TC_string[4+j]))<<16);
                            pl_block[i] |= (((uint32_t)(tc_ptr->TC_string[5+j]))<<8);
                            pl_block[i] |= (((uint32_t)(tc_ptr->TC_string[6+j])));
                        }
                        return tm_ptr;
                    }
                    else if(GETservice_subtype(tc_ptr)==0x3)
                    {
                        gPC.printf("\n\rTC with subtype = 0x3");
                        Base_tm *tm_ptr = new Long_tm;
                        TM_PMS_PL_SCHEDULE(tm_ptr,GETpacket_seq_count(tc_ptr));
                        for(uint8_t i=64,j=0;i<96;i++,j+=4)
                        {
                            pl_block[i] &= 0x00000000;
                            pl_block[i] |= (((uint32_t)(tc_ptr->TC_string[3+j]))<<24);
                            pl_block[i] |= (((uint32_t)(tc_ptr->TC_string[4+j]))<<16);
                            pl_block[i] |= (((uint32_t)(tc_ptr->TC_string[5+j]))<<8);
                            pl_block[i] |= (((uint32_t)(tc_ptr->TC_string[6+j])));
                        }
                        return tm_ptr;
                    }
                    else if(GETservice_subtype(tc_ptr)==0x4)
                    {
                        gPC.printf("\n\rTC with subtype = 0x4");
                        Base_tm *tm_ptr = new Long_tm;
                        TM_PMS_PL_SCHEDULE(tm_ptr,GETpacket_seq_count(tc_ptr));
                        for(uint8_t i=96,j=0;i<128;i++,j+=4)
                        {
                            pl_block[i] &= 0x00000000;
                            pl_block[i] |= (((uint32_t)(tc_ptr->TC_string[3+j]))<<24);
                            pl_block[i] |= (((uint32_t)(tc_ptr->TC_string[4+j]))<<16);
                            pl_block[i] |= (((uint32_t)(tc_ptr->TC_string[5+j]))<<8);
                            pl_block[i] |= (((uint32_t)(tc_ptr->TC_string[6+j])));
                        }
                        return tm_ptr;
                    }
                    else if(GETservice_subtype(tc_ptr)==0x5)
                    {   
                        gPC.printf("\n\rTC with subtype = 0x5");
                        Base_tm *tm_ptr = new Long_tm;
                        TM_PMS_PL_SCHEDULE(tm_ptr,GETpacket_seq_count(tc_ptr));
                        for(uint8_t i=128,j=0;i<160;i++,j+=4)
                        {
                            pl_block[i] &= 0x00000000;
                            pl_block[i] |= (((uint32_t)(tc_ptr->TC_string[3+j]))<<24);
                            pl_block[i] |= (((uint32_t)(tc_ptr->TC_string[4+j]))<<16);
                            pl_block[i] |= (((uint32_t)(tc_ptr->TC_string[5+j]))<<8);
                            pl_block[i] |= (((uint32_t)(tc_ptr->TC_string[6+j])));
                        }
                        return tm_ptr;    
                    }
                    else if(GETservice_subtype(tc_ptr)==0x6)
                    {
                        gPC.printf("\n\rTC with subtype = 0x6");
                        Base_tm *tm_ptr = new Long_tm;
                        TM_PMS_PL_SCHEDULE(tm_ptr,GETpacket_seq_count(tc_ptr));
                        for(uint8_t i=160,j=0;i<192;i++,j+=4)
                        {
                            pl_block[i] &= 0x00000000;
                            pl_block[i] |= (((uint32_t)(tc_ptr->TC_string[3+j]))<<24);
                            pl_block[i] |= (((uint32_t)(tc_ptr->TC_string[4+j]))<<16);
                            pl_block[i] |= (((uint32_t)(tc_ptr->TC_string[5+j]))<<8);
                            pl_block[i] |= (((uint32_t)(tc_ptr->TC_string[6+j])));
                        }
                        return tm_ptr;
                    }
                    else if(GETservice_subtype(tc_ptr)==0xF)
                    {
                        gPC.printf("\n\rTC with subtype = 0xF");
                        Base_tm *tm_ptr = new Long_tm;
                        TM_PMS_PL_SCHEDULE(tm_ptr,GETpacket_seq_count(tc_ptr));
                        return tm_ptr;
                    }
                    else
                    {
                        gPC.printf("INVALID SERVICE SUBTYPE\r\n");
                        Base_tm *tm_ptr_short = new Short_tm;
                        ACK_L234(tm_ptr_short,0x02,GETpacket_seq_count(tc_ptr));  
                        return tm_ptr_short;
                    }
                }
                default:
                {
                    gPC.printf("ILLEGAL TC");
                    Base_tm *tm_ptr_short = new Short_tm;
                    ACK_L234(tm_ptr_short,0x02,GETpacket_seq_count(tc_ptr));
                    return tm_ptr_short;                    
                }
            }
        }
        case 3:
        {
            //#if DEBUG
            gPC.printf("\n\rTelecommand is for PL\r\n");
            //#endif
            if(GETshort_or_long_tc(tc_ptr) == LONG_TC_CODE)
                y=FCTN_I2C_WRITE_PL((char*)tc_ptr->TC_string,TC_LONG_SIZE);
            else if(GETshort_or_long_tc(tc_ptr) == SHORT_TC_CODE)
                y=FCTN_I2C_WRITE_PL((char*)tc_ptr->TC_string,TC_SHORT_SIZE);
                
            if(y==1)                                                            
            {
                Base_tm *tm_ptr_short = new Short_tm;
                ACK_L234(tm_ptr_short,0x03,GETpacket_seq_count(tc_ptr));
                return tm_ptr_short;
            }                                  
            else if(y==0)
            {
                TIME_LATEST_I2C_SPEED = FCTN_CDMS_RD_RTC() >> 7;
                //wait(0.2);
                int poll=0;
                while(poll<2000 && PL_I2C_Intr==0)
                {
                    wait_us(10);
                    poll+=1;
                }    
            if(PL_I2C_Intr == 1)
                {
                    gPC.printf("\n\rPL_I2C_Intr is high");
                    Base_tm *tm_ptr = new Long_tm;
                    y=FCTN_I2C_READ_PL((char*)tm_ptr->TM_string,TM_LONG_SIZE);
                    gPC.printf("\n\r");
                    for(int i = 0;i<134;i++)
                    gPC.printf("%X",(int)(tm_ptr->TM_string[i]));
                    if(y==0)
                    {
                        TIME_LATEST_I2C_SPEED = FCTN_CDMS_RD_RTC() >> 7;
                        tm_ptr->next_TM=NULL;
                        return tm_ptr;
                    }
                    else if(y==1)
                    {
                        gPC.printf("\n\rPL_TM read failure");
                        delete tm_ptr;
                        Base_tm *tm_ptr_short = new Short_tm;
                        ACK_L234(tm_ptr_short,0x85,GETpacket_seq_count(tc_ptr));              
                        gPC.printf("\n\r0x85");
                        return tm_ptr_short;
                    }
                }
                else if(PL_I2C_Intr == 0)                                       //name to be changed later
                {
                    gPC.printf("\n\rPL_I2C_Intr is not high");                    
                    Base_tm *tm_ptr_short = new Short_tm;
                    ACK_L234(tm_ptr_short,0x84,GETpacket_seq_count(tc_ptr));
                    return tm_ptr_short;
                }
            }                             
        }
        default:    //invalid TC
        {
            gPC.printf("\n\rINVALID TC");
            Base_tm *tm_ptr_short = new Short_tm;
            ACK_L234(tm_ptr_short,0x02,GETpacket_seq_count(tc_ptr));
            return tm_ptr_short;
        }
    }
    //return NULL;
}
// CDMS TEAM CODE END
// EXECUTE OBOSC
#define execute_obosc_core(tc_ptr, tm_ptr, reset_flag) {\
    if (DEBUG)\
        /*gPC.puts("Inside execute_obosc_core\r\n")*/;\
    uint8_t service_subtype = (tc_ptr->TC_string[2]) & 0x0F;\
    uint8_t temp8 = 0x00;\
    Base_tc *modify_this = gHEAD_NODE_TCL;\
    int modify_overflow = 0x00;\
    switch( service_subtype ){\
        case OBOSC_SUB_DISABLE:\
            /*gPC.puts("target psc are ");*/\
            for(int i = 3 ; i < 9 ; ++i){\
                /*gPC.printf("%u ", tc_ptr->TC_string[i]);*/\
            }\
            /*gPC.puts("\r\n");*/\
            /*gPC.puts("disable type obosc\r\n");*/\
            while( modify_this != NULL ){\
                if( modify_overflow < TCL_OVERFLOW_CONSTANT ){\
                    uint8_t modify_psc = GETpacket_seq_count(modify_this);\
                    /*gPC.printf("mosify_psc = %u\r\n", modify_psc);*/\
                    for( int i = 3 ; i < 9 ; ++i ){\
                        uint8_t target_psc = tc_ptr->TC_string[i];\
                        if( (target_psc == modify_psc) && (target_psc != 0) ){\
                            uint16_t tempExec = TC_STATE_DISABLED;\
                            PUTexec_status( modify_this, tempExec );\
                            break;\
                        }\
                    }\
                    modify_this = modify_this->next_TC;\
                    ++modify_overflow;\
                }\
                else{\
                    RESET_CDMS;\
                    break;\
                }\
            }\
            break;\
        case OBOSC_SUB_RETRY:\
            /*gPC.puts("retry type obosc\r\n");*/\
            while( modify_this != NULL ){\
                if( modify_overflow < TCL_OVERFLOW_CONSTANT ){\
                    uint8_t modify_psc = GETpacket_seq_count(modify_this);\
                    for( int i = 3 ; i < 9 ; ++i ){\
                        uint8_t target_psc = tc_ptr->TC_string[i];\
                        if( (target_psc == modify_psc) && (target_psc != 0) ){\
                            uint16_t tempExec = TC_STATE_MARKED_RETRY;\
                            PUTexec_status( modify_this, tempExec );\
                            /*gPC.puts("reqquired tc found: disable\r\n");*/\
                            break;\
                        }\
                    }\
                    modify_this = modify_this->next_TC;\
                    ++modify_overflow;\
                }\
                else{\
                    RESET_CDMS;\
                    break;\
                }\
            }\
            break;\
    }\
    Base_tm *ackl234new = new Short_tm;\
    ackl234new->next_TM = NULL;\
    /*return telemetry pointer here*/\
    tm_ptr = ackl234new;\
    ackl234new->TM_string[0] = TMID_ACK_L234 << 4;\
    ackl234new->TM_string[1] = GETpacket_seq_count(tc_ptr);\
    ackl234new->TM_string[2] = 0xA0;\
    for(int i = 3; i < 11; ++i){\
        ackl234new->TM_string[i] = 0x00;\
    }\
    uint16_t crc = crc16_gen(ackl234new->TM_string, TM_SHORT_SIZE-2);\
    ackl234new->TM_string[11] = (crc & 0xFF00) >> 8;\
    ackl234new->TM_string[12] = crc & 0x00FF;\
    /*ack l234 old*/\
    if( service_subtype == OBOSC_SUB_REP_LE ){\
        if( gLAST_TM_SHORT_OR_LONG == SHORT_TM_CODE ){\
            Base_tm *ackl234old = new Short_tm;\
            ackl234old->next_TM = NULL;\
            /*APPEND TO ACK L234 NEW HERE*/\
            ackl234new->next_TM = ackl234old;\
            for( int i = 0 ; i < TM_SHORT_SIZE ; ++i ){\
                ackl234old->TM_string[i] = gLAST_TM[i];\
            }\
        }\
        else{\
            Base_tm *tempLongTM = new Long_tm;\
            tempLongTM->next_TM = NULL;\
            /*APPEND TO ACK L234 NEW HERE*/\
            ackl234new->next_TM = tempLongTM;\
            for( int i = 0 ; i < TM_LONG_SIZE ; ++i ){\
                tempLongTM->TM_string[i] = gLAST_TM[i];\
            }\
        }\
    }\
    else if( service_subtype == OBOSC_SUB_REP_TCLD ){\
        get_tc_list(ackl234new->next_TM, GETpacket_seq_count(tc_ptr));\
    }\
    else if( service_subtype == OBOSC_SUB_RESET ){\
        /*reset_all;*/\
        reset_flag = 1;\
        /*PENDING: VERIFY reset_all, RESET CDMS*/\
    }\
    else if( (service_subtype != OBOSC_SUB_DISABLE) && (service_subtype != OBOSC_SUB_RETRY) ){\
        /*CHANGE THE ACK CODE TO INVALID TC*/\
        ackl234new->TM_string[2] = 0xAF;\
    }\
    if (DEBUG)\
        gPC.puts("completed obosc\r\n");\
}

/*tm_ptr is the next_TM of a linked list, and should have the value NULL, i.e. tm_ptr should be the next_TM pointer of thte last node */


#define EXECUTE_OBOSC_ONLY {\
    gMASTER_STATE = TCL_STATE_EXECUTING;\
    int reset_flag = 0;\
    if (DEBUG)\
        /*gPC.puts("iNSIDE EXECUTE_OBOSC_ONLY\r\n")*/;\
    Base_tm *obosc_tm_core = NULL;\
    Base_tm *obosc_tm = obosc_tm_core;\
    for(uint8_t execute_psc = PSC_START_VALUE ; execute_psc < gTOTAL_VALID_TC ; ++execute_psc){\
        Base_tc* current_TC = gHEAD_NODE_TCL;\
        int overCount = 0;\
        while( current_TC != NULL ){\
            if( overCount < TCL_OVERFLOW_CONSTANT ){\
                if( (GETcrc_pass(current_TC) == 1) && (GETpacket_seq_count(current_TC) == execute_psc) ){\
                    /*CHECK FOR OBOSC*/\
                    uint8_t temp82 = 0x00;\
                    isit_obosc(current_TC, temp82);\
                    if(temp82 == 0x01){\
                        uint16_t current_exec_status = GETexec_status(current_TC);\
                        if( (current_exec_status == TC_STATE_SUCCESSFULLY_EXECUTED) || (current_exec_status == TC_STATE_DISABLED) )\
                            break;\
                        else if( (current_exec_status == TC_STATE_UNEXECUTED) || (current_exec_status == TC_STATE_MARKED_RETRY) ){\
                            if (DEBUG)\
                                gPC.printf("It is obosc: %u\r\n", execute_psc);\
                            /*EXECUTION OF OBOSC TC*/\
                            /*WARNING: LARGE MEMORY UTILIZATION FOR TC-LIST-REPORT */\
                            execute_obosc_core(current_TC, obosc_tm_core, reset_flag);\
                            Base_tm *obosc_tm_current = obosc_tm_core;\
                            while(obosc_tm_core != NULL){\
                               obosc_tm_core = obosc_tm_core->next_TM;\
                            }\
                            if(obosc_tm_current->TM_string[2] == 0xA0){\
                                uint16_t temp16 = TC_STATE_SUCCESSFULLY_EXECUTED;\
                                PUTexec_status(current_TC, temp16);\
                            }\
                            else{\
                                uint16_t temp16 = TC_STATE_EXECUTION_FAILED;\
                                PUTexec_status(current_TC, temp16);\
                            }\
                            while( obosc_tm_current != NULL ){\
                                int length = TM_SHORT_SIZE;\
                                if( GETshort_or_long_tm(obosc_tm_current) == SHORT_TM_CODE ){\
                                    length = TM_SHORT_SIZE;\
                                }\
                                else{\
                                    length = TM_LONG_SIZE;\
                                }\
                                for(int i = 0 ; i < length ; ++i){\
                                    /*gPC.putc(obosc_tm_current->TM_string[i]);*/\
                                }\
                                obosc_tm_current = obosc_tm_current->next_TM;\
                            }\
                        }\
                    }\
                }\
                current_TC = current_TC->next_TC;\
                ++overCount;\
            }\
            else{\
                RESET_CDMS;\
                break;\
            }\
        }\
    }\
    if(obosc_tm_core != NULL){\
        Base_tm *obosc_tm_head = NULL;\
        get_call_sign(obosc_tm_head);\
        Base_tm *obosc_tm_current = obosc_tm_head;\
        get_ack_l1(obosc_tm_current->next_TM);\
        int overflowCountOBONLY = 0;\
        while( obosc_tm_current->next_TM != NULL ){\
            if( overflowCountOBONLY < TM_OVERFLOW_CONSTANT ){\
                obosc_tm_current = obosc_tm_current->next_TM;\
                ++overflowCountOBONLY;\
            }\
            else{\
                RESET_CDMS;\
                break;\
            }\
        }\
        obosc_tm_current->next_TM = obosc_tm;\
        /*Sending OBOSC TM to GS*/\
        snd_tm.head_pointer(obosc_tm_head);\
        transmit_adf();\
        /*DELETE THE TM AFTER USE*/\
        obosc_tm_current = obosc_tm_head;\
        int overCount = 0;\
        while( obosc_tm_current != NULL ){\
            if( (overCount < TM_OVERFLOW_CONSTANT) ){\
                Base_tm *temp = obosc_tm_current->next_TM;\
                delete obosc_tm_current;\
                obosc_tm_current = temp;\
                ++overCount;\
            }\
            else{\
                RESET_CDMS;\
                break;\
            }\
        }\
    }\
    if ( reset_flag == 1 ){\
        reset_all;\
        /*Enable threads*/\
        gPAY_SPI->bulkRead_resume(&payload_isr_fun);\
        HK_counter->start(10000);\
        gSESSION_TIMEOUT.detach();\
    }\
}

#define EXECUTE_TC {\
    gMASTER_STATE = TCL_STATE_EXECUTING;\
    if (DEBUG)\
        /*gPC.puts("iNSIDE EXECUTE_TC\r\n")*/;\
    /*gPC.printf("%u\r\n", gTOTAL_VALID_TC);*/\
    for(uint8_t execute_psc = PSC_START_VALUE ; execute_psc < gTOTAL_VALID_TC ; ++execute_psc ){\
        /*wait(10)*/;\
        if (DEBUG)\
            gPC.printf("executing normal %u\r\n", execute_psc);\
        /*gLEDG = !gLEDG;*/\
        /*gLEDR = !gLEDR;*/\
        Base_tc* current_TC = gHEAD_NODE_TCL;\
        int overflowCount = 0;\
        while(current_TC != NULL){\
            if( overflowCount < TCL_OVERFLOW_CONSTANT ){\
                if( (GETcrc_pass(current_TC) == 1) && (GETpacket_seq_count(current_TC) == execute_psc) ){\
                    uint8_t current_exec_status = GETexec_status(current_TC);\
                    if( (current_exec_status == TC_STATE_SUCCESSFULLY_EXECUTED) || (current_exec_status == TC_STATE_DISABLED) ){\
                        /*gPC.printf("disabled or completed at %u\n", execute_psc);*/\
                        if( execute_psc == (gTOTAL_VALID_TC-1) ){\
                            /*LAST TC IS EXECUTED*/\
                            gMASTER_STATE = TCL_STATE_COMPLETED;\
                        }\
                        break;\
                    }\
                    else if( (current_exec_status == TC_STATE_EXECUTION_FAILED) && (GETabort_on_nack(current_TC) == 1) ){\
                        /*gPC.printf("abort on nack at %u psc\r\n", execute_psc);*/\
                        gMASTER_STATE = TCL_STATE_ABORTED;\
                        Base_tm *tm_ptr_head = NULL;\
                        get_call_sign(tm_ptr_head);\
                        Base_tm *tm_ptr = tm_ptr_head;\
                        get_ack_l1(tm_ptr->next_TM);\
                        tm_ptr = tm_ptr_head;\
                        while( tm_ptr != NULL ){\
                            int length = TM_SHORT_SIZE;\
                            if( GETshort_or_long_tm(tm_ptr) == SHORT_TM_CODE ){\
                                length = TM_SHORT_SIZE;\
                            }\
                            else{\
                                length = TM_LONG_SIZE;\
                            }\
                            /*gPC.puts("Printing Call Sign, ACK_L1, TM list");*/\
                            for(int i = 0 ; i < length ; ++i){\
                                /*gPC.putc(tm_ptr->TM_string[i]);*/\
                            }\
                            tm_ptr = tm_ptr->next_TM;\
                        }\
                        /*Send only call sign, ACK_L1 to GS*/\
                        snd_tm.head_pointer(tm_ptr_head);\
                        transmit_adf();\
                        /*DELETE THE TM AFTER USE*/\
                        tm_ptr = tm_ptr_head;\
                        int overflowCountExecute = 0;\
                        while(tm_ptr != NULL){\
                            if( overflowCountExecute < TM_OVERFLOW_CONSTANT ){\
                                Base_tm *temp = tm_ptr->next_TM;\
                                delete tm_ptr;\
                                tm_ptr = temp;\
                                ++overflowCountExecute;\
                            }\
                            else{\
                                RESET_CDMS;\
                                break;\
                            }\
                        }\
                        break;\
                    }\
                    else if( (current_exec_status == TC_STATE_UNEXECUTED) || (current_exec_status == TC_STATE_MARKED_RETRY) ){\
                        /*EXECUTION OF TC START*/\
                        uint8_t temp81 = 0x00;\
                        isit_sdcard(current_TC, temp81);\
                        if( temp81 == 0x00 ){\
                            if (DEBUG)\
                                gPC.printf("non sd card at %u\r\n", execute_psc);\
                            /*EXECUTION OF NON SD-CARD (BOTH OBOSC and CDMS functions)*/\
                            Base_tm *tm_ptr_head = NULL;\
                            get_call_sign(tm_ptr_head);\
                            Base_tm *put_tm_here = NULL;\
                            uint8_t temp82 = 0x00;\
                            uint8_t tempPAhot = 0x00;\
                            isit_obosc(current_TC, temp82);\
                            if(temp82 == 0x01){\
                                /*gPC.printf("obosc tc inside normal tc at %u\r\n", execute_psc);*/\
                                /*EXECUTION OF OBOSC TC*/\
                                /*SKIP EXECUTION OF OBOSC HERE*/\
                                break;\
                            }\
                            else{\
                                /*gPC.printf("cdms relay tmtc at %u\r\n", execute_psc);*/\
                                /*call CDMS_RLY_TMTC*/\
                                /*CDMS_RLY_TMTC(current_TC, put_tm_here);*/\
                                put_tm_here =  FCTN_CDMS_RLY_TMTC(current_TC);\
                            }\
                            /*DETECT ACK OR NACK*/\
                            uint8_t temp83 = 0x00;\
                            detect_ack(put_tm_here, temp83);\
                            if( temp83 == 0x01){\
                                uint16_t temp16 = TC_STATE_SUCCESSFULLY_EXECUTED;\
                                PUTexec_status(current_TC, temp16);\
                            }\
                            else if( temp83 == 0x03){\
                                /*gPC.puts("TC_STATE_EXECUTION_UNKNOWN");*/\
                                uint16_t temp16 = TC_STATE_EXECUTION_UNKNOWN;\
                                PUTexec_status(current_TC, temp16);\
                            }\
                            else if( temp83 == 0x04){\
                                /*gPC.puts("TC_STATE_EXECUTION_UNKNOWN");*/\
                                uint16_t temp16 = TC_STATE_EXECUTION_FAILED;\
                                PUTexec_status(current_TC, temp16);\
                                uint8_t temp84 = GETpacket_seq_count(current_TC);\
                                put_tm_here->TM_string[2] = temp84;\
                                uint16_t crc16 = crc16_gen(put_tm_here->TM_string, 11);\
                                put_tm_here->TM_string[11]  = (crc16 & 0xFF00)>>8;\
                                put_tm_here->TM_string[12] = (crc16 & 0x00FF);\
                            }\
                            else{\
                                /*gPC.puts("TC_STATE_EXECUTION_FAILED");*/\
                                uint16_t temp16 = TC_STATE_EXECUTION_FAILED;\
                                PUTexec_status(current_TC, temp16);\
                            }\
                            /*ABORT ON NACK AND TC LIST COMPLETED: UPDATE IN gMASTERSTATE*/\
                            if( ((GETexec_status(current_TC) == TC_STATE_EXECUTION_FAILED) || (GETexec_status(current_TC) == TC_STATE_EXECUTION_UNKNOWN)) && (GETabort_on_nack(current_TC) == 1) ){\
                                gMASTER_STATE = TCL_STATE_ABORTED;\
                            }\
                            else if( execute_psc == (gTOTAL_VALID_TC-1) ){\
                                /*LAST TC IS EXECUTED*/\
                                gMASTER_STATE = TCL_STATE_COMPLETED;\
                            }\
                            /*update last executed L1_ack*/\
                            if( put_tm_here != NULL ){\
                                Base_tm *ptr_tm = put_tm_here;\
                                while(ptr_tm->next_TM != NULL)\
                                    ptr_tm = ptr_tm->next_TM;\
                                if( GETshort_or_long_tm(ptr_tm) == SHORT_TM_CODE ){\
                                    for(int i = 0 ; i < TM_SHORT_SIZE ; ++i){\
                                        gLAST_TM[i] = ptr_tm->TM_string[i];\
                                        gLAST_TM_SHORT_OR_LONG = SHORT_TM_CODE;\
                                    }\
                                }\
                                else{\
                                    for( int i = 0 ; i < TM_LONG_SIZE ; ++i ){\
                                        gLAST_TM[i] = ptr_tm->TM_string[i];\
                                        gLAST_TM_SHORT_OR_LONG = LONG_TM_CODE;\
                                    }\
                                }\
                            }\
                            P_COM_HK;\
                            Base_tm *tm_ptr = tm_ptr_head;\
                            get_ack_l1(tm_ptr->next_TM);\
                            int overflowCountExecute = 0;\
                            while( tm_ptr->next_TM != NULL ){\
                                if( overflowCountExecute < TM_OVERFLOW_CONSTANT ){\
                                    tm_ptr = tm_ptr->next_TM;\
                                    ++overflowCountExecute;\
                                }\
                                else{\
                                    RESET_CDMS;\
                                    break;\
                                }\
                            }\
                            tm_ptr->next_TM = put_tm_here;\
                            tm_ptr = tm_ptr_head;\
                            while( tm_ptr != NULL ){\
                                int length = TM_SHORT_SIZE;\
                                if( GETshort_or_long_tm(tm_ptr) == SHORT_TM_CODE ){\
                                    length = TM_SHORT_SIZE;\
                                }\
                                else{\
                                    length = TM_LONG_SIZE;\
                                }\
                                /*gPC.puts("Printing Call Sign, ACK_L1, TM list");*/\
                                for(int i = 0 ; i < length ; ++i){\
                                    /*gPC.putc(tm_ptr->TM_string[i]);*/\
                                }\
                                tm_ptr = tm_ptr->next_TM;\
                            }\
                            /*SEND call sign, ACK_L1, NON OBSRS TM TO GS*/\
                            snd_tm.head_pointer(tm_ptr_head);\
                            gPC.puts("enter_adf\r\n");\
                            transmit_adf();\
                            gPC.puts("exit_adf\r\n");\
                            /*DELETE THE TM AFTER USE*/\
                            tm_ptr = tm_ptr_head;\
                            overflowCountExecute = 0;\
                            while(tm_ptr != NULL){\
                                if( overflowCountExecute < TM_OVERFLOW_CONSTANT ){\
                                    Base_tm *temp = tm_ptr->next_TM;\
                                    delete tm_ptr;\
                                    tm_ptr = temp;\
                                    ++overflowCountExecute;\
                                }\
                                else{\
                                    RESET_CDMS;\
                                    break;\
                                }\
                            }\
                        }\
                        else{\
                            if (DEBUG)\
                                gPC.printf("sd card at %u\r\n", execute_psc);\
                            /*EXECUTION OF SD-CARD DATA SENDING (OBSRS)*/\
                            execute_OBSRS_TC(current_TC);\
                            gPC.puts("en_adf");\
                            transmit_adf();\
                            gPC.puts("ex_adf");\
                        }\
                    }\
                    break;\
                }\
                current_TC = current_TC->next_TC;\
                ++overflowCount;\
            }\
            else{\
                RESET_CDMS;\
                break;\
            }\
        }\
        if( gFLAGS & COM_SESSION_TIMEOUT_FLAG ){\
            break;\
        }\
        else if( gMASTER_STATE == TCL_STATE_ABORTED ){\
            if (DEBUG)\
                gPC.puts("ABORTING DUE TO ABORT ON NACK\r\n");\
            /*EXITED DUE TO ABORT ON NACK:*/\
            COM_TX_CNTRL = 0;\
            RX1M.attach(&rx_read, Serial::RxIrq);\
            gFLAGS = gFLAGS & (~COM_MNG_TMTC_RUNNING_FLAG);\
            break;\
        }\
        else if( (gFLAGS & COM_PA_HOT_FLAG) || (gFLAGS & COM_PA_OC_FLAG) ){\
            /*PA HOT: WAIT FOR TIMEOUT*/\
            gCOM_PA_COOLING_TIMEOUT.attach(&after_cooling_pa, COM_PA_COOLING_TIME_LIMIT);\
            COM_TX_CNTRL = 0;\
            RX1M.attach(&rx_read, Serial::RxIrq);\
            gFLAGS = gFLAGS & (~COM_MNG_TMTC_RUNNING_FLAG);\
            break;\
        }\
        if (DEBUG)\
            gPC.printf("successflly executed %u tc\r\n", execute_psc);\
    }\
    if( (gMASTER_STATE == TCL_STATE_COMPLETED) || (gFLAGS & COM_SESSION_TIMEOUT_FLAG) ){\
        if (DEBUG)\
            gPC.printf("completed or session timed out: %x\r\n", gMASTER_STATE);\
        /*COMPLETED EXECUTION OF TC*/\
        gMASTER_STATE = TCL_STATE_COMPLETED;\
        COM_POWER_OFF_TX;\
        reset_all;\
        /*ENABLE THREADS*/\
        resume_pl_dma = 1;\
        /*gPAY_SPI->bulkRead_resume(&payload_isr_fun)*/;\
        HK_counter->start(10000);\
        gSESSION_TIMEOUT.detach();\
        gFLAGS = gFLAGS & (~COM_MNG_TMTC_RUNNING_FLAG);\
        gFLAGS = gFLAGS & (~COM_SESSION_FLAG);\
    }\
}

#endif