/*-----------------------------------------to_do_compression.h--------------------------------------------------

    -> SD_Write error to be checked
    -> fsc_counter is 32 bit but in the code 24 bit. Talk to chaitu
---------------------------------------------------------------------------------------------------------------*/

//updated compression algorithm
/*#include <iostream>
#include "stdio.h"
#include "crc.h"
#include "interleave.h"
#include "Convolution.h"
#include "bitset"*/
//using namespace std;

//reading functions 2byte, 4byte
#define srpz 0
#define scpz 0
#define scpz_last 0
#define srpz_last 0
#define debug_fsc 0
#define debug_time 0
#define debug_dma 1

#if debug_dma
uint16_t read_2byte(uint8_t* ptr)
{
    uint16_t output = (((uint16_t )(*(ptr+1)))<<8);
    output += (((uint16_t)(*ptr)));
    return output;
}

uint32_t read_4byte(uint8_t* ptr)
{
    uint32_t output = (uint32_t)(*(ptr+3))<<24;
    output += (uint32_t)(*(ptr+2)<<16);
    output += (uint32_t)(*(ptr+1)<<8);
    output += (uint32_t)(*(ptr));
    return output;
}
#endif
#if !debug_dma
uint16_t read_2byte(uint8_t* ptr)
{
    uint16_t output = (uint8_t ) *(ptr+1);
    output += ( (uint8_t )(*ptr) ) << 8;
    return output;
}

uint32_t read_4byte(uint8_t* ptr)
{
    uint32_t output = (uint32_t) (*(ptr+3));
    output += (uint32_t)(*(ptr+2)<<8);
    output += (uint32_t)(*(ptr+1)<<16);
    output += (uint32_t)(*(ptr)<<24);
    return output;
}
#endif
uint8_t adjust(uint8_t size, uint8_t data, uint8_t* ptr , uint8_t space)
{
    space = space&0x0f;
    if(space == 8)  *ptr = 0;
    data = data&((1<<size)-1);
    if(space >= size){
        *ptr += data<<(space-size);
        if(space - size == 0){
            return 0x18;
        }else{
            return space-size;
        }
    }else{
        ptr[0] += data>>(size-space);
        ptr[1] = (data<<(8-(size-space)))&0xff ;
        return 0x10 + 8-(size - space);
    }
}
int compress (int data, int x, int y)   //to be compressed with scheme (msb x)*4^y ;
{
    for(int i = 0 ; i < (1<<y) ; i++)
    {
        if(data <= ( (1<<x)-1) * (1<<(2*i)) )
        {
            return ( ((data>>i*2)<<y) + i);
        }
    }
    if ( data > (( (1<<x)-1) * (1<<(2*((1<<y)-1)))) )
    {
        //cout <<"compression exception"<<endl;
        return (((1<<x)-1) * (1<<(2*((1<<y)-1))));
    }
}

//--------------------------------------------------------beacon
uint8_t beacon_array[134];
uint8_t beacon_cntr = 1;
uint8_t *beacon_ptr;
//--------------------------------------------------------beacon

//variable declarations
uint8_t srp_mode , at , pzf , ezf ,sfp[71] ,scp[56],beacon_at; //tells which mode is calibrated or plot 0 for calibrated and 1 for scatterered, below threshold , proton zero flux, electron zero flux.
uint32_t sfp_bin[52] , scp_bin[52];         //storing the bin values.
uint32_t sfp_threshold_m0[52]  = {124,124,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,4032,252,252,252,252,252,4032,8128,8128,8128,8128,8128,8128,8128,8128,960,960,960,960,960,960,960,960,960,960,960,960,4032,4032,4032,4032,8128,8128,8128,8128};
uint32_t scp_threshold_m0[52]  = {4032,4032,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,114688,8128,4032,4032,4032,4032,114688,245760,245760,245760,245760,245760,245760,245760,245760,49152,49152,49152,49152,49152,49152,49152,49152,49152,49152,49152,49152,114688,114688,114688,114688,245760,245760,245760,245760};
uint32_t scp_threshold_m0_1[9] = {114688,245760,245760,245760,245760,114688,114688,65472,65472} ; //for callibrated mode with data conservation
uint32_t scp_sfp_threshold_m0_2[3] = {245760,65472,65472};
uint32_t sfp_threshold_m1[52]  = {1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,8128,8128,8128,8128};
uint32_t scp_threshold_m1[52]  = {114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,114688,245760,245760,245760,245760};
uint8_t frames[3][134] = {0};
uint8_t position_tm_frame[3] = {8,11,5} , position_tm_starting[3] = {8,11,5}; //{sc,sf-bt,sf-at}
uint8_t id;   //sf = 0,sc-at = 1,sc-bt = 2;
uint8_t TM_interleave_data[512] , TM_convoluted_data[270] = {0};
uint64_t proton_scp_sum,electron_scp_sum,FSC_science;
uint16_t temp_crc;
uint32_t debug_cntr, size,space,length;
uint8_t *ptr ,* pointer;
uint64_t sci_time = 0, time_prev_scp = 0;
uint32_t attitude = 0;
uint32_t beacon_threshold[9] = {114688,245760,245760,245760,245760,114688,114688,65472,65472};

/*----------------------------temporary counters used for testing purposes---------------------------*/
uint32_t test_fsc[4]={1,1,1,1};
/*---------------------------------------------------------------------------------------------------*/


Convolution ConvObj;
void convolution (uint8_t * ptr){
    ConvObj.convolutionEncode(ptr, TM_convoluted_data);
    ConvObj.convolutionEncode(ptr + 67, TM_convoluted_data + 135);
}

//give the pointer of 6 second data to this function
void srp(uint8_t * head)
{
    uint8_t sd_stat = 0;
        SCI_LED1 =1;

    // SCI_LED1 = !SCI_LED1;
   // gPC.printf("\n\rsrp");
    debug_cntr = 0;
    sci_time = FCTN_CDMS_RD_RTC();
    TIME_LATEST_SPI_SPEED = sci_time>>7;
    #if debug_time
    sci_time = 0x0000000021000000;
    #endif
    if(time_prev_scp==0){
        time_prev_scp = sci_time;
    }    
    FCTN_SD_MNGR();                                                             ///changed recently
    for (int i = 0; i < 52 ; i++)
    {
        scp_bin[i] = 0;
    }
    ptr = head + 3;                                         //ptr points to proton energy bin of srp
    srp_mode = head[2]&0x1;
    for(uint8_t counter = 0 ; counter < 60 ; counter++)
    {       
        #if srpz
     //   gPC.printf("\n\n\rSRP count:%d",counter+1);
        #endif
        /*-------------------- ------------populating sfp_bin and scp_bin[] starts here(also tag AT or BT)-----------------------*/
        at = 0;     pzf = 1;    ezf = 1;
        if(srp_mode == 0)                                   //calibrated mode 
        {
            #if srpz
       //     gPC.printf("\n\rSRP - Calibrated Mode");
            #endif
            for(int i=0; i<48 ; i++)                        //first 48 bins or SRP are of 16 bits size
            {
                sfp_bin[i] = read_2byte(ptr + i*2);
                scp_bin[i] += sfp_bin[i];
                if(sfp_bin[i]>sfp_threshold_m0[i])
                {
                    //gPC.printf("\n\rSFP above threshold index:%d",i);
                    at = 1;
                }
                if(i<17)
                {
                    if(sfp_bin[i] > 0)
                        pzf = 0;
                }
                else if (i>17 && i < 23)
                {
                    if(sfp_bin[i]>0)
                        ezf = 0;
                }
            }
            for(int i=0; i<4; i++)                          //last 4 bins(excluding the spare bin) are 32 bit each
            {
                sfp_bin[i+48] = read_4byte( (ptr+96) + 4*i );
                scp_bin[i+48] += sfp_bin[i+48];
                if(sfp_bin[i+48]>sfp_threshold_m0[i+48]){
                    //gPC.printf("\n\rSP above threshold index: %d",i+48);
                    at = 1;
                }
            }
        }
        else if(srp_mode == 1)                              //scattered mode
        {
            #if srpz
            gPC.printf("\n\rSRP - Scatter Plot Mode");
            #endif
            for(int i = 0; i <48; i++)                      //first 48 bins of SRP are of 16 bit size
            {
                sfp_bin[i]  = read_2byte(ptr+2*i);
                scp_bin[i] += sfp_bin[i];
                //gPC.printf("\n\rsfp_bin[%d]= %u\t\tscp_bin[%d]= %u",i,sfp_bin[i],i,scp_bin[i]);
                if(sfp_bin[i] > sfp_threshold_m1[i]){
                    //gPC.printf("\n\rSP above threshold index: %d",i);
                    at = 1;
                }
            }
            for(int i = 0; i < 4 ; i++)                     //next 4 bins are of 32 bit size
            {
                sfp_bin[i+48] = read_4byte( (ptr+96) + 4*i );
                scp_bin[i+48] += sfp_bin[i+48];
                if(sfp_bin[i+48] > sfp_threshold_m1[i+48]){
                    //gPC.printf("\n\rSP above threshold index: %d",i+48);
                    at = 1;
                }
            }
        }
        /*---------------------------populating sfp_bin[] and scp_bin[] from srp ends here(also tagging AT or BT)------------------*/

        //ptr = ptr + 112;                                    //moving the pointer to next srp packet in the DMA buffer
        
        /*------------------------------------------forming a science fine packet starts here----------------------------------------
        First we fill packet header, then fill packet data and finally assign its length
        ----------------------------------------------------------------------------------------------------------------------------*/
        for(int i = 0; i<71; i++)    
            sfp[i] = 0;
        if(srp_mode == 0)                                                                   //calibrated mode
        {
            if(at == 0)
            {
                #if srpz
                gPC.printf("\n\rSFP Below Threshold");
                #endif
                pointer = sfp; debug_cntr = 0;
                space = adjust(4, attitude,pointer,8);      pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(6, counter,pointer,space);   pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(1, srp_mode,pointer,space);  pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(1, pzf,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(1, ezf,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
                for(uint8_t i = 0 ; i < 8 ; i++){
                    space = adjust(1, ((compress(sfp_bin[24+i],7,2))&0x100)>>8 ,pointer,space); pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, ((compress(sfp_bin[24+i],7,2))&0xff) ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                }
                for(uint8_t i = 0 ; i <12 ; i++){
                    space = adjust(6, (compress(sfp_bin[32+i],4,2)) ,pointer,space);            pointer += space>>4;    debug_cntr += space>>4;
                }
                for(uint8_t i = 0; i < 4; i++){
                    space = adjust(8, (compress(sfp_bin[44+i],6,2)) ,pointer,space);            pointer += space>>4;    debug_cntr += space>>4;
                }
                for(uint8_t i = 0 ; i < 4 ; i++){
                    space = adjust(1, (compress(sfp_bin[48+i],7,2))>>8 ,pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, compress(sfp_bin[48+i],7,2) ,pointer,space);              pointer += space>>4;    debug_cntr += space>>4;
                }
                space = adjust(8, ((compress(sfp_bin[17],6,2))&0xff) ,pointer,space);           pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, ((compress(sfp_bin[23],6,2))&0xff) ,pointer,space);           pointer += space>>4;    debug_cntr += space>>4;
                if(pzf == 0){
                    for(uint8_t i = 0; i<2 ; i++){
                        space = adjust(6, ((compress(sfp_bin[i],5,1))&0xff) ,pointer,space);    pointer += space>>4;    debug_cntr += space>>4;
                    }
                    for(uint8_t i = 0; i<15 ; i++){
                        space = adjust(5, ((compress(sfp_bin[i+2],4,1))&0xff) ,pointer,space);  pointer += space>>4;    debug_cntr += space>>4;
                    }
                }
                if(ezf == 0){
                    for(uint8_t i = 0; i <5 ;i++){
                        space = adjust(7, ((compress(sfp_bin[18+i],6,1))&0xff) ,pointer,space); pointer += space>>4;    debug_cntr += space>>4;
                    }
                }
            }                                                                                           //below thershold ends here.
            if(at == 1){
                #if srpz
                gPC.printf("\n\rSFP Above Threshold");
                #endif
                pointer = sfp + 6; debug_cntr = 6;space = 8;
                sfp[0] = (sci_time>>27)&0xff;   sfp[1] = (sci_time>>19)&0xff;   sfp[2] = (sci_time>>11)&0xff;   sfp[3] = (sci_time>>3)&0xff;
                sfp[4] = ((sci_time&0x07)<<5) + ((attitude&0x0f)<<1) + (counter>>5);
                sfp[5] = ((counter&0x1f)<<3) + (srp_mode<<2);
                sfp[5] += (pzf<<1) + ezf ;
                for(uint8_t i = 0 ; i < 8 ; i++){
                    space = adjust(1, (compress(sfp_bin[24+i],7,2))>>8 ,pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, ((compress(sfp_bin[24+i],7,2))&0xff) ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                }
                for(uint8_t i = 0 ; i <12 ; i++){
                    space = adjust(6, ((compress(sfp_bin[32+i],3,3))&0xff) ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                }
                for(uint8_t i = 0 ; i < 4 ; i++){
                    space = adjust(2, (compress(sfp_bin[44+i],8,2))>>8 ,pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, compress(sfp_bin[44+i],8,2) ,pointer,space);              pointer += space>>4;    debug_cntr += space>>4;
                }
                for(uint8_t i = 0 ; i < 4 ; i++){
                    space = adjust(1, (compress(sfp_bin[48+i],6,3))>>8 ,pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, compress(sfp_bin[48+i],6,3) ,pointer,space);              pointer += space>>4;    debug_cntr += space>>4;
                }
                space = adjust(2, (compress(sfp_bin[17],8,2))>>8 ,pointer,space);               pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, compress(sfp_bin[17],8,2) ,pointer,space);                    pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(2, (compress(sfp_bin[23],8,2))>>8 ,pointer,space);               pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, compress(sfp_bin[23],8,2) ,pointer,space);                    pointer += space>>4;    debug_cntr += space>>4;

                if(pzf == 0){
                    //cout<<"proton bins ";
                    #if srpz
                    gPC.printf("\n\rProton bins present in SRP");
                    #endif
                    for(uint8_t i = 0; i<17 ; i++){
                        space = adjust(2, ((compress(sfp_bin[i],8,2))>>8) ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
                        space = adjust(8, compress(sfp_bin[i],8,2) ,pointer,space);             pointer += space>>4;    debug_cntr += space>>4;
                        //printf("%02X ",compress(sfp_bin[i],8,2));
                    }
                }
                if(ezf == 0){
                    //cout<<"electron bins ";
                    #if srpz
                    gPC.printf("\n\rElectron bins present in SRP");
                    #endif
                    for(int i = 0; i<5 ; i++){
                        space = adjust(2,((compress(sfp_bin[18+i],8,2))>>8),pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                        space = adjust(8, compress(sfp_bin[18+i],8,2),pointer,space);           pointer += space>>4;    debug_cntr += space>>4;
                        //printf("%02X ",compress(sfp_bin[i],8,2));
                    }
                }
            }                                                                                   //above threshold ends here.            
            if(at == 0)
            {
                id = 1;     length = 241+5;                                 //5 spare bits
                if(pzf == 0)
                    length += 87;
                if(ezf == 0)
                    length += 35;
            }
            else
            {
                id = 2;     length = 288;                                   //0 spare bits
                if(pzf == 0)
                    length += 170;
                if(ezf == 0)
                    length += 50;
            }
        }
        else if(srp_mode == 1)                                                                 //scattered mode
        {
            if(at == 0)
            {
                #if srpz
                gPC.printf("\n\rSFP below threshold");
                #endif
                pointer = sfp; debug_cntr = 0;  space = 8;
                space = adjust(4, attitude,pointer,8);      pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(6, counter,pointer,space);   pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(1, srp_mode,pointer,space);  pointer += space>>4;    debug_cntr += space>>4;
                for(uint8_t i=0; i<48; i++)
                {
                    space = adjust(7, compress(sfp_bin[i],5,2) ,pointer,space);             pointer += space>>4;    debug_cntr += space>>4;
                }
                for(uint8_t i = 0 ; i < 4 ; i++)
                {
                    space = adjust(1, (compress(sfp_bin[48+i],7,2))>>8 ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, compress(sfp_bin[48+i],7,2) ,pointer,space);          pointer += space>>4;    debug_cntr += space>>4;
                }
            }
            if(at == 1)
            {
                
                #if srpz                
                gPC.printf("\n\rSFP below threshold");
                #endif
                pointer = sfp; debug_cntr = 0;  space = 8;
                space = adjust(3, sci_time>>32 ,pointer,space); pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, sci_time>>24 ,pointer,space); pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, sci_time>>16 ,pointer,space); pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, sci_time>>8 ,pointer,space);  pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, sci_time ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(4, attitude,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(6, counter,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(1, srp_mode,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
                for(uint8_t i=0; i<48; i++)
                {
                    space = adjust(2, (compress(sfp_bin[i],8,2))>>8 ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, compress(sfp_bin[i],8,2) ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                }
                for(uint8_t i = 0 ; i < 4 ; i++)
                {
                    space = adjust(1, (compress(sfp_bin[48+i],6,3))>>8 ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, compress(sfp_bin[48+i],6,3) ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
                }
            }
            if(at == 0)
            {
                id = 1;     length = 384;                                       //0 spare bits
            }
            else
            {
                id = 2;     length = 568;                                       //0 spare bits
            }
        }
        length = (length%8==0)?(length/8):(length/8)+1;                         //converting length to mulitple of 8
        #if srpz
        gPC.printf("\n\rLength of SFP packet in bytes = %d",length);
        #endif
        /*----------------------------------------forming a science packet ends here-----------------------------------------------*/

        /*-----------------------------Inserting the above packet(sfp) into the TM frame(s) starts here----------------------------*/
        if(id==1){
            if(position_tm_frame[id]>130){
                #if srpz
                gPC.printf("\n\rSkipping the current frame.Inserting sfp packet into the next frame.");
                #endif
                while(position_tm_frame[id]<132){
                    frames[id][position_tm_frame[id]] = 0;
                    position_tm_frame[id]++;
                }
            }
        }
        else if(id==2){
            if(position_tm_frame[id]>126){
                #if srpz
                gPC.printf("\n\rSkipping the current frame.Inserting sfp packet into the next frame.");
                #endif
                while(position_tm_frame[id]<132){
                    frames[id][position_tm_frame[id]] = 0;
                    position_tm_frame[id]++;
                }
            }
        }
        if(position_tm_frame[id]==position_tm_starting[id]){
            frames[id][6-id] = position_tm_starting[id];
        }
        for(uint16_t j=0 ; j<length ;)
        {            
            if(position_tm_frame[id]==frames[id][6-id]){
                if(id==1){
                    #if srpz
                    gPC.printf("\n\rAdding Time to TM frame");
                    #endif
                    frames[id][6]  = (uint8_t)((sci_time>>32)&0x07);
                    frames[id][7]  = (uint8_t)((sci_time>>24)&0xff);
                    frames[id][8]  = (uint8_t)((sci_time>>16)&0xff);
                    frames[id][9]  = (uint8_t)((sci_time>>8)&0xff);
                    frames[id][10] = (uint8_t)((sci_time)&0xff);
                }
            }
            if(position_tm_frame[id]<132){
                frames[id][position_tm_frame[id]] = sfp[j];
                j++;
                position_tm_frame[id]++;                                            //incrementing position of write pointer in TM frame
            }
            if(position_tm_frame[id] == 132)
            {
                /*-----------the current frame is completely filled and we fill frame header to write into SD card---------*/
                #if srpz
                gPC.printf("\n\rSFP_TM frame full. Length of current packet = %d",j);
                gPC.printf("\n\rFirst Header pointer: %d",frames[id][6-id]);
                gPC.printf("\n\rFirst head pointer contents: 0x%02X",frames[id][frames[id][6-id]]);
                #endif
                pointer = frames[id];
                if(id == 1){    //below threshold
                    space = adjust(1,0,pointer,8);
                    space = adjust(4,3,pointer,space);
                    FSC_science = FSC_CURRENT[3];                               ///to be used as this, but FSC_CURRENT[] is 32 bit 

                    //gPC.printf("3 = 0x%X",FSC_science);                   
                    #if debug_fsc
                    frames[id][1] = (test_fsc[3]>>24)&0xff;
                    frames[id][2] = (test_fsc[3]>>16)&0xff;
                    frames[id][3] = (test_fsc[3]>>8)&0xff;
                    frames[id][4] = test_fsc[3]&0xff;                    
                    test_fsc[3]++;
                    #endif                    
                    #if !debug_fsc
                    frames[id][1] = (FSC_science>>24)&0xff;
                    frames[id][2] = (FSC_science>>16)&0xff;
                    frames[id][3] = (FSC_science>>8)&0xff;
                    frames[id][4] = FSC_science&0xff;                    
                    #endif
                }
                else if(id == 2)    //above threshold
                {
                    space = adjust(1,0,pointer,8);
                    space = adjust(4,2,pointer,space);                    
                    FSC_science = FSC_CURRENT[2];                                               ///to be used as this
                    //gPC.printf("2 = 0x%X",FSC_science);
                    #if debug_fsc
                    frames[id][1] = (test_fsc[2]>>16)&0xff;
                    frames[id][2] = (test_fsc[2]>>8)&0xff;
                    frames[id][3] = test_fsc[2]&0xff;
                    test_fsc[2]++;
                    #endif
                    #if !debug_fsc
                    frames[id][1] = (FSC_science>>16)&0xff;
                    frames[id][2] = (FSC_science>>8)&0xff;
                    frames[id][3] = FSC_science&0xff;
                    #endif
                }
                temp_crc = crc16_gen(frames[id],132);
                frames[id][132] = temp_crc>>8;
                frames[id][133] = temp_crc & 0xff;
                
                #if srpz
                gPC.printf("\n\rPrinting SFP_TM\n\r{");                
                //gPC.printf("\n\r{");
                for(uint8_t z=0;z<134;z++){
                    gPC.printf("%02X",frames[id][z]);
                }
                gPC.printf("}\n\r");
                #endif
                /*------------------current TM frame completely filled-----------------------*/
                
                exor(frames[id]);
                convolution(frames[id]);
                interleave(TM_convoluted_data,TM_interleave_data);
                interleave(TM_convoluted_data+ 135,TM_interleave_data + 144);
                if(id == 1)
                {
                    sd_stat = SD_WRITE(TM_interleave_data,FSC_science+1,3);     //sd_write will return ack later, for now not included
                }
                else if (id == 2)
                {
                    sd_stat = SD_WRITE(TM_interleave_data,FSC_science+1,2);     //sd_write will return ack later, for now not included
                }
                if(sd_stat)
                {
                    gPC.puts("sd write fail");
                }
                position_tm_frame[id] = position_tm_starting[id];
                frames[id][6-id] = (length - j)+position_tm_starting[id];
            }
        }
        /*------------------------------finished inserting the sfp packet into the TM frame(s)-------------------------------------*/
    }                                                                               // for loop bracket which runs 60 times    
    #if srpz_last
    //gPC.printf("\n\rPrinting the last SFP_TM frame");
    //gPC.printf("\n\n\rPosition of tm_pointer: %d",position_tm_frame[id]);
    while(position_tm_frame[id]<132){
        frames[id][position_tm_frame[id]] = 0;
        position_tm_frame[id]++;
    }
    if(position_tm_frame[id]==132){
        //gPC.printf("\n\rFirst head pointer contents: 0x%02X",frames[id][frames[id][6-id]]);
        pointer = frames[id];
        if(id == 1){    //below threshold
            space = adjust(1,0,pointer,8);
            space = adjust(4,3,pointer,space);
            FSC_science = FSC_CURRENT[3];                               ///to be used as this, but FSC_CURRENT[] is 32 bit                    
            #if debug_fsc
            frames[id][1] = (FSC_science>>24)&0xff;
            frames[id][2] = (FSC_science>>16)&0xff;
            frames[id][3] = (FSC_science>>8)&0xff;
            frames[id][4] = FSC_science&0xff;
            test_fsc[3]++;
            #endif
            #if !debug_fsc
            frames[id][1] = (FSC_science>>24)&0xff;
            frames[id][2] = (FSC_science>>16)&0xff;
            frames[id][3] = (FSC_science>>8)&0xff;
            frames[id][4] = FSC_science&0xff;                    
            #endif
        }
        else if(id == 2)    //above threshold
        {
            space = adjust(1,0,pointer,8);
            space = adjust(4,2,pointer,space);                    
            FSC_science = FSC_CURRENT[2];                                               ///to be used as this
            #if debug_fsc
            frames[id][1] = (test_fsc[2]>>16)&0xff;
            frames[id][2] = (test_fsc[2]>>8)&0xff;
            frames[id][3] = test_fsc[2]&0xff;
            test_fsc[2]++;
            #endif
            #if !debug_fsc
            frames[id][1] = (FSC_science>>16)&0xff;
            frames[id][2] = (FSC_science>>8)&0xff;
            frames[id][3] = FSC_science&0xff;
            #endif
        }
        temp_crc = crc16_gen(frames[id],132);
        frames[id][132] = temp_crc>>8;
        frames[id][133] = temp_crc & 0xff;        
        
        //gPC.printf("\n\rPrinting SFP_TM\n\r{");
        gPC.printf("\n\r{");
        for(uint8_t z=0;z<134;z++){
            gPC.printf("%02X",frames[id][z]);
        }
        gPC.printf("}\n\r");
        position_tm_frame[id] = position_tm_starting[id];
    }
    #endif
    at = 0;     pzf = 1;    ezf = 1;
    srp_mode = head[2]&0x1;
    uint8_t compression_option = (head[2]>>1)&0x3;
    /*-------------------------------Tagging the scp packet formed from these 60 sfp's as AT or BT starts here-------------------------
    ------------------(in case compression option = 0 , then tagging beacon packet(not yet formed) as AT or BT is also done)----------*/
    if(srp_mode ==0)
    {
        if(compression_option == 0)
        {
            for(int i=0; i<52 ;i++)
            {
                if(scp_bin[i] > scp_threshold_m0[i])
                {
                    //gPC.printf("\n\rSCP above threshold index: %d",i);
                    at = 1;
                    break;
                }
            }
        }
        else if(compression_option == 1)
        {
            if(scp_bin[44] > scp_threshold_m0_1[0]){//gPC.printf("\n\rSCP above threshold index: 44"); 
            at=1;}
            for(int i=0; i<4 ;i++)
            {
                if(scp_bin[48+i] > scp_threshold_m0_1[i+1])
                {
                    //gPC.printf("\n\rSCP above threshold index: %d",i+48);
                    at = 1;
                    break;
                }
            }
            if(scp_bin[17] > scp_threshold_m0_1[5]){ 
                //gPC.printf("\n\rSP above threshold index: 17");
                at=1;
            }
            if(scp_bin[23] > scp_threshold_m0_1[6]){ 
                //gPC.printf("\n\rSP above threshold index: 23");
                at=1;
            }

            proton_scp_sum = 0; electron_scp_sum = 0;
            for(int i=0;i<17;i++)
            {
                proton_scp_sum += scp_bin[i];
            }
            for(int i=0; i<5; i++)
            {
                electron_scp_sum += scp_bin[18+i];
            }
            if(proton_scp_sum > scp_threshold_m0_1[7]){ //gPC.printf("\n\rProton_scp_sum above threshold");
            at=1;}
            if(electron_scp_sum > scp_threshold_m0_1[8]){//gPC.printf("\n\rElectron_scp_sum above threshold");
             at=1;}
        }
        else if(compression_option == 2)
        {
            if(scp_bin[50] > scp_sfp_threshold_m0_2[0]){//gPC.printf("\n\rSCP above threshold index:50"); 
            at=1;}
            proton_scp_sum = 0; electron_scp_sum = 0;
            for(int i=0;i<17;i++)
            {
                proton_scp_sum += scp_bin[i];
            }
            for(int i=0; i<5; i++)
            {
                electron_scp_sum += scp_bin[18+i];
            }
            if(proton_scp_sum > scp_sfp_threshold_m0_2[1]){//gPC.printf("\n\rProton_SCP_sum above threshold"); 
            at=1;}
            if(electron_scp_sum > scp_sfp_threshold_m0_2[2]){//gPC.printf("\n\rElectron above threshold");
             at=1;}
        }
    }
    else if(srp_mode ==1)
    {
        if(compression_option==0){
            for(int i=0; i<48; i++)
            {
                if(scp_bin[i] > scp_threshold_m1[i]){
                    //gPC.printf("\nSCP above threshold index:%d, Value:%d",i,scp_bin[i]);
                    at = 1;
                    break;
                }
            }
            for(int i=48; i<52; i++)
            {
                if(scp_bin[i] > scp_threshold_m1[i]){
                    //gPC.printf("\nSCP above threshold index:%d, Value:%d",i,scp_bin[i]);
                    at = 1;
                    break;
                }
            }
        }
        else if(compression_option==2){            
            if(scp_bin[50]>scp_sfp_threshold_m0_2[0]){
                //gPC.printf("\nSCP above threshold index:50, Value:%",scp_bin[50]);
                at=1;
            }
        }
    }
    /*----------------------------Tagging the scp packet formed from these 60 sfp's as AT or BT ends here--------------------------*/

    if(srp_mode == 0)
    {
        //determining if non zero values of proton and electron bins exist for calibrated mode (srp)
        for(int i=0; i<17 ;i++)
        {
            if(scp_bin[i]>0)
                pzf = 0;
        }
        for(int i=18; i<23 ;i++)
        {
            if(scp_bin[i]>0)
                ezf = 0;
        }
    }
    /*-----------------------------------------Tagging beacon packet as AT or BT starts here-------------------------------------*/
    beacon_at = 0;
    if(srp_mode==0)     //those bins which can be meaningfully compared only in srp_mode==0
    {
        if(scp_bin[44]>beacon_threshold[0])     beacon_at = 1;            
        if(scp_bin[17]>beacon_threshold[5])     beacon_at = 1;
        if(scp_bin[23]>beacon_threshold[6])     beacon_at = 1;
        proton_scp_sum = 0; electron_scp_sum = 0;
        for(int i=0;i<17;i++)
        {
            proton_scp_sum += scp_bin[i];
        }
        for(int i=0; i<5; i++)
        {
            electron_scp_sum += scp_bin[18+i];
        }
        if(proton_scp_sum > beacon_threshold[7]) beacon_at =1;
        if(electron_scp_sum > beacon_threshold[8]) beacon_at =1;
    }
    if(scp_bin[48]>beacon_threshold[1])     beacon_at = 1;
    if(scp_bin[49]>beacon_threshold[2])     beacon_at = 1;
    if(scp_bin[50]>beacon_threshold[3])     beacon_at = 1;
    if(scp_bin[51]>beacon_threshold[4])     beacon_at = 1;   
    /*----------------------------------------Tagging beacon packet as AT or BT ends here------------------------------------------*/

    /*-----------------------------------------------Forming the beacon packet starts here-----------------------------------------*/
    //Last 512 bits of beacon_array excluding CRC bits is used for storing the 5 most recent beacon packets

    if(beacon_cntr == 1)
    {
        beacon_ptr = &(beacon_array[47]);   // starting block address, stores the oldest(among the 5 most recent) beacon packet
    }
    else if(beacon_cntr>1 && beacon_cntr<6)
    {
        beacon_ptr +=17;                    // increase the block number(totally 5 blocks for 5 beacon packets)
    }
    else if(beacon_cntr == 6)
    {
        for(uint16_t i=0;i<17;i++)          // when all 5 blocks have been used shift the last 4 blocks up along the array and
        {                                   // overwrite the new beacon packet in the 5th block
            beacon_array[47+i] = beacon_array[64+i];
            beacon_array[64+i] = beacon_array[81+i];
            beacon_array[81+i] = beacon_array[98+i];
            beacon_array[98+i] = beacon_array[115+i];
        }
        beacon_ptr = &(beacon_array[115]);  //address of the 5th block
        beacon_cntr = 5;
    }
    pointer = beacon_ptr;        debug_cntr = 0;     space = 8;
    space = adjust(2, compression_option,pointer,space);        pointer += space>>4;    debug_cntr += space>>4; //first two bits of compression option
    space = adjust(1, srp_mode,pointer,space);                  pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(3,(sci_time>>32)&0x07,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(8,(sci_time>>24)&0xff,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(8,(sci_time>>16)&0xff,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(8,(sci_time>>8)&0xff,pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(8,(sci_time)&0xff,pointer,space);            pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(4, (attitude)&0x0f,pointer,space);           pointer += space>>4;    debug_cntr += space>>4;

    if(srp_mode==0){
        if(beacon_at == 0){
            space = adjust(1, 0,pointer,space);                                     pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(6, compress(scp_bin[44],3,3),pointer,space);             pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(7, compress(scp_bin[48],4,3),pointer,space);             pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(7, compress(scp_bin[49],4,3),pointer,space);             pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(7, compress(scp_bin[50],4,3),pointer,space);             pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(7, compress(scp_bin[51],4,3),pointer,space);             pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(6, compress(scp_bin[17],3,3),pointer,space);             pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(6, compress(scp_bin[23],3,3),pointer,space);             pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(4, compress(proton_scp_sum ,10,2)>>8,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(8, compress(proton_scp_sum ,10,2),pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(4, compress(electron_scp_sum ,10,2)>>8,pointer,space);   pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(8, compress(electron_scp_sum ,10,2),pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
            pointer = pointer + 1;
            for(int temp_i = 12; temp_i<14; temp_i++)
            {            
                *pointer = 0;
                pointer = pointer + 1;
            }
        }
        else if(beacon_at==1){
            space = adjust(1, 1,pointer,space);     pointer += space>>4;        debug_cntr += space>>4;
            space = adjust(1, compress(sfp_bin[44],6,3)>>8,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;             
            space = adjust(8, compress(sfp_bin[44],6,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(4, compress(sfp_bin[48],9,3)>>8,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;             
            space = adjust(8, compress(sfp_bin[48],9,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(4, compress(sfp_bin[49],9,3)>>8,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;             
            space = adjust(8, compress(sfp_bin[49],9,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(4, compress(sfp_bin[50],9,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;                 
            space = adjust(8, compress(sfp_bin[50],9,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(4, compress(sfp_bin[51],9,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;                 
            space = adjust(8, compress(sfp_bin[51],9,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(1, compress(sfp_bin[17],6,3)>>8,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;             
            space = adjust(8, compress(sfp_bin[17],6,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(1, compress(sfp_bin[23],6,3)>>8,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;             
            space = adjust(8, compress(sfp_bin[23],6,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(1, compress(proton_scp_sum ,6,3)>>8,pointer,space);  pointer += space>>4;    debug_cntr += space>>4;         
            space = adjust(8, compress(proton_scp_sum ,6,3),pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(1, compress(electron_scp_sum,6,3)>>8,pointer,space); pointer += space>>4;    debug_cntr += space>>4;     
            space = adjust(8, compress(electron_scp_sum ,6,3),pointer,space);   pointer += space>>4;    debug_cntr += space>>4;
            //cout<<"for beacon space = "<<(space&0x0f)<<" counter = "<<debug_cntr;
        }
    }else if(srp_mode==1){
        if(beacon_at==0){
            space = adjust(1, 0,pointer,space);                             pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(6, compress(0,3,3),pointer,space);               pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(7, compress(sfp_bin[48],4,3),pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(7, compress(sfp_bin[49],4,3),pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(7, compress(sfp_bin[50],4,3),pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(7, compress(sfp_bin[51],4,3),pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
            pointer = pointer + 1;
            for(uint8_t temp_i = 7; temp_i<14; temp_i++)
            {            
                *pointer = 0;
                pointer = pointer + 1;
            }
        }
        else if(beacon_at==1){
            space = adjust(1, 1,pointer,space);                                 pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(1, compress(0,6,3)>>8,pointer,space);                pointer += space>>4;    debug_cntr += space>>4;             
            space = adjust(8, compress(0,6,3),pointer,space);                   pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(4, compress(sfp_bin[48],9,3)>>8,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;             
            space = adjust(8, compress(sfp_bin[48],9,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(4, compress(sfp_bin[49],9,3)>>8,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;             
            space = adjust(8, compress(sfp_bin[49],9,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(4, compress(sfp_bin[50],9,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;                 
            space = adjust(8, compress(sfp_bin[50],9,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(4, compress(sfp_bin[51],9,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;                 
            space = adjust(8, compress(sfp_bin[51],9,3),pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
            pointer = pointer + 1;
            for(uint8_t temp_i = 10; temp_i<14; temp_i++)
            {            
                *pointer = 0;
                pointer = pointer + 1;
            }
        }
    }
    beacon_cntr++;
    /*--------------------------------------------------beacon packet ends here--------------------------------------------------------*/

    //gPC.printf("\n\n\rSCP");
    uint8_t packet_pp,time_diff;
    /*------------------------------------------Forming a science packet(scp) starts here----------------------------------------------*/

    pointer = scp;      debug_cntr = 0;     space = 8;
    time_diff = 0;
    
    packet_pp = 1;
    if((((uint8_t)(sci_time>>7))&0x3f)<(((uint8_t)(time_prev_scp>>7))&0x3f))
    {
        time_diff = time_diff+60;
    }
    time_diff += (((uint8_t)(sci_time>>7))&0x3f);
    time_diff -= (((uint8_t)(time_prev_scp>>7))&0x3f);
    if(time_diff>10){
        packet_pp = 0;
    }
    time_prev_scp = sci_time;
    uint32_t sfp_at_counter;
    sfp_at_counter = FSC_CURRENT[2];
    space = adjust(1, packet_pp,pointer,space);                     pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(5, (sci_time>>8)&0x1f,pointer,space);            pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(8, (sci_time)&0xff,pointer,space);               pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(4, (attitude)&0xf,pointer,space);                pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(2, compression_option,pointer,space);            pointer += space>>4;    debug_cntr += space>>4; //first two bits of compression option
    space = adjust(1, at,pointer,space);                            pointer += space>>4;    debug_cntr += space>>4; //last bit of compression option
    space = adjust(1, srp_mode,pointer,space);                      pointer += space>>4;    debug_cntr += space>>4;
    if(!(srp_mode==0 && compression_option==2))
    {
        space = adjust(8, sfp_at_counter>>16,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
        space = adjust(8, sfp_at_counter>>8,pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
        space = adjust(8, sfp_at_counter,pointer,space);            pointer += space>>4;    debug_cntr += space>>4;
    }
    if(srp_mode == 0 && compression_option == 0){       //normal callibrated mode
        #if scpz
        gPC.printf("\n\rSCP - Normal calibrated mode");
        #endif
        space = adjust(1, pzf,pointer,space);                       pointer += space>>4;    debug_cntr += space>>4;
        space = adjust(1, ezf,pointer,space);                       pointer += space>>4;    debug_cntr += space>>4;
        if(at == 0 ){
            #if scpz
            gPC.printf("\n\rBelow threshold");
            #endif
            for(int i = 0; i<8 ;i++){
                space = adjust(7,compress(scp_bin[24+i],4,3) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            }
            for(int i = 0; i<12 ;i++){
                space = adjust(5,compress(scp_bin[32+i],2,3) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            }
            for(int i = 0; i<4 ;i++){
                space = adjust(6,compress(scp_bin[44+i],3,3) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            }
            for(int i = 0; i<4 ;i++){
                space = adjust(7,compress(scp_bin[48+i],4,3) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            }
            space = adjust(6,compress(scp_bin[17],3,3) ,pointer,space);             pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(6,compress(scp_bin[23],3,3),pointer,space);              pointer += space>>4;    debug_cntr += space>>4;
            if(pzf == 0){
                for(int i = 0; i<2 ;i++){
                    space = adjust(8,compress(scp_bin[i],6,2) ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
                }
                for(int i = 0; i<15 ;i++){
                    space = adjust(7,compress(scp_bin[i+2],5,2) ,pointer,space);    pointer += space>>4;    debug_cntr += space>>4;
                }
            }
            if(ezf == 0){
                space = adjust(1,compress(scp_bin[18],7,2)>>8 ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8,compress(scp_bin[18],7,2) ,pointer,space);         pointer += space>>4;    debug_cntr += space>>4;
                for(int i=0; i<4; i++){
                    space = adjust(8,compress(scp_bin[19+i],6,2) ,pointer,space);   pointer += space>>4;    debug_cntr += space>>4;
                }
            }
        }// below threshold ends here
        if(at == 1){
            #if scpz
            gPC.printf("\n\rAbove threshold");
            #endif
            for(int i = 0; i<8 ;i++){
                space = adjust(7,compress(scp_bin[24+i],4,3) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            }
            for(int i = 0; i<12 ;i++){
                space = adjust(5,compress(scp_bin[32+i],2,3) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            }
            for(int i = 0; i<4 ;i++){
                space = adjust(1,compress(scp_bin[44+i],6,3)>>8 ,pointer,space);    pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8,compress(scp_bin[44+i],6,3) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            }
            for(int i=0; i<4 ;i++){
                space = adjust(4,compress(scp_bin[48+i],9,3)>>8 ,pointer,space);    pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8,compress(scp_bin[48+i],9,3) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            }
            space = adjust(1,compress(scp_bin[17],6,3)>>8 ,pointer,space);          pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(8,compress(scp_bin[17],6,3),pointer,space);              pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(1,compress(scp_bin[23],6,3)>>8,pointer,space);           pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(8,compress(scp_bin[23],6,3),pointer,space);              pointer += space>>4;    debug_cntr += space>>4;

            if(pzf == 0){
                for(int i = 0; i<17 ; i++){
                    space = adjust(8, (compress(scp_bin[i],5,3)) ,pointer,space);   pointer += space>>4;    debug_cntr += space>>4;
                }
            }
            if(ezf == 0){
                for(int i = 0; i<5 ; i++){
                    space = adjust(8, (compress(scp_bin[18+i],5,3)) ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
                }
            }
        }   //above thresholds ends
    }   //srp_mode == 0 ends
    if(srp_mode == 1){
        #if scpz
        gPC.printf("\n\rSCP - Scatter plot mode");
        #endif
        if(at == 0){
            #if scpz
            gPC.printf("\n\rBelow Threshold");
            #endif
            for(int i=0; i<48; i++){
                space = adjust(6, ((compress(scp_bin[i],3,3))&0xff) ,pointer,space);    pointer += space>>4;    debug_cntr += space>>4;
            }
            for(int i = 0 ; i < 4 ; i++){
                space = adjust(7, (compress(scp_bin[48+i],4,3))>>8 ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
            }
        }
        if(at == 1){
            #if scpz
            gPC.printf("\n\rAbove threshold");
            #endif
            for(int i=0; i<48; i++){
                space = adjust(7, (compress((scp_bin[i]/2),4,3))>>8 ,pointer,space);    pointer += space>>4;    debug_cntr += space>>4;
            }
            for(int i = 0 ; i < 4 ; i++){
                space = adjust(4, (compress(scp_bin[48+i],9,3))>>8 ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, (compress(scp_bin[48+i],9,3)) ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
            }
        }
    }// scp mode 1 end
    if( srp_mode == 0 && compression_option == 1 ){ //scp data conservation mode
        #if scpz
        gPC.printf("\n\rSCP - Calibrated data conservation mode");
        #endif
        space = adjust(1, pzf,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
        space = adjust(1, ezf,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
        if(at == 0){
            #if scpz
            gPC.printf("\n\rBelow threshold");
            #endif
            space = adjust(6, (compress(scp_bin[44],3,3)) ,pointer,space);              pointer += space>>4;    debug_cntr += space>>4;
            for(int i=0; i<4; i++){
                space = adjust(7, (compress(scp_bin[48+i],4,3)) ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
            }
            space = adjust(6, (compress(scp_bin[17],3,3)) ,pointer,space);              pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(6, (compress(scp_bin[23],3,3)) ,pointer,space);              pointer += space>>4;    debug_cntr += space>>4;
            if(pzf==0){
                space = adjust(4, (compress(proton_scp_sum,10,2))>>8 ,pointer,space);   pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, ( compress(proton_scp_sum,10,2)) ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
            }
            if(ezf==0){
                space = adjust(4, (compress(electron_scp_sum,10,2))>>8 ,pointer,space); pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, (compress(electron_scp_sum,10,2)) ,pointer,space);    pointer += space>>4;    debug_cntr += space>>4;
            }
        }else if(at == 1){
            #if scpz
            gPC.printf("\n\rAbove threshold");
            #endif
            space = adjust(1, (compress(scp_bin[44],6,3))>>8 ,pointer,space);           pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(8, (compress(scp_bin[44],6,3)) ,pointer,space);              pointer += space>>4;    debug_cntr += space>>4;
            for(int i=0; i<4; i++){
                space = adjust(4, (compress(scp_bin[48+i],9,3))>>8 ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, (compress(scp_bin[48+i],9,3)) ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
            }
            space = adjust(1, (compress(scp_bin[17],6,3)>>8) ,pointer,space);           pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(8, (compress(scp_bin[17],6,3)) ,pointer,space);              pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(1, (compress(scp_bin[23],6,3))>>8 ,pointer,space);           pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(8, (compress(scp_bin[23],6,3)) ,pointer,space);              pointer += space>>4;    debug_cntr += space>>4;
            if(pzf==0){
                space = adjust(1, (compress(proton_scp_sum,6,3))>>8 ,pointer,space);    pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, (compress(proton_scp_sum,6,3)) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            }
            if(ezf==0){
                space = adjust(1, (compress(electron_scp_sum,6,3))>>8 ,pointer,space);  pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, (compress(electron_scp_sum,6,3)) ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
            }
        }
    }
    if(compression_option == 2 )  //scp extreme data conservation mode
    {
        if(srp_mode==0)
        {
            #if scpz
            gPC.printf("\n\rSCP - calibrated extreme data conservation mode");
            #endif
            space = adjust(1, pzf,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(1, ezf,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            if(at==0){
                #if scpz
                gPC.printf("\n\rBelow threshold");
                #endif
                space = adjust(7, (compress(scp_bin[50],4,3)) ,pointer,space);              pointer += space>>4;    debug_cntr += space>>4;
                if(pzf==0){
                    space = adjust(4, (compress(proton_scp_sum,10,2))>>8 ,pointer,space);   pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, ( compress(proton_scp_sum,10,2)) ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                }
                if(ezf==0){
                    space = adjust(4, (compress(electron_scp_sum,10,2))>>8 ,pointer,space); pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, (compress(electron_scp_sum,10,2)) ,pointer,space);    pointer += space>>4;    debug_cntr += space>>4;
                }
            }else if(at==1){
                #if scpz
                gPC.printf("\n\rAbove threshold");
                #endif
                space = adjust(4, (compress(scp_bin[50],9,3))>>8 ,pointer,space);           pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, (compress(scp_bin[50],9,3)) ,pointer,space);              pointer += space>>4;    debug_cntr += space>>4;
                if(pzf==0){
                    space = adjust(1, (compress(proton_scp_sum,6,3))>>8 ,pointer,space);    pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, (compress(proton_scp_sum,6,3)) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
                }
                if(ezf==0){
                    space = adjust(1, (compress(electron_scp_sum,6,3))>>8 ,pointer,space);  pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, (compress(electron_scp_sum,6,3)) ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                }
            }
        }
        else if(srp_mode==1)
        {
            #if scpz
            gPC.printf("\n\rSCP - Scatter plot, extreme data conservation mode");
            #endif
            pzf = 0;    ezf = 0;    //because proton energy bins are not available in scatter plot mode and hence in the packet we send dummy data(which is nothng but the maximum value which fits into that particular compression scheme)
            space = adjust(1, pzf,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(1, ezf,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            if(at==0){
                #if scpz
                gPC.printf("\n\rBelow threshold");
                #endif
                space = adjust(7, (compress(scp_bin[50],4,3)) ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
                // below 4 lines - filling the proton ane electron energy bins with zeros(junk value) since they're not available in srp
                space = adjust(4, (compress(0,10,2))>>8 ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, (compress(0,10,2)) ,pointer,space);           pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(4, (compress(0,10,2))>>8 ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, (compress(0,10,2)) ,pointer,space);           pointer += space>>4;    debug_cntr += space>>4;
            }
            else if(at==1){
                #if scpz
                gPC.printf("\n\rAbove threshold");
                #endif
                space = adjust(4, (compress(scp_bin[50],9,3))>>8 ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, (compress(scp_bin[50],9,3)) ,pointer,space);          pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(1, (compress(0,6,3))>>8 ,pointer,space);                 pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, (compress(0,6,3)) ,pointer,space);                    pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(1, (compress(0,6,3))>>8 ,pointer,space);                 pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, (compress(0,6,3)) ,pointer,space);                    pointer += space>>4;    debug_cntr += space>>4;
            }
        }
    }
    /*---------------------------------------------forming a science packet ends here----------------------------------------------*/

    id = 0;
    if(srp_mode == 0 && compression_option == 0){
        if(at == 0){
            length = 228+2;                                                       //2 spare bits
            if(pzf == 0)
                length += 121;
            if(ezf == 0)
                length +=41;
        }else if(at == 1){
            length = 266+6;                                                       //6 spare bits
            if(pzf == 0)
                length += 136;
            if(ezf == 0)
                length += 40;
        }
    }else if(srp_mode == 0 && compression_option == 1){                         //data conservation mode
        if(at == 0){
            length = 94+2;                                                        //2 spare bits
            if(pzf == 0)
                length += 12;
            if(ezf == 0)
                length += 12;
        }else if(at == 1){
            length = 123+3;                                                       //3 spare bits
            if(pzf == 0)
                length += 9;
            if(ezf == 0)
                length += 9;
        }
    }
    else if( srp_mode == 1){
        if(at == 0)
            length = 368;
        else if(at == 1)
            length = 432;
    }
    else if(compression_option == 2)                                //in extreme data conservation mode, length is same for both srp_modes
    {                         
        if(at == 0){
            length = 31+1;                                                        //1 spare bits
            if(pzf == 0)
                length += 12;
            if(ezf == 0)
                length += 12;
        }else if(at == 1){
            length = 36+2;                                                       //2 spare bits
            if(pzf == 0)
                length += 9;
            if(ezf == 0)
                length += 9;
        }
    }
    length = (length%8==0)?(length/8):(length/8)+1;
    #if scpz
    gPC.printf("\n\rSCP packet length = %d",length);
    #endif
    if(position_tm_frame[id]>129){        
        #if scpz
        gPC.printf("\n\rSkipping the current TM frame. Inserting SCP into the next frame");
        gPC.printf("\n\rposition_tm_frame = %d",position_tm_frame[id]);
        #endif
        while(position_tm_frame[id]<132){
            frames[id][position_tm_frame[id]] = 0;
            position_tm_frame[id]++;
        }
    }
    if(position_tm_frame[id]==position_tm_starting[id]){
        frames[id][4] = position_tm_starting[id];
    }
    for(int j= 0; j < length ;)
    {        
        if(position_tm_frame[id]==frames[id][4]){
            #if scpz
            gPC.printf("\n\rInserting Time into SCP_TM");
            #endif
            frames[id][5] = (uint8_t)((sci_time>>29)&0x3f);
            frames[id][6] = (uint8_t)((sci_time>>21)&0xff);
            frames[id][7] = (uint8_t)((sci_time>>13)&0x3f);
        }
        if(position_tm_frame[id]<132){
            frames[id][position_tm_frame[id]] = scp[j];
            j++;
            position_tm_frame[id]++;
        }
        if(position_tm_frame[id] == 132)                                                //space full in the frame bro
        {
            #if scpz
            gPC.printf("\n\rSCP_TM frame full. Length of current SCP packet = %d",j);
            #endif
            pointer = frames[id];
            space = adjust(1,0,pointer,8);
            space = adjust(4,1,pointer,space);
            FSC_science = FSC_CURRENT[1];
            //gPC.printf("1 = 0x%X",FSC_science);
            
            #if debug_fsc
            frames[id][1] = (FSC_science>>16)&0xff;
            frames[id][2] = (FSC_science>>8)&0xff;
            frames[id][3] = (FSC_science)&0xff;
            test_fsc[1]++;
            #endif
            #if !debug_fsc
            frames[id][1] = (FSC_science>>16)&0xff;
            frames[id][2] = (FSC_science>>8)&0xff;
            frames[id][3] = (FSC_science)&0xff;
            #endif

            temp_crc = crc16_gen(frames[id],132);
            frames[id][132] = temp_crc>>8;
            frames[id][133] = temp_crc & 0xff;
            #if scpz
            //gPC.printf("\n\rFirst head pointer contents: 0x%02X",frames[id][frames[id][4]]);
            //gPC.printf("\n\rPrinting SCP_TM\n\r{");
            gPC.printf("\n\r{");
            for(uint8_t z=0;z<134;z++){
                gPC.printf("%02X",frames[id][z]);
            }
            gPC.printf("}\n\r");
            #endif
            exor(frames[id]);
            convolution(frames[id]);
            interleave(TM_convoluted_data,TM_interleave_data);
            interleave(TM_convoluted_data+ 135,TM_interleave_data + 144);

            sd_stat = SD_WRITE(TM_interleave_data,FSC_science+1,1);         //sd_write returns ack, for now not included
            if(sd_stat)
            {
                gPC.puts("sd write fail");
            }
            position_tm_frame[id] = position_tm_starting[id];
            frames[id][4] = (length - j)+position_tm_starting[id];
        }
    }
    #if scpz_last
    //gPC.printf("\n\rPrinting the last SCP_TM frame");
    //gPC.printf("\n\n\rPosition of tm_pointer: %d",position_tm_frame[id]);
    while(position_tm_frame[id]<132){
        frames[id][position_tm_frame[id]] = 0;
        position_tm_frame[id]++;
    }
    if(position_tm_frame[id] == 132)                                                //space full in the frame bro
    {
        //gPC.printf("\n\rSCP_TM frame full. Length of current SCP packet = %d",j);
        pointer = frames[id];
        space = adjust(1,0,pointer,8);
        space = adjust(4,1,pointer,space);
        FSC_science = FSC_CURRENT[1];
        //gPC.printf("1 = 0x%X",FSC_science);
        
        #if debug_fsc
        frames[id][1] = (FSC_science>>16)&0xff;
        frames[id][2] = (FSC_science>>8)&0xff;
        frames[id][3] = (FSC_science)&0xff;
        test_fsc[1]++;
        #endif
        #if !debug_fsc
        frames[id][1] = (FSC_science>>16)&0xff;
        frames[id][2] = (FSC_science>>8)&0xff;
        frames[id][3] = (FSC_science)&0xff;
        #endif

        temp_crc = crc16_gen(frames[id],132);
        frames[id][132] = temp_crc>>8;
        frames[id][133] = temp_crc & 0xff;
        //gPC.printf("\n\rFirst head pointer contents: 0x%02X",frames[id][frames[id][4]]);
        //gPC.printf("\n\rPrinting SCP_TM\n\r{");
        gPC.printf("\n\r{");
        for(uint8_t z=0;z<134;z++){
            gPC.printf("%02X",frames[id][z]);
        }
        gPC.printf("}\n\r");
        position_tm_frame[id] = position_tm_starting[id];
    }
    #endif   
    gPC.printf("fsc = %u, %u,%u\n\r", FSC_CURRENT[1],FSC_CURRENT[2],FSC_CURRENT[3]);
    //gPC.printf("\n\rEndSRP"); 
 //   SCI_LED1 = !SCI_LED1;
     SCI_LED1 = 0;


}