#include "mbed.h"
#include "rpc.h"
#include "RPCFunction.h"
#include "RPCVariable.h"
Serial pc(USBTX, USBRX);
I2C i2c(p28,p27);
//functions definition
void sendData(char * input, char * output);
void readData(char * input, char * output);
//RPC function calls
RPCFunction send(&sendData, "send");
RPCFunction read(&readData, "read");

// Functions
void sendData(char * input, char * output)
{
    int adress;
    int length;
    int offset;
    char *data = &input[0];
    int temp;
    int i=0;
    sscanf(data, "%x %x %n", &adress,&length, &offset);
   // printf("adress = %#x \nlengte= %#x \n", adress , length);
    data += offset;
    char cmd[length];
    while (1==sscanf(data, "%x %n", &temp, &offset))
      {
        cmd[i]=temp;
        data += offset;
        i++;
      }
  //    printf("adress = %#x \nlengte= %#x \ncmd[0]= %#x \ncmd[1]= %#x\n", adress , length ,cmd[0],cmd[1]);
    i2c.write(adress,cmd,length);
}
void readData(char * input, char * output)
{
    strcpy(output,"");
    int adress;
    int length;
    int offset;
    char *data = &input[0];
    sscanf(data, " %x %x%n", &adress,&length, &offset);
    data += offset;
    char cmd[length];

    i2c.read(adress,cmd,length);
    char temp[4];
    for (int i=0;i<length;i++)
    {
    sprintf(temp,"%x",cmd[i]);
    strcat(output,temp);
    }
   // printf("%#x %#x",cmd[0],cmd[1]);
}

int main() {
    // setup the classes that can be created dynamically
    Base::add_rpc_class<AnalogIn>();
    Base::add_rpc_class<AnalogOut>();
    Base::add_rpc_class<DigitalIn>();
    Base::add_rpc_class<DigitalOut>();
    Base::add_rpc_class<DigitalInOut>();
    Base::add_rpc_class<PwmOut>();
    Base::add_rpc_class<Timer>();
    Base::add_rpc_class<SPI>();
    Base::add_rpc_class<BusOut>();
    Base::add_rpc_class<BusIn>();
    Base::add_rpc_class<BusInOut>();
    Base::add_rpc_class<Serial>();
    // receive commands, and send back the responses
    char buf[256], outbuf[256];
    while(1) {
        pc.gets(buf, 256);
        rpc(buf, outbuf); 
        pc.printf("%s\n", outbuf);
    }
}
