#include "mbed.h"
#include "rpc.h"
#include "RPCVariable.h"
//#include "LM75B.h"
#include "MMA7660.h"



Serial pc(USBTX, USBRX);
AnalogIn pot1 (p19, "pot1");
//LM75B tmp(p28,p27);
MMA7660 MMA(p28, p27);

//float t1;
float x, tmpx;
float y;
float z;
//RPCVariable<float>RPCtemp(&t1,"t1");
RPCVariable<float>RPCx(&x,"x-as");
RPCVariable<float>RPCy(&y,"y-as");
RPCVariable<float>RPCz(&z,"z-as");

int main() {
    pc.baud(57600);
    // setup the classes that can be created dynamically
    Base::add_rpc_class<AnalogIn>();
    Base::add_rpc_class<AnalogOut>();
    Base::add_rpc_class<DigitalIn>();
    Base::add_rpc_class<DigitalOut>();
    Base::add_rpc_class<DigitalInOut>();
    Base::add_rpc_class<PwmOut>();
    Base::add_rpc_class<Timer>();
    Base::add_rpc_class<SPI>();
    Base::add_rpc_class<BusOut>();
    Base::add_rpc_class<BusIn>();
    Base::add_rpc_class<BusInOut>();
    Base::add_rpc_class<Serial>();
    // receive commands, and send back the responses
    char buf[256], outbuf[256];
    while(1) {
        //t1 = tmp.read();

        x = MMA.x();
        y = MMA.y();
        z = MMA.z();

        pc.gets(buf, 256);
        rpc(buf, outbuf); 
        pc.printf("%s\n", outbuf);
    }
}
