#include "mbed.h"
#include "HTTPServer.h"
#include "FsHandler.h"
#include "LocalFileSystem.h"
#include "RpcHandler.h"
#include "mbed_rpc.h"



//  Use LED1 to indicate that the main loop is still executing
DigitalOut myled(LED1);
//  Use the serial connection 'pc' to dump debug information
Serial pc(USBTX, USBRX, "pc");
//  Instantiate a HTTPServer to handle incoming requests
HTTPServer  svr;
//  Instantiate a local file system handler named 'local' which will be used later to access files on the mbed.
LocalFileSystem local("local");

//  Create the EthernetInterface. This is optional, please see the documentation of HTTP Server's start method.
EthernetInterface eth;

//Make these variables accessible over RPC by attaching them to an RPCVariable
int Request = 0;
RPCVariable<int> RPCRequest(&Request, "Request");

int main() {

    HTTPFsRequestHandler::mount("/local/", "/");   //   Mount /local/ filesystem as root web path /
    svr.addHandler<HTTPFsRequestHandler>("/");     //   Serve all default HTTP requests
    svr.addHandler<HTTPRpcRequestHandler>("/rpc"); //   Serve all RPC requests
    

    //  Initialize the EthernetInterface and initiate a connection using default DHCP.
    eth.init();
    eth.connect();
    
    if (!svr.start(80, &eth)) {
        error("Server not starting !");
        exit(0);
    }
    
    while(1) {
        svr.poll();
        myled = Request;
    }
}
