#include <events/mbed_events.h>
#include <mbed.h>
#include "ble/BLE.h"
#include "Sensorservice.h"
#include "stm32l475e_iot01_tsensor.h"
#include "stm32l475e_iot01_hsensor.h"
#include "stm32l475e_iot01_magneto.h"
#include "stm32l475e_iot01_gyro.h"
#include "stm32l475e_iot01_accelero.h"
#include "stm32l475e_iot01_psensor.h"


EnvironmentalService *SensorPtr;
static float currentTemperature   = 0.0;
static float currentHumidity   = 0.0;
static float currentPressure   = 0.0;
static int16_t      MagnetoXYZ[3]     ={0};
static int16_t     AcceleroXYZ[3]     ={0};
static float           GyroXYZ[3]     ={0};

Serial pc(USBTX,USBRX);

DigitalOut alivenessLED(LED1, 0);
DigitalOut actuatedLED(LED2, 0);
DigitalOut led(LED1, 1);
uint16_t customServiceUUID  = 0xA000; /*Service*/
uint16_t readCharUUID       = 0xA001; /*Read*/
uint16_t writeCharUUID      = 0xA002; /*Write*/

const static char     DEVICE_NAME[]        = "Projet";
static const uint16_t uuid16_list[]        = {GattService::UUID_ENVIRONMENTAL_SERVICE}; 


static uint8_t writeValue[10] = {0};
WriteOnlyArrayGattCharacteristic<uint8_t, sizeof(writeValue)> writeChar(writeCharUUID, writeValue);


GattCharacteristic *characteristics[] = {&writeChar};
GattService        customService(customServiceUUID, characteristics, sizeof(characteristics) / sizeof(GattCharacteristic *));

static EventQueue eventQueue(10 * EVENTS_EVENT_SIZE);


void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    (void) params;
    BLE::Instance().gap().startAdvertising();
}

  
void updateTSensorValue(void) {
    currentTemperature = BSP_TSENSOR_ReadTemp();
    currentHumidity =    BSP_HSENSOR_ReadHumidity();
    currentPressure   =  BSP_PSENSOR_ReadPressure();
    BSP_MAGNETO_GetXYZ(MagnetoXYZ);
    BSP_GYRO_GetXYZ(GyroXYZ);
    BSP_ACCELERO_AccGetXYZ(AcceleroXYZ);
    SensorPtr->updateTemperature(currentTemperature);
    SensorPtr->updateHumidity(currentHumidity);
    SensorPtr->updatePressure(currentPressure);
    SensorPtr->updateAccelero(AcceleroXYZ);
    SensorPtr->updateMagneto(MagnetoXYZ);
    SensorPtr->updateGyro(GyroXYZ);
}


void blinkCallback(void)
{
    alivenessLED = !alivenessLED; 
        if (BLE::Instance().gap().getState().connected) {
        eventQueue.call(updateTSensorValue);
    }
}

/********Lecture des donées et traitement selon leurs taille*******/
void onDataWrittenCallback(const GattWriteCallbackParams *params) {
    if ((params->handle == writeChar.getValueHandle())) {
        if(params->len == 1) {
            actuatedLED = *(params->data);
            pc.printf("Data received: length = %d\n\r",params->len);
            if(actuatedLED == 1){
              pc.printf("LED is on\n\r");
            }
            else{
                pc.printf("LED is off\n\r");
            }
            for(int x=0; x < params->len; x++) {
                pc.printf("%x", params->data[x]);
                pc.printf("\n\r");
            }
        }
        else {
            pc.printf("Data received: length = %d, data = 0x",params->len);
            for(int x=0; x < params->len; x++) {
                pc.printf("%x", params->data[x]);
            }
            pc.printf("\n\r");
        }
        
    }
}


void onBleInitError(BLE &ble, ble_error_t error)
{
    pc.printf("Erreur\n\r");
}


void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE&        ble   = params->ble;
    ble_error_t error = params->error;

    if (error != BLE_ERROR_NONE) {
        onBleInitError(ble, error);
        return;
    }

    if(ble.getInstanceID() != BLE::DEFAULT_INSTANCE) {
        return;
    }

    ble.gap().onDisconnection(disconnectionCallback);
    SensorPtr = new EnvironmentalService(ble);
    ble.gattServer().onDataWritten(onDataWrittenCallback);


/************************** advertising***********************/
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.gap().setAdvertisingInterval(1000); /* 1000ms. */
    ble.addService(customService);
    ble.gap().startAdvertising();
}

void scheduleBleEventsProcessing(BLE::OnEventsToProcessCallbackContext* context) {
    BLE &ble = BLE::Instance();
    eventQueue.call(Callback<void()>(&ble, &BLE::processEvents));
}

/******************************MAIN*******************************/

int main()
{
    BSP_TSENSOR_Init();
    BSP_HSENSOR_Init();
    BSP_PSENSOR_Init();
    BSP_MAGNETO_Init();
    BSP_GYRO_Init();
    BSP_ACCELERO_Init();
    pc.printf("BLE is Working\n\r");
    eventQueue.call_every(500, blinkCallback);
    

    BLE &ble = BLE::Instance();
    ble.onEventsToProcess(scheduleBleEventsProcessing);
    ble.init(bleInitComplete);

    eventQueue.dispatch_forever();

    return 0;
}
