#include "mbed.h"
#include "wifi.h"
#include "stm32l475e_iot01_tsensor.h"
#include "stm32l475e_iot01_hsensor.h"
#include "stm32l475e_iot01_psensor.h"
#include "stm32l475e_iot01_magneto.h"
#include "stm32l475e_iot01_gyro.h"
#include "stm32l475e_iot01_accelero.h"

#define WIFI_WRITE_TIMEOUT 10000
#define WIFI_READ_TIMEOUT  10000
#define PORT           80
#define MBED_RAM_SIZE 0xCE30


/* Private typedef------------------------------------------------------------*/
typedef enum
{
  WS_IDLE = 0,
  WS_CONNECTED,
  WS_DISCONNECTED,
  WS_ERROR,
} WebServerState_t;

/* Private macro -------------------------------------------------------------*/
static int wifi_sample_run(void);
static void WebServerProcess(void);
/*Declaring variables*/
float Tsensor_value = 0;
float Hsensor_value = 0;
float Psensor_value = 0;
int16_t ACCELERO_DataXYZ[3] = {0};
int16_t MAGNETO_DataXYZ[3] = {0};
float pGyroDataXYZ[3] = {0};

static WIFI_Status_t SendWebPage(uint8_t ledIsOn, float Tsensor_value, float Hsensor_value, float Psensor_value, int16_t ACCELERO_DataXYZ[3], int16_t MAGNETO_DataXYZ[3], float pGyroDataXYZ[3]);
/* Private variables ---------------------------------------------------------*/
Serial pc(USBTX, USBRX);
static   uint8_t http[1024];
static   uint8_t resp[1024];
uint16_t respLen;
uint8_t  IP_Addr[4]; 
uint8_t  MAC_Addr[6]; 
int32_t Socket = -1;
static   WebServerState_t  State = WS_ERROR;
char     ModuleName[32];

DigitalOut Led_WIFI(LED2);
AnalogIn adc_temp(ADC_TEMP); /*to work on---*/

DigitalOut led(LED1);

int main()
{

    BSP_TSENSOR_Init();
    BSP_HSENSOR_Init();
    BSP_PSENSOR_Init();

    BSP_MAGNETO_Init();
    BSP_GYRO_Init();
    BSP_ACCELERO_Init();

    while(1) {

        led = 1;

        Tsensor_value = BSP_TSENSOR_ReadTemp();
        pc.printf("\nTEMPERATURE = %.2f degC\n", Tsensor_value);

        Hsensor_value = BSP_HSENSOR_ReadHumidity();
        pc.printf("HUMIDITY    = %.2f %%\n", Hsensor_value);

        Psensor_value = BSP_PSENSOR_ReadPressure();
        pc.printf("PRESSURE is = %.2f mBar\n", Psensor_value);

        Led_WIFI = 0;

        wait(1);

        led = 1;

        BSP_MAGNETO_GetXYZ(MAGNETO_DataXYZ);
        pc.printf("\nMAGNETO_X = %d\n", MAGNETO_DataXYZ[0]);
        pc.printf("MAGNETO_Y = %d\n", MAGNETO_DataXYZ[1]);
        printf("MAGNETO_Z = %d\n", MAGNETO_DataXYZ[2]);

        BSP_GYRO_GetXYZ(pGyroDataXYZ);
        pc.printf("\nGYRO_X = %.2f\n", pGyroDataXYZ[0]);
        pc.printf("GYRO_Y = %.2f\n", pGyroDataXYZ[1]);
        pc.printf("GYRO_Z = %.2f\n", pGyroDataXYZ[2]);

        BSP_ACCELERO_AccGetXYZ(ACCELERO_DataXYZ);
        pc.printf("\nACCELERO_X = %d\n", ACCELERO_DataXYZ[0]);
        pc.printf("ACCELERO_Y = %d\n", ACCELERO_DataXYZ[1]);
        pc.printf("ACCELERO_Z = %d\n", ACCELERO_DataXYZ[2]);

        led = 0;
        int ret = 0;
        led = 0;
        pc.baud(115200);
        pc.printf("\n");
        pc.printf("************************************************************\n\r");
        pc.printf("***                WIFI Web Server                     ***\n\r");
        pc.printf("************************************************************\n\r");
        
        /* Working application */
        ret = wifi_sample_run();
        
        if (ret != 0) {
            return -1;
        }
    
        
        while(1) {
            WebServerProcess ();
        }

        wait(1);

    }
}

int wifi_sample_run(void)
{
  
    /*Initialisation module WIFI */
    if(WIFI_Init() ==  WIFI_STATUS_OK) {
        pc.printf("WIFI Initialise.\n\r");
    
        if(WIFI_GetMAC_Address(MAC_Addr) == WIFI_STATUS_OK) {       
            pc.printf("> adresse MAC: %X:%X:%X:%X:%X:%X\n\r",     
                   MAC_Addr[0],
                   MAC_Addr[1],
                   MAC_Addr[2],
                   MAC_Addr[3],
                   MAC_Addr[4],
                   MAC_Addr[5]);   
        } else {
            pc.printf("> ERREUR : CANNOT get MAC address\n\r");
        }
    
        if( WIFI_Connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, WIFI_ECN_WPA2_PSK) == WIFI_STATUS_OK) {
            pc.printf("> module WIFI connecté \n\r");
      
            if(WIFI_GetIP_Address(IP_Addr) == WIFI_STATUS_OK) {
                pc.printf("> IP Address : %d.%d.%d.%d\n\r",     
                       IP_Addr[0],
                       IP_Addr[1],
                       IP_Addr[2],
                       IP_Addr[3]); 
        
                pc.printf(">Serveur HTTP ... \n\r");
                State = WS_IDLE;
            } else {    
                pc.printf("> ERROR :module CANNOT get IP address\n\r");
                return -1;
            }
        } else {
            pc.printf("> ERROR : module NOT connected\n\r");
            return -1;
        }
    } else {
        pc.printf("> ERROR : WIFI Module cannot be initialized.\n"); 
        return -1;
    }
    return 0;
}


static void WebServerProcess(void)
{
  uint8_t LedState = 0;
  float temp;
  switch(State)
  {
  case WS_IDLE:
    Socket = 0;
    WIFI_StartServer(Socket, WIFI_TCP_PROTOCOL, "", PORT);
    
    if(Socket != -1)
    {
      pc.printf("> HTTP Server Started \n");  
      State = WS_CONNECTED;
    }
    else
    {
      pc.printf("> ERROR : Connection cannot be established.\n"); 
      State = WS_ERROR;
    }    
    break;
    
  case WS_CONNECTED:
    
    WIFI_ReceiveData(Socket, resp, 1200, &respLen, WIFI_READ_TIMEOUT);
    
    if( respLen > 0)
    {
      if(strstr((char *)resp, "GET")) /* GET: put web page */
      {
        temp = (adc_temp.read()*100);
        if(SendWebPage(LedState, Tsensor_value, Hsensor_value, Psensor_value, ACCELERO_DataXYZ, MAGNETO_DataXYZ, pGyroDataXYZ) != WIFI_STATUS_OK)
        {
          pc.printf("> ERROR : Cannot send web page\n");
          State = WS_ERROR;
        }
      }
      else if(strstr((char *)resp, "POST"))/* POST: received info */
      {
          if(strstr((char *)resp, "radio"))
          {          
            if(strstr((char *)resp, "radio=0"))
            {
              LedState = 0;
              Led_WIFI = 0;
            }
            else if(strstr((char *)resp, "radio=1"))
            {
              LedState = 1;
              Led_WIFI = 1;
            } 
            
           temp = (adc_temp.read()*100);
            if(SendWebPage(LedState, Tsensor_value, Hsensor_value, Psensor_value, ACCELERO_DataXYZ, MAGNETO_DataXYZ, pGyroDataXYZ) != WIFI_STATUS_OK)
            {
              pc.printf("> ERROR : Cannot send web page\n");
              State = WS_ERROR;
          }
        }
      }
    }
    if(WIFI_StopServer(Socket) == WIFI_STATUS_OK)
    {
      WIFI_StartServer(Socket, WIFI_TCP_PROTOCOL, "", PORT);
    }
    else
    {
      State = WS_ERROR;  
    }
    break;
  case WS_ERROR:   
  default:
    break;
  }
}


/**
  * @brief  Send HTML page
  * @param  None
  * @retval None
  */
static WIFI_Status_t SendWebPage(uint8_t ledIsOn, float Tsensor_value, float Hsensor_value, float Psensor_value, int16_t ACCELERO_DataXYZ[3], int16_t MAGNETO_DataXYZ[3], float pGyroDataXYZ[3])
{
  uint8_t  temp[50];
  uint16_t SentDataLength;
  WIFI_Status_t ret;
  
  /* construct web page content */
  strcpy((char *)http, (char *)"HTTP/1.0 200 OK\r\nContent-Type: text/html\r\nPragma: no-cache\r\n\r\n");
  strcat((char *)http, (char *)"<html>\r\n<body>\r\n");
  strcat((char *)http, (char *)"<title>STM32 Web Server</title>\r\n");
  strcat((char *)http, (char *)"<h2>Server WIFI</h2>\r\n");
  strcat((char *)http, (char *)"<br /><hr>\r\n");
  
  strcat((char *)http, (char *)"<p><form method=\"POST\"><strong>Pression: <input type=\"text\" size=6 value=\"");
  sprintf((char *)temp, "%f", Psensor_value);
  strcat((char *)http, (char *)temp);
  strcat((char *)http, (char *)"\"> mBar");
  
  strcat((char *)http, (char *)"<p><form method=\"POST\"><strong>Temperature: <input type=\"text\" size=2 value=\"");
  sprintf((char *)temp, "%f", Tsensor_value);
  strcat((char *)http, (char *)temp);
  strcat((char *)http, (char *)"\"> <sup>O</sup>C");
  
  strcat((char *)http, (char *)"<p><form method=\"POST\"><strong>Humidity: <input type=\"text\" size=2 value=\"");
  sprintf((char *)temp, "%f", Hsensor_value);
  strcat((char *)http, (char *)temp);
  strcat((char *)http, (char *)"\">%");
  
  /*ACCELERO_DataXYZ*/
  strcat((char *)http, (char *)"<p><form method=\"POST\"><strong>ACCELERO_X: <input type=\"text\" size=4 value=\"");
  sprintf((char *)temp, "%d", ACCELERO_DataXYZ[0]);
  strcat((char *)http, (char *)temp);
  strcat((char *)http, (char *)"\"> ");
  strcat((char *)http, (char *)"<p><form method=\"POST\"><strong>ACCELERO_Y: <input type=\"text\" size=4 value=\"");
  sprintf((char *)temp, "%d", ACCELERO_DataXYZ[1]);
  strcat((char *)http, (char *)temp);
  strcat((char *)http, (char *)"\"> ");
  strcat((char *)http, (char *)"<p><form method=\"POST\"><strong>ACCELERO_Z: <input type=\"text\" size=4 value=\"");
  sprintf((char *)temp, "%d", ACCELERO_DataXYZ[2]);
  strcat((char *)http, (char *)temp);
  strcat((char *)http, (char *)"\">");
  
  /*MAGNETO_DataXYZ*/
  strcat((char *)http, (char *)"<p><form method=\"POST\"><strong>MAGNETO_X: <input type=\"text\" size=4 value=\"");
  sprintf((char *)temp, "%d", MAGNETO_DataXYZ[0]);
  strcat((char *)http, (char *)temp);
  strcat((char *)http, (char *)"\">");
  strcat((char *)http, (char *)"<p><form method=\"POST\"><strong>MAGNETO_Y: <input type=\"text\" size=4 value=\"");
  sprintf((char *)temp, "%d", MAGNETO_DataXYZ[1]);
  strcat((char *)http, (char *)temp);
  strcat((char *)http, (char *)"\">");
  strcat((char *)http, (char *)"<p><form method=\"POST\"><strong>MAGNETO_Z: <input type=\"text\" size=4 value=\"");
  sprintf((char *)temp, "%d", MAGNETO_DataXYZ[2]);
  strcat((char *)http, (char *)temp);
  strcat((char *)http, (char *)"\">");
 
  /*Gyro_Data*/
  strcat((char *)http, (char *)"<p><form method=\"POST\"><strong>Gyro_X: <input type=\"text\" size=4 value=\"");
  sprintf((char *)temp, "%.2f", pGyroDataXYZ[0]);
  strcat((char *)http, (char *)temp);
  strcat((char *)http, (char *)"\">");
  strcat((char *)http, (char *)"<p><form method=\"POST\"><strong>Gyro_Y: <input type=\"text\" size=4 value=\"");
  sprintf((char *)temp, "%.2f", pGyroDataXYZ[1]);
  strcat((char *)http, (char *)temp);
  strcat((char *)http, (char *)"\">");
  strcat((char *)http, (char *)"<p><form method=\"POST\"><strong>Gyro_Z: <input type=\"text\" size=4 value=\"");
  sprintf((char *)temp, "%.2f", pGyroDataXYZ[2]);
  strcat((char *)http, (char *)temp);
  strcat((char *)http, (char *)"\">");
  
  
  
  ret = WIFI_SendData(0, (uint8_t *)http, strlen((char *)http), &SentDataLength, WIFI_WRITE_TIMEOUT); 
  
  if((ret == WIFI_STATUS_OK) && (SentDataLength != strlen((char *)http)))
  {
    ret = WIFI_STATUS_ERROR;
  }
    
  return ret;
}