/*
Copyright (c) 2010 Peter Barrett

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef HCI_PRIVATE_H_INCLUDED
#define HCI_PRIVATE_H_INCLUDED

#define HCI_OP_INQUIRY                0x0401
#define HCI_OP_INQUIRY_CANCEL        0x0402
#define HCI_OP_EXIT_PERIODIC_INQ    0x0404
#define HCI_OP_CREATE_CONN            0x0405
#define HCI_OP_DISCONNECT            0x0406
#define HCI_OP_ADD_SCO                0x0407
#define HCI_OP_CREATE_CONN_CANCEL    0x0408
#define HCI_OP_ACCEPT_CONN_REQ        0x0409
#define HCI_OP_REJECT_CONN_REQ        0x040a
#define HCI_OP_LINK_KEY_REPLY        0x040b
#define HCI_OP_LINK_KEY_NEG_REPLY    0x040c
#define HCI_OP_PIN_CODE_REPLY        0x040d
#define HCI_OP_PIN_CODE_NEG_REPLY    0x040e
#define HCI_OP_CHANGE_CONN_PTYPE    0x040f
#define HCI_OP_AUTH_REQUESTED        0x0411
#define HCI_OP_SET_CONN_ENCRYPT        0x0413
#define HCI_OP_CHANGE_CONN_LINK_KEY    0x0415
#define HCI_OP_REMOTE_NAME_REQ        0x0419
#define HCI_OP_REMOTE_NAME_REQ_CANCEL    0x041a
#define HCI_OP_READ_REMOTE_FEATURES    0x041b
#define HCI_OP_READ_REMOTE_EXT_FEATURES    0x041c
#define HCI_OP_READ_REMOTE_VERSION    0x041d
#define HCI_OP_SETUP_SYNC_CONN        0x0428
#define HCI_OP_ACCEPT_SYNC_CONN_REQ    0x0429
#define HCI_OP_REJECT_SYNC_CONN_REQ    0x042a

#define HCI_OP_SNIFF_MODE            0x0803
#define HCI_OP_EXIT_SNIFF_MODE        0x0804
#define HCI_OP_ROLE_DISCOVERY        0x0809
#define HCI_OP_SWITCH_ROLE            0x080b
#define HCI_OP_READ_LINK_POLICY        0x080c
#define HCI_OP_WRITE_LINK_POLICY    0x080d
#define HCI_OP_READ_DEF_LINK_POLICY    0x080e
#define HCI_OP_WRITE_DEF_LINK_POLICY    0x080f
#define HCI_OP_SNIFF_SUBRATE        0x0811


#define HCI_OP_SET_EVENT_MASK        0x0c01
#define HCI_OP_RESET                0x0c03
#define HCI_OP_SET_EVENT_FLT        0x0c05
#define HCI_OP_WRITE_LOCAL_NAME        0x0c13
#define HCI_OP_READ_LOCAL_NAME        0x0c14
#define HCI_OP_WRITE_CA_TIMEOUT        0x0c16
#define HCI_OP_WRITE_PG_TIMEOUT        0x0c18
#define HCI_OP_WRITE_SCAN_ENABLE     0x0c1a
#define HCI_OP_READ_AUTH_ENABLE        0x0c1f
#define HCI_OP_WRITE_AUTH_ENABLE    0x0c20
#define HCI_OP_READ_ENCRYPT_MODE    0x0c21
#define HCI_OP_WRITE_ENCRYPT_MODE    0x0c22
    #define ENCRYPT_DISABLED    0x00
    #define ENCRYPT_P2P        0x01
    #define ENCRYPT_BOTH        0x02
#define HCI_OP_READ_CLASS_OF_DEV    0x0c23
#define HCI_OP_WRITE_CLASS_OF_DEV    0x0c24
#define HCI_OP_READ_VOICE_SETTING    0x0c25
#define HCI_OP_WRITE_VOICE_SETTING    0x0c26
#define HCI_OP_CONTR_TO_HOST_FLOW        0x0c31
#define HCI_OP_HOST_BUFFER_SIZE        0x0c33
#define HCI_OP_NUM_COMP_PKTS        0x0c35
#define HCI_OP_READ_SSP_MODE        0x0c55
#define HCI_OP_WRITE_SSP_MODE        0x0c56

#define HCI_OP_READ_LOCAL_VERSION    0x1001
#define HCI_OP_READ_LOCAL_COMMANDS    0x1002
#define HCI_OP_READ_LOCAL_FEATURES    0x1003
#define HCI_OP_READ_LOCAL_EXT_FEATURES    0x1004
#define HCI_OP_READ_BUFFER_SIZE        0x1005
#define HCI_OP_READ_BD_ADDR            0x1009

//  events
#define HCI_EV_INQUIRY_COMPLETE        0x01
#define HCI_EV_INQUIRY_RESULT        0x02
#define HCI_EV_CONN_COMPLETE        0x03
#define HCI_EV_CONN_REQUEST            0x04
#define HCI_EV_DISCONN_COMPLETE        0x05
#define HCI_EV_AUTH_COMPLETE        0x06
#define HCI_EV_REMOTE_NAME            0x07
#define HCI_EV_ENCRYPT_CHANGE        0x08
#define HCI_EV_CHANGE_LINK_KEY_COMPLETE    0x09
#define HCI_EV_REMOTE_FEATURES        0x0b
#define HCI_EV_REMOTE_VERSION        0x0c
#define HCI_EV_QOS_SETUP_COMPLETE    0x0d
#define HCI_EV_CMD_COMPLETE            0x0e
#define HCI_EV_CMD_STATUS            0x0f
#define HCI_EV_ROLE_CHANGE            0x12
#define HCI_EV_NUM_COMP_PKTS        0x13
#define HCI_EV_MODE_CHANGE            0x14
#define HCI_EV_RETURN_LINK_KEYS        0x15
#define HCI_EV_PIN_CODE_REQ            0x16
#define HCI_EV_LINK_KEY_REQ            0x17
#define HCI_EV_LINK_KEY_NOTIFY        0x18
#define HCI_EV_CLOCK_OFFSET            0x1c
#define HCI_EV_PKT_TYPE_CHANGE        0x1d
#define HCI_EV_PSCAN_REP_MODE        0x20
#define HCI_EV_INQUIRY_RESULT_WITH_RSSI    0x22
#define HCI_EV_REMOTE_EXT_FEATURES    0x23
#define HCI_EV_SYNC_CONN_COMPLETE    0x2c
#define HCI_EV_SYNC_CONN_CHANGED    0x2d
#define HCI_EV_SNIFF_SUBRATE        0x2e
#define HCI_EV_EXTENDED_INQUIRY_RESULT    0x2f
#define HCI_EV_IO_CAPA_REQUEST        0x31
#define HCI_EV_SIMPLE_PAIR_COMPLETE    0x36
#define HCI_EV_REMOTE_HOST_FEATURES    0x3d
#define HCI_EV_VENDOR               0xff

/* Possible error codes */
#define HCI_UNKNOWN_HCI_COMMAND 0x01
#define HCI_NO_CONNECTION 0x02
#define HCI_HW_FAILURE 0x03
#define HCI_PAGE_TIMEOUT 0x04
#define HCI_AUTHENTICATION_FAILURE 0x05
#define HCI_KEY_MISSING 0x06
#define HCI_MEMORY_FULL 0x07
#define HCI_CONN_TIMEOUT 0x08
#define HCI_MAX_NUMBER_OF_CONNECTIONS 0x09
#define HCI_MAX_NUMBER_OF_SCO_CONNECTIONS_TO_DEVICE 0x0A
#define HCI_ACL_CONNECTION_EXISTS 0x0B
#define HCI_COMMAND_DISSALLOWED 0x0C
#define HCI_HOST_REJECTED_DUE_TO_LIMITED_RESOURCES 0x0D
#define HCI_HOST_REJECTED_DUE_TO_SECURITY_REASONS 0x0E
#define HCI_HOST_REJECTED_DUE_TO_REMOTE_DEVICE_ONLY_PERSONAL_SERVICE 0x0F
#define HCI_HOST_TIMEOUT 0x10
#define HCI_UNSUPPORTED_FEATURE_OR_PARAMETER_VALUE 0x11
#define HCI_INVALID_HCI_COMMAND_PARAMETERS 0x12
#define HCI_OTHER_END_TERMINATED_CONN_USER_ENDED 0x13
#define HCI_OTHER_END_TERMINATED_CONN_LOW_RESOURCES 0x14
#define HCI_OTHER_END_TERMINATED_CONN_ABOUT_TO_POWER_OFF 0x15
#define HCI_CONN_TERMINATED_BY_LOCAL_HOST 0x16
#define HCI_REPETED_ATTEMPTS 0x17
#define HCI_PAIRING_NOT_ALLOWED 0x18
#define HCI_UNKNOWN_LMP_PDU 0x19
#define HCI_UNSUPPORTED_REMOTE_FEATURE 0x1A
#define HCI_SCO_OFFSET_REJECTED 0x1B
#define HCI_SCO_INTERVAL_REJECTED 0x1C
#define HCI_SCO_AIR_MODE_REJECTED 0x1D
#define HCI_INVALID_LMP_PARAMETERS 0x1E
#define HCI_UNSPECIFIED_ERROR 0x1F
#define HCI_UNSUPPORTED_LMP_PARAMETER_VALUE 0x20
#define HCI_ROLE_CHANGE_NOT_ALLOWED 0x21
#define HCI_LMP_RESPONSE_TIMEOUT 0x22
#define HCI_LMP_ERROR_TRANSACTION_COLLISION 0x23
#define HCI_LMP_PDU_NOT_ALLOWED 0x24
#define HCI_ENCRYPTION_MODE_NOT_ACCEPTABLE 0x25
#define HCI_UNIT_KEY_USED 0x26
#define HCI_QOS_NOT_SUPPORTED 0x27
#define HCI_INSTANT_PASSED 0x28
#define HCI_PAIRING_UNIT_KEY_NOT_SUPPORTED 0x29

const char* EvtStr(int evt)
{
    switch (evt)
    {
        case HCI_EV_INQUIRY_COMPLETE:    return "HCI_EV_INQUIRY_COMPLETE";
        case HCI_EV_INQUIRY_RESULT:    return "HCI_EV_INQUIRY_RESULT";
        case HCI_EV_CONN_COMPLETE:    return "HCI_EV_CONN_COMPLETE";
        case HCI_EV_CONN_REQUEST:    return "HCI_EV_CONN_REQUEST";
        case HCI_EV_DISCONN_COMPLETE:    return "HCI_EV_DISCONN_COMPLETE";
        case HCI_EV_AUTH_COMPLETE:    return "HCI_EV_AUTH_COMPLETE";
        case HCI_EV_REMOTE_NAME:    return "HCI_EV_REMOTE_NAME";
        case HCI_EV_ENCRYPT_CHANGE:    return "HCI_EV_ENCRYPT_CHANGE";
        case HCI_EV_CHANGE_LINK_KEY_COMPLETE    :    return "HCI_EV_CHANGE_LINK_KEY_COMPLETE";
        case HCI_EV_REMOTE_FEATURES:    return "HCI_EV_REMOTE_FEATURES";
        case HCI_EV_REMOTE_VERSION:    return "HCI_EV_REMOTE_VERSION";
        case HCI_EV_QOS_SETUP_COMPLETE    :    return "HCI_EV_QOS_SETUP_COMPLETE";
        case HCI_EV_CMD_COMPLETE:    return "HCI_EV_CMD_COMPLETE";
        case HCI_EV_CMD_STATUS:    return "HCI_EV_CMD_STATUS";
        case HCI_EV_ROLE_CHANGE:    return "HCI_EV_ROLE_CHANGE";
        case HCI_EV_NUM_COMP_PKTS:    return "HCI_EV_NUM_COMP_PKTS";
        case HCI_EV_MODE_CHANGE:    return "HCI_EV_MODE_CHANGE";
        case HCI_EV_PIN_CODE_REQ:    return "HCI_EV_PIN_CODE_REQ";
        case HCI_EV_LINK_KEY_REQ:    return "HCI_EV_LINK_KEY_REQ";
        case HCI_EV_LINK_KEY_NOTIFY:    return "HCI_EV_LINK_KEY_NOTIFY";
        case HCI_EV_CLOCK_OFFSET:    return "HCI_EV_CLOCK_OFFSET";
        case HCI_EV_PKT_TYPE_CHANGE:    return "HCI_EV_PKT_TYPE_CHANGE";
        case HCI_EV_PSCAN_REP_MODE:    return "HCI_EV_PSCAN_REP_MODE";
        case HCI_EV_INQUIRY_RESULT_WITH_RSSI    :    return "HCI_EV_INQUIRY_RESULT_WITH_RSSI";
        case HCI_EV_REMOTE_EXT_FEATURES:    return "HCI_EV_REMOTE_EXT_FEATURES";
        case HCI_EV_SYNC_CONN_COMPLETE:    return "HCI_EV_SYNC_CONN_COMPLETE";
        case HCI_EV_SYNC_CONN_CHANGED:    return "HCI_EV_SYNC_CONN_CHANGED";
        case HCI_EV_SNIFF_SUBRATE:    return "HCI_EV_SNIFF_SUBRATE";
        case HCI_EV_EXTENDED_INQUIRY_RESULT:    return "HCI_EV_EXTENDED_INQUIRY_RESULT";
        case HCI_EV_IO_CAPA_REQUEST:    return "HCI_EV_IO_CAPA_REQUEST";
        case HCI_EV_SIMPLE_PAIR_COMPLETE:    return "HCI_EV_SIMPLE_PAIR_COMPLETE";
        case HCI_EV_REMOTE_HOST_FEATURES:    return "HCI_EV_REMOTE_HOST_FEATURES";
    }
    return "Unknown Event";
}

const char* CmdStr(int cmd)
{
    switch (cmd)
    {
        // 0x04XX
        case HCI_OP_INQUIRY:    return "HCI_OP_INQUIRY";
        case HCI_OP_INQUIRY_CANCEL:    return "HCI_OP_INQUIRY_CANCEL";
        case HCI_OP_EXIT_PERIODIC_INQ:    return "HCI_OP_EXIT_PERIODIC_INQ";
        case HCI_OP_CREATE_CONN:    return "HCI_OP_CREATE_CONN";
        case HCI_OP_DISCONNECT:    return "HCI_OP_DISCONNECT";
        case HCI_OP_ADD_SCO:    return "HCI_OP_ADD_SCO";
        case HCI_OP_CREATE_CONN_CANCEL:    return "HCI_OP_CREATE_CONN_CANCEL";
        case HCI_OP_ACCEPT_CONN_REQ:    return "HCI_OP_ACCEPT_CONN_REQ";
        case HCI_OP_REJECT_CONN_REQ:    return "HCI_OP_REJECT_CONN_REQ";
        case HCI_OP_LINK_KEY_REPLY:    return "HCI_OP_LINK_KEY_REPLY";
        case HCI_OP_LINK_KEY_NEG_REPLY:    return "HCI_OP_LINK_KEY_NEG_REPLY";
        case HCI_OP_PIN_CODE_REPLY:    return "HCI_OP_PIN_CODE_REPLY";
        case HCI_OP_PIN_CODE_NEG_REPLY:    return "HCI_OP_PIN_CODE_NEG_REPLY";
        case HCI_OP_CHANGE_CONN_PTYPE:    return "HCI_OP_CHANGE_CONN_PTYPE";
        case HCI_OP_AUTH_REQUESTED:    return "HCI_OP_AUTH_REQUESTED";
        case HCI_OP_SET_CONN_ENCRYPT:    return "HCI_OP_SET_CONN_ENCRYPT";
        case HCI_OP_CHANGE_CONN_LINK_KEY:    return "HCI_OP_CHANGE_CONN_LINK_KEY";
        case HCI_OP_REMOTE_NAME_REQ:    return "HCI_OP_REMOTE_NAME_REQ";
        case HCI_OP_REMOTE_NAME_REQ_CANCEL:    return "HCI_OP_REMOTE_NAME_REQ_CANCEL";
        case HCI_OP_READ_REMOTE_FEATURES:    return "HCI_OP_READ_REMOTE_FEATURES";
        case HCI_OP_READ_REMOTE_EXT_FEATURES:    return "HCI_OP_READ_REMOTE_EXT_FEATURES";
        case HCI_OP_READ_REMOTE_VERSION:    return "HCI_OP_READ_REMOTE_VERSION";
        case HCI_OP_SETUP_SYNC_CONN:    return "HCI_OP_SETUP_SYNC_CONN";
        case HCI_OP_ACCEPT_SYNC_CONN_REQ:    return "HCI_OP_ACCEPT_SYNC_CONN_REQ";
        case HCI_OP_REJECT_SYNC_CONN_REQ:    return "HCI_OP_REJECT_SYNC_CONN_REQ";
        // 0x0CXX
        case HCI_OP_SET_EVENT_MASK: return "HCI_OP_SET_EVENT_MASK";
        case HCI_OP_RESET:            return "HCI_OP_RESET";
        case HCI_OP_SET_EVENT_FLT:  return "HCI_OP_SET_EVENT_FLT";
        case HCI_OP_WRITE_LOCAL_NAME:   return "HCI_OP_WRITE_LOCAL_NAME";
        case HCI_OP_READ_LOCAL_NAME:    return "HCI_OP_READ_LOCAL_NAME";
        case HCI_OP_WRITE_CA_TIMEOUT:   return "HCI_OP_WRITE_CA_TIMEOUT";
        case HCI_OP_WRITE_PG_TIMEOUT:   return "HCI_OP_WRITE_PG_TIMEOUT";
        case HCI_OP_WRITE_SCAN_ENABLE:  return "HCI_OP_WRITE_SCAN_ENABLE";
        case HCI_OP_READ_AUTH_ENABLE:   return "HCI_OP_READ_AUTH_ENABLE";
        case HCI_OP_WRITE_AUTH_ENABLE:  return "HCI_OP_WRITE_AUTH_ENABLE";
        case HCI_OP_READ_ENCRYPT_MODE:  return "HCI_OP_READ_ENCRYPT_MODE";
        case HCI_OP_WRITE_ENCRYPT_MODE: return "HCI_OP_WRITE_ENCRYPT_MODE";
        case HCI_OP_READ_CLASS_OF_DEV:  return "HCI_OP_READ_CLASS_OF_DEV";
        case HCI_OP_WRITE_CLASS_OF_DEV:    return "HCI_OP_WRITE_CLASS_OF_DEV";
        case HCI_OP_READ_VOICE_SETTING: return "HCI_OP_READ_VOICE_SETTING";
        case HCI_OP_WRITE_VOICE_SETTING:    return "HCI_OP_WRITE_VOICE_SETTING";
        case HCI_OP_HOST_BUFFER_SIZE:   return "HCI_OP_HOST_BUFFER_SIZE";
        case HCI_OP_READ_SSP_MODE:      return "HCI_OP_READ_SSP_MODE";
        case HCI_OP_WRITE_SSP_MODE: return "HCI_OP_WRITE_SSP_MODE";

        // 10xx
        case HCI_OP_READ_LOCAL_VERSION: return "HCI_OP_READ_LOCAL_VERSION";
        case HCI_OP_READ_LOCAL_COMMANDS: return "HCI_OP_READ_LOCAL_COMMANDS";
        case HCI_OP_READ_LOCAL_FEATURES: return "HCI_OP_READ_LOCAL_FEATURES";
        case HCI_OP_READ_LOCAL_EXT_FEATURES: return "HCI_OP_READ_LOCAL_EXT_FEATURES";
        case HCI_OP_READ_BUFFER_SIZE: return "HCI_OP_READ_BUFFER_SIZE";
        case HCI_OP_READ_BD_ADDR: return "HCI_OP_READ_BD_ADDR";
    }
    return "Unknown Cmd";
}

const char* HCIErrStr(int err)
{
    switch (err)
    {
        case 0: return "OK";
        case HCI_UNKNOWN_HCI_COMMAND:    return "HCI_UNKNOWN_HCI_COMMAND";
        case HCI_NO_CONNECTION:    return "HCI_NO_CONNECTION";
        case HCI_HW_FAILURE:    return "HCI_HW_FAILURE";
        case HCI_PAGE_TIMEOUT:    return "HCI_PAGE_TIMEOUT";
        case HCI_AUTHENTICATION_FAILURE:    return "HCI_AUTHENTICATION_FAILURE";
        case HCI_KEY_MISSING:    return "HCI_KEY_MISSING";
        case HCI_MEMORY_FULL:    return "HCI_MEMORY_FULL";
        case HCI_CONN_TIMEOUT:    return "HCI_CONN_TIMEOUT";
        case HCI_MAX_NUMBER_OF_CONNECTIONS:    return "HCI_CONN_TIMEOUT";
        case HCI_MAX_NUMBER_OF_SCO_CONNECTIONS_TO_DEVICE:    return "HCI_MAX_NUMBER_OF_SCO_CONNECTIONS_TO_DEVICE";
        case HCI_ACL_CONNECTION_EXISTS:    return "HCI_ACL_CONNECTION_EXISTS";
        case HCI_COMMAND_DISSALLOWED:    return "HCI_COMMAND_DISSALLOWED";
        case HCI_HOST_REJECTED_DUE_TO_LIMITED_RESOURCES:    return "HCI_HOST_REJECTED_DUE_TO_LIMITED_RESOURCES";
        case HCI_HOST_REJECTED_DUE_TO_SECURITY_REASONS:    return "HCI_HOST_REJECTED_DUE_TO_SECURITY_REASONS";
        case HCI_HOST_REJECTED_DUE_TO_REMOTE_DEVICE_ONLY_PERSONAL_SERVICE:    return "HCI_HOST_REJECTED_DUE_TO_REMOTE_DEVICE_ONLY_PERSONAL_SERVICE";
        case HCI_HOST_TIMEOUT:    return "HCI_HOST_TIMEOUT";
        case HCI_UNSUPPORTED_FEATURE_OR_PARAMETER_VALUE:    return "HCI_UNSUPPORTED_FEATURE_OR_PARAMETER_VALUE";
        case HCI_INVALID_HCI_COMMAND_PARAMETERS:    return "HCI_INVALID_HCI_COMMAND_PARAMETERS";
        case HCI_OTHER_END_TERMINATED_CONN_USER_ENDED:    return "HCI_OTHER_END_TERMINATED_CONN_USER_ENDED";
        case HCI_OTHER_END_TERMINATED_CONN_LOW_RESOURCES:    return "HCI_OTHER_END_TERMINATED_CONN_LOW_RESOURCES";
        case HCI_OTHER_END_TERMINATED_CONN_ABOUT_TO_POWER_OFF:    return "HCI_OTHER_END_TERMINATED_CONN_ABOUT_TO_POWER_OFF";
        case HCI_CONN_TERMINATED_BY_LOCAL_HOST:    return "HCI_CONN_TERMINATED_BY_LOCAL_HOST";
        case HCI_REPETED_ATTEMPTS:    return "HCI_REPEATED_ATTEMPTS";
        case HCI_PAIRING_NOT_ALLOWED:    return "HCI_PAIRING_NOT_ALLOWED";
        case HCI_UNKNOWN_LMP_PDU:    return "HCI_UNKNOWN_LMP_PDU";
        case HCI_UNSUPPORTED_REMOTE_FEATURE:    return "HCI_UNSUPPORTED_REMOTE_FEATURE";
        case HCI_SCO_OFFSET_REJECTED:    return "HCI_SCO_OFFSET_REJECTED";
        case HCI_SCO_INTERVAL_REJECTED:    return "HCI_SCO_INTERVAL_REJECTED";
        case HCI_SCO_AIR_MODE_REJECTED:    return "HCI_SCO_AIR_MODE_REJECTED";
        case HCI_INVALID_LMP_PARAMETERS:    return "HCI_INVALID_LMP_PARAMETERS";
        case HCI_UNSPECIFIED_ERROR:    return "HCI_UNSPECIFIED_ERROR";
        case HCI_UNSUPPORTED_LMP_PARAMETER_VALUE:    return "HCI_UNSUPPORTED_LMP_PARAMETER_VALUE";
        case HCI_ROLE_CHANGE_NOT_ALLOWED:    return "HCI_ROLE_CHANGE_NOT_ALLOWED";
        case HCI_LMP_RESPONSE_TIMEOUT:    return "HCI_LMP_RESPONSE_TIMEOUT";
        case HCI_LMP_ERROR_TRANSACTION_COLLISION:    return "HCI_LMP_ERROR_TRANSACTION_COLLISION";
        case HCI_LMP_PDU_NOT_ALLOWED:    return "HCI_LMP_PDU_NOT_ALLOWED";
        case HCI_ENCRYPTION_MODE_NOT_ACCEPTABLE:    return "HCI_ENCRYPTION_MODE_NOT_ACCEPTABLE";
        case HCI_UNIT_KEY_USED:    return "HCI_UNIT_KEY_USED";
        case HCI_QOS_NOT_SUPPORTED:    return "HCI_QOS_NOT_SUPPORTED";
        case HCI_INSTANT_PASSED:    return "HCI_INSTANT_PASSED";
        case HCI_PAIRING_UNIT_KEY_NOT_SUPPORTED:    return "HCI_PAIRING_UNIT_KEY_NOT_SUPPORTED";
    };
    return "Unknow HCI err";
};


#endif // HCI_PRIVATE_H_INCLUDED
