
#include "mbed.h"
#include <vector>
#include "Utils.h"
#include "USBHost.h"
#include "hci.h"
#include "HCITransportUSB.h"
#include "RFCOMM.h"
#include "ftclasslibusbdevbt.h"
#include "sdp_data.h"
#include "sdp.h"
#include "btserial.h"
#include "neighbourhood.h"
#include "GPS.h"
#include "GSM.h"
#include "C12832.h"
#include <string>


C12832 lcd(p5, p7, p6, p8, p11);
GPS gps(p28, p27);


/************************************************
Dr.Faycal Bensaali, Dr.Fadi Jaber, Sami Alshorman
************************************************/
// GSM PART
#define PHONE_NUMBER            "0097455303701"

#define SEND_SMS_TEST           1
#define CALL_UP_TEST            0
#define ANSWER_TEST             0
#define READ_SMS_TEST           0
#define DEBUG   1
int state = 0;


GSM gsm(p9, p10, 19200, PHONE_NUMBER);

void messageHandle(void)
{        
     __disable_irq();
    int messageType = gsm.loopHandle();
    if(MESSAGE_RING == messageType) {
        gsm.answer();
    } else if(MESSAGE_SMS == messageType) {
        char smsMessage[SMS_MAX_LENGTH];
        gsm.getSMS(smsMessage);
    }
    __enable_irq();
}
// END OF GSM PART


//int bulk = 0;
void printf(const BD_ADDR* addr) {
    const u8* a = addr->addr;
    printf("%02X:%02X:%02X:%02X:%02X:%02X",a[5],a[4],a[3],a[2],a[1],a[0]);
}


class application : public HCI {
    BTDevice* devs[8];
    int count, i, pending;
public:
    void ConnectionComplete(connection_info* info) {
        printf("ConnectionComplete ");
        BD_ADDR* a = &info->bdaddr;
        printf(a);
        printf("\n");
        RemoteNameRequest(a);
        for (i++; i < count; i++) {//find the next device to open
            printfBytes("DEVICE CLASS",devs[i]->_info.dev_class,3);
            //if (devs[i]->_handle == 0 && memcmp(devs[i]->_info.dev_class, FtDevClass, 3)==0) {//or some other way to connect to RFCOMM devices
            if (devs[i]->_handle == 0) { // 
                BD_ADDR* bd = &devs[i]->_info.bdaddr;
                printf("Connecting to ");
                printf(bd);
                printf("\n");
                pending++;
                CreateConnection(bd); //some low level connect, just let it happen for now (sets pin, mtu etc.)
                printf("connection cmd was sent\n");
                return;
            }
        }
    }

    void ConnectDevices() {
        count = GetDevices(devs,8);//get pointers to all bluetooth devices
        pending = 0;
        for (i = 0; i < count; i++) {
            printfBytes("DEVICE CLASS",devs[i]->_info.dev_class,3);
            if (devs[i]->_handle == 0 /*&& memcmp(devs[i]->_info.dev_class, FtDevClass, 3)==0*/) {//or some other way to connect to RFCOMM devices
                BD_ADDR* bd = &devs[i]->_info.bdaddr;
                printf("Connecting to ");
                printf(bd);
                printf("\n");
                pending++;
                CreateConnection(bd); //some low level connect, just let it happen for now (sets pin, mtu etc.)
                printf("connection cmd was sent\n");
                return;
            }
        }
        if (pending == 0) state = 1;//for the case when there are no ft devices
    }
    virtual void Callback(HCI_CALLBACK_EVENT c, const u8* data, int len);
    int csr_write_bd_addr(BD_ADDR *bdaddr, bool transient=true);
    int csr_reset_device(bool transient=true);
} App; //application instance

extern "C" void mbed_reset();


void application::Callback(HCI_CALLBACK_EVENT evt, const u8* data, int len) {//these events are forwarded (in)directly from HCIRecv
    unsigned char pin[] = "681010";
    unsigned char newaddr[] = {0x14, 0xd4, 0x00, 0x05, 0x1c, 0x00};//possible ft TX address (ROBO TX-277)
//    unsigned char newaddr[] = {0x57, 0x0a, 0x3d, 0x83, 0x15, 0x00};//original address of the cheap round BT dongle
    printf("\x1b[%dm", 33);
    switch (evt) {
        case CALLBACK_READY:
            printf("CALLBACK_READY\n");
            printf("my address = ");
            printf((BD_ADDR*)data);
            if (memcmp(newaddr, data, 6) != 0) { //csr_write_bd_addr((BD_ADDR*)newaddr, false);
            }
            Inquiry();//start the second phase of the discovery
            break;

        case CALLBACK_INQUIRY_RESULT: //optionally build the list of FT devices here
            printf("CALLBACK_INQUIRY_RESULT ");
            printf((BD_ADDR*)data);
            printf("\n");//data points to inquiry_info struct
            break;

        case CALLBACK_INQUIRY_DONE:
            printf("CALLBACK_INQUIRY_DONE\n");
            neighbors = new neighbourhood(&App);
            neighbors->read();
            ConnectDevices();
            break;

        case CALLBACK_REMOTE_NAME: {
            BD_ADDR* addr = (BD_ADDR*)data;
            const char* name = (const char*)(data + 6);
            printf(addr);
            printf(" = % s\n",name);
            pending--;
            if (pending == 0) state = 1;
        }
        break;

        case CALLBACK_CONNECTION_COMPLETE: {
            connection_info *ci = (connection_info*)data;
            if (ci->status>0) {
                printf("Connection failed, status=0x%02X\n", ci->status);
                break;
            }
            ConnectionComplete(ci);
            printf("Going to open sdp socket\n");
            L2CAPAddr addr;
            memcpy(&addr.bdaddr, &ci->bdaddr, 6);
        }
        break;
        case CALLBACK_PIN_REQ:
            printf("Enter PIN for ");
            printf((BD_ADDR*)data);
            printf(" :  submitting %s\n", pin);
            PinCodeReply(data, pin);
            break;
        case CALLBACK_VENDOR:
            printfBytes("Vendor Reply:", data, len);
            if (data[0] == 0xc2)
                csr_reset_device(false);
           break;
        default:
            printf("Unhandled HCI Callback %d\n", evt);
    };
    printf("\x1b[%dm", 0);
}

#define CSR_WRITE        0xFC00

int application::csr_write_bd_addr(BD_ADDR *bdaddr, bool transient) {
    unsigned char cmd[] = { 0xc2,
                            0x02, 0x00, 0x0c, 0x00, 0x11, 0x47, 0x03, 0x70,
                            0x00, 0x00, 0x01, 0x00, 0x04, 0x00, 0x00, 0x00,
                            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                          };

    if (transient)
        cmd[15] = 0x08;

    cmd[17] = bdaddr->addr[2];
    cmd[18] = 0x00;
    cmd[19] = bdaddr->addr[0];
    cmd[20] = bdaddr->addr[1];
    cmd[21] = bdaddr->addr[3];
    cmd[22] = 0x00;
    cmd[23] = bdaddr->addr[4];
    cmd[24] = bdaddr->addr[5];

    return SendCmd(CSR_WRITE, cmd, sizeof(cmd));
}

int application::csr_reset_device(bool transient) {
    unsigned char cmd[] = { 0xc2, 0x02, 0x00, 0x09, 0x00,
                            0x00, 0x00, 0x01, 0x40, 0x00, 0x00,
                            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                          };

    if (transient)
        cmd[7] = 0x02;

    return SendCmd(CSR_WRITE, cmd, sizeof(cmd));
}


//  these should be placed in the DMA SRAM
typedef struct {
    u8 _hciBuffer[MAX_HCL_SIZE];
    u8 _aclBuffer[MAX_ACL_SIZE];
} SRAMPlacement;

HCITransportUSB _HCITransportUSB;  //use USB as the transport to the radio

int OnBluetoothInsert(int device) {//install the HCI and start discovery, user callbacks are made to HciCalback
    printf("Bluetooth inserted of %d\n",device);
    u32 sramLen;
    u8* sram =  USBGetBuffer(&sramLen);
    sram = (u8*)(((u32)sram + 1023) & ~1023);
    SRAMPlacement* s = (SRAMPlacement*)sram;
    _HCITransportUSB.Open(device,s->_hciBuffer,s->_aclBuffer);//setup buffers for USB host, incoming data goes first to HCIRecv and ACLRecv
    RegisterSocketHandler(SOCKET_L2CAP,&App); //register the application::hci as handler for L2CAP events
    RegisterSocketHandler(SOCKET_RFCOM, &rfcomm_manager);//set the RFCOMMManager as the RFCOM socket handler
    if (RegisterSocketHandler(SOCKET_SDP, &SDP))
        printf("Could not register SDP socket type\n");
    App.Open(&_HCITransportUSB);//the callback is virtual
    App.Inquiry();//start discovery of BT devices phase 0
    return 0;
}

DigitalOut led(LED1), loop(LED2);

int comm = 0;
btserial *incoming, *outgoing;

void echo(int socket, SocketState state, const u8* data, int len, void* userData) {
    const u8 connack[] = { 0xbe, 0xef, 8, 'C','O','N','N','_','A','C','K', 0x11};
    printf("Echo: socket %d, state %d, len=%d\n", socket, state, len);
    if (state==SocketState_Open) {
        if (len == 0) {
            printf("Sending CONN_ACK\n");
            Socket_Send(socket, connack, sizeof(connack));
        } else {
            printf("echo back: len=%d, data[0]=%x\n", len, data[0]);
            Socket_Send(socket, data, len);  // uncomment
            printfBytes("echo:", data, len);
        }
    }
}

void TestShell() {
   char newaddr[] = {0x14, 0xd4, 0x00, 0x05, 0x1c, 0x00};
   string n;
   int x=0;
   short int c[3], SPO2, HR;
   int QEWS;
   int SCORE_S;
   int SCORE_H;
   

    USBInit();

    for( ; ;) {  
    
        switch (state) {
            case 0: //inquiry and low-level connection
                break;
            case 1: {//initialisation
                state = 2;
                incoming = new btserial(newaddr,1);
                
            }
            break;
            case 2://main loop

              
                   if (incoming->readable()>0)
                   { 
                             c[x]= incoming->getc();
                           
                             if (x==3) 
                             {
                                 SPO2 = c[2];
                                 HR = (c[1] & 0x7F) | ((c[0] & 0x03) << 7);                   
                                 lcd.printf("HR   is: %d \nSPo2 is: %d",HR, SPO2);
  
                                  if(SPO2 >= 0x60) SCORE_S=0;
                                   else if((SPO2 >= 0x5D) && (SPO2 <= 0x5F)) SCORE_S=1;
                                   else if((SPO2 >= 0x5A) && (SPO2 <= 0x5C)) SCORE_S=2; 
                                   else SCORE_S = 3;
                                   
                                       if(( HR >= 0x32)&& (HR <= 0x64)) SCORE_H=0;
                                       else if((( HR >= 0x65)&& (HR <= 0x6E))|| (( HR >= 0x29)&& (HR <= 0x32)))SCORE_H=1;  
                                       else if((( HR >= 0x6F)&& (HR <= 0x81))|| (( HR >= 0x1F)&& (HR <= 0x28)))SCORE_H=2; 
                                       else SCORE_H = 3;
                                    
                                    QEWS=SCORE_S +SCORE_H;
                                    
                                    
             
                                             lcd.printf("\n QEWS   is: %d",QEWS);
                                    //         wait(5);
                                             
                                     if  ( QEWS>0)
                                     {       
                                                while(gps.sample()==0);
                                                
                                                lcd.printf("I'm at %f, %f\n", gps.longitude, gps.latitude);  


                                                   while(0 != gsm.init()) {
                                                        wait(2);
                                                    }
                                                    char buffer[100];
                                                // n=sprintf (buffer, "%s,%f,\n %s,%f", "long:",gps.longitude,"Alt:",gps.latitude);
                                                 n=sprintf (buffer, "%s \n %s %d %s \n %s %d %s \n %s %d \n %s \n %s %f \n %s %f", "Patient 1" ,"SPO2 is ", SPO2,"% ","HR is ",HR,"bpm","QEWS is ",QEWS,"GPS coordinates: ","Longitude is ",gps.longitude,"Latitude is ",gps.latitude);
                                                                                                   
                                                #if SEND_SMS_TEST
                                                    //gsm.sendSMS(PHONE_NUMBER, "salam from sami alshorman");
                                                    gsm.sendSMS(PHONE_NUMBER,buffer);
                                                    
                                                #endif
                                                
                                                #if CALL_UP_TEST
                                                    gsm.callUp(PHONE_NUMBER);
                                                #endif
                                                
                                                #if ANSWER_TEST || READ_SMS_TEST
                                                    gsm.gsmSerial.attach(&messageHandle);
                                                #endif
                                                
                                      }          

                                 wait(5);  
                                 mbed_reset();

                             }

                             x++;
                   
                     } 
 
                 
                 break;                  
            default:
                break;
        }
        
     USBLoop();     
    }
}

