#ifndef HCITRANSPORTUSB_H
#define HCITRANSPORTUSB_H
#define MAX_HCL_SIZE 260
#define MAX_ACL_SIZE 400
#include "USBHost.h"

extern int bulk;

class HCITransportUSB : public HCITransport {
    int _device;
    u8* _hciBuffer;
    u8* _aclBuffer;

public:
    void Open(int device, u8* hciBuffer, u8* aclBuffer) {
        _device = device;
        _hciBuffer = hciBuffer;
        _aclBuffer = aclBuffer;
        USBInterruptTransfer(_device,0x81,_hciBuffer,MAX_HCL_SIZE,HciCallback,this);
        USBBulkTransfer(_device,0x82,_aclBuffer,MAX_ACL_SIZE,AclCallback,this);
    }

    static void HciCallback(int device, int endpoint, int status, u8* data, int len, void* userData) {
        HCI* t = ((HCITransportUSB*)userData)->_target; //printf("HCI: %d bytes avail\n", len);
        if (t){
        printfBytes("HCICallback:", data, len);
            t->HCIRecv(data,len);
            }
        USBInterruptTransfer(device,0x81,data,MAX_HCL_SIZE,HciCallback,userData);
    }

    static void AclCallback(int device, int endpoint, int status, u8* data, int len, void* userData) {
        HCI* t = ((HCITransportUSB*)userData)->_target; printf("ACL: %d bytes avail\n", len);
        if (t){
        printfBytes("ACLCallback:", data, len);
            t->ACLRecv(data,len);
            }
            printf("ACL Read pending..\n");
        USBBulkTransfer(device,0x82,data,MAX_ACL_SIZE,AclCallback,userData);
    }

    virtual void HCISend(const u8* data, int len) {
        printfBytes("HCISend:", data, len);
        USBControlTransfer(_device,REQUEST_TYPE_CLASS, 0, 0, 0,(u8*)data,len);
    }

    virtual int ACLSend(const u8* data, int len) { //printf("send %d bytes to usb\n", len);
        if (len > _acl_mtu) {
            printf("Max outgoing packet(%d) size exceeded, segmenting necessary, pktlen = %d\n", _acl_mtu, len);
            return 0;
        }
#ifdef HOST_CONTR_FLOW
        if (data_credits == 0)
          printf("Waiting for ACL buffers...\n");
        while (data_credits < 1) {
            USBLoop();
        }
        data_credits--;
#endif
        printfBytes("ACLSend:", data, len);
        return USBBulkTransfer(_device,0x02,(u8*)data,len);
    }
};

#endif
