#ifndef BTSERIAL_H
#define BTSERIAL_H
#include "mbed.h"
#include "RFCOMM.h"

class btserial {
    static const int bufsize = 4;
    int recbufsize, sndbufsize;
    int sock;
    unsigned char sendbuf[bufsize], recbuf[bufsize];
    int sendptr, recptrin, recptrout, free;
    static void cb(int socket, SocketState state, const unsigned char *data, int len, void* userData);
    void stash(const unsigned char *data, int len);
    bool open;
public:
    btserial(char ba[6], char ch);//outgoing
    btserial(char ch);//incoming
    void baud(int);
    void format(int, Serial::Parity, int);
    int putc(int);
    int getc();
    int readable() {
        if (!open) return -1;
        return bufsize-free;
    }
    int writeable() {
        if (!open) return -1;
        return bufsize - sendptr;
    }
};

#endif