#include "mbed.h"

AnalogIn ain(p20);      //interrupt pin
  
DigitalOut led[]= {p19,p18,p17,p16,p15,p14,p13,p12};   //b,a,f,g,e,d,c,dp

int number[11][8]= {
    {1,1,1,0,1,1,1,0},      // 0
    {1,0,0,0,0,0,1,0},      // 1
    {1,1,0,1,1,1,0,0},      // 2
    {1,1,0,1,0,1,1,0},      // 3
    {1,0,1,1,0,0,1,0},      // 4
    {0,1,1,1,0,1,1,0},      // 5
    {0,1,1,1,1,1,1,0},      // 6
    {1,1,0,0,0,0,1,0},      // 7
    {1,1,1,1,1,1,1,0},      // 8
    {1,1,1,1,0,1,1,0},      // 9
    {0,0,0,0,0,0,0,1}       // dp
};

//function for glowing seven segment display
int glow(int no)
{
    for(int i=0; i<8; i++)
        led[i]=number[no][i];    
    return 1;
}

int main()
{
    int j = 0; // Set counter to zero
    
    float x;
    
    while (1) {
        if(j>5)  // Count to a maximum no 5
           j=0;
         
        x=ain.read();
        
        if (x > 0.35) {
            glow(++j);  //Increment the counter whenever voltage at interrupt pin is greater than a threshold (in my case it is 0.35)
            wait(2);
        } 
        else
            glow(j);
    }
}