#include "mbed.h"
#include <string>
#include "eeprom.h"


#define EEPROM_ADDR 0x0   // I2c EEPROM address is 0x00

#define SDA p9            // I2C SDA pin
#define SCL p10           // I2C SCL pin

#define MIN(X,Y) ((X) < (Y) ? (X) : (Y))
#define MAX(X,Y) ((X) > (Y) ? (X) : (Y))

#define MB_ID 0x00
#define NO_OF_DEV 0x01
#define DEV_1_ID 0x02
#define DEV_1_ST 0x03
#define DEV_1_VAL 0x04
#define DEV_2_ID 0x05
#define DEV_2_ST 0x06
#define DEV_2_VAL 0x07
#define DEV_3_ID 0x08
#define DEV_3_VAL 0x09
#define DEV_4_ID 0x0A
#define DEV_4_ST 0x0B
#define DEV_4_VAL 0x0C

int mb_ID = 0x00;
int NOno_of_dev = 0x00;
int dev_1_id = 0x00;
int dev_1_st = 0x00;
int dev_1_val = 0x00;
int dev_2_id = 0x00;
int dev_2_st = 0x00;
int dev_2_val = 0x00;
int dev_3_id = 0x00;
int dev_3_st = 0x00;
int dev_3_val = 0x00;
int dev_4_id = 0x00;
int dev_5_st = 0x00;
int dev_6_val = 0x00;


typedef struct _MyData {
                         int16_t sdata;
                         int32_t idata;
                         float fdata;
                       } MyData;
                       
                       
//static void myerror(std::string msg)
//{
//  printf("Error %s\n",msg.c_str());
//  exit(1);
//}

int ID_Map(int8_t id)
{
    int return_val =0;
    
    if (id == 0x01) //ethernet
    return_val=DEV_1_ID;
    
    else if (id == 0x02)    //CAN
    return_val=DEV_2_ID;
    
    else if (id ==0x03)     //tem
    return_val=DEV_3_ID;
    
    else if (id == 0x04)    //aceslometer
    return_val=DEV_3_ID;
    
    else 
    return_val= -1;
    
    return return_val;
    }
    
bool healthWrite( int8_t id, int8_t status, int8_t val)
 {  
     EEPROM eep(SDA,SCL,EEPROM_ADDR,EEPROM::T24C128);  // 24C64 eeprom with sda = p9 and scl = p10
     int8_t add = ID_Map(id);
     bool return_val = false;
     if (add == 0)
     {
        printf("\r\n EEPROM not working..!!!");
        return_val = false;
     }
     else if (add == -1)
     {
        printf("\r\n Wrong Memory address..!!!");
        return_val = false;
     }
     else
     {
        
        eep.write(add,id);
        if(eep.getError() != 0)
            return_val = false;
        else 
            return_val = true;
       
        eep.write(add+1,status);
        if(eep.getError() != 0)
            return_val = false;
        else 
            return_val = true;
    
        eep.write(add+2,val);
        if(eep.getError() != 0)
            return_val = false;
        else 
            return_val = true;
        }
    
    //printf("\r\n Memory \r\n");
    //printf("\r\n %3d \r\n",i);
    //printf("\r\n Value is \r\n");  
    //printf("\r\n %3d \r\n",ival);
     
     return return_val;
     }
     
int healthReadStatus( int8_t id)
{
     EEPROM eep(SDA,SCL,EEPROM_ADDR,EEPROM::T24C128);  // 24C64 eeprom with sda = p9 and scl = p10
     int8_t add = ID_Map(id);
     int return_val = -1;
     int8_t Status;
     if (add == 0)
     {
        printf("\r\n EEPROM not working..!!!");
        return_val = -1;
     }
     else if (add == -1)
     {
        printf("\r\n Wrong Memory address..!!!");
        return_val = -1;
     }
     else
     {
        eep.read(add+1,Status);
        if (eep.getError() != 0)
            return_val = -1;
        
        else return_val=Status;
    } 
    return return_val;
 
 }
 int healthReadValue( int8_t id)
{
     EEPROM eep(SDA,SCL,EEPROM_ADDR,EEPROM::T24C128);  // 24C64 eeprom with sda = p9 and scl = p10
     int8_t add = ID_Map(id);
     int8_t val;
     int8_t return_val = -1;
     if (add == 0)
     {
        printf("\r\n EEPROM not working..!!!");
        return_val = -1;
     }
     else if (add == -1)
     {
        printf("\r\n Wrong Memory address request..!!!");
        return_val = -1;
     }
     else
     {
        eep.read(add+2,val);
        if(eep.getError() != 0)
            return_val = -1;
        
        else 
            return_val = val;
            
        }
    return return_val;
}
 
int main() {
    EEPROM eep(SDA,SCL,EEPROM_ADDR,EEPROM::T24C128);  // 24C64 eeprom with sda = p9 and scl = p10
    //uint8_t data[256],data_r[256];
    //int8_t ival;
    //uint16_t s;
    //int16_t sdata,sdata_r;
    //int32_t ldata[1024];
    int32_t max_size,eeprom_size;
    //uint32_t addr;
    //int32_t idata,idata_r;
    //uint32_t i; //,j,k,l,t,id;
    //float fdata,fdata_r;
    //MyData md,md_r;
    
    eeprom_size = eep.getSize();
    max_size = MIN(eeprom_size,256);
  
    printf("\r\n Test EEPROM I2C model %s of %d bytes\r\n",eep.getName(),eeprom_size);
    
    int8_t id =0x02;
    
    //healthWrite( int8_t id, int8_t status, int8_t val)
    bool helthW = healthWrite( id ,0x01, 0x05);
    
    if (helthW == true)
    {
         printf("\r\n helth write successfull \r\n");
        }
    else 
    {
        printf("\r\n helth write NOT successfull\r\n");
        }
///////////////////////////////////////////////////////////////////////
    int helthRS = healthReadStatus(id);

    if (helthRS == -1)
    {
         printf("\r\n helth read NOT successfull...!!! \r\n");
        }
    else 
    {
        printf("\r\n  device %X Status %X \r\n",id,helthRS);
        }
/////////////////////////////////////////////////////////////////////
    int helthRV = healthReadValue(id);
    if (helthRV == -1)
    {
         printf("\r\n helth read NOT successfull...!!! \r\n");
        }
    else 
    {
        printf("\r\n device %X Value %X \r\n",id, helthRV);
        }
//////////////////////////////////////////////////////////////////        
//    
//    i=2;
//    
//    eep.read(i,ival);
//    if(eep.getError() != 0)
//       myerror(eep.getErrorMessage());
//    
//    printf("\r\n Memory \r\n");
//    printf("\r\n %3d \r\n",i);
//    printf("\r\n Value is \r\n");  
//    printf("\r\n %3d \r\n",ival);
//    
//    ival = 3;
//    
//    eep.write(i,ival);
//    if(eep.getError() != 0)
//       myerror(eep.getErrorMessage());
//    
//    printf("\r\n Memory \r\n");
//    printf("\r\n %3d \r\n",i);
//    printf("\r\n Value is \r\n");  
//    printf("\r\n %3d \r\n",ival);
    
  
    while(1) {

    }
}
