#ifndef __OLED_H
#define __OLED_H			  	 


//-----------------OLEDport defination---------------- 
#define OLED_CMD  0	//Send commend
#define OLED_DATA 1	//Send data

#define FONT12			12
#define FONT16 			16
#define	LINE_1_FONT12	0
#define	LINE_2_FONT12	12
#define	LINE_3_FONT12	24
#define	LINE_4_FONT12	36
#define	LINE_5_FONT12	48
#define	LINE_6_FONT12	52


#define	LINE_1_FONT16	0
#define	LINE_2_FONT16	16
#define	LINE_3_FONT16	32
#define	LINE_4_FONT16	48


class oled
{
    public:
    
    	/** Create a oled control interface    
	     *
	     * @param oled_SCL A DigitalOut, Clock pin 
	     * @param oled_SDA A DigitalOut, Data pin 
	     * @param oled_RES A DigitalOut, Reset pin 
	     * @param oled_DC A DigitalOut, Command Pin
	     */
    	oled(PinName oled_SCL, PinName oled_SDA, PinName oled_RES, PinName oled_DC);
    	
    	 /** Draw a point on screen at specific co-ordinate
	     * 
	     * @param x An unisgned integer byte, X co-ordinate of the point to be draw on screen (Range from 0~127)
		 * @param y An unisgned integer byte, Y co-ordinate of the point to be draw on screen (Range from 0~63)
		 * @param t A boolean, 1 = Fill, 0=Clear		
	     */
		void OLED_DrawPoint(uint8_t x,uint8_t y,bool t);
		
		/** Display a charcter at specific position
	     * 
	     * @param x An unisgned integer byte, X co-ordinate of the point to be draw on screen (Range from 0~127)
		 * @param y An unisgned integer byte, Y co-ordinate of the point to be draw on screen (Range from 0~63)
		 * @param chr An unisgned integer byte, the character to be display
		 * @param size An unisgned integer byte, the font size of the character (12pt or 16pt)
		 * @param mode A boolean, 0 = inverted display,  1 = normal display
	     */
		void OLED_ShowChar(uint8_t x,uint8_t y,uint8_t chr,uint8_t size,bool mode);
		
		/** Display a number at specific position
	     * 
	     * @param x An unisgned integer byte, X co-ordinate of the point to be draw on screen (Range from 0~127)
		 * @param y An unisgned integer byte, Y co-ordinate of the point to be draw on screen (Range from 0~63)
		 * @param size An unisgned integer byte, the font size of the character (12pt or 16pt)
	  	 * @param num An unisgned integer 32bit, value of the number to be display
	     */
		void OLED_ShowNumber(uint8_t x,uint8_t y,uint8_t size, uint32_t num );
		
		/** Display a string at specific position with 16 x 8 font size
	     * 
	     * @param x An unisgned integer byte, X co-ordinate of the point to be draw on screen (Range from 0~127)
		 * @param y An unisgned integer byte, Y co-ordinate of the point to be draw on screen (Range from 0~63)
		 * @param size An unisgned integer byte, the font size of the character (12pt or 16pt)
		 * @param *p A string pointer, the address of the string to be display on screen (Maximium 16 characters for a line)
	     */
		void OLED_ShowString(uint8_t x,uint8_t y,uint8_t size,const uint8_t *p);
		
		
		void OLED_Display_On(void);
		void OLED_Display_Off(void);	
		void OLED_Refresh(void);
		void OLED_Clear(void);
		
		
    private:
        DigitalOut _oled_SCL;
        DigitalOut _oled_SDA;
        DigitalOut _oled_RES;
        DigitalOut _oled_DC;
        uint8_t _OLED_GRAM[128][8];	 
        uint32_t oled_pow(uint8_t m,uint8_t n);
        void OLED_WR_Byte(uint8_t dat,uint8_t cmd);  
        void OLED_RST_Clr(void);
        void OLED_RST_Set(void);
		void OLED_RS_Clr(void);
		void OLED_RS_Set(void);
		void OLED_SCLK_Clr(void);
		void OLED_SCLK_Set(void);
		void OLED_SDIN_Clr(void);
		void OLED_SDIN_Set(void); 

        
};
	 
#endif  
	 
