#include "mbed.h"
#include "oled.h"
#include "oledfont.h"  	 
#include "stdlib.h"


//initialize OLED					    
oled::oled(PinName oled_SCL, PinName oled_SDA, PinName oled_RES, PinName oled_DC):_oled_SCL(oled_SCL), _oled_SDA(oled_SDA), _oled_RES(oled_RES), _oled_DC(oled_DC)
{ 	
	OLED_RST_Clr();
	wait_ms(100);
	OLED_RST_Set(); 
					  
	OLED_WR_Byte(0xAE,OLED_CMD); //Shut down display
	OLED_WR_Byte(0xD5,OLED_CMD); //Set clock division,oscillation frequency
	OLED_WR_Byte(80,OLED_CMD);   //[3:0],clock division;[7:4],oscillation frequency
	OLED_WR_Byte(0xA8,OLED_CMD); //Set driving channel
	OLED_WR_Byte(0X3F,OLED_CMD); //default 0X3F(1/64) 
	OLED_WR_Byte(0xD3,OLED_CMD); //Set display shift
	OLED_WR_Byte(0X00,OLED_CMD); //default=0

	OLED_WR_Byte(0x40,OLED_CMD); //Set display start coloum [5:0], coloum number.
													    
	OLED_WR_Byte(0x8D,OLED_CMD); //Set charge pump
	OLED_WR_Byte(0x14,OLED_CMD); //Start/Shut down
	OLED_WR_Byte(0x20,OLED_CMD); //Set flash address mode
	OLED_WR_Byte(0x02,OLED_CMD); //[1:0],00,row address mode;01,coloum address mode;10,page address mode;default=10;
	OLED_WR_Byte(0xA1,OLED_CMD); //Redefine Set,bit0: 0,0->0;1,0->127;
	OLED_WR_Byte(0xC0,OLED_CMD); //Set COM scan direction;bit3:0,Normal mode;1,redefine mode COM[N-1]->COM0;N: driving channel
	OLED_WR_Byte(0xDA,OLED_CMD); //Set COM pin assignment
	OLED_WR_Byte(0x12,OLED_CMD); //[5:4]Setup
		 
	OLED_WR_Byte(0x81,OLED_CMD); //Set contrast
	OLED_WR_Byte(0xEF,OLED_CMD); //1~255;default 0X7F (Set brightness)
	OLED_WR_Byte(0xD9,OLED_CMD); //Set pre-charge period
	OLED_WR_Byte(0xf1,OLED_CMD); //[3:0],PHASE 1;[7:4],PHASE 2;
	OLED_WR_Byte(0xDB,OLED_CMD); //Set VCOMH voltage rate
	OLED_WR_Byte(0x30,OLED_CMD); //[6:4]

	OLED_WR_Byte(0xA4,OLED_CMD); //Whole display start; bit0: 1=start, 0=Shut down;
	OLED_WR_Byte(0xA6,OLED_CMD); //Set display mode; bit0: 1=inverted display,0=normal display	    						   
	OLED_WR_Byte(0xAF,OLED_CMD); //Open display	 
	OLED_Clear();
}

//turn on OLED display    
void oled::OLED_Display_On(void)
{
	OLED_WR_Byte(0X8D,OLED_CMD);  //SET DCDC command
	OLED_WR_Byte(0X14,OLED_CMD);  //DCDC ON
	OLED_WR_Byte(0XAF,OLED_CMD);  //DISPLAY ON
}

//Shutdown OLED display     
void oled::OLED_Display_Off(void)
{
	OLED_WR_Byte(0X8D,OLED_CMD);  //SET DCDC command
	OLED_WR_Byte(0X10,OLED_CMD);  //DCDC OFF
	OLED_WR_Byte(0XAE,OLED_CMD);  //DISPLAY OFF
}	

//Draw a point 
//x:0~127
//y:0~63
//t:1=Fill, 0=Clear				   
void oled::OLED_DrawPoint(uint8_t x,uint8_t y,bool t)
{
	uint8_t pos,bx,temp=0;
	if(x>127||y>63)return;//Out of range
	pos=7-y/8;
	bx=y%8;
	temp=1<<(7-bx);
	if(t)_OLED_GRAM[x][pos]|=temp;
	else _OLED_GRAM[x][pos]&=~temp;	    
}

//m^n Function
uint32_t oled::oled_pow(uint8_t m,uint8_t n)
{
	uint32_t result=1;	 
	while(n--)result*=m;    
	return result;
}

// display 2 numbers
//x,y : Start co-ordinate	 
//len : length of the number
//size: Font size 16/12 
//mode: 0=overtype mode; 1=insert mode
//num: value(0~4294967295);	 		  
void oled::OLED_ShowNumber(uint8_t x,uint8_t y,uint8_t size, uint32_t num)
{         	
	uint8_t t,temp;
	uint8_t enshow=0;						   
	uint8_t len=0;
	uint32_t temp_num = num;
	
	while(temp_num !=0)
	{
		temp_num /= 10;
		len++;
	}
	
	for(t=0;t<len;t++)
	{
		temp=(num/oled_pow(10,len-t-1))%10;
		if(enshow==0&&t<(len-1))
		{
			if(temp==0)
			{
				OLED_ShowChar(x+(size/2)*t,y,' ',size,1);
				continue;
			}else enshow=1; 
		 	 
		}
	 	OLED_ShowChar(x+(size/2)*t,y,temp+'0',size,1); 
	}
}


//Display a charcter at specific position
//x:0~127
//y:0~63
//mode:0=inverted display;1=normal display				 
//size:Choose font 16/12 
void oled::OLED_ShowChar(uint8_t x,uint8_t y,uint8_t chr,uint8_t size,bool mode)
{      			    
	uint8_t temp,t,t1;
	uint8_t y0=y;
	chr=chr-' ';				   
    for(t=0;t<size;t++)
    {   
		if(size==12)temp=oled_asc2_1206[chr][t];  //1206 Font size
		else temp=oled_asc2_1608[chr][t];		 //1608 Font size 	                          
        for(t1=0;t1<8;t1++)
		{
			if(temp&0x80)OLED_DrawPoint(x,y,mode);
			else OLED_DrawPoint(x,y,!mode);
			temp<<=1;
			y++;
			if((y-y0)==size)
			{
				y=y0;
				x++;
				break;
			}
		}  	 
    }          
}

// display string
//x,y: start co-ordinate  
//*p: String address
//Font size = 16
void oled::OLED_ShowString(uint8_t x,uint8_t y,uint8_t size,const uint8_t *p)
{
#define MAX_CHAR_POSX 122
#define MAX_CHAR_POSY 58          
    while(*p!='\0')
    {       
        if(x>MAX_CHAR_POSX){x=0;y+=16;}
        if(y>MAX_CHAR_POSY){y=x=0;OLED_Clear();}
        if(size == 12){OLED_ShowChar(x,y,*p,12,1);}
        if(size == 16){OLED_ShowChar(x,y,*p,12,1);}
        x+=8;
        p++;
    }  
}	 

//Send a byte to OLED
//dat: data / command
//cmd: data type 0 = command, 1 = data
void oled::OLED_WR_Byte(uint8_t dat,uint8_t cmd)
{	
	uint8_t i;			  
	if(cmd)
	  OLED_RS_Set();
	else 
	  OLED_RS_Clr();		  
	for(i=0;i<8;i++)
	{			  
		OLED_SCLK_Clr();
		if(dat&0x80)
		   OLED_SDIN_Set();
		else 
		   OLED_SDIN_Clr();
		OLED_SCLK_Set();
		dat<<=1;   
	}				 		  
	OLED_RS_Set();   	  
}

void oled::OLED_Refresh(void)
{
	uint8_t i,n;		    
	for(i=0;i<8;i++)  
	{  
		OLED_WR_Byte (0xb0+i,OLED_CMD);    //Set page address
		OLED_WR_Byte (0x00,OLED_CMD);      //Set displace position - Row (Address byte 1)
		OLED_WR_Byte (0x10,OLED_CMD);      //Set displace position - Row (Address byte 2)
		for(n=0;n<128;n++)OLED_WR_Byte(_OLED_GRAM[n][i],OLED_DATA); 
	}   
}

//Clear screen (Black)	  
void oled::OLED_Clear(void)  
{  
	uint8_t i,n;  
	for(i=0;i<8;i++)for(n=0;n<128;n++)_OLED_GRAM[n][i]=0X00;  
	OLED_Refresh();//Refresh display
}


void oled::OLED_RST_Clr(void) 
{
	_oled_RES=0;
}

void oled::OLED_RST_Set(void) 
{
	_oled_RES=1;   //RST
}

void oled::OLED_RS_Clr(void) 
{
	_oled_DC=0;    //DC
}

void oled::OLED_RS_Set(void)
{
	_oled_DC=1;    //DC
}

void oled::OLED_SCLK_Clr(void)
{
	_oled_SCL=0;  //SCL
}

void oled::OLED_SCLK_Set(void)
{
	_oled_SCL=1;   //SCL
}

void oled::OLED_SDIN_Clr(void)
{
	_oled_SDA=0;   //SDA
}

void oled::OLED_SDIN_Set(void)
{
	_oled_SDA=1;   //SDA
}  




