#include "mbed.h"

int main()
{
    unsigned int UUID_LOC_WORD0 = 0x40048060;
    unsigned int UUID_LOC_WORD1 = 0x4004805C;
    unsigned int UUID_LOC_WORD2 = 0x40048058;
    unsigned int UUID_LOC_WORD3 = 0x40048054;

    // Fetch word 0
    uint32_t word0 = *(uint32_t *)UUID_LOC_WORD0;

    // Fetch word 1
    // we only want bottom 16 bits of word1 (MAC bits 32-47)
    // and bit 9 forced to 1, bit 8 forced to 0
    // Locally administered MAC, reduced conflicts
    // http://en.wikipedia.org/wiki/MAC_address
    uint32_t word1 = *(uint32_t *)UUID_LOC_WORD1;
    //word1 |= 0x00000200;
    //word1 &= 0x0000FEFF;
    
    uint32_t word2 = *(uint32_t *)UUID_LOC_WORD2;
    uint32_t word3 = *(uint32_t *)UUID_LOC_WORD3;
    
    //printf("%4x%08x", word1, word0);   // Device id must be in lower case
    printf("%08x%08x%08x%08x", word3, word2, word1, word0);   // Device id must be in lower case
    
    while(1);
}

